/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;

public class NoRevAvailCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public NoRevAvailCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        if (this.certificate.isNoRevAvail()) {
            return !this.certificate.isCA() && Utils.isCollectionEmpty((Collection)this.certificate.getCRLDistributionPoints()) && Utils.isCollectionEmpty((Collection)this.certificate.getFreshestCRLUrls()) && Utils.isCollectionEmpty((Collection)this.certificate.getOCSPAccessUrls());
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICNRAEV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICNRAEV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

