/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PolicyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificatePolicyTreeCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public CertificatePolicyTreeCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        ArrayList<CertificateWrapper> certificateChain = new ArrayList<CertificateWrapper>();
        certificateChain.add(this.certificate);
        certificateChain.addAll(this.certificate.getCertificateChain());
        PolicyTreeNode validPolicyTree = PolicyTreeNode.initTree();
        int explicitPolicy = certificateChain.size() + 1;
        int inhibitAnyPolicy = certificateChain.size() + 1;
        Set<PolicyTreeNode> previousLevelNodes = Collections.singleton(validPolicyTree);
        for (int i = certificateChain.size() - 1; i > -1; --i) {
            CertificateWrapper cert = (CertificateWrapper)certificateChain.get(i);
            int certRequireExplicitPolicy = cert.getRequireExplicitPolicy();
            int certInhibitAnyPolicy = cert.getInhibitAnyPolicy();
            HashSet<PolicyTreeNode> currentLevelNodes = new HashSet<PolicyTreeNode>();
            List certificatePolicies = cert.getCertificatePolicies();
            if (Utils.isCollectionNotEmpty((Collection)certificatePolicies) && Utils.isCollectionNotEmpty(previousLevelNodes)) {
                for (XmlCertificatePolicy certificatePolicy : certificatePolicies) {
                    PolicyTreeNode policyNode = new PolicyTreeNode(certificatePolicy.getValue(), certificatePolicy.getCpsUrl());
                    if (!policyNode.isAnyPolicy()) {
                        for (PolicyTreeNode node : previousLevelNodes) {
                            if (!node.addChildNodeIfMatch(policyNode)) continue;
                            currentLevelNodes.add(policyNode);
                        }
                        continue;
                    }
                    if (inhibitAnyPolicy <= 0 && (i == 0 || !cert.isSelfSigned())) continue;
                    for (PolicyTreeNode node : previousLevelNodes) {
                        Set<PolicyTreeNode> children = node.createAnyPolicyChildren();
                        currentLevelNodes.addAll(children);
                    }
                }
                if (validPolicyTree != null) {
                    validPolicyTree = validPolicyTree.deleteNodesAtLevelWithoutChildren(certificateChain.size() - 1 - i);
                }
            } else if (Utils.isCollectionEmpty((Collection)certificatePolicies)) {
                validPolicyTree = null;
            }
            if (i != 0) {
                previousLevelNodes = currentLevelNodes;
                if (!cert.isSelfSigned()) {
                    if (explicitPolicy != 0) {
                        --explicitPolicy;
                    }
                    if (inhibitAnyPolicy != 0) {
                        --inhibitAnyPolicy;
                    }
                }
                if (certRequireExplicitPolicy != -1 && certRequireExplicitPolicy < explicitPolicy) {
                    explicitPolicy = certRequireExplicitPolicy;
                }
                if (certInhibitAnyPolicy == -1 || certInhibitAnyPolicy >= inhibitAnyPolicy) continue;
                inhibitAnyPolicy = certInhibitAnyPolicy;
                continue;
            }
            if (explicitPolicy != 0) {
                --explicitPolicy;
            }
            if (certRequireExplicitPolicy == 0) {
                explicitPolicy = 0;
            }
            if (explicitPolicy != 0 || validPolicyTree != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICPTV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICPTV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

