/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.QCLimitValueWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class CertificateMinQcTransactionLimitCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private final NumericValueRule constraint;

    public CertificateMinQcTransactionLimitCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, NumericValueRule constraint) {
        super(i18nProvider, result, (LevelRule)constraint);
        this.certificate = certificate;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        QCLimitValueWrapper qcLimitValue = this.certificate.getQCLimitValue();
        if (qcLimitValue != null) {
            double value = (double)qcLimitValue.getAmount() * Math.pow(10.0, qcLimitValue.getExponent());
            return value >= (double)this.constraint.getValue().intValue();
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCLVA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCLVA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

