/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class ProspectiveCertificateChainAtValidationTimeCheck
extends ChainItem<XmlXCV> {
    private final CertificateWrapper certificate;
    private final Date controlTime;

    public ProspectiveCertificateChainAtValidationTimeCheck(I18nProvider i18nProvider, XmlXCV result, CertificateWrapper certificate, Date controlTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.controlTime = controlTime;
    }

    @Override
    protected boolean process() {
        if (ValidationProcessUtils.isTrustAnchor(this.certificate, this.controlTime, this.getFailLevelRule())) {
            return true;
        }
        for (CertificateWrapper caCertificate : this.certificate.getCertificateChain()) {
            if (!ValidationProcessUtils.isTrustAnchor(caCertificate, this.controlTime, this.getFailLevelRule())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_HPCCVVT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_HPCCVVT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND_NO_POE;
    }

    private LevelRule getFailLevelRule() {
        return ValidationProcessUtils.getLevelRule(Level.FAIL);
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.VALIDATION_TIME, new Object[]{ValidationProcessUtils.getFormattedDate(this.controlTime)});
    }
}

