/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;

public class EncryptionAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;
    private final CryptographicSuite cryptographicSuite;

    protected EncryptionAlgorithmReliableCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAcceptableEncryptionAlgorithmsLevel()));
        this.encryptionAlgo = encryptionAlgo;
        this.cryptographicSuite = cryptographicSuite;
    }

    @Override
    protected boolean process() {
        return CryptographicSuiteUtils.isEncryptionAlgorithmReliable(this.cryptographicSuite, this.encryptionAlgo);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_EAA, this.getName(this.encryptionAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_EAA_ANS, this.getName(this.encryptionAlgo), this.position);
    }
}

