/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmAtValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmAtValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeAcceptableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeKnownCheck;
import java.util.Date;

public abstract class AbstractCryptographicChecker
extends Chain<XmlCC> {
    private static final String ALGORITHM_UNIDENTIFIED = "UNIDENTIFIED";
    private static final String ALGORITHM_UNIDENTIFIED_URN = "urn:etsi:019102:algorithm:unidentified";
    protected final EncryptionAlgorithm encryptionAlgorithm;
    protected final DigestAlgorithm digestAlgorithm;
    protected final String keyLengthUsedToSignThisToken;
    protected final Date validationDate;
    protected final CryptographicSuite cryptographicSuite;
    protected final MessageTag position;
    private XmlCryptographicAlgorithm cryptographicAlgorithm;

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, DigestAlgorithm digestAlgorithm, Date validationDate, MessageTag position, CryptographicSuite constraint) {
        this(i18nProvider, null, digestAlgorithm, null, validationDate, position, constraint);
    }

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, String keyLengthUsedToSignThisToken, Date validationDate, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, new XmlCC());
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.digestAlgorithm = digestAlgorithm;
        this.keyLengthUsedToSignThisToken = keyLengthUsedToSignThisToken;
        this.validationDate = validationDate;
        this.cryptographicSuite = cryptographicSuite;
        this.position = position;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CC;
    }

    protected boolean isExpirationDateAvailable(DigestAlgorithm digestAlgorithm) {
        return CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, digestAlgorithm) != null;
    }

    protected boolean isExpirationDateAvailable(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        return CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, encryptionAlgorithm, keyLength) != null;
    }

    protected ChainItem<XmlCC> encryptionAlgorithmReliable() {
        return new EncryptionAlgorithmReliableCheck(this.i18nProvider, this.encryptionAlgorithm, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> digestAlgorithmReliable() {
        return new DigestAlgorithmReliableCheck(this.i18nProvider, this.digestAlgorithm, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> encryptionAlgorithmOnValidationTime() {
        return new EncryptionAlgorithmAtValidationTimeCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, this.validationDate, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> digestAlgorithmOnValidationTime() {
        return new DigestAlgorithmAtValidationTimeCheck(this.i18nProvider, this.digestAlgorithm, this.validationDate, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> publicKeySizeKnown() {
        return new PublicKeySizeKnownCheck(this.i18nProvider, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> publicKeySizeAcceptable() {
        return new PublicKeySizeAcceptableCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlCC)this.result).setVerifiedAlgorithm(this.getAlgorithm());
        ((XmlCC)this.result).setNotAfter(this.getNotAfter());
    }

    private XmlCryptographicAlgorithm getAlgorithm() {
        if (this.cryptographicAlgorithm == null) {
            this.cryptographicAlgorithm = new XmlCryptographicAlgorithm();
            if (this.digestAlgorithm == null) {
                this.cryptographicAlgorithm.setName(ALGORITHM_UNIDENTIFIED);
                this.cryptographicAlgorithm.setUri(ALGORITHM_UNIDENTIFIED_URN);
            } else if (this.encryptionAlgorithm != null) {
                SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(this.digestAlgorithm, this.encryptionAlgorithm);
                this.cryptographicAlgorithm.setName(signatureAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getSignatureAlgorithmUri(signatureAlgorithm));
                this.cryptographicAlgorithm.setKeyLength(this.keyLengthUsedToSignThisToken);
            } else {
                this.cryptographicAlgorithm.setName(this.digestAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getDigestAlgorithmUri(this.digestAlgorithm));
            }
        }
        return this.cryptographicAlgorithm;
    }

    private SignatureAlgorithm getSignatureAlgorithm(DigestAlgorithm digestAlgorithm, EncryptionAlgorithm encryptionAlgorithm) {
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
    }

    private String getSignatureAlgorithmUri(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm != null) {
            if (signatureAlgorithm.getUri() != null) {
                return signatureAlgorithm.getUri();
            }
            if (signatureAlgorithm.getOid() != null) {
                return signatureAlgorithm.getURIBasedOnOID();
            }
        }
        return ALGORITHM_UNIDENTIFIED_URN;
    }

    private String getDigestAlgorithmUri(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            if (digestAlgorithm.getUri() != null) {
                return digestAlgorithm.getUri();
            }
            if (digestAlgorithm.getOid() != null) {
                return digestAlgorithm.getOid();
            }
        }
        return ALGORITHM_UNIDENTIFIED_URN;
    }

    protected Date getNotAfter() {
        if (CryptographicSuiteUtils.isDigestAlgorithmReliable(this.cryptographicSuite, this.digestAlgorithm) && CryptographicSuiteUtils.isEncryptionAlgorithmReliable(this.cryptographicSuite, this.encryptionAlgorithm) && CryptographicSuiteUtils.isEncryptionAlgorithmWithKeySizeReliable(this.cryptographicSuite, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken)) {
            Date notAfter = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.digestAlgorithm);
            Date expirationEncryption = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken);
            if (notAfter == null || expirationEncryption != null && expirationEncryption.before(notAfter)) {
                notAfter = expirationEncryption;
            }
            return notAfter;
        }
        return null;
    }
}

