/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.AbstractSignatureWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.math.BigInteger;
import java.util.List;

public class ByteRangeCollisionCheck
extends ChainItem<XmlFC> {
    private final AbstractSignatureWrapper currentSignature;
    private final DiagnosticData diagnosticData;

    public ByteRangeCollisionCheck(I18nProvider i18nProvider, XmlFC result, AbstractSignatureWrapper signatureWrapper, DiagnosticData diagnosticData, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.currentSignature = signatureWrapper;
        this.diagnosticData = diagnosticData;
    }

    @Override
    protected boolean process() {
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            if (this.currentSignature.getId().equals(signature.getId()) || !this.collide(this.currentSignature, (AbstractSignatureWrapper)signature)) continue;
            return false;
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            if (this.currentSignature.getId().equals(timestamp.getId()) || !this.collide(this.currentSignature, (AbstractSignatureWrapper)timestamp)) continue;
            return false;
        }
        return true;
    }

    private boolean collide(AbstractSignatureWrapper signatureWrapperOne, AbstractSignatureWrapper signatureWrapperTwo) {
        return signatureWrapperOne.getPDFRevision() != null && signatureWrapperTwo.getPDFRevision() != null && (this.collide(signatureWrapperOne.getPDFRevision().getSignatureByteRange(), signatureWrapperTwo.getPDFRevision().getSignatureByteRange()) || this.collide(signatureWrapperTwo.getPDFRevision().getSignatureByteRange(), signatureWrapperOne.getPDFRevision().getSignatureByteRange()));
    }

    private boolean collide(List<BigInteger> byteRangeOne, List<BigInteger> byteRangeTwo) {
        if (byteRangeOne.size() != 4 || byteRangeTwo.size() != 4) {
            throw new IllegalStateException("Signature ByteRange shall have 4 integers!");
        }
        return this.getFirstByteRangePartLength(byteRangeOne) < this.getFirstByteRangePartLength(byteRangeTwo) != this.getFirstByteRangePartLength(byteRangeOne) < this.getSecondByteRangePartLength(byteRangeTwo);
    }

    private int getFirstByteRangePartLength(List<BigInteger> byteRange) {
        return byteRange.get(0).intValue() + byteRange.get(1).intValue();
    }

    private int getSecondByteRangePartLength(List<BigInteger> byteRange) {
        return byteRange.get(2).intValue() + byteRange.get(3).intValue();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_DBTOOST;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_DBTOOST_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

