/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.ValidationModel;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.DurationRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.ContextAndSubContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidationPolicyWithCryptographicSuite
implements ValidationPolicy {
    private final ValidationPolicy validationPolicy;
    private final Map<ContextAndSubContext, CryptographicSuite> cryptographicSuitesMap = new HashMap<ContextAndSubContext, CryptographicSuite>();

    public ValidationPolicyWithCryptographicSuite(ValidationPolicy validationPolicy) {
        Objects.requireNonNull(validationPolicy, "ValidationPolicy cannot be null!");
        this.validationPolicy = validationPolicy;
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite) {
        this.cryptographicSuitesMap.put(new ContextAndSubContext(), cryptographicSuite);
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite, Context context) {
        this.cryptographicSuitesMap.put(new ContextAndSubContext(context, null), cryptographicSuite);
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite, Context context, SubContext subContext) {
        if (Context.EVIDENCE_RECORD == context && subContext != null) {
            throw new IllegalArgumentException("Please use a NULL SubContext for the Context.EVIDENCE_RECORD or use #setCryptographicSuite(cryptographicSuite, context) method.");
        }
        this.cryptographicSuitesMap.put(new ContextAndSubContext(context, subContext), cryptographicSuite);
    }

    public String getPolicyName() {
        return this.validationPolicy.getPolicyName();
    }

    public String getPolicyDescription() {
        return this.validationPolicy.getPolicyDescription();
    }

    public MultiValuesRule getSignaturePolicyConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyConstraint(context);
    }

    public LevelRule getSignaturePolicyIdentifiedConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyIdentifiedConstraint(context);
    }

    public LevelRule getSignaturePolicyStorePresentConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyStorePresentConstraint(context);
    }

    public LevelRule getSignaturePolicyPolicyHashValid(Context context) {
        return this.validationPolicy.getSignaturePolicyPolicyHashValid(context);
    }

    public LevelRule getStructuralValidationConstraint(Context context) {
        return this.validationPolicy.getStructuralValidationConstraint(context);
    }

    public LevelRule getSigningCertificateRefersCertificateChainConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(context);
    }

    public LevelRule getReferencesToAllCertificateChainPresentConstraint(Context context) {
        return this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(context);
    }

    public LevelRule getSigningCertificateDigestAlgorithmConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestAlgorithmConstraint(context);
    }

    public LevelRule getSigningDurationRule(Context context) {
        return this.validationPolicy.getSigningDurationRule(context);
    }

    public ValueRule getContentTypeConstraint(Context context) {
        return this.validationPolicy.getContentTypeConstraint(context);
    }

    public ValueRule getContentHintsConstraint(Context context) {
        return this.validationPolicy.getContentHintsConstraint(context);
    }

    public ValueRule getContentIdentifierConstraint(Context context) {
        return this.validationPolicy.getContentIdentifierConstraint(context);
    }

    public LevelRule getMessageDigestOrSignedPropertiesConstraint(Context context) {
        return this.validationPolicy.getMessageDigestOrSignedPropertiesConstraint(context);
    }

    public LevelRule getEllipticCurveKeySizeConstraint(Context context) {
        return this.validationPolicy.getEllipticCurveKeySizeConstraint(context);
    }

    public MultiValuesRule getCommitmentTypeIndicationConstraint(Context context) {
        return this.validationPolicy.getCommitmentTypeIndicationConstraint(context);
    }

    public LevelRule getSignerLocationConstraint(Context context) {
        return this.validationPolicy.getSignerLocationConstraint(context);
    }

    public LevelRule getContentTimeStampConstraint(Context context) {
        return this.validationPolicy.getContentTimeStampConstraint(context);
    }

    public LevelRule getContentTimeStampMessageImprintConstraint(Context context) {
        return this.validationPolicy.getContentTimeStampMessageImprintConstraint(context);
    }

    public MultiValuesRule getClaimedRoleConstraint(Context context) {
        return this.validationPolicy.getClaimedRoleConstraint(context);
    }

    public MultiValuesRule getCertifiedRolesConstraint(Context context) {
        return this.validationPolicy.getCertifiedRolesConstraint(context);
    }

    public CryptographicSuite getSignatureCryptographicConstraint(Context context) {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(context, null);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getSignatureCryptographicConstraint(context);
        }
        return cryptographicSuite;
    }

    public CryptographicSuite getCertificateCryptographicConstraint(Context context, SubContext subContext) {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(context, subContext);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getCertificateCryptographicConstraint(context, subContext);
        }
        return cryptographicSuite;
    }

    public CryptographicSuite getEvidenceRecordCryptographicConstraint() {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(Context.EVIDENCE_RECORD, null);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getEvidenceRecordCryptographicConstraint();
        }
        return cryptographicSuite;
    }

    private CryptographicSuite getCryptographicSuite(Context context, SubContext subContext) {
        if (Utils.isMapNotEmpty(this.cryptographicSuitesMap)) {
            ContextAndSubContext contextAndSubContext;
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (context != contextAndSubContext.getContext() || subContext != contextAndSubContext.getSubContext()) continue;
                return entry.getValue();
            }
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (context != contextAndSubContext.getContext() || contextAndSubContext.getSubContext() != null) continue;
                return entry.getValue();
            }
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (contextAndSubContext.getContext() != null || contextAndSubContext.getSubContext() != null) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public LevelRule getCertificateCAConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCAConstraint(context, subContext);
    }

    public LevelRule getCertificateIssuerNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuerNameConstraint(context, subContext);
    }

    public LevelRule getCertificateMaxPathLengthConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMaxPathLengthConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateKeyUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateKeyUsageConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateExtendedKeyUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateExtendedKeyUsageConstraint(context, subContext);
    }

    public LevelRule getCertificatePolicyTreeConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyTreeConstraint(context, subContext);
    }

    public LevelRule getCertificateNameConstraintsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNameConstraintsConstraint(context, subContext);
    }

    public LevelRule getCertificateNoRevAvailConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNoRevAvailConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateSupportedCriticalExtensionsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSupportedCriticalExtensionsConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateForbiddenExtensionsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateForbiddenExtensionsConstraint(context, subContext);
    }

    public LevelRule getCertificateNotExpiredConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotExpiredConstraint(context, subContext);
    }

    public LevelRule getCertificateSunsetDateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSunsetDateConstraint(context, subContext);
    }

    public LevelRule getProspectiveCertificateChainConstraint(Context context) {
        return this.validationPolicy.getProspectiveCertificateChainConstraint(context);
    }

    public LevelRule getCertificateSignatureConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSignatureConstraint(context, subContext);
    }

    public LevelRule getUnknownStatusConstraint() {
        return this.validationPolicy.getUnknownStatusConstraint();
    }

    public LevelRule getThisUpdatePresentConstraint() {
        return this.validationPolicy.getThisUpdatePresentConstraint();
    }

    public LevelRule getRevocationIssuerKnownConstraint() {
        return this.validationPolicy.getRevocationIssuerKnownConstraint();
    }

    public LevelRule getRevocationIssuerValidAtProductionTimeConstraint() {
        return this.validationPolicy.getRevocationIssuerValidAtProductionTimeConstraint();
    }

    public LevelRule getRevocationAfterCertificateIssuanceConstraint() {
        return this.validationPolicy.getRevocationAfterCertificateIssuanceConstraint();
    }

    public LevelRule getRevocationHasInformationAboutCertificateConstraint() {
        return this.validationPolicy.getRevocationHasInformationAboutCertificateConstraint();
    }

    public LevelRule getOCSPResponseResponderIdMatchConstraint() {
        return this.validationPolicy.getOCSPResponseResponderIdMatchConstraint();
    }

    public LevelRule getOCSPResponseCertHashPresentConstraint() {
        return this.validationPolicy.getOCSPResponseCertHashPresentConstraint();
    }

    public LevelRule getOCSPResponseCertHashMatchConstraint() {
        return this.validationPolicy.getOCSPResponseCertHashMatchConstraint();
    }

    public LevelRule getSelfIssuedOCSPConstraint() {
        return this.validationPolicy.getSelfIssuedOCSPConstraint();
    }

    public LevelRule getRevocationDataAvailableConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationDataAvailableConstraint(context, subContext);
    }

    public LevelRule getAcceptableRevocationDataFoundConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getAcceptableRevocationDataFoundConstraint(context, subContext);
    }

    public LevelRule getCRLNextUpdatePresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCRLNextUpdatePresentConstraint(context, subContext);
    }

    public LevelRule getOCSPNextUpdatePresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getOCSPNextUpdatePresentConstraint(context, subContext);
    }

    public DurationRule getRevocationFreshnessConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationFreshnessConstraint(context, subContext);
    }

    public LevelRule getRevocationFreshnessNextUpdateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationFreshnessNextUpdateConstraint(context, subContext);
    }

    public LevelRule getCertificateNotRevokedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotRevokedConstraint(context, subContext);
    }

    public LevelRule getCertificateNotOnHoldConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotOnHoldConstraint(context, subContext);
    }

    public LevelRule getRevocationIssuerNotExpiredConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationIssuerNotExpiredConstraint(context, subContext);
    }

    public LevelRule getCertificateNotSelfSignedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotSelfSignedConstraint(context, subContext);
    }

    public LevelRule getCertificateSelfSignedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSelfSignedConstraint(context, subContext);
    }

    public MultiValuesRule getTrustServiceTypeIdentifierConstraint(Context context) {
        return this.validationPolicy.getTrustServiceTypeIdentifierConstraint(context);
    }

    public MultiValuesRule getTrustServiceStatusConstraint(Context context) {
        return this.validationPolicy.getTrustServiceStatusConstraint(context);
    }

    public MultiValuesRule getCertificatePolicyIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyIdsConstraint(context, subContext);
    }

    public LevelRule getCertificatePolicyQualificationIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyQualificationIdsConstraint(context, subContext);
    }

    public LevelRule getCertificatePolicySupportedByQSCDIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicySupportedByQSCDIdsConstraint(context, subContext);
    }

    public LevelRule getCertificateQCComplianceConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQCComplianceConstraint(context, subContext);
    }

    public ValueRule getCertificateQcEuLimitValueCurrencyConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcEuLimitValueCurrencyConstraint(context, subContext);
    }

    public NumericValueRule getCertificateMinQcEuLimitValueConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMinQcEuLimitValueConstraint(context, subContext);
    }

    public NumericValueRule getCertificateMinQcEuRetentionPeriodConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMinQcEuRetentionPeriodConstraint(context, subContext);
    }

    public LevelRule getCertificateQcSSCDConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcSSCDConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateQcEuPDSLocationConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcEuPDSLocationConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateQcTypeConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcTypeConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateQcCCLegislationConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcCCLegislationConstraint(context, subContext);
    }

    public LevelRule getCertificateIssuedToNaturalPersonConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(context, subContext);
    }

    public LevelRule getCertificateIssuedToLegalPersonConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateSemanticsIdentifierConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSemanticsIdentifierConstraint(context, subContext);
    }

    public MultiValuesRule getCertificatePS2DQcTypeRolesOfPSPConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcTypeRolesOfPSPConstraint(context, subContext);
    }

    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcCompetentAuthorityNameConstraint(context, subContext);
    }

    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityIdConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcCompetentAuthorityIdConstraint(context, subContext);
    }

    public LevelRule getSigningCertificateRecognitionConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateRecognitionConstraint(context);
    }

    public LevelRule getSigningCertificateAttributePresentConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateAttributePresentConstraint(context);
    }

    public LevelRule getUnicitySigningCertificateAttributeConstraint(Context context) {
        return this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(context);
    }

    public LevelRule getSigningCertificateDigestValuePresentConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(context);
    }

    public LevelRule getSigningCertificateDigestValueMatchConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(context);
    }

    public LevelRule getSigningCertificateIssuerSerialMatchConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(context);
    }

    public LevelRule getKeyIdentifierPresent(Context context) {
        return this.validationPolicy.getKeyIdentifierPresent(context);
    }

    public LevelRule getKeyIdentifierMatch(Context context) {
        return this.validationPolicy.getKeyIdentifierMatch(context);
    }

    public LevelRule getReferenceDataExistenceConstraint(Context context) {
        return this.validationPolicy.getReferenceDataExistenceConstraint(context);
    }

    public LevelRule getReferenceDataIntactConstraint(Context context) {
        return this.validationPolicy.getReferenceDataIntactConstraint(context);
    }

    public LevelRule getReferenceDataNameMatchConstraint(Context context) {
        return this.validationPolicy.getReferenceDataNameMatchConstraint(context);
    }

    public LevelRule getManifestEntryObjectExistenceConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectExistenceConstraint(context);
    }

    public LevelRule getManifestEntryObjectIntactConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectIntactConstraint(context);
    }

    public LevelRule getManifestEntryObjectGroupConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectGroupConstraint(context);
    }

    public LevelRule getManifestEntryNameMatchConstraint(Context context) {
        return this.validationPolicy.getManifestEntryNameMatchConstraint(context);
    }

    public LevelRule getSignatureIntactConstraint(Context context) {
        return this.validationPolicy.getSignatureIntactConstraint(context);
    }

    public LevelRule getSignatureDuplicatedConstraint(Context context) {
        return this.validationPolicy.getSignatureDuplicatedConstraint(context);
    }

    public LevelRule getSignerInformationStoreConstraint(Context context) {
        return this.validationPolicy.getSignerInformationStoreConstraint(context);
    }

    public LevelRule getByteRangeConstraint(Context context) {
        return this.validationPolicy.getByteRangeConstraint(context);
    }

    public LevelRule getByteRangeCollisionConstraint(Context context) {
        return this.validationPolicy.getByteRangeCollisionConstraint(context);
    }

    public LevelRule getByteRangeAllDocumentConstraint(Context context) {
        return this.validationPolicy.getByteRangeAllDocumentConstraint(context);
    }

    public LevelRule getPdfSignatureDictionaryConstraint(Context context) {
        return this.validationPolicy.getPdfSignatureDictionaryConstraint(context);
    }

    public LevelRule getPdfPageDifferenceConstraint(Context context) {
        return this.validationPolicy.getPdfPageDifferenceConstraint(context);
    }

    public LevelRule getPdfAnnotationOverlapConstraint(Context context) {
        return this.validationPolicy.getPdfAnnotationOverlapConstraint(context);
    }

    public LevelRule getPdfVisualDifferenceConstraint(Context context) {
        return this.validationPolicy.getPdfVisualDifferenceConstraint(context);
    }

    public LevelRule getDocMDPConstraint(Context context) {
        return this.validationPolicy.getDocMDPConstraint(context);
    }

    public LevelRule getFieldMDPConstraint(Context context) {
        return this.validationPolicy.getFieldMDPConstraint(context);
    }

    public LevelRule getSigFieldLockConstraint(Context context) {
        return this.validationPolicy.getSigFieldLockConstraint(context);
    }

    public LevelRule getFormFillChangesConstraint(Context context) {
        return this.validationPolicy.getFormFillChangesConstraint(context);
    }

    public LevelRule getAnnotationChangesConstraint(Context context) {
        return this.validationPolicy.getAnnotationChangesConstraint(context);
    }

    public LevelRule getUndefinedChangesConstraint(Context context) {
        return this.validationPolicy.getUndefinedChangesConstraint(context);
    }

    public LevelRule getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint() {
        return this.validationPolicy.getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint();
    }

    public LevelRule getTimestampCoherenceConstraint() {
        return this.validationPolicy.getTimestampCoherenceConstraint();
    }

    public DurationRule getTimestampDelayConstraint() {
        return this.validationPolicy.getTimestampDelayConstraint();
    }

    public LevelRule getTimestampValidConstraint() {
        return this.validationPolicy.getTimestampValidConstraint();
    }

    public LevelRule getTimestampTSAGeneralNamePresent() {
        return this.validationPolicy.getTimestampTSAGeneralNamePresent();
    }

    public LevelRule getTimestampTSAGeneralNameContentMatch() {
        return this.validationPolicy.getTimestampTSAGeneralNameContentMatch();
    }

    public LevelRule getTimestampTSAGeneralNameOrderMatch() {
        return this.validationPolicy.getTimestampTSAGeneralNameOrderMatch();
    }

    public LevelRule getAtsHashIndexConstraint() {
        return this.validationPolicy.getAtsHashIndexConstraint();
    }

    public LevelRule getTimestampContainerSignedAndTimestampedFilesCoveredConstraint() {
        return this.validationPolicy.getTimestampContainerSignedAndTimestampedFilesCoveredConstraint();
    }

    public LevelRule getRevocationTimeAgainstBestSignatureDurationRule() {
        return this.validationPolicy.getRevocationTimeAgainstBestSignatureDurationRule();
    }

    public LevelRule getEvidenceRecordValidConstraint() {
        return this.validationPolicy.getEvidenceRecordValidConstraint();
    }

    public LevelRule getEvidenceRecordDataObjectExistenceConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectExistenceConstraint();
    }

    public LevelRule getEvidenceRecordDataObjectIntactConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectIntactConstraint();
    }

    public LevelRule getEvidenceRecordDataObjectFoundConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectFoundConstraint();
    }

    public LevelRule getEvidenceRecordDataObjectGroupConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectGroupConstraint();
    }

    public LevelRule getEvidenceRecordSignedFilesCoveredConstraint() {
        return this.validationPolicy.getEvidenceRecordSignedFilesCoveredConstraint();
    }

    public LevelRule getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint() {
        return this.validationPolicy.getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint();
    }

    public LevelRule getEvidenceRecordHashTreeRenewalConstraint() {
        return this.validationPolicy.getEvidenceRecordHashTreeRenewalConstraint();
    }

    public LevelRule getCounterSignatureConstraint(Context context) {
        return this.validationPolicy.getCounterSignatureConstraint(context);
    }

    public LevelRule getSignatureTimeStampConstraint(Context context) {
        return this.validationPolicy.getSignatureTimeStampConstraint(context);
    }

    public LevelRule getValidationDataTimeStampConstraint(Context context) {
        return this.validationPolicy.getValidationDataTimeStampConstraint(context);
    }

    public LevelRule getValidationDataRefsOnlyTimeStampConstraint(Context context) {
        return this.validationPolicy.getValidationDataRefsOnlyTimeStampConstraint(context);
    }

    public LevelRule getArchiveTimeStampConstraint(Context context) {
        return this.validationPolicy.getArchiveTimeStampConstraint(context);
    }

    public LevelRule getDocumentTimeStampConstraint(Context context) {
        return this.validationPolicy.getDocumentTimeStampConstraint(context);
    }

    public LevelRule getTLevelTimeStampConstraint(Context context) {
        return this.validationPolicy.getTLevelTimeStampConstraint(context);
    }

    public LevelRule getLTALevelTimeStampConstraint(Context context) {
        return this.validationPolicy.getLTALevelTimeStampConstraint(context);
    }

    public MultiValuesRule getSignatureFormatConstraint(Context context) {
        return this.validationPolicy.getSignatureFormatConstraint(context);
    }

    public MultiValuesRule getCertificateCountryConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCountryConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateLocalityConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateLocalityConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateStateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateStateConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateOrganizationIdentifierConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationIdentifierConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateOrganizationNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationNameConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateOrganizationUnitConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationUnitConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateSurnameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSurnameConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateGivenNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateGivenNameConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateCommonNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCommonNameConstraint(context, subContext);
    }

    public MultiValuesRule getCertificatePseudonymConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePseudonymConstraint(context, subContext);
    }

    public LevelRule getCertificatePseudoUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePseudoUsageConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateTitleConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateTitleConstraint(context, subContext);
    }

    public MultiValuesRule getCertificateEmailConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateEmailConstraint(context, subContext);
    }

    public LevelRule getCertificateSerialNumberConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSerialNumberConstraint(context, subContext);
    }

    public LevelRule getCertificateAuthorityInfoAccessPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(context, subContext);
    }

    public CertificateApplicabilityRule getRevocationDataSkipConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationDataSkipConstraint(context, subContext);
    }

    public LevelRule getCertificateRevocationInfoAccessPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(context, subContext);
    }

    public MultiValuesRule getAcceptedContainerTypesConstraint() {
        return this.validationPolicy.getAcceptedContainerTypesConstraint();
    }

    public LevelRule getZipCommentPresentConstraint() {
        return this.validationPolicy.getZipCommentPresentConstraint();
    }

    public MultiValuesRule getAcceptedZipCommentsConstraint() {
        return this.validationPolicy.getAcceptedZipCommentsConstraint();
    }

    public LevelRule getMimeTypeFilePresentConstraint() {
        return this.validationPolicy.getMimeTypeFilePresentConstraint();
    }

    public MultiValuesRule getAcceptedMimeTypeContentsConstraint() {
        return this.validationPolicy.getAcceptedMimeTypeContentsConstraint();
    }

    public LevelRule getManifestFilePresentConstraint() {
        return this.validationPolicy.getManifestFilePresentConstraint();
    }

    public LevelRule getSignedFilesPresentConstraint() {
        return this.validationPolicy.getSignedFilesPresentConstraint();
    }

    public LevelRule getFilenameAdherenceConstraint() {
        return this.validationPolicy.getFilenameAdherenceConstraint();
    }

    public LevelRule getAllFilesSignedConstraint() {
        return this.validationPolicy.getAllFilesSignedConstraint();
    }

    public LevelRule getFullScopeConstraint() {
        return this.validationPolicy.getFullScopeConstraint();
    }

    public MultiValuesRule getAcceptablePDFAProfilesConstraint() {
        return this.validationPolicy.getAcceptablePDFAProfilesConstraint();
    }

    public LevelRule getPDFACompliantConstraint() {
        return this.validationPolicy.getPDFACompliantConstraint();
    }

    public boolean isEIDASConstraintPresent() {
        return this.validationPolicy.isEIDASConstraintPresent();
    }

    public DurationRule getTLFreshnessConstraint() {
        return this.validationPolicy.getTLFreshnessConstraint();
    }

    public LevelRule getTLWellSignedConstraint() {
        return this.validationPolicy.getTLWellSignedConstraint();
    }

    public LevelRule getTLNotExpiredConstraint() {
        return this.validationPolicy.getTLNotExpiredConstraint();
    }

    public MultiValuesRule getTLVersionConstraint() {
        return this.validationPolicy.getTLVersionConstraint();
    }

    public LevelRule getTLStructureConstraint() {
        return this.validationPolicy.getTLStructureConstraint();
    }

    public ValidationModel getValidationModel() {
        return this.validationPolicy.getValidationModel();
    }

    public String toString() {
        return "ValidationPolicyWithCryptographicSuite [validationPolicyName=" + this.validationPolicy.getPolicyName() + ", cryptographicSuitesNames=" + this.cryptographicSuitesMap.values().stream().map(CryptographicSuite::getPolicyName).collect(Collectors.toList()) + ']';
    }
}

