/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.DurationRule;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.spi.validation.RevocationDataVerifier;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationDataVerifierFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationDataVerifierFactory.class);
    private final ValidationPolicy validationPolicy;
    private Date validationTime;

    public RevocationDataVerifierFactory(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    protected Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public RevocationDataVerifierFactory setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
        return this;
    }

    public RevocationDataVerifier create() {
        RevocationDataVerifier revocationDataVerifier = RevocationDataVerifier.createEmptyRevocationDataVerifier();
        this.instantiateCryptographicSuite(revocationDataVerifier);
        this.instantiateRevocationSkipConstraints(revocationDataVerifier);
        this.instantiateRevocationFreshnessConstraints(revocationDataVerifier);
        this.instantiateAcceptRevocationIssuersWithoutRevocationConstraint(revocationDataVerifier);
        return revocationDataVerifier;
    }

    private void instantiateCryptographicSuite(RevocationDataVerifier revocationDataVerifier) {
        ArrayList<EncryptionAlgorithmWithMinKeySize> acceptableEncryptionAlgorithms;
        List<DigestAlgorithm> acceptableDigestAlgorithms;
        CryptographicSuite cryptographicSuite = this.getRevocationCryptographicSuite(this.validationPolicy);
        if (cryptographicSuite != null && Level.FAIL.equals((Object)cryptographicSuite.getLevel())) {
            Date currentTime = this.getValidationTime();
            acceptableDigestAlgorithms = CryptographicSuiteUtils.getReliableDigestAlgorithmsAtTime(cryptographicSuite, currentTime);
            acceptableEncryptionAlgorithms = CryptographicSuiteUtils.getReliableEncryptionAlgorithmsWithMinimalKeyLengthAtTime(cryptographicSuite, currentTime);
        } else {
            LOG.info("No enforced cryptographic constraints have been found in the provided validation policy. Accept all cryptographic algorithms.");
            acceptableDigestAlgorithms = Arrays.asList(DigestAlgorithm.values());
            acceptableEncryptionAlgorithms = new ArrayList();
            for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
                acceptableEncryptionAlgorithms.add(new EncryptionAlgorithmWithMinKeySize(encryptionAlgorithm, 0));
            }
        }
        revocationDataVerifier.setAcceptableDigestAlgorithms(acceptableDigestAlgorithms);
        revocationDataVerifier.setAcceptableEncryptionAlgorithmKeyLength(this.toEncryptionAlgorithmWithKeySizesMap(acceptableEncryptionAlgorithms));
    }

    private CryptographicSuite getRevocationCryptographicSuite(ValidationPolicy validationPolicy) {
        return validationPolicy.getSignatureCryptographicConstraint(Context.REVOCATION);
    }

    private Map<EncryptionAlgorithm, Integer> toEncryptionAlgorithmWithKeySizesMap(List<EncryptionAlgorithmWithMinKeySize> encryptionAlgorithms) {
        EnumMap<EncryptionAlgorithm, Integer> encryptionAlgorithmsMap = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
        for (EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize : encryptionAlgorithms) {
            EncryptionAlgorithm encryptionAlgorithm = encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm();
            Integer minKeySize = (Integer)encryptionAlgorithmsMap.get(encryptionAlgorithm);
            int keySize = encryptionAlgorithmWithMinKeySize.getMinKeySize();
            if (minKeySize != null && minKeySize <= keySize) continue;
            encryptionAlgorithmsMap.put(encryptionAlgorithm, keySize);
        }
        return encryptionAlgorithmsMap;
    }

    private void instantiateRevocationSkipConstraints(RevocationDataVerifier revocationDataVerifier) {
        HashSet<String> certificateExtensions = new HashSet<String>();
        HashSet<String> certificatePolicies = new HashSet<String>();
        this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, Context.SIGNATURE);
        this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, Context.COUNTER_SIGNATURE);
        this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, Context.REVOCATION);
        this.populateRevocationSkipFromBasicSignatureConstraints(certificateExtensions, certificatePolicies, Context.TIMESTAMP);
        revocationDataVerifier.setRevocationSkipCertificateExtensions(certificateExtensions);
        revocationDataVerifier.setRevocationSkipCertificatePolicies(certificatePolicies);
    }

    private void populateRevocationSkipFromBasicSignatureConstraints(Set<String> certificateExtensions, Set<String> certificatePolicies, Context context) {
        this.populateRevocationSkipFromCertificateConstraints(certificateExtensions, certificatePolicies, context, SubContext.SIGNING_CERT);
        this.populateRevocationSkipFromCertificateConstraints(certificateExtensions, certificatePolicies, context, SubContext.CA_CERTIFICATE);
    }

    private void populateRevocationSkipFromCertificateConstraints(Set<String> certificateExtensions, Set<String> certificatePolicies, Context context, SubContext subContext) {
        MultiValuesRule certificatePoliciesConstraint;
        CertificateApplicabilityRule revocationDataSkipConstraint = this.validationPolicy.getRevocationDataSkipConstraint(context, subContext);
        if (revocationDataSkipConstraint == null) {
            return;
        }
        MultiValuesRule certificateExtensionsConstraint = revocationDataSkipConstraint.getCertificateExtensions();
        if (certificateExtensionsConstraint != null) {
            certificateExtensions.addAll(certificateExtensionsConstraint.getValues());
        }
        if ((certificatePoliciesConstraint = revocationDataSkipConstraint.getCertificatePolicies()) != null) {
            certificatePolicies.addAll(certificatePoliciesConstraint.getValues());
        }
    }

    private void instantiateRevocationFreshnessConstraints(RevocationDataVerifier revocationDataVerifier) {
        revocationDataVerifier.setSignatureMaximumRevocationFreshness(this.getSignatureRevocationFreshnessConstraint());
        revocationDataVerifier.setTimestampMaximumRevocationFreshness(this.getRevocationFreshnessConstraint(Context.TIMESTAMP));
        revocationDataVerifier.setRevocationMaximumRevocationFreshness(this.getRevocationFreshnessConstraint(Context.REVOCATION));
        boolean revocationFreshnessNextUpdateConstraint = this.getRevocationFreshnessNextUpdateConstraintPresent(Context.SIGNATURE);
        revocationFreshnessNextUpdateConstraint = revocationFreshnessNextUpdateConstraint || this.getRevocationFreshnessNextUpdateConstraintPresent(Context.COUNTER_SIGNATURE);
        revocationFreshnessNextUpdateConstraint = revocationFreshnessNextUpdateConstraint || this.getRevocationFreshnessNextUpdateConstraintPresent(Context.TIMESTAMP);
        revocationFreshnessNextUpdateConstraint = revocationFreshnessNextUpdateConstraint || this.getRevocationFreshnessNextUpdateConstraintPresent(Context.REVOCATION);
        revocationDataVerifier.setCheckRevocationFreshnessNextUpdate(revocationFreshnessNextUpdateConstraint);
    }

    private Long getSignatureRevocationFreshnessConstraint() {
        Long maximumRevocationFreshness = this.getRevocationFreshnessConstraint(Context.SIGNATURE);
        Long counterSignatureRevocationFreshnessConstraint = this.getRevocationFreshnessConstraint(Context.COUNTER_SIGNATURE);
        if (maximumRevocationFreshness == null || counterSignatureRevocationFreshnessConstraint != null && counterSignatureRevocationFreshnessConstraint < maximumRevocationFreshness) {
            maximumRevocationFreshness = counterSignatureRevocationFreshnessConstraint;
        }
        return maximumRevocationFreshness;
    }

    private Long getRevocationFreshnessConstraint(Context context) {
        Long maximumRevocationFreshness = this.getRevocationFreshnessConstraintValue(context, SubContext.SIGNING_CERT);
        Long caCertRevocationFreshness = this.getRevocationFreshnessConstraintValue(context, SubContext.CA_CERTIFICATE);
        if (maximumRevocationFreshness == null || caCertRevocationFreshness != null && caCertRevocationFreshness < maximumRevocationFreshness) {
            maximumRevocationFreshness = caCertRevocationFreshness;
        }
        return maximumRevocationFreshness;
    }

    private Long getRevocationFreshnessConstraintValue(Context context, SubContext subContext) {
        DurationRule revocationFreshness = this.validationPolicy.getRevocationFreshnessConstraint(context, subContext);
        if (revocationFreshness != null) {
            return revocationFreshness.getDuration();
        }
        return null;
    }

    private boolean getRevocationFreshnessNextUpdateConstraintPresent(Context context) {
        LevelRule revocationFreshnessNextUpdateConstraint = this.validationPolicy.getRevocationFreshnessNextUpdateConstraint(context, SubContext.SIGNING_CERT);
        if (revocationFreshnessNextUpdateConstraint != null) {
            return true;
        }
        revocationFreshnessNextUpdateConstraint = this.validationPolicy.getRevocationFreshnessNextUpdateConstraint(context, SubContext.CA_CERTIFICATE);
        return revocationFreshnessNextUpdateConstraint != null;
    }

    private void instantiateAcceptRevocationIssuersWithoutRevocationConstraint(RevocationDataVerifier revocationDataVerifier) {
        boolean revocationDataAvailableConstraint = this.getRevocationDataAvailablePresent(Context.REVOCATION);
        revocationDataVerifier.setAcceptRevocationCertificatesWithoutRevocation(!revocationDataAvailableConstraint);
        revocationDataAvailableConstraint = this.getRevocationDataAvailablePresent(Context.TIMESTAMP);
        revocationDataVerifier.setAcceptTimestampCertificatesWithoutRevocation(!revocationDataAvailableConstraint);
    }

    private boolean getRevocationDataAvailablePresent(Context context) {
        LevelRule signingCertificateRule = this.validationPolicy.getRevocationDataAvailableConstraint(context, SubContext.SIGNING_CERT);
        if (signingCertificateRule != null && Level.FAIL.equals((Object)signingCertificateRule.getLevel())) {
            return true;
        }
        LevelRule caCertificateRule = this.validationPolicy.getRevocationDataAvailableConstraint(context, SubContext.CA_CERTIFICATE);
        return caCertificateRule != null && Level.FAIL.equals((Object)caCertificateRule.getLevel());
    }
}

