/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingTask;
import eu.europa.esig.dss.tsl.parsing.LOTLParsingTask;
import eu.europa.esig.dss.tsl.parsing.ParsingUtils;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResult;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.concurrent.Callable;

public class PivotProcessing
extends AbstractAnalysis
implements Callable<PivotProcessingResult> {
    private final CacheAccessByKey lotlCacheAccess;
    private final List<CacheAccessByKey> preceedingPivotCacheAccessByKeyList;

    public PivotProcessing(LOTLSource pivotSource, CacheAccessByKey pivotCacheAccess, CacheAccessByKey lotlCacheAccess, List<CacheAccessByKey> preceedingPivotCacheAccessByKeyList, DSSFileLoader dssFileLoader) {
        super(pivotSource, pivotCacheAccess, dssFileLoader);
        this.lotlCacheAccess = lotlCacheAccess;
        this.preceedingPivotCacheAccessByKeyList = preceedingPivotCacheAccessByKeyList;
    }

    @Override
    public PivotProcessingResult call() throws Exception {
        DSSDocument pivot = this.download(this.getSource().getUrl());
        if (pivot != null) {
            this.parsing(pivot);
            ParsingCacheDTO parsingResult = this.getCacheAccessByKey().getParsingReadOnlyResult();
            OtherTSLPointer xmlLotlPointer = ParsingUtils.getXMLLOTLPointer(parsingResult);
            if (xmlLotlPointer != null) {
                return new PivotProcessingResult(pivot, ParsingUtils.getLOTLAnnouncedCertificateSource(xmlLotlPointer), xmlLotlPointer.getTSLLocation());
            }
        }
        return null;
    }

    @Override
    protected AbstractParsingTask<?> getParsingTask(DSSDocument document) {
        return new LOTLParsingTask(document, (LOTLSource)this.getSource());
    }

    @Override
    protected void expireCache() {
        super.expireCache();
        this.lotlCacheAccess.expireValidation();
        if (Utils.isCollectionNotEmpty(this.preceedingPivotCacheAccessByKeyList)) {
            for (CacheAccessByKey pivotCacheAccessByKey : this.preceedingPivotCacheAccessByKeyList) {
                pivotCacheAccessByKey.expireValidation();
            }
        }
    }
}

