/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts.handlers.log;

import eu.europa.esig.dss.alert.handler.AlertHandler;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogOJUrlChangeAlertHandler
implements AlertHandler<LOTLInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(LogOJUrlChangeAlertHandler.class);

    public void process(LOTLInfo currentInfo) {
        if (currentInfo.getParsingCacheInfo() != null) {
            LOG.warn("The Official Journal URL has changed - new location : {}", (Object)currentInfo.getParsingCacheInfo().getSigningCertificateAnnouncementUrl());
        } else {
            LOG.warn("No parsing result found for a LOTL with URL '{}'", (Object)currentInfo.getUrl());
        }
    }
}

