/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.RepositoryRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcRevocationSource<R extends Revocation>
extends RepositoryRevocationSource<R> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRevocationSource.class);
    private static final long serialVersionUID = 8752226611048306095L;
    private transient JdbcCacheConnector jdbcCacheConnector;

    protected JdbcRevocationSource() {
    }

    protected abstract SqlQuery getCreateTableQuery();

    protected abstract SqlQuery getTableExistenceQuery();

    protected abstract SqlQuery getDeleteTableQuery();

    protected abstract SqlQuery getInsertRevocationTokenEntryQuery();

    protected abstract SqlQuery getUpdateRevocationTokenEntryQuery();

    protected abstract SqlQuery getRemoveRevocationTokenEntryQuery();

    protected abstract RevocationToken<R> buildRevocationTokenFromResult(SqlRecord var1, CertificateToken var2, CertificateToken var3) throws DSSExternalResourceException;

    protected JdbcCacheConnector getJdbcCacheConnector() {
        Objects.requireNonNull(this.jdbcCacheConnector, "JdbcCacheConnector shall be provided! Use setJdbcCacheConnector(jdbcCacheConnector) method.");
        return this.jdbcCacheConnector;
    }

    public void setJdbcCacheConnector(JdbcCacheConnector jdbcCacheConnector) {
        this.jdbcCacheConnector = jdbcCacheConnector;
    }

    @Override
    protected List<RevocationToken<R>> findRevocations(String key, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        Collection<SqlRecord> responses = this.getJdbcCacheConnector().select(this.getRevocationDataExtractQuery(), key);
        LOG.debug("Record obtained : {}", (Object)responses.size());
        if (Utils.isCollectionNotEmpty(responses)) {
            return this.getRevocationDataFromRecords(responses, certificateToken, issuerCertificateToken);
        }
        return Collections.emptyList();
    }

    private List<RevocationToken<R>> getRevocationDataFromRecords(Collection<SqlRecord> records, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        ArrayList<RevocationToken<R>> revocationTokens = new ArrayList<RevocationToken<R>>();
        for (SqlRecord sqlRecord : records) {
            RevocationToken<R> revocationToken = this.buildRevocationTokenFromResult(sqlRecord, certificateToken, issuerCertificateToken);
            if (revocationToken == null) continue;
            revocationTokens.add(revocationToken);
        }
        return revocationTokens;
    }

    protected abstract SqlSelectQuery getRevocationDataExtractQuery();

    @Override
    protected void removeRevocation(String revocationTokenKey) {
        this.getJdbcCacheConnector().execute(this.getRemoveRevocationTokenEntryQuery(), revocationTokenKey);
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    private void createTable() throws SQLException {
        this.getJdbcCacheConnector().executeThrowable(this.getCreateTableQuery());
    }

    public boolean isTableExists() {
        return this.getJdbcCacheConnector().tableQuery(this.getTableExistenceQuery());
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        this.getJdbcCacheConnector().executeThrowable(this.getDeleteTableQuery());
    }
}

