/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateReorderer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class BaselineBCertificateSelector
extends CertificateReorderer {
    private CertificateSource trustedCertificateSource;
    private boolean trustAnchorBPPolicy = true;

    public BaselineBCertificateSelector(CertificateToken signingCertificate, Collection<CertificateToken> certificateChain) {
        super(signingCertificate, certificateChain);
    }

    public BaselineBCertificateSelector setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
        return this;
    }

    public BaselineBCertificateSelector setTrustAnchorBPPolicy(boolean trustAnchorBPPolicy) {
        this.trustAnchorBPPolicy = trustAnchorBPPolicy;
        return this;
    }

    public List<CertificateToken> getCertificates() {
        List<CertificateToken> orderedCertificates = this.getOrderedCertificates();
        if (this.trustAnchorBPPolicy && this.trustedCertificateSource != null) {
            LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
            for (CertificateToken certificateToken : orderedCertificates) {
                if (this.trustedCertificateSource.isTrusted(certificateToken)) break;
                result.add(certificateToken);
            }
            return result;
        }
        return orderedCertificates;
    }
}

