/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.FileRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheOCSPSource
extends FileRevocationSource<OCSP>
implements OCSPSource {
    private static final long serialVersionUID = 4464882643639588480L;
    private static final Logger LOG = LoggerFactory.getLogger(FileCacheOCSPSource.class);
    private static final String OCSP_FILE_EXTENSION = ".ocsp";

    public FileCacheOCSPSource() {
    }

    public FileCacheOCSPSource(OCSPSource proxiedSource) {
        super((RevocationSource)proxiedSource);
    }

    protected OCSPToken reconstructTokenFromEncodedData(FileRevocationSource.FileCacheEntry revocationCache, CertificateToken certificateToken, CertificateToken issuerCertToken) {
        try {
            OCSPResp ocspResp = new OCSPResp(revocationCache.getRevocationDataBinaries());
            Object responseObject = ocspResp.getResponseObject();
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)responseObject;
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse((BasicOCSPResp)basicOCSPResp, (CertificateToken)certificateToken, (CertificateToken)issuerCertToken);
            OCSPToken token = new OCSPToken(basicOCSPResp, latestSingleResponse, certificateToken, issuerCertToken);
            token.setExternalOrigin(RevocationOrigin.CACHED);
            token.setSourceURL(revocationCache.getRevocationDataSourceUrl());
            return token;
        }
        catch (Exception e) {
            LOG.error("Failed to create OCSP token from cached data for certificate '{}': {}", (Object)certificateToken.getDSSIdAsString(), (Object)e.getMessage());
            return null;
        }
    }

    protected String getRevocationFileExtension() {
        return OCSP_FILE_EXTENSION;
    }

    protected String getRevocationTokenKey(CertificateToken certificateToken, String revocationAccessUrl) {
        return DSSUtils.getNormalizedString((String)revocationAccessUrl);
    }

    protected List<String> getRevocationAccessUrls(CertificateToken certificateToken) {
        return CertificateExtensionsUtils.getOCSPAccessUrls((CertificateToken)certificateToken);
    }

    protected List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        ArrayList<String> revocationKeys = new ArrayList<String>();
        List<String> ocspUrls = this.getRevocationAccessUrls(certificateToken);
        for (String ocspUrl : ocspUrls) {
            revocationKeys.add(this.getRevocationTokenKey(certificateToken, ocspUrl));
        }
        return revocationKeys;
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, false);
    }
}

