/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.FileRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheCRLSource
extends FileRevocationSource<CRL>
implements CRLSource {
    private static final long serialVersionUID = 5466286947813965429L;
    private static final Logger LOG = LoggerFactory.getLogger(FileCacheCRLSource.class);
    private static final String CRL_FILE_EXTENSION = ".crl";

    public FileCacheCRLSource() {
    }

    public FileCacheCRLSource(CRLSource proxiedSource) {
        super((RevocationSource)proxiedSource);
    }

    protected RevocationToken<CRL> reconstructTokenFromEncodedData(FileRevocationSource.FileCacheEntry revocationCache, CertificateToken certificateToken, CertificateToken issuerCertToken) {
        try {
            CRLBinary crlBinary = CRLUtils.buildCRLBinary((byte[])revocationCache.getRevocationDataBinaries());
            CertificateToken revocationIssuer = revocationCache.getIssuerCertificateToken();
            if (revocationIssuer == null) {
                revocationIssuer = issuerCertToken;
            }
            CRLValidity crlValidity = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)revocationIssuer);
            crlValidity.setIssuerToken(revocationIssuer);
            CRLToken token = new CRLToken(certificateToken, crlValidity);
            token.setExternalOrigin(RevocationOrigin.CACHED);
            token.setSourceURL(revocationCache.getRevocationDataSourceUrl());
            return token;
        }
        catch (Exception e) {
            LOG.error("Failed to create CRL token from cached data for certificate '{}': {}", (Object)certificateToken.getDSSIdAsString(), (Object)e.getMessage());
            return null;
        }
    }

    protected void saveRevocationToken(FileRevocationSource.FileCacheEntry revocationCache, RevocationToken<CRL> token) {
        super.saveRevocationToken(revocationCache, token);
        if (token.getIssuerCertificateToken() != null) {
            revocationCache.saveCertificateToken(token.getIssuerCertificateToken());
        }
    }

    protected String getRevocationFileExtension() {
        return CRL_FILE_EXTENSION;
    }

    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSUtils.getNormalizedString((String)urlString);
    }

    protected List<String> getRevocationAccessUrls(CertificateToken certificateToken) {
        return CertificateExtensionsUtils.getCRLAccessUrls((CertificateToken)certificateToken);
    }

    protected List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        List<String> crlUrls = this.getRevocationAccessUrls(certificateToken);
        ArrayList<String> keys = new ArrayList<String>();
        for (String crlUrl : crlUrls) {
            keys.add(this.getRevocationTokenKey(certificateToken, crlUrl));
        }
        return keys;
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, false);
    }
}

