/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFile
implements Serializable {
    private static final long serialVersionUID = -5971045309587760817L;
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFile.class);
    private DSSDocument document;
    private String signatureFilename;
    private List<ManifestEntry> entries;
    private ASiCManifestTypeEnum manifestType;

    public DSSDocument getDocument() {
        return this.document;
    }

    public void setDocument(DSSDocument document) {
        this.document = document;
    }

    public String getFilename() {
        return this.document.getName();
    }

    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    public String getDigestBase64String(DigestAlgorithm digestAlgorithm) {
        return this.document.getDigest(digestAlgorithm);
    }

    public List<ManifestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ManifestEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
    }

    public ASiCManifestTypeEnum getManifestType() {
        return this.manifestType;
    }

    public void setManifestType(ASiCManifestTypeEnum manifestType) {
        this.manifestType = manifestType;
    }

    @Deprecated
    public boolean isTimestampManifest() {
        return this.manifestType != null && ASiCManifestTypeEnum.TIMESTAMP == this.manifestType;
    }

    @Deprecated
    public void setTimestampManifest(boolean timestampManifest) {
        LOG.warn("Use of deprecated method #setTimestampManifest! Use #setManifestType instead.");
        this.setManifestType(ASiCManifestTypeEnum.TIMESTAMP);
    }

    @Deprecated
    public boolean isArchiveManifest() {
        return this.manifestType != null && ASiCManifestTypeEnum.ARCHIVE_MANIFEST == this.manifestType;
    }

    @Deprecated
    public void setArchiveManifest(boolean archiveManifest) {
        LOG.warn("Use of deprecated method #setTimestampManifest! Use #setManifestType instead.");
        this.setManifestType(ASiCManifestTypeEnum.ARCHIVE_MANIFEST);
    }

    public ManifestEntry getRootFile() {
        for (ManifestEntry entry : this.getEntries()) {
            if (!entry.isRootfile()) continue;
            return entry;
        }
        return null;
    }

    public boolean isDocumentCovered(String documentName) {
        if (documentName != null && documentName.length() > 0) {
            for (ManifestEntry entry : this.getEntries()) {
                if (!documentName.equals(entry.getFileName())) continue;
                return true;
            }
        }
        return false;
    }
}

