/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.signature.FileNameBuilder;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SignatureValueChecker;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.Signature;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureService<SP extends SerializableSignatureParameters, TP extends SerializableTimestampParameters>
implements DocumentSignatureService<SP, TP> {
    private static final Logger LOG;
    protected final CertificateVerifier certificateVerifier;
    protected TSPSource tspSource;

    protected AbstractSignatureService(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null !");
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void assertSigningCertificateValid(AbstractSignatureParameters<?> parameters) {
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        if (signingCertificate == null) {
            if (parameters.isGenerateTBSWithoutCertificate()) {
                return;
            }
            throw new IllegalArgumentException("Signing Certificate is not defined! Set signing certificate or use method setGenerateTBSWithoutCertificate(true).");
        }
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, parameters);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signingCertificate);
    }

    protected SignatureValue ensureSignatureValue(SignatureAlgorithm targetSignatureAlgorithm, SignatureValue signatureValue) {
        return new SignatureValueChecker().ensureSignatureValue(signatureValue, targetSignatureAlgorithm);
    }

    protected String getFinalDocumentName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, SignaturePackaging packaging, MimeType containerMimeType) {
        return new FileNameBuilder().setOriginalFilename(originalFile.getName()).setSigningOperation(operation).setSignatureLevel(level).setSignaturePackaging(packaging).setMimeType(containerMimeType).build();
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation) {
        return this.getFinalFileName(originalFile, operation, null);
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level) {
        return this.getFinalDocumentName(originalFile, operation, level, null);
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, SignaturePackaging packaging) {
        return this.getFinalDocumentName(originalFile, operation, level, packaging, null);
    }

    protected String getFinalDocumentName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, MimeType containerMimeType) {
        return this.getFinalDocumentName(originalFile, operation, level, null, containerMimeType);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, TP parameters) {
        throw new UnsupportedOperationException("Unsupported operation for this file format");
    }

    @Override
    public boolean isValidSignatureValue(ToBeSigned toBeSigned, SignatureValue signatureValue, CertificateToken signingCertificate) {
        Objects.requireNonNull(toBeSigned, "ToBeSigned cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        Objects.requireNonNull(signingCertificate, "CertificateToken cannot be null!");
        try {
            Signature signature = Signature.getInstance(signatureValue.getAlgorithm().getJCEId(), DSSSecurityProvider.getSecurityProviderName());
            signature.initVerify(signingCertificate.getPublicKey());
            signature.update(toBeSigned.getBytes());
            return signature.verify(signatureValue.getValue());
        }
        catch (IllegalStateException | GeneralSecurityException e) {
            LOG.error("Unable to verify the signature value : {}", (Object)e.getMessage());
            return false;
        }
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
        LOG = LoggerFactory.getLogger(AbstractSignatureService.class);
    }
}

