/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.evidencerecord;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import java.util.List;

public interface EvidenceRecord
extends IdentifierBasedObject {
    public String getFilename();

    public List<ReferenceValidation> getReferenceValidation();

    public List<DSSDocument> getDetachedContents();

    public TokenCertificateSource getCertificateSource();

    public OfflineRevocationSource<CRL> getCRLSource();

    public OfflineRevocationSource<OCSP> getOCSPSource();

    public List<TimestampToken> getTimestamps();

    public List<EvidenceRecord> getDetachedEvidenceRecords();

    public void addExternalEvidenceRecord(EvidenceRecord var1);

    public List<SignatureScope> getEvidenceRecordScopes();

    public void setEvidenceRecordScopes(List<SignatureScope> var1);

    public List<String> getStructureValidationResult();

    public EvidenceRecordTypeEnum getReferenceRecordType();

    public ManifestFile getManifestFile();

    public List<TimestampedReference> getTimestampedReferences();

    public void setTimestampedReferences(List<TimestampedReference> var1);

    public String getId();

    public byte[] getEncoded();
}

