/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.EndorsementType;
import java.util.Date;

public class SignerRole {
    private final String role;
    private final EndorsementType category;
    private Date notBefore;
    private Date notAfter;

    public SignerRole(String role, EndorsementType category) {
        this.role = role;
        this.category = category;
    }

    public String getRole() {
        return this.role;
    }

    public EndorsementType getCategory() {
        return this.category;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public String toString() {
        return "SignerRole [category=" + this.category.name() + ", role details=" + this.role + ", notBefore=" + this.notBefore + ", notAfter=" + this.notAfter + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SignerRole)) {
            return false;
        }
        SignerRole s = (SignerRole)obj;
        if (!this.category.equals((Object)s.category)) {
            return false;
        }
        if (!this.role.equals(s.role)) {
            return false;
        }
        if (this.notBefore == null && s.notBefore != null || this.notBefore != null && !this.notBefore.equals(s.notBefore)) {
            return false;
        }
        return (this.notAfter != null || s.notAfter == null) && (this.notAfter == null || this.notAfter.equals(s.notAfter));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.notBefore == null ? 0 : this.notBefore.hashCode());
        result = 31 * result + (this.notAfter == null ? 0 : this.notAfter.hashCode());
        return result;
    }
}

