/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignatureAttribute;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCertificateSource;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampTokenIdentifier;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampToken
extends Token {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampToken.class);
    private final TimeStampToken timeStamp;
    private final TimestampType timeStampType;
    private final TimestampCertificateSource certificateSource;
    private final TimestampCRLSource crlSource;
    private final TimestampOCSPSource ocspSource;
    private final List<TimestampedReference> timestampedReferences;
    private boolean processed = false;
    private Digest messageImprint;
    private boolean messageImprintData;
    private Boolean messageImprintIntact = null;
    private String fileName;
    private List<SignatureScope> timestampScopes;
    private ManifestFile manifestFile;
    private List<TimestampInclude> timestampIncludes;
    private ArchiveTimestampType archiveTimestampType;
    private String canonicalizationMethod;
    private X500Principal tsaX500Principal;
    private SignatureAttribute attribute;
    private CandidatesForSigningCertificate candidatesForSigningCertificate;

    public TimestampToken(byte[] binaries, TimestampType type) throws TSPException, IOException, CMSException {
        this(binaries, type, new ArrayList<TimestampedReference>());
    }

    public TimestampToken(byte[] binaries, TimestampType type, List<TimestampedReference> timestampedReferences) throws TSPException, IOException, CMSException {
        this(new CMSSignedData(binaries), type, timestampedReferences);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, List<TimestampedReference> timestampedReferences) throws TSPException, IOException {
        this(new TimeStampToken(cms), type, timestampedReferences);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, List<TimestampedReference> timestampedReferences) {
        this.timeStamp = timeStamp;
        this.timeStampType = type;
        this.certificateSource = new TimestampCertificateSource(timeStamp);
        this.ocspSource = new TimestampOCSPSource(timeStamp);
        this.crlSource = new TimestampCRLSource(timeStamp);
        this.timestampedReferences = timestampedReferences;
    }

    public X500Principal getIssuerX500Principal() {
        return this.tsaX500Principal;
    }

    public String getAbbreviation() {
        return this.timeStampType.name() + ": " + this.getDSSIdAsString() + ": " + DSSUtils.formatDateToRFC((Date)this.timeStamp.getTimeStampInfo().getGenTime());
    }

    public TimestampCertificateSource getCertificateSource() {
        return this.certificateSource;
    }

    public TimestampCRLSource getCRLSource() {
        return this.crlSource;
    }

    public TimestampOCSPSource getOCSPSource() {
        return this.ocspSource;
    }

    @Deprecated
    public boolean isSignatureValid() {
        return this.isValid();
    }

    public boolean isValid() {
        return this.isSignatureIntact() && this.isMessageImprintDataFound() && this.isMessageImprintDataIntact();
    }

    public synchronized boolean isSignedBy(CertificateToken certificateToken) {
        if (this.publicKeyOfTheSigner != null) {
            return this.publicKeyOfTheSigner.equals(certificateToken.getPublicKey());
        }
        if (SignatureValidity.VALID == this.checkIsSignedBy(certificateToken)) {
            if (!this.isSelfSigned()) {
                this.publicKeyOfTheSigner = certificateToken.getPublicKey();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isSignedBy(PublicKey publicKey) {
        throw new UnsupportedOperationException("Use method isSignedBy(certificateToken) for a TimestampToken validation!");
    }

    protected SignatureValidity checkIsSignedBy(CertificateToken candidate) {
        X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)candidate);
        if (this.timeStamp.getSID().match((Object)x509CertificateHolder)) {
            SignerInformationVerifier signerInformationVerifier = this.getSignerInformationVerifier(candidate);
            if (this.isValidTimestamp(signerInformationVerifier) || this.isValidCMSSignedData(signerInformationVerifier)) {
                this.signatureValidity = SignatureValidity.VALID;
                this.tsaX500Principal = candidate.getSubject().getPrincipal();
                SignerInformation signerInformation = this.timeStamp.toCMSSignedData().getSignerInfos().get(this.timeStamp.getSID());
                if (SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.getOid().equals(signerInformation.getEncryptionAlgOID())) {
                    this.signatureAlgorithm = SignatureAlgorithm.forOidAndParams((String)signerInformation.getEncryptionAlgOID(), (byte[])signerInformation.getEncryptionAlgParams());
                } else {
                    EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName((String)candidate.getPublicKey().getAlgorithm());
                    AlgorithmIdentifier hashAlgorithm = signerInformation.getDigestAlgorithmID();
                    DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)hashAlgorithm.getAlgorithm().getId());
                    this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
                }
            } else {
                this.signatureValidity = SignatureValidity.INVALID;
            }
            return this.signatureValidity;
        }
        return SignatureValidity.INVALID;
    }

    private boolean isValidTimestamp(SignerInformationVerifier signerInformationVerifier) {
        try {
            this.timeStamp.validate(signerInformationVerifier);
            return true;
        }
        catch (TSPException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to validate timestamp token : ", (Throwable)e);
            } else {
                LOG.warn("Unable to validate timestamp token : {}", (Object)e.getMessage());
            }
            this.signatureInvalidityReason = ((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage();
            return false;
        }
    }

    private boolean isValidCMSSignedData(SignerInformationVerifier signerInformationVerifier) {
        try {
            SignerInformationStore signerInfos = this.timeStamp.toCMSSignedData().getSignerInfos();
            SignerInformation signerInformation = signerInfos.get(this.timeStamp.getSID());
            return signerInformation.verify(signerInformationVerifier);
        }
        catch (CMSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to validate the related CMSSignedData : ", (Throwable)e);
            } else {
                LOG.warn("Unable to validate the related CMSSignedData : {}", (Object)e.getMessage());
            }
            this.signatureInvalidityReason = ((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage();
            return false;
        }
    }

    private SignerInformationVerifier getSignerInformationVerifier(CertificateToken candidate) {
        try {
            JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
            verifier.setProvider(DSSSecurityProvider.getSecurityProviderName());
            return verifier.build(candidate.getCertificate());
        }
        catch (OperatorException e) {
            throw new DSSException("Unable to build an instance of SignerInformationVerifier", (Throwable)e);
        }
    }

    protected SignatureValidity checkIsSignedBy(PublicKey publicKey) {
        throw new UnsupportedOperationException("Use method checkIsSignedBy(certificateToken) for a TimestampToken validation!");
    }

    public boolean matchData(DSSDocument timestampedData) {
        return this.matchData(timestampedData, false);
    }

    public boolean matchData(DSSDocument timestampedData, boolean suppressMatchWarnings) {
        this.processed = true;
        this.messageImprintData = timestampedData != null;
        this.messageImprintIntact = false;
        if (!this.messageImprintData) {
            LOG.warn("Timestamped data not found !");
            return false;
        }
        Digest currentMessageImprint = this.getMessageImprint();
        String computedBase64Digest = timestampedData.getDigest(currentMessageImprint.getAlgorithm());
        return this.matchData(Utils.fromBase64((String)computedBase64Digest), suppressMatchWarnings);
    }

    public boolean matchData(DSSMessageDigest messageDigest) {
        return this.matchData(messageDigest, false);
    }

    public boolean matchData(DSSMessageDigest messageDigest, boolean suppressMatchWarnings) {
        this.processed = true;
        if (messageDigest == null || messageDigest.isEmpty()) {
            this.messageImprintIntact = false;
            if (!suppressMatchWarnings) {
                LOG.warn("Invalid or incomplete message-digest has been provided for timestamp verification!");
            }
        } else if (this.getDigestAlgorithm() != messageDigest.getAlgorithm()) {
            this.messageImprintIntact = false;
            if (!suppressMatchWarnings) {
                LOG.warn("DigestAlgorithm '{}' used in the provided message-digest does not match the one used in the timestamp token '{}'!", (Object)messageDigest.getAlgorithm(), (Object)this.getDigestAlgorithm());
            }
        } else {
            this.messageImprintIntact = this.matchData(messageDigest.getValue(), suppressMatchWarnings);
        }
        return this.messageImprintIntact;
    }

    public boolean matchData(byte[] expectedMessageImprintDigest) {
        return this.matchData(expectedMessageImprintDigest, false);
    }

    public boolean matchData(byte[] expectedMessageImprintDigest, boolean suppressMatchWarnings) {
        this.processed = true;
        this.messageImprintData = expectedMessageImprintDigest != null;
        this.messageImprintIntact = false;
        if (this.messageImprintData) {
            Digest currentMessageImprint = this.getMessageImprint();
            this.messageImprintIntact = Arrays.equals(expectedMessageImprintDigest, currentMessageImprint.getValue());
            if (!this.messageImprintIntact.booleanValue() && !suppressMatchWarnings) {
                LOG.warn("Provided digest value for TimestampToken matchData : {}", (Object)Utils.toBase64((byte[])expectedMessageImprintDigest));
                LOG.warn("Digest ({}) present in TimestampToken : {}", (Object)currentMessageImprint.getAlgorithm(), (Object)Utils.toBase64((byte[])currentMessageImprint.getValue()));
                LOG.warn("Digest in TimestampToken matches digest of extracted data from document: {}", (Object)this.messageImprintIntact);
            }
        } else {
            LOG.warn("Timestamped data not found !");
        }
        return this.messageImprintIntact;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public TimestampType getTimeStampType() {
        return this.timeStampType;
    }

    public Date getGenerationTime() {
        return this.timeStamp.getTimeStampInfo().getGenTime();
    }

    public Date getCreationDate() {
        return this.getGenerationTime();
    }

    public Digest getMessageImprint() {
        if (this.messageImprint == null) {
            DigestAlgorithm messageImprintDigestAlgo = this.getDigestAlgorithm();
            byte[] messageImprintDigestValue = this.timeStamp.getTimeStampInfo().getMessageImprintDigest();
            this.messageImprint = new Digest(messageImprintDigestAlgo, messageImprintDigestValue);
        }
        return this.messageImprint;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        ASN1ObjectIdentifier oid = this.timeStamp.getTimeStampInfo().getMessageImprintAlgOID();
        return DigestAlgorithm.forOID((String)oid.getId());
    }

    public boolean isMessageImprintDataFound() {
        return Utils.isTrue((Boolean)this.messageImprintData);
    }

    public boolean isMessageImprintDataIntact() {
        if (!this.processed) {
            throw new IllegalStateException("Invoke matchData(byte[] data) method before!");
        }
        return Utils.isTrue((Boolean)this.messageImprintIntact);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ManifestFile getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public List<TimestampedReference> getTimestampedReferences() {
        return this.timestampedReferences;
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.archiveTimestampType;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public byte[] getEncoded() {
        return DSSASN1Utils.getDEREncoded((TimeStampToken)this.timeStamp);
    }

    public List<TimestampInclude> getTimestampIncludes() {
        return this.timestampIncludes;
    }

    public void setTimestampIncludes(List<TimestampInclude> timestampIncludes) {
        this.timestampIncludes = timestampIncludes;
    }

    public List<SignatureScope> getTimestampScopes() {
        return this.timestampScopes;
    }

    public void setTimestampScopes(List<SignatureScope> timestampScopes) {
        this.timestampScopes = timestampScopes;
    }

    public List<CertificateToken> getCertificates() {
        return this.certificateSource.getCertificates();
    }

    public Set<CertificateRef> getCertificateRefs() {
        return this.certificateSource.getAllCertificateRefs();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.timeStamp.getUnsignedAttributes();
    }

    public X500Principal getTSTInfoTsa() {
        GeneralName tsaGeneralName = this.timeStamp.getTimeStampInfo().getTsa();
        if (tsaGeneralName != null) {
            try {
                X500Name x500Name = X500Name.getInstance((Object)tsaGeneralName.getName());
                return new X500Principal(x500Name.getEncoded());
            }
            catch (IOException e) {
                LOG.warn("Unable to decode TSTInfo.tsa attribute value to X500Principal. Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public TimeStampToken getTimeStamp() {
        return this.timeStamp;
    }

    public SignatureAttribute getTimestampAttribute() {
        return this.attribute;
    }

    public void setTimestampAttribute(SignatureAttribute attribute) {
        this.attribute = attribute;
    }

    public String toString(String indentStr) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(indentStr).append("TimestampToken[signedBy=").append(this.getIssuerX500Principal());
            out.append(", generated: ").append(DSSUtils.formatDateToRFC((Date)this.timeStamp.getTimeStampInfo().getGenTime()));
            out.append(" / ").append(this.timeStampType).append('\n');
            if (this.isSignatureIntact()) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: VALID").append('\n');
                indentStr = indentStr.substring(1);
            } else if (!this.signatureInvalidityReason.isEmpty()) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: INVALID").append(" - ").append(this.signatureInvalidityReason).append('\n');
                indentStr = indentStr.substring(1);
            }
            indentStr = indentStr + "\t";
            if (this.messageImprintIntact != null) {
                if (this.messageImprintIntact.booleanValue()) {
                    out.append(indentStr).append("Timestamp MATCHES the signed data.").append('\n');
                } else {
                    out.append(indentStr).append("Timestamp DOES NOT MATCH the signed data.").append('\n');
                }
            }
            out.append(']');
            return out.toString();
        }
        catch (Exception e) {
            return ((Object)((Object)this)).getClass().getName();
        }
    }

    public Set<SignerIdentifier> getSignerInformationStoreInfos() {
        return this.getCertificateSource().getAllCertificateIdentifiers();
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate == null) {
            this.candidatesForSigningCertificate = this.getCertificateSource().getCandidatesForSigningCertificate(null);
        }
        return this.candidatesForSigningCertificate;
    }

    public SignerInformation getSignerInformation() {
        Collection signers = this.timeStamp.toCMSSignedData().getSignerInfos().getSigners(this.timeStamp.getSID());
        return (SignerInformation)signers.iterator().next();
    }

    protected TokenIdentifier buildTokenIdentifier() {
        return new TimestampTokenIdentifier(this);
    }
}

