/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.status;

import eu.europa.esig.dss.alert.status.ObjectStatus;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SignatureStatus
extends ObjectStatus {
    private final Map<AdvancedSignature, String> relatedSignatureMap = new HashMap<AdvancedSignature, String>();

    public void addRelatedTokenAndErrorMessage(AdvancedSignature signature, String errorMessage) {
        super.addRelatedObjectIdentifierAndErrorMessage(signature.getId(), errorMessage);
        this.relatedSignatureMap.put(signature, errorMessage);
    }

    public Collection<AdvancedSignature> getRelatedSignatures() {
        return this.relatedSignatureMap.keySet();
    }

    public String getMessageForSignature(AdvancedSignature signature) {
        return this.relatedSignatureMap.get(signature);
    }

    public boolean isEmpty() {
        return super.isEmpty() && Utils.isMapEmpty(this.relatedSignatureMap);
    }
}

