/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.LinkedList;
import java.util.List;

public class BaselineBCertificateSelector
extends CertificateReorderer {
    private final CertificateVerifier certificateVerifier;
    private final AbstractSignatureParameters<?> parameters;

    public BaselineBCertificateSelector(CertificateVerifier certificateVerifier, AbstractSignatureParameters<?> parameters) {
        super(parameters.getSigningCertificate(), parameters.getCertificateChain());
        this.certificateVerifier = certificateVerifier;
        this.parameters = parameters;
    }

    public List<CertificateToken> getCertificates() {
        List<CertificateToken> orderedCertificates = this.getOrderedCertificates();
        ListCertificateSource trustedCertSources = this.certificateVerifier.getTrustedCertSources();
        if (this.parameters.bLevel().isTrustAnchorBPPolicy() && !trustedCertSources.isEmpty()) {
            LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
            for (CertificateToken certificateToken : orderedCertificates) {
                if (trustedCertSources.isTrusted(certificateToken)) break;
                result.add(certificateToken);
            }
            return result;
        }
        return orderedCertificates;
    }
}

