/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.timestamp;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.validation.timestamp.TimestampMessageDigestBuilder;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampMessageDigestBuilder
implements TimestampMessageDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampMessageDigestBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken with Id '{}'. Reason : {}";
    private final CMS cms;
    private final SignerInformation signerInformation;
    private final List<DSSDocument> detachedDocuments;
    private final CadesLevelBaselineLTATimestampExtractor timestampExtractor;
    private DigestAlgorithm digestAlgorithm;
    private TimestampToken timestampToken;

    public CAdESTimestampMessageDigestBuilder(CAdESSignature signature, DigestAlgorithm digestAlgorithm) {
        this(signature, signature.getCertificateSource().getSignedDataCertificates());
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public CAdESTimestampMessageDigestBuilder(CAdESSignature signature, ListCertificateSource certificateSource, TimestampToken timestampToken) {
        this(signature, certificateSource.getCertificates());
        Objects.requireNonNull(timestampToken, "TimestampToken cannot be null!");
        this.timestampToken = timestampToken;
        this.digestAlgorithm = timestampToken.getDigestAlgorithm();
    }

    private CAdESTimestampMessageDigestBuilder(CAdESSignature signature, List<CertificateToken> certificates) {
        Objects.requireNonNull(signature, "Signature cannot be null!");
        Objects.requireNonNull(certificates, "List of CertificateToken's cannot be null!");
        this.cms = signature.getCMS();
        this.signerInformation = signature.getSignerInformation();
        this.detachedDocuments = signature.getDetachedContents();
        this.timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(signature);
    }

    public DSSMessageDigest getContentTimestampMessageDigest() {
        return this.getOriginalDocumentDigest();
    }

    public DSSMessageDigest getSignatureTimestampMessageDigest() {
        byte[] signature = this.signerInformation.getSignature();
        return new DSSMessageDigest(this.digestAlgorithm, DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])signature));
    }

    public DSSMessageDigest getTimestampX1MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            digestCalculator.update(this.signerInformation.getSignature());
            Object[] attributes = CAdESUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            if (Utils.isArrayNotEmpty((Object[])attributes)) {
                for (Object attribute : attributes) {
                    digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                    digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
                }
            }
            this.writeTimestampX2MessageDigest(digestCalculator);
            return digestCalculator.getMessageDigest(this.digestAlgorithm);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, new Object[]{this.timestampToken.getDSSIdAsString(), e.getMessage(), e});
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)this.timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public DSSMessageDigest getTimestampX2MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeTimestampX2MessageDigest(digestCalculator);
            return digestCalculator.getMessageDigest(this.digestAlgorithm);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, new Object[]{this.timestampToken.getDSSIdAsString(), e.getMessage(), e});
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)this.timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    private void writeTimestampX2MessageDigest(DSSMessageDigestCalculator digestCalculator) {
        Object[] revAttributes;
        Object[] certAttributes = CAdESUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        if (Utils.isArrayNotEmpty((Object[])certAttributes)) {
            for (Object attribute : certAttributes) {
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
            }
        }
        if (Utils.isArrayNotEmpty((Object[])(revAttributes = CAdESUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs)))) {
            for (Object attribute : revAttributes) {
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
            }
        }
    }

    public DSSMessageDigest getArchiveTimestampMessageDigest() {
        DSSMessageDigest messageDigest;
        ArchiveTimestampType archiveTimestampType = this.timestampToken != null ? this.timestampToken.getArchiveTimestampType() : ArchiveTimestampType.CAdES_V3;
        switch (archiveTimestampType) {
            case CAdES_V2: {
                messageDigest = this.getArchiveTimestampDataV2(true);
                if (this.timestampToken.matchData(messageDigest, true)) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to match message imprint for an Archive TimestampToken V2 with Id '{}' by including unsigned attribute tags and length, try to compute the data without...", (Object)this.timestampToken.getDSSIdAsString());
                }
                messageDigest = this.getArchiveTimestampDataV2(false);
                break;
            }
            case CAdES_V3: {
                messageDigest = this.getArchiveTimestampDataV3();
                break;
            }
            default: {
                throw new DSSException("Unsupported ArchiveTimestampType " + archiveTimestampType);
            }
        }
        return messageDigest;
    }

    private DSSMessageDigest getArchiveTimestampDataV3() throws DSSException {
        Attribute atsHashIndexAttribute = this.timestampExtractor.getVerifiedAtsHashIndex(this.signerInformation, this.timestampToken);
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument != null) {
            return this.timestampExtractor.getArchiveTimestampV3MessageImprint(this.signerInformation, atsHashIndexAttribute, originalDocument, this.digestAlgorithm);
        }
        LOG.warn("The original document is not found for TimestampToken with Id '{}'! Unable to compute message imprint.", (Object)this.timestampToken.getDSSIdAsString());
        return DSSMessageDigest.createEmptyDigest();
    }

    private DSSMessageDigest getOriginalDocumentDigest() {
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument != null) {
            byte[] digest = originalDocument.getDigestValue(this.digestAlgorithm);
            return new DSSMessageDigest(this.digestAlgorithm, digest);
        }
        LOG.warn("The original document is not found for TimestampToken with Id '{}'! Unable to compute message imprint.", (Object)this.timestampToken.getDSSIdAsString());
        return DSSMessageDigest.createEmptyDigest();
    }

    private DSSMessageDigest getArchiveTimestampDataV2(boolean includeUnsignedAttrsTagAndLength) throws DSSException {
        DSSMessageDigest dSSMessageDigest;
        block11: {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            OutputStream dos = digestCalculator.getOutputStream();
            try {
                this.writeContentInfoBytes(dos);
                if (this.cms.isDetachedSignature()) {
                    this.writeOriginalDocumentBinaries(dos);
                }
                this.writeCertificateDataBytes(dos);
                this.writeCRLDataBytes(dos);
                this.writeSignerInfoBytes(dos, includeUnsignedAttrsTagAndLength);
                dSSMessageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
                if (dos == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errorMessage = "An error in computing of message-imprint for a TimestampToken with Id : %s. Reason : %s";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(String.format(errorMessage, this.timestampToken.getDSSIdAsString(), e.getMessage()), (Throwable)e);
                    } else {
                        LOG.warn(String.format(errorMessage, this.timestampToken.getDSSIdAsString(), e.getMessage()));
                    }
                    return DSSMessageDigest.createEmptyDigest();
                }
            }
            dos.close();
        }
        return dSSMessageDigest;
    }

    private void writeContentInfoBytes(OutputStream os) throws IOException {
        CMSUtils.writeContentInfoEncoded((CMS)this.cms, (OutputStream)os);
    }

    private void writeOriginalDocumentBinaries(OutputStream os) throws IOException {
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument == null) {
            throw new DSSException(String.format("The detached content is not provided for a TimestampToken with Id '%s'. Not possible to compute message imprint!", this.timestampToken.getDSSIdAsString()));
        }
        os.write(DSSUtils.toByteArray((DSSDocument)originalDocument));
    }

    private void writeCertificateDataBytes(OutputStream os) throws IOException {
        CMSUtils.writeSignedDataCertificatesEncoded((CMS)this.cms, (OutputStream)os);
    }

    private void writeCRLDataBytes(OutputStream os) throws IOException {
        CMSUtils.writeSignedDataCRLsEncoded((CMS)this.cms, (OutputStream)os);
    }

    private void writeSignerInfoBytes(OutputStream os, boolean includeUnsignedAttrsTagAndLength) throws IOException {
        SignerInfo signerInfo = this.signerInformation.toASN1Structure();
        ASN1Set unauthenticatedAttributes = signerInfo.getUnauthenticatedAttributes();
        ASN1Sequence filteredUnauthenticatedAttributes = this.filterUnauthenticatedAttributes(unauthenticatedAttributes, this.timestampToken);
        ASN1Sequence asn1Object = this.getSignerInfoEncoded(signerInfo, filteredUnauthenticatedAttributes, includeUnsignedAttrsTagAndLength);
        for (int ii = 0; ii < asn1Object.size(); ++ii) {
            byte[] signerInfoBytes = DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Object.getObjectAt(ii).toASN1Primitive());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SignerInfoBytes: {}", (Object)DSSUtils.toHex((byte[])signerInfoBytes));
            }
            os.write(signerInfoBytes);
        }
    }

    private ASN1Sequence filterUnauthenticatedAttributes(ASN1Set unauthenticatedAttributes, TimestampToken timestampToken) {
        ASN1EncodableVector result = new ASN1EncodableVector();
        for (int ii = 0; ii < unauthenticatedAttributes.size(); ++ii) {
            Attribute attribute = Attribute.getInstance((Object)unauthenticatedAttributes.getObjectAt(ii));
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)attrType) || OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)attrType)) {
                try {
                    TimeStampToken token = CAdESUtils.getTimeStampToken(attribute);
                    if (token == null || !token.getTimeStampInfo().getGenTime().before(timestampToken.getGenerationTime())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new DSSException(String.format("Unexpected error occurred on reading unsigned properties : %s", e.getMessage()), (Throwable)e);
                }
            }
            result.add(unauthenticatedAttributes.getObjectAt(ii));
        }
        return new DERSequence(result);
    }

    private ASN1Sequence getSignerInfoEncoded(SignerInfo signerInfo, ASN1Sequence unauthenticatedAttributes, boolean includeUnsignedAttrsTagAndLength) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)signerInfo.getVersion());
        v.add((ASN1Encodable)signerInfo.getSID());
        v.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
        DERTaggedObject signedAttributes = CAdESUtils.getDERSignedAttributes(this.signerInformation);
        if (signedAttributes != null) {
            v.add((ASN1Encodable)signedAttributes);
        }
        v.add((ASN1Encodable)signerInfo.getDigestEncryptionAlgorithm());
        v.add((ASN1Encodable)signerInfo.getEncryptedDigest());
        if (unauthenticatedAttributes != null) {
            if (includeUnsignedAttrsTagAndLength) {
                v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)unauthenticatedAttributes));
            } else {
                for (int i = 0; i < unauthenticatedAttributes.size(); ++i) {
                    v.add(unauthenticatedAttributes.getObjectAt(i));
                }
            }
        }
        return new DERSequence(v);
    }

    private DSSDocument getOriginalDocument() {
        try {
            return CAdESUtils.getOriginalDocument(this.cms, this.detachedDocuments);
        }
        catch (DSSException e) {
            LOG.warn("Cannot extract original document! Reason : {}", (Object)e.getMessage());
            return null;
        }
    }
}

