/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESEvidenceRecordScopeFinder;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSSignedDocument;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordTimestampScopeFinder;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentAnalyzer
extends DefaultDocumentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentAnalyzer.class);
    protected CMS cms;

    CMSDocumentAnalyzer() {
    }

    @Deprecated
    public CMSDocumentAnalyzer(CMSSignedData cmsSignedData) {
        this.cms = this.toCMS((DSSDocument)new CMSSignedDocument(cmsSignedData));
    }

    public CMSDocumentAnalyzer(CMS cms) {
        this.cms = cms;
    }

    public CMSDocumentAnalyzer(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
        this.cms = this.toCMS(document);
    }

    private CMS toCMS(DSSDocument document) {
        try {
            return CMSUtils.parseToCMS((DSSDocument)document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("A CMS file is expected : %s", e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return !DSSUtils.isTimestampToken((DSSDocument)dssDocument) && !EvidenceRecordAnalyzerFactory.isSupportedDocument((DSSDocument)dssDocument);
        }
        return false;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cms != null) {
            for (SignerInformation signerInformation : this.cms.getSignerInfos().getSigners()) {
                CAdESSignature cadesSignature = new CAdESSignature(this.cms, signerInformation);
                if (this.document != null) {
                    cadesSignature.setFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFile(this.manifestFile);
                cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                cadesSignature.initBaselineRequirementsChecker(this.certificateVerifier);
                this.validateSignaturePolicy((AdvancedSignature)cadesSignature);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    protected void appendExternalEvidenceRecords(List<AdvancedSignature> allSignatureList) {
        super.appendExternalEvidenceRecords(allSignatureList);
        for (AdvancedSignature signature : allSignatureList) {
            List embeddedEvidenceRecords = signature.getEmbeddedEvidenceRecords();
            if (!Utils.isCollectionNotEmpty((Collection)embeddedEvidenceRecords)) continue;
            for (AdvancedSignature coveredSignature : allSignatureList) {
                if (signature == coveredSignature || !this.sameCMS(signature, coveredSignature)) continue;
                embeddedEvidenceRecords.forEach(arg_0 -> ((AdvancedSignature)coveredSignature).addExternalEvidenceRecord(arg_0));
                embeddedEvidenceRecords.forEach(r -> this.addSignatureScope((EvidenceRecord)r, coveredSignature));
            }
        }
    }

    private boolean sameCMS(AdvancedSignature signatureOne, AdvancedSignature signatureTwo) {
        CAdESSignature cadesSignatureOne = (CAdESSignature)signatureOne;
        CAdESSignature cadesSignatureTwo = (CAdESSignature)signatureTwo;
        return cadesSignatureOne.getCMS() == cadesSignatureTwo.getCMS();
    }

    private void addSignatureScope(EvidenceRecord evidenceRecord, AdvancedSignature signature) {
        CAdESEvidenceRecordScopeFinder evidenceRecordScopeFinder = new CAdESEvidenceRecordScopeFinder(evidenceRecord, signature);
        List<SignatureScope> evidenceRecordScopes = evidenceRecordScopeFinder.findEvidenceRecordScope();
        evidenceRecord.setEvidenceRecordScopes(evidenceRecordScopes);
        this.addTimestampedReferences(evidenceRecord.getTimestampedReferences(), evidenceRecordScopes);
        EvidenceRecordTimestampScopeFinder timestampScopeFinder = new EvidenceRecordTimestampScopeFinder(evidenceRecord);
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            List timestampScopes = timestampToken.getTimestampScopes();
            for (SignatureScope evidenceRecordScope : timestampScopeFinder.findTimestampScope(timestampToken)) {
                if (timestampScopes.contains(evidenceRecordScope)) continue;
                timestampToken.getTimestampScopes().add(evidenceRecordScope);
            }
            this.addTimestampedReferences(timestampToken.getTimestampedReferences(), evidenceRecordScopes);
        }
    }

    private void addTimestampedReferences(List<TimestampedReference> references, List<SignatureScope> signatureScopes) {
        for (SignatureScope signatureScope : signatureScopes) {
            TimestampedReference timestampedReference = new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA);
            if (references.contains(timestampedReference)) continue;
            references.add(timestampedReference);
        }
    }

    public CMS getCMS() {
        return this.cms;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Collections.singletonList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

