/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSGenerator;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CMSBuilder {
    private CertificateToken signingCertificate;
    private Collection<CertificateToken> certificateChain;
    private boolean generateWithoutCertificates = false;
    private CertificateSource trustedCertificateSource;
    private boolean trustAnchorBPPolicy = true;
    private CMS originalCMS;
    private boolean encapsulate = true;

    public CMSBuilder setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        return this;
    }

    public CMSBuilder setCertificateChain(Collection<CertificateToken> certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public CMSBuilder setGenerateWithoutCertificates(boolean generateWithoutCertificates) {
        this.generateWithoutCertificates = generateWithoutCertificates;
        return this;
    }

    public CMSBuilder setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
        return this;
    }

    public CMSBuilder setTrustAnchorBPPolicy(boolean trustAnchorBPPolicy) {
        this.trustAnchorBPPolicy = trustAnchorBPPolicy;
        return this;
    }

    public CMSBuilder setOriginalCMS(CMS originalCMS) {
        this.originalCMS = originalCMS;
        return this;
    }

    public CMSBuilder setEncapsulate(boolean encapsulate) {
        this.encapsulate = encapsulate;
        return this;
    }

    public CMS createCMS(SignerInfoGenerator signerInfoGenerator, DSSDocument toSignDocument) {
        CMSGenerator generator = CMSGenerator.loadCMSGenerator();
        generator.setSignerInfoGenerator(signerInfoGenerator);
        generator.setCertificates(this.getCertificateStore());
        generator.setDigestAlgorithmIDs(this.getDigestAlgorithmIDs(signerInfoGenerator));
        generator.setToBeSignedDocument(toSignDocument);
        generator.setEncapsulate(this.encapsulate);
        if (this.originalCMS != null) {
            generator.setSigners(this.originalCMS.getSignerInfos());
            generator.setAttributeCertificates(this.originalCMS.getAttributeCertificates());
            generator.setCRLs(this.originalCMS.getCRLs());
            generator.setOcspBasicStore(this.originalCMS.getOcspBasicStore());
            generator.setOcspResponsesStore(this.originalCMS.getOcspResponseStore());
        }
        return generator.generate();
    }

    private Store<X509CertificateHolder> getCertificateStore() {
        LinkedList<CertificateToken> certificates = new LinkedList<CertificateToken>();
        if (this.originalCMS != null) {
            Store certificateStore = this.originalCMS.getCertificates();
            Collection certificatesMatches = certificateStore.getMatches(null);
            for (X509CertificateHolder certificatesMatch : certificatesMatches) {
                CertificateToken token = DSSASN1Utils.getCertificate((X509CertificateHolder)certificatesMatch);
                if (certificates.contains(token)) continue;
                certificates.add(token);
            }
        }
        return this.getJcaCertStore(certificates);
    }

    private JcaCertStore getJcaCertStore(Collection<CertificateToken> certificates) {
        List certificatesToAdd = this.signingCertificate == null && this.generateWithoutCertificates ? new ArrayList() : new BaselineBCertificateSelector(this.signingCertificate, this.certificateChain).setTrustedCertificateSource(this.trustedCertificateSource).setTrustAnchorBPPolicy(this.trustAnchorBPPolicy).getCertificates();
        for (CertificateToken certificateToken : certificatesToAdd) {
            if (certificates.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (CertificateToken certificateToken : certificates) {
                certs.add(certificateToken.getCertificate());
            }
            return new JcaCertStore(certs);
        }
        catch (CertificateEncodingException e) {
            throw new DSSException(String.format("Unable to get JcaCertStore. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private Set<AlgorithmIdentifier> getDigestAlgorithmIDs(SignerInfoGenerator signerInfoGenerator) {
        HashSet<AlgorithmIdentifier> digestAlgorithmIDs = new HashSet<AlgorithmIdentifier>();
        if (this.originalCMS != null) {
            digestAlgorithmIDs.addAll(this.originalCMS.getDigestAlgorithmIDs());
        }
        digestAlgorithmIDs.add(signerInfoGenerator.getDigestAlgorithm());
        return digestAlgorithmIDs;
    }

    public CMS extendCMSSignedData(Collection<CertificateToken> certificateTokens, Collection<CRLToken> crlTokens, Collection<OCSPToken> ocspTokens) {
        if (this.originalCMS == null) {
            throw new NullPointerException("Original CMSSignedData shall be provided! Use #setOriginalCMSSignedData(CMSSignedData) method.");
        }
        Store certificatesStore = this.originalCMS.getCertificates();
        LinkedHashSet<X509CertificateHolder> newCertificateStore = new LinkedHashSet<X509CertificateHolder>(certificatesStore.getMatches(null));
        for (CertificateToken certificateToken : certificateTokens) {
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)certificateToken);
            newCertificateStore.add(x509CertificateHolder);
        }
        certificatesStore = new CollectionStore(newCertificateStore);
        Store attributeCertificatesStore = this.originalCMS.getAttributeCertificates();
        Store crlsStore = this.originalCMS.getCRLs();
        LinkedHashSet<X509CRLHolder> newCrlsStore = new LinkedHashSet<X509CRLHolder>(crlsStore.getMatches(null));
        for (CRLToken crlToken : crlTokens) {
            X509CRLHolder x509CRLHolder = this.getX509CrlHolder(crlToken);
            newCrlsStore.add(x509CRLHolder);
        }
        crlsStore = new CollectionStore(newCrlsStore);
        Store otherRevocationInfoFormatStoreOcsp = this.originalCMS.getOcspResponseStore();
        LinkedHashSet<ASN1Primitive> newOtherRevocationInfoFormatStore = new LinkedHashSet<ASN1Primitive>(otherRevocationInfoFormatStoreOcsp.getMatches(null));
        for (OCSPToken ocspToken : ocspTokens) {
            ASN1Primitive ocspResponseASN1Primitive = DSSASN1Utils.toASN1Primitive((byte[])ocspToken.getEncoded());
            newOtherRevocationInfoFormatStore.add(ocspResponseASN1Primitive);
        }
        otherRevocationInfoFormatStoreOcsp = new CollectionStore(newOtherRevocationInfoFormatStore);
        Store otherRevocationInfoFormatStoreBasic = this.originalCMS.getOcspBasicStore();
        return CMSUtils.replaceCertificatesAndCRLs((CMS)this.originalCMS, (Store)certificatesStore, (Store)attributeCertificatesStore, (Store)crlsStore, (Store)otherRevocationInfoFormatStoreOcsp, (Store)otherRevocationInfoFormatStoreBasic);
    }

    private X509CRLHolder getX509CrlHolder(CRLToken crlToken) {
        X509CRLHolder x509CRLHolder;
        block8: {
            InputStream is = crlToken.getCRLStream();
            try {
                x509CRLHolder = new X509CRLHolder(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Unable to convert X509CRL to X509CRLHolder", (Throwable)e);
                }
            }
            is.close();
        }
        return x509CRLHolder;
    }
}

