/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineT
extends CAdESSignatureExtension {
    public CAdESLevelBaselineT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMS extendCMSSignatures(CMS cms, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        CMSDocumentAnalyzer documentAnalyzer = this.getDocumentValidator(cms, parameters);
        List signatures = documentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        List<AdvancedSignature> signaturesToExtend = this.getExtendToTLevelSignatures(signatures, signatureIdsToExtend, parameters);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return cms;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(parameters);
        signatureRequirementsChecker.assertExtendToTLevelPossible(signaturesToExtend);
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signaturesToExtend);
        for (AdvancedSignature signature : signatures) {
            SignerInformation signerInformation;
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
            if (signaturesToExtend.contains((Object)cadesSignature)) {
                newSignerInformation = this.extendSignerInformation(signerInformation, parameters);
            }
            newSignerInformationList.add(newSignerInformation);
        }
        return this.replaceSigners(cms, newSignerInformationList);
    }

    private SignerInformation extendSignerInformation(SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        unsignedAttributes = this.addSignatureTimestampAttribute(signerInformation, unsignedAttributes, parameters);
        return CMSUtils.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
    }

    protected SignatureRequirementsChecker getSignatureRequirementsChecker(CAdESSignatureParameters parameters) {
        return new SignatureRequirementsChecker(this.certificateVerifier, (AbstractSignatureParameters)parameters);
    }

    private List<AdvancedSignature> getExtendToTLevelSignatures(List<AdvancedSignature> signatures, List<String> signatureIdsToExtend, CAdESSignatureParameters parameters) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!signatureIdsToExtend.contains(signature.getId()) || !this.tLevelExtensionRequired(signature, parameters)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean tLevelExtensionRequired(AdvancedSignature cadesSignature, CAdESSignatureParameters parameters) {
        return SignatureLevel.CAdES_BASELINE_T.equals((Object)parameters.getSignatureLevel()) || !cadesSignature.hasTProfile();
    }

    private AttributeTable addSignatureTimestampAttribute(SignerInformation signerInformation, AttributeTable unsignedAttributes, CAdESSignatureParameters parameters) {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        DSSMessageDigest messageDigest = new DSSMessageDigest(timestampDigestAlgorithm, DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])signerInformation.getSignature()));
        ASN1Object signatureTimeStamp = this.getTimeStampAttributeValue(messageDigest, timestampDigestAlgorithm, new Attribute[0]);
        return unsignedAttributes.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Encodable)signatureTimeStamp);
    }
}

