/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineLTA
extends CAdESLevelBaselineLT {
    public CAdESLevelBaselineLTA(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMS extendCMSSignatures(CMS cms, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        cms = super.extendCMSSignatures(cms, parameters, signatureIdsToExtend);
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        CMSDocumentAnalyzer documentAnalyzer = this.getDocumentValidator(cms, parameters);
        List signatures = documentAnalyzer.getSignatures();
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures, signatureIdsToExtend);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return cms;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(parameters);
        signatureRequirementsChecker.assertExtendToLTALevelPossible(signaturesToExtend);
        for (AdvancedSignature signature : signatures) {
            SignerInformation signerInformation;
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
            if (signaturesToExtend.contains((Object)cadesSignature)) {
                AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
                unsignedAttributes = this.addArchiveTimestampV3Attribute(cadesSignature, signerInformation, parameters, unsignedAttributes);
                newSignerInformation = CMSUtils.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
                DigestAlgorithm timestampDigestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
                AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)timestampDigestAlgorithm);
                cms = CMSUtils.populateDigestAlgorithmSet((CMS)cms, Collections.singleton(algorithmIdentifier));
            }
            newSignerInformationList.add(newSignerInformation);
        }
        return this.replaceSigners(cms, newSignerInformationList);
    }

    private AttributeTable addArchiveTimestampV3Attribute(CAdESSignature cadesSignature, SignerInformation signerInformation, CAdESSignatureParameters parameters, AttributeTable unsignedAttributes) {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(cadesSignature);
        DigestAlgorithm timestampDigestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
        DSSDocument originalDocument = cadesSignature.getOriginalDocument();
        ASN1ObjectIdentifier atsHashIndexTableIdentifier = this.getAtsHashIndexTableIdentifier(parameters);
        Attribute atsHashIndexAttribute = timestampExtractor.getAtsHashIndex(signerInformation, timestampDigestAlgorithm, atsHashIndexTableIdentifier);
        DSSMessageDigest timestampMessageDigest = timestampExtractor.getArchiveTimestampV3MessageImprint(signerInformation, atsHashIndexAttribute, originalDocument, timestampDigestAlgorithm);
        ASN1Object timeStampAttributeValue = this.getTimeStampAttributeValue(timestampMessageDigest, timestampDigestAlgorithm, atsHashIndexAttribute);
        return unsignedAttributes.add(OID.id_aa_ets_archiveTimestampV3, (ASN1Encodable)timeStampAttributeValue);
    }

    private ASN1ObjectIdentifier getAtsHashIndexTableIdentifier(CAdESSignatureParameters signatureParameters) {
        if (!signatureParameters.isEn319122()) {
            return OID.id_aa_ATSHashIndex;
        }
        return OID.id_aa_ATSHashIndexV3;
    }
}

