/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.evidencerecord;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESAttributeOrderComparator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.evidencerecord.AbstractSignatureEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class CAdESEvidenceRecordDigestBuilder
extends AbstractSignatureEvidenceRecordDigestBuilder {
    protected DSSDocument detachedDocument;
    protected boolean derEncoded;

    public CAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument) {
        super(signatureDocument);
    }

    public CAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument, DigestAlgorithm digestAlgorithm) {
        super(signatureDocument, digestAlgorithm);
    }

    protected CAdESEvidenceRecordDigestBuilder(AdvancedSignature signature, SignatureAttribute evidenceRecordAttribute, DigestAlgorithm digestAlgorithm) {
        super(signature, evidenceRecordAttribute, digestAlgorithm);
    }

    public CAdESEvidenceRecordDigestBuilder setDetachedContent(DSSDocument detachedDocument) {
        this.detachedDocument = detachedDocument;
        return this;
    }

    public CAdESEvidenceRecordDigestBuilder setDEREncoded(boolean derEncoded) {
        this.derEncoded = derEncoded;
        return this;
    }

    public CAdESEvidenceRecordDigestBuilder setParallelEvidenceRecord(boolean parallelEvidenceRecord) {
        return (CAdESEvidenceRecordDigestBuilder)super.setParallelEvidenceRecord(parallelEvidenceRecord);
    }

    public Digest build() {
        CMS cms = this.getCMS();
        return this.getDigest(cms);
    }

    public List<Digest> buildExternalEvidenceRecordDigest() {
        CMS cms = this.getCMS();
        Digest signatureDigest = this.getDigest(cms);
        Digest originalDocumentDigest = this.getDigest(this.detachedDocument);
        return Arrays.asList(signatureDigest, originalDocumentDigest);
    }

    protected CMS getCMS() {
        if (this.signature != null) {
            return ((CAdESSignature)this.signature).getCMS();
        }
        if (this.signatureDocument != null) {
            return CMSUtils.parseToCMS((DSSDocument)this.signatureDocument);
        }
        throw new IllegalStateException("Either a signature or a signature document shall be provided!");
    }

    protected Digest getDigest(CMS cms) {
        byte[] messageImprint = this.getCMSContentInfoMessageImprint(cms);
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])messageImprint);
        return new Digest(this.digestAlgorithm, digest);
    }

    protected byte[] getCMSContentInfoMessageImprint(CMS cms) {
        if (this.parallelEvidenceRecord || this.signature != null) {
            cms = this.getCMSSignedDataBeforeLastEvidenceRecord(cms);
        }
        return this.getEncoded(cms);
    }

    protected CMS getCMSSignedDataBeforeLastEvidenceRecord(CMS cms) {
        boolean signerWithERFound = false;
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : cms.getSignerInfos().getSigners()) {
            if (this.signature == null || ((CAdESSignature)this.signature).getSignerInformation() == signerInformation) {
                CAdESUnsignedAttributes unsignedAttributes = CAdESUnsignedAttributes.build(signerInformation);
                CAdESAttribute targetEvidenceRecordAttribute = null;
                if (this.parallelEvidenceRecord) {
                    targetEvidenceRecordAttribute = this.getLatestEvidenceRecordAttribute(unsignedAttributes);
                } else if (this.evidenceRecordAttribute != null) {
                    targetEvidenceRecordAttribute = (CAdESAttribute)this.evidenceRecordAttribute;
                }
                if (targetEvidenceRecordAttribute != null) {
                    if (signerWithERFound) {
                        throw new IllegalInputException("The CMSSignedData contains multiple evidence record attributes! Unable to compute hash.");
                    }
                    AttributeTable unsignedAttributesTable = this.removeAttributesAtAndAfter(unsignedAttributes, targetEvidenceRecordAttribute);
                    if (unsignedAttributesTable.size() == 0) {
                        unsignedAttributesTable = null;
                    }
                    signerInformation = CMSUtils.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributesTable);
                    if (this.parallelEvidenceRecord) {
                        signerWithERFound = true;
                    }
                }
            }
            newSignerInformationList.add(signerInformation);
        }
        return CMSUtils.replaceSigners((CMS)cms, (SignerInformationStore)new SignerInformationStore(newSignerInformationList));
    }

    private CAdESAttribute getLatestEvidenceRecordAttribute(CAdESUnsignedAttributes unsignedAttributes) {
        CAdESAttribute lastAttribute;
        List<CAdESAttribute> attributes;
        if (unsignedAttributes != null && Utils.isCollectionNotEmpty(attributes = unsignedAttributes.getAttributes()) && (lastAttribute = attributes.get(attributes.size() - 1)).isEvidenceRecord()) {
            return lastAttribute;
        }
        return null;
    }

    private AttributeTable removeAttributesAtAndAfter(CAdESUnsignedAttributes unsignedAttributes, CAdESAttribute unsignedAttribute) {
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        ArrayList<CAdESAttribute> attributesList = new ArrayList<CAdESAttribute>();
        for (CAdESAttribute attribute : unsignedAttributes.getAttributes()) {
            if (unsignedAttribute.equals(attribute)) break;
            attributesList.add(attribute);
        }
        if (Utils.isCollectionNotEmpty(attributesList)) {
            attributesList.sort(new CAdESAttributeOrderComparator());
            attributesList.forEach(a -> asn1EncodableVector.add((ASN1Encodable)new Attribute(a.getASN1Oid(), a.getAttrValues())));
        }
        return new AttributeTable(asn1EncodableVector);
    }

    protected byte[] getEncoded(CMS cms) {
        if (this.derEncoded) {
            return cms.getDEREncoded();
        }
        return cms.getEncoded();
    }
}

