/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.evidencerecord;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEvidenceRecordIncorporationParameters;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.spi.validation.SignatureValidationAlerter;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class CAdESEmbeddedEvidenceRecordBuilder {
    private final CertificateVerifier certificateVerifier;
    private ManifestFile manifestFile;

    public CAdESEmbeddedEvidenceRecordBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = new CertificateVerifierBuilder(certificateVerifier).buildOfflineCopy();
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public DSSDocument addEvidenceRecord(DSSDocument signatureDocument, DSSDocument evidenceRecordDocument, CAdESEvidenceRecordIncorporationParameters parameters) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        Objects.requireNonNull(evidenceRecordDocument, "Evidence record document must be provided!");
        Objects.requireNonNull(parameters, "CAdESEvidenceRecordIncorporationParameters must be provided!");
        CMSDocumentAnalyzer documentAnalyzer = this.initDocumentAnalyzer(signatureDocument, parameters.getDetachedContents());
        CAdESSignature signature = this.getCAdESSignature(documentAnalyzer, parameters.getSignatureId());
        this.assertSignatureExtensionPossible(signature, parameters);
        CAdESAttribute unsignedAttribute = this.getUnsignedAttributeToEmbed(signature, parameters);
        EvidenceRecord evidenceRecord = this.getEvidenceRecord(evidenceRecordDocument, signature, unsignedAttribute, parameters.getDetachedContents());
        this.assertEvidenceRecordValid(evidenceRecord, parameters);
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (AdvancedSignature currentSignature : documentAnalyzer.getSignatures()) {
            CAdESSignature cadesSignature = (CAdESSignature)currentSignature;
            if (signature.equals((Object)cadesSignature)) {
                SignerInformation newSignerInformation = this.addEvidenceRecordUnsignedProperty(cadesSignature, evidenceRecord, unsignedAttribute);
                newSignerInformationList.add(newSignerInformation);
                continue;
            }
            newSignerInformationList.add(cadesSignature.getSignerInformation());
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        CMS cms = CMSUtils.replaceSigners((CMS)signature.getCMS(), (SignerInformationStore)newSignerStore);
        return new InMemoryDocument(cms.getEncoded());
    }

    protected CAdESSignature getCAdESSignature(DefaultDocumentAnalyzer documentAnalyzer, String signatureId) {
        if (signatureId != null) {
            AdvancedSignature signature = documentAnalyzer.getSignatureById(signatureId);
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Unable to find a signature with Id : %s!", signatureId));
            }
            return (CAdESSignature)signature;
        }
        List signatures = documentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException(String.format("No signatures found in the document with name '%s'", documentAnalyzer.getDocument().getName()));
        }
        if (Utils.collectionSize((Collection)signatures) > 1) {
            throw new IllegalArgumentException(String.format("More than one signature found in a document with name '%s'! Please provide a signatureId within the parameters.", documentAnalyzer.getDocument().getName()));
        }
        return (CAdESSignature)((Object)signatures.get(0));
    }

    private CAdESAttribute getUnsignedAttributeToEmbed(CAdESSignature signature, CAdESEvidenceRecordIncorporationParameters parameters) {
        List<CAdESAttribute> attributes;
        CAdESAttribute lastUnsignedAttribute;
        CAdESUnsignedAttributes unsignedAttributes;
        if (parameters.isParallelEvidenceRecord() && (unsignedAttributes = CAdESUnsignedAttributes.build(signature.getSignerInformation())).isExist() && (lastUnsignedAttribute = (attributes = unsignedAttributes.getAttributes()).get(attributes.size() - 1)).isEvidenceRecord()) {
            ASN1ObjectIdentifier expectedEvidenceRecordAttributeType = this.getEvidenceRecordUnsignedPropertyOID(signature);
            if (!expectedEvidenceRecordAttributeType.equals((ASN1Primitive)lastUnsignedAttribute.getASN1Oid())) {
                throw new IllegalInputException(String.format("Unable to embed the parallel evidence record. Expected type '%s', obtained type '%s'.", lastUnsignedAttribute.getASN1Oid().getId(), expectedEvidenceRecordAttributeType.getId()));
            }
            return lastUnsignedAttribute;
        }
        return null;
    }

    private EvidenceRecord getEvidenceRecord(DSSDocument evidenceRecordDocument, CAdESSignature signature, CAdESAttribute unsignedAttribute, List<DSSDocument> detachedContents) {
        try {
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument((DSSDocument)evidenceRecordDocument);
            CAdESEmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = new CAdESEmbeddedEvidenceRecordHelper(signature, unsignedAttribute);
            if (Utils.isCollectionNotEmpty(detachedContents)) {
                evidenceRecordAnalyzer.setEvidenceRecordIncorporationType(EvidenceRecordIncorporationType.EXTERNAL_EVIDENCE_RECORD);
                embeddedEvidenceRecordHelper.setDetachedContents(detachedContents);
            }
            evidenceRecordAnalyzer.setEmbeddedEvidenceRecordHelper((EmbeddedEvidenceRecordHelper)embeddedEvidenceRecordHelper);
            return evidenceRecordAnalyzer.getEvidenceRecord();
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unable to build an evidence record from the provided document. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private void validateTimestamps(EvidenceRecord evidenceRecord) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.addDocumentCertificateSource((CertificateSource)evidenceRecord.getCertificateSource());
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        validationContext.validate();
        SignatureValidationAlerter signatureValidationAlerter = new SignatureValidationAlerter(validationContext);
        signatureValidationAlerter.setSigningOperation(SigningOperation.ADD_EVIDENCE_RECORD);
        signatureValidationAlerter.assertAllTimestampsValid();
    }

    private CMSDocumentAnalyzer initDocumentAnalyzer(DSSDocument signatureDocument, List<DSSDocument> detachedContents) {
        CMSDocumentAnalyzer analyzer = new CMSDocumentAnalyzer(signatureDocument);
        analyzer.setManifestFile(this.manifestFile);
        analyzer.setDetachedContents(detachedContents);
        return analyzer;
    }

    private SignerInformation addEvidenceRecordUnsignedProperty(CAdESSignature signature, EvidenceRecord evidenceRecord, CAdESAttribute unsignedAttribute) {
        ASN1ObjectIdentifier attributeOID = this.getEvidenceRecordUnsignedPropertyOID(signature);
        Attribute evidenceRecordAttribute = this.getEvidenceRecordAttribute(evidenceRecord, attributeOID, unsignedAttribute);
        SignerInformation signerInformation = signature.getSignerInformation();
        AttributeTable unsignedAttributesWithER = this.getUnsignedPropertiesTable(signerInformation, evidenceRecordAttribute, unsignedAttribute != null);
        return CMSUtils.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributesWithER);
    }

    private Attribute getEvidenceRecordAttribute(EvidenceRecord evidenceRecord, ASN1ObjectIdentifier attributeOID, CAdESAttribute unsignedAttribute) {
        ASN1Sequence asn1EvidenceRecord = this.getASN1EvidenceRecord(evidenceRecord);
        if (unsignedAttribute != null) {
            ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
            asn1EncodableVector.addAll(unsignedAttribute.getAttrValues().toArray());
            asn1EncodableVector.add((ASN1Encodable)asn1EvidenceRecord);
            return new Attribute(attributeOID, (ASN1Set)new DERSet(asn1EncodableVector));
        }
        return new Attribute(attributeOID, (ASN1Set)new DERSet((ASN1Encodable)asn1EvidenceRecord));
    }

    private AttributeTable getUnsignedPropertiesTable(SignerInformation signerInformation, Attribute evidenceRecordAttribute, boolean parallelER) {
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        int originalAttributeTableLength = unsignedAttributes.size();
        if (parallelER) {
            --originalAttributeTableLength;
        }
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < originalAttributeTableLength; ++i) {
            ASN1Encodable attribute = unsignedAttributes.toASN1EncodableVector().get(i);
            asn1EncodableVector.add(attribute);
        }
        asn1EncodableVector.add((ASN1Encodable)evidenceRecordAttribute);
        return new AttributeTable(asn1EncodableVector);
    }

    private ASN1Sequence getASN1EvidenceRecord(EvidenceRecord evidenceRecord) {
        return ASN1Sequence.getInstance((Object)evidenceRecord.getEncoded());
    }

    private ASN1ObjectIdentifier getEvidenceRecordUnsignedPropertyOID(CAdESSignature signature) {
        if (signature.getCMS().isDetachedSignature()) {
            return OID.id_aa_er_external;
        }
        return OID.id_aa_er_internal;
    }

    private void assertEvidenceRecordValid(EvidenceRecord evidenceRecord, CAdESEvidenceRecordIncorporationParameters parameters) {
        if (EvidenceRecordTypeEnum.ASN1_EVIDENCE_RECORD != evidenceRecord.getEvidenceRecordType()) {
            throw new IllegalInputException(String.format("Only RFC 4998 ERS type of Evidence Records is allowed for CAdES signatures! Identified type of evidence record: '%s'", evidenceRecord.getEvidenceRecordType()));
        }
        block5: for (ReferenceValidation referenceValidation : evidenceRecord.getReferenceValidation()) {
            if (referenceValidation.isIntact()) continue;
            switch (referenceValidation.getType()) {
                case EVIDENCE_RECORD_MASTER_SIGNATURE: {
                    throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the signature!");
                }
                case EVIDENCE_RECORD_ARCHIVE_OBJECT: {
                    if (Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
                        throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the detached content! Please use #setDetachedContent method to provide original documents.");
                    }
                    throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the detached content!");
                }
                case EVIDENCE_RECORD_ORPHAN_REFERENCE: {
                    continue block5;
                }
            }
            throw new IllegalStateException(String.format("Unexpected digest matcher type '%s' does not correspond to the value present in the evidence record!", referenceValidation.getType()));
        }
        this.validateTimestamps(evidenceRecord);
    }

    private void assertSignatureExtensionPossible(CAdESSignature signature, CAdESEvidenceRecordIncorporationParameters parameters) {
        CMSUtils.assertEvidenceRecordEmbeddingSupported();
        this.assertNoEvidenceRecordsInOtherSignerInfos(signature);
        if (CAdESUtils.containsATSTv2(signature.getSignerInformation())) {
            throw new IllegalInputException("Cannot add evidence record to a CAdES containing an archiveTimestampV2");
        }
        if (signature.getCMS().isDetachedSignature() && Utils.collectionSize((Collection)parameters.getDetachedContents()) != 1) {
            throw new IllegalArgumentException("One and only one detached document is allowed for an embedded evidence record in CAdES!");
        }
    }

    private void assertNoEvidenceRecordsInOtherSignerInfos(CAdESSignature signature) {
        for (SignerInformation signerInfo : signature.getCMS().getSignerInfos()) {
            if (signature.getSignerInformation() == signerInfo || !CAdESUtils.containsEvidenceRecord(signerInfo)) continue;
            throw new IllegalInputException("At most one of the SignerInfo instances within the SignedData instance shall contain evidence-records attributes! Please abolish the operation or provide another signature Id.");
        }
    }
}

