/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.alert;

import eu.europa.esig.dss.alert.Alert;
import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.alert.handler.AlertHandler;
import java.util.Objects;

public abstract class AbstractAlert<T>
implements Alert<T> {
    private final AlertDetector<T> detector;
    private final AlertHandler<T> handler;

    protected AbstractAlert() {
        this(null, null);
    }

    protected AbstractAlert(AlertDetector<T> detector, AlertHandler<T> handler) {
        this.detector = detector;
        this.handler = handler;
    }

    @Override
    public void alert(T object) {
        if (this.getAlertDetector().detect(object)) {
            this.getAlertHandler().process(object);
        }
    }

    protected AlertDetector<T> getAlertDetector() {
        Objects.requireNonNull(this.detector, "AlertDetector shall be defined!");
        return this.detector;
    }

    protected AlertHandler<T> getAlertHandler() {
        Objects.requireNonNull(this.handler, "AlertHandler shall be defined!");
        return this.handler;
    }
}

