/*
 * Decompiled with CFR 0.152.
 */
package jcifs.context;

import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Credentials;
import jcifs.context.CIFSContextCredentialWrapper;
import jcifs.smb.NtlmPasswordAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCIFSContext
extends Thread
implements CIFSContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractCIFSContext.class);
    private boolean closed;

    public AbstractCIFSContext() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    @Override
    public CIFSContext withCredentials(Credentials creds) {
        return new CIFSContextCredentialWrapper(this, creds);
    }

    @Override
    public CIFSContext withAnonymousCredentials() {
        return this.withCredentials(new NtlmPasswordAuthenticator());
    }

    @Override
    public CIFSContext withDefaultCredentials() {
        return this.withCredentials(this.getDefaultCredentials());
    }

    @Override
    public CIFSContext withGuestCrendentials() {
        return this.withCredentials(new NtlmPasswordAuthenticator(null, null, null, NtlmPasswordAuthenticator.AuthenticationType.GUEST));
    }

    @Override
    public Credentials getCredentials() {
        return this.getDefaultCredentials();
    }

    @Override
    public boolean hasDefaultCredentials() {
        return this.getDefaultCredentials() != null && !this.getDefaultCredentials().isAnonymous();
    }

    protected abstract Credentials getDefaultCredentials();

    @Override
    public boolean renewCredentials(String locationHint, Throwable error) {
        return false;
    }

    @Override
    public boolean close() throws CIFSException {
        if (!this.closed) {
            Runtime.getRuntime().removeShutdownHook(this);
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.closed = true;
            this.close();
        }
        catch (CIFSException e) {
            log.warn("Failed to close context on shutdown", (Throwable)e);
        }
    }
}

