/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.morphString;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.morphString.MorphStringConfig;

public class Morph {
    public static final String ENCRYPT_KEY = "encrypt.key";
    public static String testMorphKey = null;

    public static void main(String[] args) {
        System.out.println("a: " + Morph.decryptIfFile("a"));
        System.out.println("*: " + Morph.decryptIfFile("*"));
        System.out.println("****: " + Morph.decryptIfFile("****"));
    }

    public static String encrypt(String in) {
        in = GrouperClientUtils.trimToEmpty(in);
        return Crypto.getThreadLocalCrypto().encrypt(in);
    }

    public static String decrypt(String in) {
        in = GrouperClientUtils.trim(in);
        String result = null;
        try {
            result = Crypto.getThreadLocalCrypto().decrypt(in);
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Problem decrypting string: " + re.getMessage(), re);
        }
        return result;
    }

    public static String decryptIfFile(String in) {
        in = GrouperClientUtils.trimToEmpty(in);
        String newIn = GrouperClientUtils.readFromFileIfFileUtf8(in, false);
        try {
            return Morph.decrypt(newIn);
        }
        catch (Exception exception) {
            return newIn;
        }
    }

    public static String key() {
        if (testMorphKey != null && !"".equals(testMorphKey.trim())) {
            return testMorphKey;
        }
        String decryptKey = MorphStringConfig.retrieveConfig().propertyValueString(ENCRYPT_KEY);
        if (GrouperClientUtils.isBlank(decryptKey)) {
            throw new RuntimeException("You must have a decrypt key in the morphString.properties file under encrypt.key");
        }
        String fileNamePossibly = decryptKey;
        decryptKey = GrouperClientUtils.readFromFileIfFileUtf8(decryptKey, false);
        if (MorphStringConfig.retrieveConfig().propertyValueBoolean("encrypt.trimWhitespaceFromMorphSecretFile", true)) {
            decryptKey = GrouperClientUtils.trim(decryptKey);
        }
        if (GrouperClientUtils.isBlank(decryptKey)) {
            throw new RuntimeException("You must have a decrypt key in the morphString.properties file under encrypt.key and if using external file, must have a key in the file: '" + fileNamePossibly + "'");
        }
        return decryptKey + "w";
    }

    private Morph() {
    }
}

