/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.contrib.benchmark;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.Header;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HostConfiguration;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpClient;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpMethod;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.contrib.benchmark.Stats;
import java.io.IOException;
import java.io.InputStream;

public class BenchmarkWorker {
    private byte[] buffer = new byte[4096];
    private final int verbosity;
    private final HttpClient httpexecutor;

    public BenchmarkWorker(HttpClient httpexecutor, int verbosity) {
        this.httpexecutor = httpexecutor;
        this.verbosity = verbosity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats execute(HostConfiguration hostconf, HttpMethod method, int count, boolean keepalive) throws HttpException {
        Stats stats = new Stats();
        stats.start();
        for (int i = 0; i < count; ++i) {
            try {
                int h;
                Header[] headers;
                this.httpexecutor.executeMethod(hostconf, method);
                if (this.verbosity >= 4) {
                    System.out.println(">> " + method.getName() + " " + method.getURI() + " " + method.getParams().getVersion());
                    headers = method.getRequestHeaders();
                    for (h = 0; h < headers.length; ++h) {
                        System.out.print(">> " + headers[h].toString());
                    }
                    System.out.println();
                }
                if (this.verbosity >= 3) {
                    System.out.println(method.getStatusLine().getStatusCode());
                }
                if (this.verbosity >= 4) {
                    System.out.println("<< " + method.getStatusLine().toString());
                    headers = method.getResponseHeaders();
                    for (h = 0; h < headers.length; ++h) {
                        System.out.print("<< " + headers[h].toString());
                    }
                    System.out.println();
                }
                InputStream instream = method.getResponseBodyAsStream();
                long contentlen = 0L;
                if (instream != null) {
                    int l = 0;
                    while ((l = instream.read(this.buffer)) != -1) {
                        stats.incTotal(l);
                        contentlen += (long)l;
                    }
                }
                stats.setContentLength(contentlen);
                stats.incSuccessCount();
            }
            catch (IOException ex) {
                stats.incFailureCount();
                if (this.verbosity >= 2) {
                    System.err.println("I/O error: " + ex.getMessage());
                }
            }
            finally {
                method.releaseConnection();
            }
            if (keepalive) continue;
            this.httpexecutor.getHttpConnectionManager().closeIdleConnections(0L);
        }
        stats.finish();
        Header header = method.getResponseHeader("Server");
        if (header != null) {
            stats.setServerName(header.getValue());
        }
        return stats;
    }
}

