/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlIndenter {
    private String xml;
    private int startTagIndex;
    private int endTagIndex;
    private int currentNumberOfIndents;
    private String currentTagName;
    private StringBuilder result;

    public String result() {
        try {
            this.indent();
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Problem here: " + this, re);
        }
        if (this.xml == null) {
            return null;
        }
        return GrouperClientUtils.trim(this.result.toString());
    }

    private void indent() {
        if (this.xml == null) {
            return;
        }
        this.result = new StringBuilder();
        this.startTagIndex = -1;
        this.endTagIndex = -1;
        this.currentTagName = null;
        this.currentNumberOfIndents = 0;
        while (true) {
            boolean isNextTagCloseTag;
            int nextTagEndIndex;
            this.startTagIndex = this.findStartTagIndex();
            if (this.startTagIndex == -1) {
                if (this.endTagIndex == this.xml.length() - 1) break;
                this.result.append(this.xml, this.endTagIndex + 1, this.xml.length());
                break;
            }
            this.endTagIndex = this.findEndTagIndex();
            if (XmlIndenter.ignoreTag(this.xml, this.startTagIndex, this.endTagIndex)) {
                this.printNewlineIndent(this.startTagIndex, this.endTagIndex + 1);
                continue;
            }
            this.currentTagName = this.findTagName();
            if (XmlIndenter.selfClosedTag(this.xml, this.endTagIndex)) {
                this.printNewlineIndent(this.startTagIndex, this.endTagIndex + 1);
                continue;
            }
            if (XmlIndenter.closeTag(this.xml, this.startTagIndex)) {
                this.unindent();
                --this.currentNumberOfIndents;
                this.printNewlineIndent(this.startTagIndex, this.endTagIndex + 1);
                continue;
            }
            int nextTagStartIndex = XmlIndenter.findNextStartTagIndex(this.xml, this.endTagIndex + 1);
            String nextTagName = XmlIndenter.tagName(this.xml, nextTagStartIndex, nextTagEndIndex = XmlIndenter.findNextEndTagIndex(this.xml, nextTagStartIndex + 1));
            if (!XmlIndenter.textTag(this.xml, this.endTagIndex, this.currentTagName, nextTagName, isNextTagCloseTag = XmlIndenter.closeTag(this.xml, nextTagStartIndex))) {
                ++this.currentNumberOfIndents;
                this.printNewlineIndent(this.startTagIndex, this.endTagIndex + 1);
                continue;
            }
            this.printNewlineIndent(this.startTagIndex, nextTagEndIndex + 1);
            this.startTagIndex = nextTagEndIndex;
            this.endTagIndex = nextTagEndIndex;
        }
    }

    public static boolean ignoreTag(String theXml, int theStartTagIndex, int theEndTagIndex) {
        char firstChar = theXml.charAt(theStartTagIndex + 1);
        return firstChar == '?' || firstChar == '!';
    }

    private void printNewlineIndent(int start, int end) {
        this.result.append(this.xml, start, end);
        this.newlineIndent();
    }

    private void newlineIndent() {
        this.result.append("\n").append(GrouperClientUtils.repeat("  ", this.currentNumberOfIndents));
    }

    private void unindent() {
        for (int i = 0; i < 2; ++i) {
            if (this.result.charAt(this.result.length() - 1) != ' ') continue;
            this.result.deleteCharAt(this.result.length() - 1);
        }
    }

    public static String tagName(String xml, int startTagIndex, int endTagIndex) {
        endTagIndex = endTagIndex > startTagIndex ? endTagIndex : xml.length() - 1;
        String tag = xml.substring(startTagIndex, endTagIndex + 1);
        Pattern tagPattern = Pattern.compile("^<[\\s/]*([a-zA-Z_\\-0-9:\\.]+).*$", 32);
        Matcher matcher = tagPattern.matcher(tag);
        if (!matcher.matches()) {
            Pattern commentPattern = Pattern.compile("^<!--.*-->$");
            matcher = commentPattern.matcher(tag);
            if (matcher.matches()) {
                return "XML_COMMENT";
            }
            throw new RuntimeException("Cant match tag: '" + tag + "'");
        }
        String tagName = matcher.group(1);
        return tagName;
    }

    private int findStartTagIndex() {
        return XmlIndenter.findNextStartTagIndex(this.xml, this.endTagIndex + 1);
    }

    private String findTagName() {
        return XmlIndenter.tagName(this.xml, this.startTagIndex, this.endTagIndex);
    }

    private int findEndTagIndex() {
        return XmlIndenter.findNextEndTagIndex(this.xml, this.startTagIndex + 1);
    }

    public static int findNextStartTagIndex(String xml, int startFrom) {
        int length = xml.length();
        for (int i = startFrom; i < length; ++i) {
            if (xml.charAt(i) != '<') continue;
            return i;
        }
        return -1;
    }

    public static int findNextEndTagIndex(String xml, int startFrom) {
        int length = xml.length();
        for (int i = startFrom; i < length; ++i) {
            if (xml.charAt(i) != '>') continue;
            return i;
        }
        return -1;
    }

    public static boolean selfClosedTag(String xml, int endTagIndex) {
        for (int i = endTagIndex - 1; i >= 0; --i) {
            char curChar = xml.charAt(i);
            if (Character.isWhitespace(curChar)) continue;
            return curChar == '/';
        }
        return false;
    }

    public static boolean closeTag(String xml, int startTagIndex) {
        for (int i = startTagIndex + 1; i < xml.length(); ++i) {
            char curChar = xml.charAt(i);
            if (Character.isWhitespace(curChar)) continue;
            return curChar == '/' || curChar == '!';
        }
        return false;
    }

    public static boolean textTag(String xml, int endTagIndex, String tagName, String nextTagName, boolean isNextCloseTag) {
        if (GrouperClientUtils.equals("XML_COMMENT", tagName)) {
            return false;
        }
        return GrouperClientUtils.equals(tagName, nextTagName) && isNextCloseTag;
    }

    public XmlIndenter(String theXml) {
        if (theXml != null) {
            this.xml = GrouperClientUtils.trimToEmpty(theXml);
        }
    }
}

