/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.ToStringStyle;

public class JsonIndenter {
    private String json;
    private int startTagIndex;
    private int endTagIndex;
    private int currentNumberOfIndents;
    private StringBuilder result;

    public String result() {
        try {
            this.indent();
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Problem here: " + this, re);
        }
        if (this.json == null) {
            return null;
        }
        return StringUtils.trim(this.result.toString());
    }

    private void indent() {
        if (this.json == null) {
            return;
        }
        this.result = new StringBuilder();
        this.startTagIndex = -1;
        this.endTagIndex = -1;
        this.currentNumberOfIndents = 0;
        while (true) {
            char nextChar;
            this.startTagIndex = this.findStartTagIndex();
            if (this.startTagIndex == -1) {
                if (this.endTagIndex == this.json.length() - 1) break;
                this.result.append(this.json, this.endTagIndex + 1, this.json.length());
                break;
            }
            if (JsonIndenter.instantIndent(this.json, this.startTagIndex)) {
                ++this.currentNumberOfIndents;
                this.printNewlineIndent(this.startTagIndex, this.startTagIndex + 1);
                this.endTagIndex = this.startTagIndex;
                continue;
            }
            if (JsonIndenter.instantUnindentTwoChars(this.json, this.startTagIndex)) {
                --this.currentNumberOfIndents;
                this.newlineIndent();
                this.printNewlineIndent(this.startTagIndex, this.startTagIndex + 2);
                this.endTagIndex = this.startTagIndex + 1;
                continue;
            }
            if (JsonIndenter.instantUnindent(this.json, this.startTagIndex)) {
                --this.currentNumberOfIndents;
                if (this.onNewline()) {
                    this.unindent();
                } else {
                    this.newlineIndent();
                }
                this.printNewlineIndent(this.startTagIndex, this.startTagIndex + 1);
                this.endTagIndex = this.startTagIndex;
                continue;
            }
            if (JsonIndenter.instantNewline(this.json, this.startTagIndex)) {
                this.printNewlineIndent(this.startTagIndex, this.startTagIndex + 1);
                this.endTagIndex = this.startTagIndex;
                continue;
            }
            this.endTagIndex = this.findEndTagIndex();
            this.result.append(this.json, this.startTagIndex, this.endTagIndex + 1);
            if (this.endTagIndex >= this.json.length() - 1 || (nextChar = this.json.charAt(this.endTagIndex + 1)) != ':') continue;
            this.result.append(':');
            ++this.endTagIndex;
        }
    }

    private boolean onNewline() {
        for (int i = this.result.length() - 1; i >= 0; --i) {
            char curChar = this.result.charAt(i);
            if (curChar == '\n') {
                return true;
            }
            if (Character.isWhitespace(curChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean instantIndent(String json, int index) {
        char curChar = json.charAt(index);
        return curChar == '{' || curChar == '[';
    }

    public static boolean instantNewline(String json, int index) {
        char curChar = json.charAt(index);
        return curChar == ',';
    }

    public static boolean instantUnindent(String json, int index) {
        char curChar = json.charAt(index);
        return curChar == '}' || curChar == ']';
    }

    public static boolean instantUnindentTwoChars(String json, int index) {
        char curChar = json.charAt(index);
        if (index == json.length() - 1) {
            return false;
        }
        char nextchar = json.charAt(index + 1);
        return curChar == '}' && nextchar == ',';
    }

    private void printNewlineIndent(int start, int end) {
        this.result.append(this.json, start, end);
        this.newlineIndent();
    }

    private void newlineIndent() {
        this.result.append("\n").append(StringUtils.repeat("  ", this.currentNumberOfIndents));
    }

    private void unindent() {
        for (int i = 0; i < 2; ++i) {
            if (this.result.charAt(this.result.length() - 1) != ' ') continue;
            this.result.deleteCharAt(this.result.length() - 1);
        }
    }

    private int findStartTagIndex() {
        return JsonIndenter.findNextStartTagIndex(this.json, this.endTagIndex + 1);
    }

    private int findEndTagIndex() {
        return JsonIndenter.findNextEndTagIndex(this.json, this.startTagIndex + 1);
    }

    public static int findNextStartTagIndex(String json, int startFrom) {
        int length = json.length();
        for (int i = startFrom; i < length; ++i) {
            char curChar = json.charAt(i);
            if (Character.isWhitespace(curChar)) continue;
            return i;
        }
        return -1;
    }

    public static int findNextEndTagIndex(String json, int startFrom) {
        int length = json.length();
        boolean quotedString = json.charAt(startFrom - 1) == '\"';
        int ignoreSlashInIndex = -1;
        boolean afterSlash = false;
        for (int i = startFrom; i < length; ++i) {
            afterSlash = i != ignoreSlashInIndex && i != startFrom && json.charAt(i - 1) == '\\';
            char curChar = json.charAt(i);
            if (!afterSlash && curChar == '\\') {
                ignoreSlashInIndex = i + 2;
            }
            if (!quotedString) {
                if (curChar != ':' && !Character.isWhitespace(curChar) && curChar != ']' && curChar != '}' && curChar != ',') continue;
                return i - 1;
            }
            if (afterSlash || curChar != '\"') continue;
            return i;
        }
        return json.length() - 1;
    }

    public JsonIndenter(String theJson) {
        if (theJson != null) {
            this.json = StringUtils.trimToEmpty(theJson);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}

