/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GcJsonIndenter;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.util.XmlIndenter;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.binary.Base64;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GcElUtilsSafe {
    private static Pattern emailPattern;
    public static final String LOG_ERROR = "Error trying to make parent dirs for logger or logging first statement, check to make sure you have proper file permissions, and that your servlet container is giving your app rights to access the log directory (e.g. for tomcat set TOMCAT5_SECURITY=no), google it for more info";
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String TIMESTAMP_FILE_FORMAT = "yyyy_MM_dd__HH_mm_ss_SSS";
    static final SimpleDateFormat timestampFileFormat;
    public static final String DATE_FORMAT2 = "yyyy/MM/dd";
    public static final String DATE_MINUTES_SECONDS_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_MINUTES_SECONDS_NO_SLASH_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String TIMESTAMP_NO_SLASH_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    static final SimpleDateFormat dateFormat;
    static final SimpleDateFormat dateFormat2;
    static final SimpleDateFormat dateMinutesSecondsFormat;
    static final SimpleDateFormat dateMinutesSecondsNoSlashFormat;
    static final SimpleDateFormat timestampFormat;
    static final SimpleDateFormat timestampNoSlashFormat;
    private static char[] lastId;
    private static final String TIMESTAMP_XML_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static Pattern datePattern_yyyy_mm_dd;
    private static Pattern datePattern_dd_mon_yyyy;
    private static Pattern datePattern_yyyy_mm_dd_hhmmss;
    private static Pattern datePattern_dd_mon_yyyy_hhmmss;
    private static Pattern datePattern_yyyy_mm_dd_hhmmss_SSS;
    private static Pattern datePattern_dd_mon_yyyy_hhmmss_SSS;
    private static final String errorStart = "Invalid timestamp, please use any of the formats: yyyyMMdd, yyyy/MM/dd HH:mm:ss.SSS, yyyy/MM/dd HH:mm:ss: ";
    public static final int NOT_FOUND = -999999999;
    private static Log LOG;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final String[] PADDING;
    private static final String WS_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String WS_DATE_FORMAT2 = "yyyy/MM/dd_HH:mm:ss.SSS";
    private static final String[] XML_REPLACE_NO_SINGLE;
    private static final String[] XML_SEARCH_NO_SINGLE;
    private static final Method THROWABLE_CAUSE_METHOD;
    private static String[] CAUSE_METHOD_NAMES;

    public static String readFileIntoStringUtf8(String fileName) {
        return GcElUtilsSafe.readFileIntoStringUtf8(fileName, true);
    }

    public static String readFileIntoStringUtf8(String fileName, boolean trim) {
        File theFile = new File(fileName);
        if (!theFile.exists() || !theFile.isFile()) {
            throw new RuntimeException("File doesnt exist! '" + fileName + "'");
        }
        try {
            String fileContents = GrouperClientUtils.readFileIntoStringUtf8(theFile);
            if (trim) {
                fileContents = GcElUtilsSafe.trim(fileContents);
            }
            return fileContents;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "error reading from fileName: '" + fileName + "', file: '" + (theFile == null ? null : theFile.getAbsolutePath()) + "'");
            throw re;
        }
    }

    public static String processEnvVarOrFile(String envVarOrFileBase) {
        return GcElUtilsSafe.processEnvVarOrFileHelper(envVarOrFileBase, true);
    }

    public static String processEnvVarOrFileNoTrim(String envVarOrFileBase) {
        return GcElUtilsSafe.processEnvVarOrFileHelper(envVarOrFileBase, false);
    }

    private static String processEnvVarOrFileHelper(String envVarOrFileBase, boolean trim) {
        if (GcElUtilsSafe.isBlank(envVarOrFileBase)) {
            throw new RuntimeException("env var is required");
        }
        String envVarFile = envVarOrFileBase + "_FILE";
        String fileName = GcElUtilsSafe.trim(System.getenv().get(envVarFile));
        if (!GcElUtilsSafe.isBlank(fileName)) {
            File theFile = new File(fileName);
            try {
                String fileContents = GrouperClientUtils.readFileIntoStringUtf8(theFile);
                if (trim) {
                    fileContents = GcElUtilsSafe.trim(fileContents);
                }
                return fileContents;
            }
            catch (RuntimeException re) {
                GrouperClientUtils.injectInException(re, "error with env var: '" + envVarFile + "', file: '" + (theFile == null ? null : theFile.getAbsolutePath()) + "'");
                throw re;
            }
        }
        return GcElUtilsSafe.trim(System.getenv().get(envVarOrFileBase));
    }

    public static String environmentVariable(String key) {
        return System.getenv().get(key);
    }

    public static String append(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return GcElUtilsSafe.stringValue(objects[0]);
        }
        StringBuilder result = new StringBuilder();
        for (Object object : objects) {
            result.append(GcElUtilsSafe.stringValue(object));
        }
        return result.toString();
    }

    public static String normalizeEmailAddresses(String emailAddresses) {
        if (emailAddresses == null) {
            return null;
        }
        emailAddresses = GcElUtilsSafe.replace(emailAddresses, ",", " ");
        emailAddresses = GcElUtilsSafe.replace(emailAddresses, ";", " ");
        emailAddresses = GcElUtilsSafe.replace(emailAddresses, "\n", " ");
        emailAddresses = GcElUtilsSafe.replace(emailAddresses, "\t", " ");
        emailAddresses = GcElUtilsSafe.replace(emailAddresses, "\r", " ");
        emailAddresses = GcElUtilsSafe.join((Object[])GcElUtilsSafe.splitTrim(emailAddresses, " "), ";");
        return emailAddresses;
    }

    public static boolean validEmail(String email) {
        Matcher matcher = emailPattern.matcher(email);
        return matcher.matches();
    }

    public static <T> Set<T> setShorten(Set<T> theSet, int maxSize) {
        if (GcElUtilsSafe.length(theSet) < maxSize) {
            return theSet;
        }
        LinkedHashSet<T> newList = new LinkedHashSet<T>();
        int i = 0;
        for (T t : theSet) {
            if (i >= maxSize) break;
            newList.add(t);
            ++i;
        }
        return newList;
    }

    public static String formatNumberWithCommas(Long number) {
        if (number == null) {
            return "null";
        }
        DecimalFormat df = new DecimalFormat();
        return df.format(number);
    }

    public static int compare(Comparable first, Comparable second) {
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return first.compareTo(second);
    }

    public static Map<String, String> toMap(String ... strings) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (strings != null) {
            if (strings.length % 2 != 0) {
                throw new RuntimeException("Must pass in an even number of strings: " + strings.length);
            }
            for (int i = 0; i < strings.length; i += 2) {
                map.put(strings[i], strings[i + 1]);
            }
        }
        return map;
    }

    public static Map<String, Object> toStringObjectMap(Object ... stringObjects) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (stringObjects != null) {
            if (stringObjects.length % 2 != 0) {
                throw new RuntimeException("Must pass in an even number of strings: " + stringObjects.length);
            }
            for (int i = 0; i < stringObjects.length; i += 2) {
                String key = (String)stringObjects[i];
                map.put(key, stringObjects[i + 1]);
            }
        }
        return map;
    }

    public static String convertMillisToFriendlyString(Integer duration) {
        if (duration == null) {
            return GcElUtilsSafe.convertMillisToFriendlyString((Long)null);
        }
        return GcElUtilsSafe.convertMillisToFriendlyString(new Long(duration.intValue()));
    }

    public static String convertMillisToFriendlyString(Long duration) {
        if (duration == null) {
            return EMPTY;
        }
        if (duration < 1000L) {
            return duration + "ms";
        }
        long ms = duration % 1000L;
        duration = duration / 1000L;
        long s = duration % 60L;
        if ((duration = Long.valueOf(duration / 60L)) == 0L) {
            return s + "s, " + ms + "ms";
        }
        long m = duration % 60L;
        if ((duration = Long.valueOf(duration / 60L)) == 0L) {
            return m + "m, " + s + "s, " + ms + "ms";
        }
        long h = duration % 24L;
        if ((duration = Long.valueOf(duration / 24L)) == 0L) {
            return h + "h, " + m + "m, " + s + "s, " + ms + "ms";
        }
        long d = duration;
        return d + "d, " + h + "h, " + m + "m, " + s + "s, " + ms + "ms";
    }

    public static String argAfter(String[] args, String argBefore) {
        if (GcElUtilsSafe.length(args) <= 1) {
            return null;
        }
        int argBeforeIndex = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!GcElUtilsSafe.equals(args[i], argBefore)) continue;
            argBeforeIndex = i;
            break;
        }
        if (argBeforeIndex == -1) {
            throw new RuntimeException("Cant find arg before");
        }
        if (argBeforeIndex < args.length - 1) {
            return args[argBeforeIndex + 1];
        }
        return null;
    }

    public static void append(StringBuilder result, String separatorIfResultNotEmpty, String stringToAppend) {
        if (result.length() != 0) {
            result.append(separatorIfResultNotEmpty);
        }
        result.append(stringToAppend);
    }

    public static String byteCountToDisplaySize(long size) {
        String displaySize = size / 0x40000000L > 0L ? String.valueOf(size / 0x40000000L) + " GB" : (size / 0x100000L > 0L ? String.valueOf(size / 0x100000L) + " MB" : (size / 1024L > 0L ? String.valueOf(size / 1024L) + " KB" : String.valueOf(size) + " bytes"));
        return displaySize;
    }

    public static String suffixAfterChar(String input, char theChar) {
        if (input == null) {
            return null;
        }
        int lastIndex = input.lastIndexOf(theChar);
        if (lastIndex > -1) {
            input = input.substring(lastIndex + 1, input.length());
        }
        return input;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static void sleepWithStdoutCountdown(int seconds) {
        for (int i = seconds; i > 0; --i) {
            System.out.println("Sleeping: " + i);
            GcElUtilsSafe.sleep(1000L);
        }
    }

    public static synchronized String encryptSha(String plaintext) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            md.update(plaintext.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] raw = md.digest();
        byte[] encoded = Base64.encodeBase64(raw);
        String hash = new String(encoded);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uniqueId() {
        Class<GcElUtilsSafe> clazz = GcElUtilsSafe.class;
        synchronized (GcElUtilsSafe.class) {
            lastId = GcElUtilsSafe.incrementStringInt(lastId);
            // ** MonitorExit[var0] (shouldn't be in output)
            return String.valueOf(lastId);
        }
    }

    public static <T> T[] nonNull(T[] array, Class<?> theClass) {
        if (Integer.TYPE.equals(theClass)) {
            return new int[0];
        }
        if (Float.TYPE.equals(theClass)) {
            return new float[0];
        }
        if (Double.TYPE.equals(theClass)) {
            return new double[0];
        }
        if (Short.TYPE.equals(theClass)) {
            return new short[0];
        }
        if (Long.TYPE.equals(theClass)) {
            return new long[0];
        }
        if (Byte.TYPE.equals(theClass)) {
            return new byte[0];
        }
        if (Boolean.TYPE.equals(theClass)) {
            return new boolean[0];
        }
        if (Character.TYPE.equals(theClass)) {
            return new char[0];
        }
        return array == null ? (Object[])Array.newInstance(theClass, 0) : array;
    }

    public static String stripSuffix(String string, String suffix) {
        if (string == null || suffix == null) {
            return string;
        }
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String prefixOrSuffix(String startString, String separator, boolean isPrefix) {
        String prefixOrSuffix = null;
        if (startString == null) {
            return startString;
        }
        int separatorIndex = startString.indexOf(separator);
        if (separatorIndex == -1) {
            return startString;
        }
        int separatorLength = separator.length();
        prefixOrSuffix = isPrefix ? startString.substring(0, separatorIndex) : startString.substring(separatorIndex + separatorLength, startString.length());
        return prefixOrSuffix;
    }

    public static String indent(String string, boolean failIfTypeNotFound) {
        if (string == null) {
            return null;
        }
        if ((string = GcElUtilsSafe.trim(string)).startsWith("<")) {
            return new XmlIndenter(string).result();
        }
        if (string.startsWith("{")) {
            return new GcJsonIndenter(string).result();
        }
        if (!failIfTypeNotFound) {
            return string;
        }
        throw new RuntimeException("Cant find type of string: " + string);
    }

    public static String extensionFromName(String name) {
        if (GcElUtilsSafe.isBlank(name)) {
            return name;
        }
        int lastColonIndex = name.lastIndexOf(58);
        if (lastColonIndex == -1) {
            return name;
        }
        String extension = name.substring(lastColonIndex + 1);
        return extension;
    }

    public static String parentStemNameFromName(String name) {
        return GcElUtilsSafe.parentStemNameFromName(name, true);
    }

    public static String parentStemNameFromName(String name, boolean nullForRoot) {
        if (GcElUtilsSafe.isBlank(name)) {
            return name;
        }
        int lastColonIndex = name.lastIndexOf(58);
        if (lastColonIndex == -1) {
            if (nullForRoot) {
                return null;
            }
            return ":";
        }
        String parentStemName = name.substring(0, lastColonIndex);
        return parentStemName;
    }

    public static String defaultIfBlank(String string, String defaultStringIfBlank) {
        return GcElUtilsSafe.isBlank(string) ? defaultStringIfBlank : string;
    }

    public static <T> T defaultIfNull(T theValue, T defaultIfTheValueIsNull) {
        return theValue != null ? theValue : defaultIfTheValueIsNull;
    }

    public static <T> void addIfNotThere(Collection<T> list, Collection<T> listToAdd) {
        if (listToAdd == null) {
            return;
        }
        for (T t : listToAdd) {
            if (list.contains(t)) continue;
            list.add(t);
        }
    }

    private static void toStringForLogHelper(Object object, int maxChars, StringBuilder result) {
        try {
            if (object == null) {
                result.append("null");
            } else if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (length == 0) {
                    result.append("Empty array");
                } else {
                    result.append("Array size: ").append(length).append(": ");
                    for (int i = 0; i < length; ++i) {
                        result.append("[").append(i).append("]: ").append(Array.get(object, i)).append("\n");
                        if (maxChars == -1 || result.length() <= maxChars) continue;
                        return;
                    }
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int collectionSize = collection.size();
                if (collectionSize == 0) {
                    result.append("Empty ").append(object.getClass().getSimpleName());
                } else {
                    result.append(object.getClass().getSimpleName()).append(" size: ").append(collectionSize).append(": ");
                    int i = 0;
                    for (Object collectionObject : collection) {
                        result.append("[").append(i).append("]: ").append(collectionObject).append("\n");
                        if (maxChars != -1 && result.length() > maxChars) {
                            return;
                        }
                        ++i;
                    }
                }
            } else {
                result.append(object.toString());
            }
        }
        catch (Exception e) {
            result.append("<<exception>> ").append(object.getClass()).append(":\n").append(GcElUtilsSafe.getFullStackTrace(e)).append("\n");
        }
    }

    public static String collectionToString(Collection collection) {
        if (collection == null) {
            return "null";
        }
        if (collection.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : collection) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object);
        }
        return result.toString();
    }

    public static String setToString(Set set) {
        return GcElUtilsSafe.collectionToString(set);
    }

    @Deprecated
    public static String MapToString(Map map) {
        return GcElUtilsSafe.mapToString(map);
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : map.keySet()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object).append(": ").append(map.get(object));
        }
        return result.toString();
    }

    public static String toStringForLog(Object object) {
        StringBuilder result = new StringBuilder();
        GcElUtilsSafe.toStringForLogHelper(object, -1, result);
        return result.toString();
    }

    public static String toStringForLog(Object object, int maxChars) {
        StringBuilder result = new StringBuilder();
        GcElUtilsSafe.toStringForLogHelper(object, -1, result);
        String resultString = result.toString();
        if (maxChars != -1) {
            return GcElUtilsSafe.abbreviate(resultString, maxChars);
        }
        return resultString;
    }

    public static int batchNumberOfBatches(int count, int batchSize, boolean haveAtLeastOne) {
        if (!haveAtLeastOne && count == 0) {
            return 0;
        }
        if (batchSize == 0) {
            return 0;
        }
        int batches = 1 + (count - 1) / batchSize;
        return batches;
    }

    @Deprecated
    public static int batchNumberOfBatches(int count, int batchSize) {
        return GcElUtilsSafe.batchNumberOfBatches(count, batchSize, true);
    }

    @Deprecated
    public static int batchNumberOfBatches(Collection<?> collection, int batchSize) {
        return GcElUtilsSafe.batchNumberOfBatches(collection, batchSize, true);
    }

    public static int batchNumberOfBatches(Collection<?> collection, int batchSize, boolean haveAtLeastOne) {
        int arrraySize = GcElUtilsSafe.length(collection);
        return GcElUtilsSafe.batchNumberOfBatches(arrraySize, batchSize, haveAtLeastOne);
    }

    public static <T> List<T> batchList(Collection<T> collection, int batchSize, int batchIndex) {
        int numberOfBatches = GcElUtilsSafe.batchNumberOfBatches(collection, batchSize);
        int arraySize = GcElUtilsSafe.length(collection);
        if (arraySize == 0) {
            return new ArrayList();
        }
        ArrayList<T> theBatchObjects = new ArrayList<T>();
        if (batchIndex == numberOfBatches - 1) {
            int collectionIndex = 0;
            for (T t : collection) {
                if (collectionIndex++ < batchIndex * batchSize) continue;
                theBatchObjects.add(t);
            }
        } else {
            int collectionIndex = 0;
            for (T t : collection) {
                if (collectionIndex < batchIndex * batchSize) {
                    ++collectionIndex;
                    continue;
                }
                if (collectionIndex < (batchIndex + 1) * batchSize) {
                    theBatchObjects.add(t);
                    ++collectionIndex;
                    continue;
                }
                break;
            }
        }
        return theBatchObjects;
    }

    public static String[] splitTrim(String input, String separator) {
        return GcElUtilsSafe.splitTrim(input, separator, true);
    }

    public static List<String> splitTrimToList(String input, String separator) {
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        String[] array = GcElUtilsSafe.splitTrim(input, separator);
        return GcElUtilsSafe.toList(array);
    }

    public static Set<String> splitTrimToSet(String input, String separator) {
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        String[] array = GcElUtilsSafe.splitTrim(input, separator);
        return GcElUtilsSafe.toSet(array);
    }

    public static String[] splitTrim(String input, String separator, boolean treatAdjacentSeparatorsAsOne) {
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        String[] items = treatAdjacentSeparatorsAsOne ? GcElUtilsSafe.splitByWholeSeparator(input, separator) : GcElUtilsSafe.split(input, separator);
        for (int i = 0; items != null && i < items.length; ++i) {
            items[i] = GcElUtilsSafe.trim(items[i]);
        }
        return items;
    }

    public static String escapeUrlEncode(String string) {
        String result = null;
        try {
            result = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String escapeUrlDecode(String string) {
        String result = null;
        try {
            result = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static <T> List<T> nonNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> Collection<T> nonNull(Collection<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> Set<T> nonNull(Set<T> set) {
        return set == null ? new HashSet() : set;
    }

    public static <K, V> Map<K, V> nonNull(Map<K, V> map) {
        return map == null ? new HashMap() : map;
    }

    public static <T> List<T> toList(T ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 1 && objects[0] instanceof List) {
            return (List)objects[0];
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static List<Object> toListObject(Object ... objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            result.add(object);
        }
        return result;
    }

    public static <T> Set<T> toSet(T ... objects) {
        if (objects == null) {
            return null;
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static <T> Set<T> toSetObject(T object) {
        if (object == null) {
            return null;
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        result.add(object);
        return result;
    }

    public static void assertion(boolean isTrue, String reason) {
        if (!isTrue) {
            throw new RuntimeException(reason);
        }
    }

    public static Iterator iterator(Object collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof Collection && !(collection instanceof ArrayList)) {
            return ((Collection)collection).iterator();
        }
        return null;
    }

    public static int length(Object arrayOrCollection) {
        if (arrayOrCollection == null) {
            return 0;
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.getLength(arrayOrCollection);
        }
        if (arrayOrCollection instanceof Collection) {
            return ((Collection)arrayOrCollection).size();
        }
        if (arrayOrCollection instanceof Map) {
            return ((Map)arrayOrCollection).size();
        }
        return 1;
    }

    public static Object next(Object arrayOrCollection, Iterator iterator, int index) {
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (arrayOrCollection instanceof ArrayList) {
            return ((ArrayList)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            return iterator.next();
        }
        if (0 == index) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static Object remove(Object arrayOrCollection, int index) {
        return GcElUtilsSafe.remove(arrayOrCollection, null, index);
    }

    public static Object remove(Object arrayOrCollection, Iterator iterator, int index) {
        if (iterator != null) {
            iterator.remove();
            return arrayOrCollection;
        }
        if (arrayOrCollection.getClass().isArray()) {
            int newLength = Array.getLength(arrayOrCollection) - 1;
            Object newArray = Array.newInstance(arrayOrCollection.getClass().getComponentType(), newLength);
            if (newLength == 0) {
                return newArray;
            }
            if (index > 0) {
                System.arraycopy(arrayOrCollection, 0, newArray, 0, index);
            }
            if (index < newLength) {
                System.arraycopy(arrayOrCollection, index + 1, newArray, index, newLength - index);
            }
            return newArray;
        }
        if (arrayOrCollection instanceof List) {
            ((List)arrayOrCollection).remove(index);
            return arrayOrCollection;
        }
        if (arrayOrCollection instanceof Collection) {
            ((Collection)arrayOrCollection).remove(GcElUtilsSafe.get(arrayOrCollection, index));
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static String classesString(Object object) {
        StringBuilder result = new StringBuilder();
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                result.append(((Class)Array.get(object, i)).getSimpleName());
                if (i >= length - 1) continue;
                result.append(", ");
            }
            return result.toString();
        }
        throw new RuntimeException("Not implemented: " + GcElUtilsSafe.className(object));
    }

    public static String classNameCollection(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = GcElUtilsSafe.iterator(object);
        int length = GcElUtilsSafe.length(object);
        for (int i = 0; i < length && i < 20; ++i) {
            result.append(GcElUtilsSafe.className(GcElUtilsSafe.next(object, iterator, i)));
            if (i == length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static Object toArray(Object objectOrArrayOrCollection) {
        if (objectOrArrayOrCollection != null && objectOrArrayOrCollection.getClass().isArray()) {
            return objectOrArrayOrCollection;
        }
        int length = GcElUtilsSafe.length(objectOrArrayOrCollection);
        if (length == 0) {
            return null;
        }
        if (objectOrArrayOrCollection instanceof Collection) {
            Collection collection;
            Object first = (collection = (Collection)objectOrArrayOrCollection).iterator().next();
            return GcElUtilsSafe.toArray(collection, first == null ? Object.class : first.getClass());
        }
        Object array = Array.newInstance(objectOrArrayOrCollection.getClass(), 1);
        Array.set(array, 0, objectOrArrayOrCollection);
        return array;
    }

    public static <T> T[] toArray(Collection collection, Class<T> theClass) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.toArray((Object[])Array.newInstance(theClass, collection.size()));
    }

    public static String replace(String text, Object searchFor, Object replaceWith) {
        return GcElUtilsSafe.replace(null, null, text, searchFor, replaceWith, false, 0, false);
    }

    public static String replace(String text, Object searchFor, Object replaceWith, boolean recurse) {
        return GcElUtilsSafe.replace(null, null, text, searchFor, replaceWith, recurse, recurse ? GcElUtilsSafe.length(searchFor) : 0, false);
    }

    public static String replace(String text, Object searchFor, Object replaceWith, boolean recurse, boolean removeIfFound) {
        return GcElUtilsSafe.replace(null, null, text, searchFor, replaceWith, recurse, recurse ? GcElUtilsSafe.length(searchFor) : 0, removeIfFound);
    }

    public static String replace(String text, String repl, String with) {
        return GcElUtilsSafe.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || GcElUtilsSafe.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith) {
        GcElUtilsSafe.replace(outBuffer, null, text, searchFor, replaceWith, false, 0, false);
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith, boolean recurse) {
        GcElUtilsSafe.replace(outBuffer, null, text, searchFor, replaceWith, recurse, recurse ? GcElUtilsSafe.length(searchFor) : 0, false);
    }

    private static String replace(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive, boolean removeIfFound) {
        if (!recurse) {
            return GcElUtilsSafe.replaceHelper(outBuffer, outWriter, text, searchFor, replaceWith, recurse, timeToLive, removeIfFound);
        }
        String result = GcElUtilsSafe.replaceHelper(null, null, text, searchFor, replaceWith, recurse, timeToLive, removeIfFound);
        if (outBuffer != null) {
            outBuffer.append(result);
            return null;
        }
        if (outWriter != null) {
            try {
                outWriter.write(result);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return null;
        }
        return result;
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith) {
        GcElUtilsSafe.replace(null, outWriter, text, searchFor, replaceWith, false, 0, false);
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse) {
        GcElUtilsSafe.replace(null, outWriter, text, searchFor, replaceWith, recurse, recurse ? GcElUtilsSafe.length(searchFor) : 0, false);
    }

    private static String replaceHelper(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive, boolean removeIfFound) {
        try {
            boolean writeToWriter;
            if (timeToLive < 0) {
                throw new IllegalArgumentException("TimeToLive under 0: " + timeToLive + ", " + text);
            }
            int searchForLength = GcElUtilsSafe.length(searchFor);
            boolean done = false;
            if (GcElUtilsSafe.isEmpty(text)) {
                return text;
            }
            if (searchForLength == 0) {
                done = true;
            }
            boolean[] noMoreMatchesForReplIndex = null;
            int inputIndex = -1;
            int replaceIndex = -1;
            long resultPacked = -1L;
            if (!done) {
                if (searchForLength != GcElUtilsSafe.length(replaceWith)) {
                    throw new IndexOutOfBoundsException("Lengths dont match: " + searchForLength + ", " + GcElUtilsSafe.length(replaceWith));
                }
                noMoreMatchesForReplIndex = new boolean[searchForLength];
                resultPacked = GcElUtilsSafe.findNextIndexHelper(searchForLength, searchFor, replaceWith, noMoreMatchesForReplIndex, text, 0);
                inputIndex = GcElUtilsSafe.unpackInt(resultPacked, true);
                replaceIndex = GcElUtilsSafe.unpackInt(resultPacked, false);
            }
            boolean bl = writeToWriter = outWriter != null;
            if (done || inputIndex == -1) {
                if (writeToWriter) {
                    outWriter.write(text, 0, text.length());
                    return null;
                }
                if (outBuffer != null) {
                    GcElUtilsSafe.appendSubstring(outBuffer, text, 0, text.length());
                    return null;
                }
                return text;
            }
            StringBuffer bufferToWriteTo = outBuffer != null ? outBuffer : (writeToWriter ? null : new StringBuffer(text.length() + GcElUtilsSafe.replaceStringsBufferIncrease(text, searchFor, replaceWith)));
            String searchString = null;
            String replaceString = null;
            int start = 0;
            while (inputIndex != -1) {
                searchString = (String)GcElUtilsSafe.get(searchFor, replaceIndex);
                replaceString = (String)GcElUtilsSafe.get(replaceWith, replaceIndex);
                if (writeToWriter) {
                    outWriter.write(text, start, inputIndex - start);
                    outWriter.write(replaceString);
                } else {
                    GcElUtilsSafe.appendSubstring(bufferToWriteTo, text, start, inputIndex).append(replaceString);
                }
                if (removeIfFound) {
                    searchFor = GcElUtilsSafe.remove(searchFor, replaceIndex);
                    replaceWith = GcElUtilsSafe.remove(replaceWith, replaceIndex);
                    noMoreMatchesForReplIndex = (boolean[])GcElUtilsSafe.remove(noMoreMatchesForReplIndex, replaceIndex);
                    --searchForLength;
                }
                start = inputIndex + searchString.length();
                resultPacked = GcElUtilsSafe.findNextIndexHelper(searchForLength, searchFor, replaceWith, noMoreMatchesForReplIndex, text, start);
                inputIndex = GcElUtilsSafe.unpackInt(resultPacked, true);
                replaceIndex = GcElUtilsSafe.unpackInt(resultPacked, false);
            }
            if (writeToWriter) {
                outWriter.write(text, start, text.length() - start);
            } else {
                GcElUtilsSafe.appendSubstring(bufferToWriteTo, text, start, text.length());
            }
            if (writeToWriter || outBuffer != null) {
                if (recurse) {
                    throw new IllegalArgumentException("Cannot recurse and write to existing buffer or writer!");
                }
                return null;
            }
            String resultString = bufferToWriteTo.toString();
            if (recurse) {
                return GcElUtilsSafe.replaceHelper(outBuffer, outWriter, resultString, searchFor, replaceWith, recurse, timeToLive - 1, false);
            }
            return resultString;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static int replaceStringsBufferIncrease(String text, Object repl, Object with) {
        int increase = 0;
        Iterator iteratorReplace = GcElUtilsSafe.iterator(repl);
        Iterator iteratorWith = GcElUtilsSafe.iterator(with);
        int replLength = GcElUtilsSafe.length(repl);
        String currentRepl = null;
        String currentWith = null;
        for (int i = 0; i < replLength; ++i) {
            currentRepl = (String)GcElUtilsSafe.next(repl, iteratorReplace, i);
            currentWith = (String)GcElUtilsSafe.next(with, iteratorWith, i);
            if (currentRepl == null || currentWith == null) {
                throw new NullPointerException("Replace string is null: " + text + ", " + currentRepl + ", " + currentWith);
            }
            int greater = currentWith.length() - currentRepl.length();
            increase += greater > 0 ? 3 * greater : 0;
        }
        increase = Math.min(increase, text.length() / 5);
        return increase;
    }

    private static long findNextIndexHelper(int searchForLength, Object searchFor, Object replaceWith, boolean[] noMoreMatchesForReplIndex, String input, int start) {
        int inputIndex = -1;
        int replaceIndex = -1;
        Iterator iteratorSearchFor = GcElUtilsSafe.iterator(searchFor);
        Iterator iteratorReplaceWith = GcElUtilsSafe.iterator(replaceWith);
        String currentSearchFor = null;
        String currentReplaceWith = null;
        int tempIndex = -1;
        for (int i = 0; i < searchForLength; ++i) {
            currentSearchFor = (String)GcElUtilsSafe.next(searchFor, iteratorSearchFor, i);
            currentReplaceWith = (String)GcElUtilsSafe.next(replaceWith, iteratorReplaceWith, i);
            if (noMoreMatchesForReplIndex[i] || GcElUtilsSafe.isEmpty(currentSearchFor) || currentReplaceWith == null) continue;
            tempIndex = input.indexOf(currentSearchFor, start);
            boolean bl = noMoreMatchesForReplIndex[i] = tempIndex == -1;
            if (tempIndex == -1 || inputIndex != -1 && tempIndex >= inputIndex) continue;
            inputIndex = tempIndex;
            replaceIndex = i;
        }
        long resultPacked = GcElUtilsSafe.packInts(inputIndex, replaceIndex);
        return resultPacked;
    }

    public static long packInts(int first, int second) {
        long result = first;
        result <<= 32;
        return result |= (long)second;
    }

    public static int unpackInt(long theLong, boolean isFirst) {
        int result = 0;
        if (isFirst) {
            theLong >>= 32;
        }
        result = (int)(theLong & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    private static StringBuffer appendSubstring(StringBuffer buf, String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            buf.append(string.charAt(i));
        }
        return buf;
    }

    public static String toStringSafe(Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int collectionSize = collection.size();
                if (collectionSize == 0) {
                    return "Empty " + object.getClass().getSimpleName();
                }
                Object first = collection.iterator().next();
                return object.getClass().getSimpleName() + " of size " + collectionSize + " with first type: " + (first == null ? null : first.getClass());
            }
            return object.toString();
        }
        catch (Exception e) {
            return "<<exception>> " + object.getClass() + ":\n" + GcElUtilsSafe.getFullStackTrace(e) + "\n";
        }
    }

    public static boolean booleanValue(Object object) {
        if (GcElUtilsSafe.nullOrBlank(object)) {
            throw new RuntimeException("Expecting something which can be converted to boolean, but is null or blank: '" + object + "'");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (GcElUtilsSafe.equalsIgnoreCase(string, "true") || GcElUtilsSafe.equalsIgnoreCase(string, "t") || GcElUtilsSafe.equalsIgnoreCase(string, "yes") || GcElUtilsSafe.equalsIgnoreCase(string, "y")) {
                return true;
            }
            if (GcElUtilsSafe.equalsIgnoreCase(string, "false") || GcElUtilsSafe.equalsIgnoreCase(string, "f") || GcElUtilsSafe.equalsIgnoreCase(string, "no") || GcElUtilsSafe.equalsIgnoreCase(string, "n")) {
                return false;
            }
            throw new RuntimeException("Invalid string to boolean conversion: '" + string + "' expecting true|false or t|f or yes|no or y|n case insensitive");
        }
        throw new RuntimeException("Cant convert object to boolean: " + object.getClass());
    }

    public static boolean booleanValue(Object object, boolean defaultBoolean) {
        if (GcElUtilsSafe.nullOrBlank(object)) {
            return defaultBoolean;
        }
        return GcElUtilsSafe.booleanValue(object);
    }

    public static Boolean booleanObjectValue(Object object) {
        if (GcElUtilsSafe.nullOrBlank(object)) {
            return null;
        }
        return GcElUtilsSafe.booleanValue(object);
    }

    public static boolean nullOrBlank(Object object) {
        if (object == null) {
            return true;
        }
        return object instanceof String && GcElUtilsSafe.isBlank((String)object);
    }

    public static Long dateLongValue(String date) {
        if (GcElUtilsSafe.isBlank(date)) {
            return null;
        }
        java.util.Date dateObject = GcElUtilsSafe.dateValue(date);
        return dateObject.getTime();
    }

    public static String dateStringValue(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static String dateStringValue(Long theDate) {
        if (theDate == null) {
            return null;
        }
        return GcElUtilsSafe.dateStringValue(new java.util.Date(theDate));
    }

    public static java.util.Date dateValue(Object inputObject) {
        if (inputObject == null) {
            return null;
        }
        if (inputObject instanceof java.util.Date) {
            return (java.util.Date)inputObject;
        }
        if (inputObject instanceof String) {
            String input = (String)inputObject;
            if (GcElUtilsSafe.isBlank(input)) {
                return null;
            }
            try {
                if (input.length() == 8) {
                    return GcElUtilsSafe.dateFormat().parse(input);
                }
                if (!GcElUtilsSafe.contains(input, '.')) {
                    if (GcElUtilsSafe.contains(input, '/')) {
                        return dateMinutesSecondsFormat.parse(input);
                    }
                    return dateMinutesSecondsNoSlashFormat.parse(input);
                }
                if (GcElUtilsSafe.contains(input, '/')) {
                    int lastDotIndex = input.lastIndexOf(46);
                    if (lastDotIndex == input.length() - 7) {
                        String nonNanoInput = input.substring(0, input.length() - 3);
                        java.util.Date date = timestampFormat.parse(nonNanoInput);
                        String lastThree = input.substring(input.length() - 3, input.length());
                        int lastThreeInt = Integer.parseInt(lastThree);
                        Timestamp timestamp = new Timestamp(date.getTime());
                        timestamp.setNanos(timestamp.getNanos() + lastThreeInt * 1000);
                        return timestamp;
                    }
                    return timestampFormat.parse(input);
                }
                return timestampNoSlashFormat.parse(input);
            }
            catch (ParseException pe) {
                throw new RuntimeException(errorStart + GcElUtilsSafe.toStringForLog(input));
            }
        }
        throw new RuntimeException("Cannot convert Object to date : " + GcElUtilsSafe.toStringForLog(inputObject));
    }

    public static java.util.Date stringToDate2(String input) {
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        input = input.trim();
        Matcher matcher = null;
        int month = 0;
        int day = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milli = 0;
        boolean foundMatch = false;
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd.matcher(input)).matches()) {
            year = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.intValue(matcher.group(2));
            day = GcElUtilsSafe.intValue(matcher.group(3));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy.matcher(input)).matches()) {
            day = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.monthInt(matcher.group(2));
            year = GcElUtilsSafe.intValue(matcher.group(3));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd_hhmmss.matcher(input)).matches()) {
            year = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.intValue(matcher.group(2));
            day = GcElUtilsSafe.intValue(matcher.group(3));
            hour = GcElUtilsSafe.intValue(matcher.group(4));
            minute = GcElUtilsSafe.intValue(matcher.group(5));
            second = GcElUtilsSafe.intValue(matcher.group(6));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy_hhmmss.matcher(input)).matches()) {
            day = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.monthInt(matcher.group(2));
            year = GcElUtilsSafe.intValue(matcher.group(3));
            hour = GcElUtilsSafe.intValue(matcher.group(4));
            minute = GcElUtilsSafe.intValue(matcher.group(5));
            second = GcElUtilsSafe.intValue(matcher.group(6));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd_hhmmss_SSS.matcher(input)).matches()) {
            year = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.intValue(matcher.group(2));
            day = GcElUtilsSafe.intValue(matcher.group(3));
            hour = GcElUtilsSafe.intValue(matcher.group(4));
            minute = GcElUtilsSafe.intValue(matcher.group(5));
            second = GcElUtilsSafe.intValue(matcher.group(6));
            milli = GcElUtilsSafe.intValue(matcher.group(7));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy_hhmmss_SSS.matcher(input)).matches()) {
            day = GcElUtilsSafe.intValue(matcher.group(1));
            month = GcElUtilsSafe.monthInt(matcher.group(2));
            year = GcElUtilsSafe.intValue(matcher.group(3));
            hour = GcElUtilsSafe.intValue(matcher.group(4));
            minute = GcElUtilsSafe.intValue(matcher.group(5));
            second = GcElUtilsSafe.intValue(matcher.group(6));
            milli = GcElUtilsSafe.intValue(matcher.group(7));
            foundMatch = true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milli);
        return calendar.getTime();
    }

    public static int monthInt(String mon) {
        if (!GcElUtilsSafe.isBlank(mon)) {
            if (GcElUtilsSafe.equals(mon = mon.toLowerCase(), "jan") || GcElUtilsSafe.equals(mon, "january")) {
                return 1;
            }
            if (GcElUtilsSafe.equals(mon, "feb") || GcElUtilsSafe.equals(mon, "february")) {
                return 2;
            }
            if (GcElUtilsSafe.equals(mon, "mar") || GcElUtilsSafe.equals(mon, "march")) {
                return 3;
            }
            if (GcElUtilsSafe.equals(mon, "apr") || GcElUtilsSafe.equals(mon, "april")) {
                return 4;
            }
            if (GcElUtilsSafe.equals(mon, "may")) {
                return 5;
            }
            if (GcElUtilsSafe.equals(mon, "jun") || GcElUtilsSafe.equals(mon, "june")) {
                return 6;
            }
            if (GcElUtilsSafe.equals(mon, "jul") || GcElUtilsSafe.equals(mon, "july")) {
                return 7;
            }
            if (GcElUtilsSafe.equals(mon, "aug") || GcElUtilsSafe.equals(mon, "august")) {
                return 8;
            }
            if (GcElUtilsSafe.equals(mon, "sep") || GcElUtilsSafe.equals(mon, "september")) {
                return 9;
            }
            if (GcElUtilsSafe.equals(mon, "oct") || GcElUtilsSafe.equals(mon, "october")) {
                return 10;
            }
            if (GcElUtilsSafe.equals(mon, "nov") || GcElUtilsSafe.equals(mon, "november")) {
                return 11;
            }
            if (GcElUtilsSafe.equals(mon, "dec") || GcElUtilsSafe.equals(mon, "december")) {
                return 12;
            }
        }
        throw new RuntimeException("Invalid month: " + mon);
    }

    public static boolean isBlank(Object input) {
        if (null == input) {
            return true;
        }
        return input instanceof String && GcElUtilsSafe.isBlank((String)input);
    }

    public static boolean isScalar(Class<?> type) {
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (CharSequence.class.equals(type) || CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        return Class.class == type || Boolean.class == type || type.isEnum();
    }

    public static Timestamp toTimestamp(Object input) {
        if (null == input) {
            return null;
        }
        if (input instanceof Timestamp) {
            return (Timestamp)input;
        }
        if (input instanceof String) {
            return GcElUtilsSafe.stringToTimestamp((String)input);
        }
        if (input instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)input).getTime());
        }
        if (input instanceof Date) {
            return new Timestamp(((Date)input).getTime());
        }
        throw new RuntimeException("Cannot convert Object to timestamp : " + input);
    }

    public static String stringValue(Object input) {
        if (input == null) {
            return (String)input;
        }
        if (input instanceof Timestamp) {
            return GcElUtilsSafe.timestampToString((Timestamp)input);
        }
        if (input instanceof java.util.Date) {
            return GcElUtilsSafe.stringValue((java.util.Date)input);
        }
        if (input instanceof Number) {
            DecimalFormat decimalFormat = new DecimalFormat("###################.###############");
            return decimalFormat.format(((Number)input).doubleValue());
        }
        return input.toString();
    }

    public static synchronized String timestampToString(java.util.Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestampFormat.format(timestamp);
    }

    public static synchronized String timestampToFileString(java.util.Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestampFileFormat.format(timestamp);
    }

    static synchronized SimpleDateFormat dateFormat() {
        return dateFormat;
    }

    static synchronized SimpleDateFormat dateFormat2() {
        return dateFormat2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringValue(java.util.Date date) {
        Class<GcElUtilsSafe> clazz = GcElUtilsSafe.class;
        synchronized (GcElUtilsSafe.class) {
            if (date == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
                String theString = GcElUtilsSafe.dateFormat2().format(date);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return theString;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return GcElUtilsSafe.timestampToString(date);
        }
    }

    public static Timestamp stringToTimestamp(String input) {
        java.util.Date date = GcElUtilsSafe.stringToTimestampHelper(input);
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    static synchronized java.util.Date stringToTimestampHelper(String input) {
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        input = input.trim();
        try {
            if (GcElUtilsSafe.equals("99999999", input) || GcElUtilsSafe.equals("999999", input)) {
                input = "20991231";
            }
            if (input.length() == 8) {
                return GcElUtilsSafe.dateFormat().parse(input);
            }
            if (input.length() == 10) {
                return GcElUtilsSafe.dateFormat2().parse(input);
            }
            if (!GcElUtilsSafe.contains(input, '.')) {
                if (GcElUtilsSafe.contains(input, '/')) {
                    return dateMinutesSecondsFormat.parse(input);
                }
                return dateMinutesSecondsNoSlashFormat.parse(input);
            }
            if (GcElUtilsSafe.contains(input, '/')) {
                int lastDotIndex = input.lastIndexOf(46);
                if (lastDotIndex == input.length() - 7) {
                    String nonNanoInput = input.substring(0, input.length() - 3);
                    java.util.Date date = timestampFormat.parse(nonNanoInput);
                    String lastThree = input.substring(input.length() - 3, input.length());
                    int lastThreeInt = Integer.parseInt(lastThree);
                    Timestamp timestamp = new Timestamp(date.getTime());
                    timestamp.setNanos(timestamp.getNanos() + lastThreeInt * 1000);
                    return timestamp;
                }
                return timestampFormat.parse(input);
            }
            return timestampNoSlashFormat.parse(input);
        }
        catch (ParseException pe) {
            throw new RuntimeException(errorStart + input);
        }
    }

    public static BigDecimal bigDecimalObjectValue(Object input) {
        if (input instanceof BigDecimal) {
            return (BigDecimal)input;
        }
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return BigDecimal.valueOf(GcElUtilsSafe.doubleValue(input));
    }

    public static Byte byteObjectValue(Object input) {
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return GcElUtilsSafe.byteValue(input);
    }

    public static byte byteValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Byte.parseByte(string);
        }
        if (input instanceof Number) {
            return ((Number)input).byteValue();
        }
        throw new RuntimeException("Cannot convert to byte: " + GcElUtilsSafe.className(input));
    }

    public static Double doubleObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (allowNullBlank && GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return GcElUtilsSafe.doubleValue(input);
    }

    public static double doubleValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Double.parseDouble(string);
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        throw new RuntimeException("Cannot convert to double: " + GcElUtilsSafe.className(input));
    }

    public static double doubleValueNoError(Object input) {
        if (input == null || input instanceof String && GcElUtilsSafe.isBlank((String)input)) {
            return -9.99999999E8;
        }
        try {
            return GcElUtilsSafe.doubleValue(input);
        }
        catch (Exception exception) {
            return -9.99999999E8;
        }
    }

    public static Float floatObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (allowNullBlank && GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return Float.valueOf(GcElUtilsSafe.floatValue(input));
    }

    public static float floatValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Float.parseFloat(string);
        }
        if (input instanceof Number) {
            return ((Number)input).floatValue();
        }
        throw new RuntimeException("Cannot convert to float: " + GcElUtilsSafe.className(input));
    }

    public static float floatValueNoError(Object input) {
        if (input == null || input instanceof String && GcElUtilsSafe.isBlank((String)input)) {
            return -1.0E9f;
        }
        try {
            return GcElUtilsSafe.floatValue(input);
        }
        catch (Exception e) {
            LOG.error(e);
            return -1.0E9f;
        }
    }

    public static Integer intObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (allowNullBlank && GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return GcElUtilsSafe.intValue(input);
    }

    public static int intValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Integer.parseInt(string);
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        throw new RuntimeException("Cannot convert to int: " + GcElUtilsSafe.className(input));
    }

    public static int intValue(Object input, int valueIfNull) {
        if (input == null || EMPTY.equals(input)) {
            return valueIfNull;
        }
        return GcElUtilsSafe.intObjectValue(input, false);
    }

    public static int intValueNoError(Object input) {
        if (input == null || input instanceof String && GcElUtilsSafe.isBlank((String)input)) {
            return -999999999;
        }
        try {
            return GcElUtilsSafe.intValue(input);
        }
        catch (Exception exception) {
            return -999999999;
        }
    }

    public static Long longObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Long) {
            return (Long)input;
        }
        if (allowNullBlank && GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return GcElUtilsSafe.longValue(input);
    }

    public static long longValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Long.parseLong(string);
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        throw new RuntimeException("Cannot convert to long: " + GcElUtilsSafe.className(input));
    }

    public static long longValue(Object input, long valueIfNull) {
        if (input == null || EMPTY.equals(input)) {
            return valueIfNull;
        }
        return GcElUtilsSafe.longObjectValue(input, false);
    }

    public static long longValueNoError(Object input) {
        if (input == null || input instanceof String && GcElUtilsSafe.isBlank((String)input)) {
            return -999999999L;
        }
        try {
            return GcElUtilsSafe.longValue(input);
        }
        catch (Exception exception) {
            return -999999999L;
        }
    }

    public static Short shortObjectValue(Object input) {
        if (input instanceof Short) {
            return (Short)input;
        }
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return GcElUtilsSafe.shortValue(input);
    }

    public static short shortValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Short.parseShort(string);
        }
        if (input instanceof Number) {
            return ((Number)input).shortValue();
        }
        throw new RuntimeException("Cannot convert to short: " + GcElUtilsSafe.className(input));
    }

    public static Character charObjectValue(Object input) {
        if (input instanceof Character) {
            return (Character)input;
        }
        if (GcElUtilsSafe.isBlank(input)) {
            return null;
        }
        return new Character(GcElUtilsSafe.charValue(input));
    }

    public static char charValue(Object input) {
        String inputString;
        if (input instanceof Character) {
            return ((Character)input).charValue();
        }
        if (input instanceof String && (inputString = (String)input).length() == 1) {
            return inputString.charAt(0);
        }
        throw new RuntimeException("Cannot convert to char: " + (input == null ? null : input.getClass() + ", " + input));
    }

    public static String replaceWhitespaceWithSpace(String input) {
        if (input == null) {
            return input;
        }
        return input.replaceAll("\\s+", " ");
    }

    public static String convertLongToChar(long theLong) {
        if (theLong < 0L || theLong >= 62L) {
            throw new RuntimeException("convertLongToChar()  invalid input (not >=0 && <62: " + theLong);
        }
        if (theLong < 26L) {
            return EMPTY + (char)(97L + theLong);
        }
        if (theLong < 52L) {
            return EMPTY + (char)(65L + (theLong - 26L));
        }
        return EMPTY + (char)(48L + (theLong - 52L));
    }

    public static String convertLongToCharSmall(long theLong) {
        if (theLong < 0L || theLong >= 36L) {
            throw new RuntimeException("convertLongToCharSmall()  invalid input (not >=0 && <36: " + theLong);
        }
        if (theLong < 26L) {
            return EMPTY + (char)(65L + theLong);
        }
        return EMPTY + (char)(48L + (theLong - 26L));
    }

    public static String convertLongToString(long theLong) {
        long quotient = theLong / 62L;
        long remainder = theLong % 62L;
        if (quotient == 0L) {
            return GcElUtilsSafe.convertLongToChar(remainder);
        }
        StringBuffer result = new StringBuffer();
        result.append(GcElUtilsSafe.convertLongToString(quotient));
        result.append(GcElUtilsSafe.convertLongToChar(remainder));
        return result.toString();
    }

    public static String convertLongToStringSmall(long theLong) {
        long quotient = theLong / 36L;
        long remainder = theLong % 36L;
        if (quotient == 0L) {
            return GcElUtilsSafe.convertLongToCharSmall(remainder);
        }
        StringBuffer result = new StringBuffer();
        result.append(GcElUtilsSafe.convertLongToStringSmall(quotient));
        result.append(GcElUtilsSafe.convertLongToCharSmall(remainder));
        return result.toString();
    }

    public static char incrementChar(char theChar) {
        if (theChar == 'Z') {
            return '0';
        }
        if (theChar == '9') {
            return 'A';
        }
        theChar = (char)(theChar + '\u0001');
        return theChar;
    }

    public static char[] incrementStringInt(char[] string) {
        if (string == null) {
            return string;
        }
        int i = 0;
        for (i = string.length - 1; i >= 0; --i) {
            char inc = string[i];
            string[i] = inc = GcElUtilsSafe.incrementChar(inc);
            if (inc != 'A') break;
        }
        if (i < 0) {
            return ("A" + new String(string)).toCharArray();
        }
        return string;
    }

    public static boolean isAscii(char input) {
        return input < '\u0080';
    }

    public static int lengthAscii(String input) {
        if (input == null) {
            return 0;
        }
        int utfLength = input.length();
        int extras = 0;
        for (int i = 0; i < utfLength; ++i) {
            if (GcElUtilsSafe.isAscii(input.charAt(i))) continue;
            ++extras;
        }
        return utfLength + extras;
    }

    public static int stringLength(String string) {
        return string == null ? 0 : string.length();
    }

    public static String truncateAscii(String input, int requiredLength) {
        if (input == null) {
            return input;
        }
        int utfLength = input.length();
        if (utfLength * 2 < requiredLength) {
            return input;
        }
        int asciiLength = 0;
        for (int i = 0; i < utfLength; ++i) {
            ++asciiLength;
            if (!GcElUtilsSafe.isAscii(input.charAt(i))) {
                ++asciiLength;
            }
            if (asciiLength <= requiredLength) continue;
            return input.substring(0, i);
        }
        return input;
    }

    public static boolean equals(String first, String second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !GcElUtilsSafe.isBlank(str);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String abbreviate(String str, int maxWidth) {
        return GcElUtilsSafe.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + GcElUtilsSafe.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String[] split(String str) {
        return GcElUtilsSafe.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        return GcElUtilsSafe.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return GcElUtilsSafe.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return GcElUtilsSafe.splitWorker(str, separatorChars, max, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return GcElUtilsSafe.splitByWholeSeparator(str, separator, -1);
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return GcElUtilsSafe.split(str, null, max);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return GcElUtilsSafe.splitWorker(str, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        return GcElUtilsSafe.splitWorker(str, separatorChar, true);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return GcElUtilsSafe.splitWorker(str, separatorChars, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max) {
        return GcElUtilsSafe.splitWorker(str, separatorChars, max, true);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array) {
        return GcElUtilsSafe.join(array, null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (separator == null || !iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String defaultString(String str) {
        return str == null ? EMPTY : str;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return GcElUtilsSafe.isEmpty(str) ? defaultStr : str;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean contains(String str, char searchChar) {
        if (GcElUtilsSafe.isEmpty(str)) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static String stripLastSlashIfExists(String input) {
        if (input == null || input.length() == 0) {
            return null;
        }
        char lastChar = input.charAt(input.length() - 1);
        if (lastChar == '\\' || lastChar == '/') {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return GcElUtilsSafe.padding(repeat, str.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuffer buf = new StringBuffer(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    private static String padding(int repeat, char padChar) {
        String pad = PADDING[padChar];
        if (pad == null) {
            pad = String.valueOf(padChar);
        }
        while (pad.length() < repeat) {
            pad = pad.concat(pad);
        }
        GcElUtilsSafe.PADDING[padChar] = pad;
        return pad.substring(0, repeat);
    }

    public static String rightPad(String str, int size) {
        return GcElUtilsSafe.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return GcElUtilsSafe.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(GcElUtilsSafe.padding(pads, padChar));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (GcElUtilsSafe.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return GcElUtilsSafe.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return GcElUtilsSafe.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return GcElUtilsSafe.leftPad(str, size, String.valueOf(padChar));
        }
        return GcElUtilsSafe.padding(pads, padChar).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (GcElUtilsSafe.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return GcElUtilsSafe.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String substringBefore(String str, String separator) {
        if (GcElUtilsSafe.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (GcElUtilsSafe.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (GcElUtilsSafe.isEmpty(str) || GcElUtilsSafe.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (GcElUtilsSafe.isEmpty(str)) {
            return str;
        }
        if (GcElUtilsSafe.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static <T> T listPopOne(List<T> list) {
        int size = GcElUtilsSafe.length(list);
        if (size == 1) {
            return list.get(0);
        }
        if (size == 0) {
            return null;
        }
        throw new RuntimeException("More than one object of type " + GcElUtilsSafe.className(list.get(0)) + " was returned when only one was expected. (size:" + size + ")");
    }

    public static <T> T setPopOne(Set<T> set) {
        int size = GcElUtilsSafe.length(set);
        if (size == 1) {
            return set.iterator().next();
        }
        if (size == 0) {
            return null;
        }
        throw new RuntimeException("More than one object of type " + GcElUtilsSafe.className(set.iterator().next()) + " was returned when only one was expected. (size:" + size + ")");
    }

    public static <T> T collectionPopOne(Collection<T> collection, boolean exceptionIfMoreThanOne) {
        int size = GcElUtilsSafe.length(collection);
        if (size > 1 && exceptionIfMoreThanOne) {
            throw new RuntimeException("More than one object of type " + GcElUtilsSafe.className(GcElUtilsSafe.get(collection, 0)) + " was returned when only one was expected. (size:" + size + ")");
        }
        if (size == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    public static String xmlEscape(String input, boolean isEscape) {
        if (isEscape) {
            return GcElUtilsSafe.replace(input, XML_SEARCH_NO_SINGLE, XML_REPLACE_NO_SINGLE);
        }
        return GcElUtilsSafe.replace(input, XML_REPLACE_NO_SINGLE, XML_SEARCH_NO_SINGLE);
    }

    public static boolean appendIfNotBlank(StringBuilder result, Object theStringOrArrayOrList) {
        return GcElUtilsSafe.appendIfNotBlank(result, null, theStringOrArrayOrList, null);
    }

    public static String appendIfNotBlankString(String string, String separator, String suffix) {
        string = GcElUtilsSafe.trimToEmpty(string);
        suffix = GcElUtilsSafe.trimToEmpty(suffix);
        boolean stringIsBlank = GcElUtilsSafe.isBlank(string);
        boolean suffixIsBlank = GcElUtilsSafe.isBlank(suffix);
        if (stringIsBlank && suffixIsBlank) {
            return EMPTY;
        }
        if (stringIsBlank) {
            return suffix;
        }
        if (suffixIsBlank) {
            return string;
        }
        return string + separator + suffix;
    }

    public static boolean appendIfNotBlank(StringBuilder result, String prefix, Object theStringOrArrayOrList) {
        return GcElUtilsSafe.appendIfNotBlank(result, prefix, theStringOrArrayOrList, null);
    }

    public static boolean appendIfNotBlank(StringBuilder result, String prefix, Object theStringOrArrayOrList, String suffix) {
        return GcElUtilsSafe.appendIfNotBlank(result, prefix, null, theStringOrArrayOrList, suffix);
    }

    public static boolean appendIfNotBlank(StringBuilder result, String prefix, String prefixIfNotBlank, Object theStringOrArrayOrList, String suffix) {
        int length = GcElUtilsSafe.length(theStringOrArrayOrList);
        Iterator iterator = GcElUtilsSafe.iterator(theStringOrArrayOrList);
        boolean appendedAnything = false;
        boolean hasPrefix = !GcElUtilsSafe.isEmpty(prefix);
        boolean hasPrefixIfNotBlank = !GcElUtilsSafe.isEmpty(prefixIfNotBlank);
        boolean hasSuffix = !GcElUtilsSafe.isEmpty(suffix);
        for (int i = 0; i < length; ++i) {
            String current = (String)GcElUtilsSafe.next(theStringOrArrayOrList, iterator, i);
            if (GcElUtilsSafe.isBlank(current)) continue;
            appendedAnything = true;
            if (hasPrefix) {
                result.append(prefix);
            }
            if (hasPrefixIfNotBlank && result.length() > 0) {
                result.append(prefixIfNotBlank);
            }
            result.append(current);
            if (!hasSuffix) continue;
            result.append(suffix);
        }
        return appendedAnything;
    }

    public static boolean appendIfNotEmpty(StringBuilder result, Object theStringOrArrayOrList) {
        return GcElUtilsSafe.appendIfNotEmpty(result, null, theStringOrArrayOrList, null);
    }

    public static boolean appendIfNotEmpty(StringBuilder result, String prefix, Object theStringOrArrayOrList) {
        return GcElUtilsSafe.appendIfNotEmpty(result, prefix, theStringOrArrayOrList, null);
    }

    public static boolean appendIfNotEmpty(StringBuilder result, String prefix, Object theStringOrArrayOrList, String suffix) {
        return GcElUtilsSafe.appendIfNotEmpty(result, prefix, null, theStringOrArrayOrList, suffix);
    }

    public static boolean appendIfNotEmpty(StringBuilder result, String prefix, String prefixIfNotEmpty, Object theStringOrArrayOrList, String suffix) {
        int length = GcElUtilsSafe.length(theStringOrArrayOrList);
        Iterator iterator = GcElUtilsSafe.iterator(theStringOrArrayOrList);
        boolean appendedAnything = false;
        boolean hasPrefix = !GcElUtilsSafe.isEmpty(prefix);
        boolean hasPrefixIfNotEmpty = !GcElUtilsSafe.isEmpty(prefixIfNotEmpty);
        boolean hasSuffix = !GcElUtilsSafe.isEmpty(suffix);
        for (int i = 0; i < length; ++i) {
            String current = (String)GcElUtilsSafe.next(theStringOrArrayOrList, iterator, i);
            if (GcElUtilsSafe.isEmpty(current)) continue;
            appendedAnything = true;
            if (hasPrefix) {
                result.append(prefix);
            }
            if (hasPrefixIfNotEmpty && result.length() > 0) {
                result.append(prefixIfNotEmpty);
            }
            result.append(current);
            if (!hasSuffix) continue;
            result.append(suffix);
        }
        return appendedAnything;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return GcElUtilsSafe.indexOf(array, objectToFind, 0);
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return GcElUtilsSafe.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T arrayPopOne(T[] array) {
        int size = GcElUtilsSafe.length(array);
        if (size == 1) {
            return array[0];
        }
        if (size == 0) {
            return null;
        }
        throw new RuntimeException("More than one object of type " + GcElUtilsSafe.className(array[0]) + " was returned when only one was expected. (size:" + size + ")");
    }

    public static String dateToString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static java.util.Date stringToDate(String dateString) {
        if (GcElUtilsSafe.isBlank(dateString)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        try {
            return simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(WS_DATE_FORMAT2);
            try {
                return simpleDateFormat2.parse(dateString);
            }
            catch (ParseException e2) {
                throw new RuntimeException("Cannot convert '" + dateString + "' to a date based on format: " + "yyyy/MM/dd HH:mm:ss.SSS", e);
            }
        }
    }

    public static Long getMaxLongValue(Long ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Long maxValue = null;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || maxValue != null && maxValue.compareTo(values[i]) >= 0) continue;
            maxValue = new Long(values[i]);
        }
        return maxValue;
    }

    public static Long getMinLongValue(Long ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Long minValue = null;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || minValue != null && minValue.compareTo(values[i]) <= 0) continue;
            minValue = new Long(values[i]);
        }
        return minValue;
    }

    public static boolean ipOnNetwork(String ipString, String networkIpString, int mask) {
        if (mask == 0) {
            return true;
        }
        int ip = GcElUtilsSafe.ipInt(ipString);
        int networkIp = GcElUtilsSafe.ipInt(networkIpString);
        return (ip = GcElUtilsSafe.ipReadyForAnd(ip, mask)) == (networkIp = GcElUtilsSafe.ipReadyForAnd(networkIp, mask));
    }

    public static boolean ipOnNetworks(String ipString, String networkIpStrings) {
        String[] networkIpStringsArray;
        for (String networkIpString : networkIpStringsArray = GcElUtilsSafe.splitTrim(networkIpStrings, ",")) {
            if (!GcElUtilsSafe.contains(networkIpString, "/")) {
                throw new RuntimeException("String must contain slash and CIDR network bits, e.g. 1.2.3.4/14");
            }
            String network = GcElUtilsSafe.prefixOrSuffix(networkIpString, "/", true);
            network = GcElUtilsSafe.trim(network);
            String mask = GcElUtilsSafe.prefixOrSuffix(networkIpString, "/", false);
            mask = GcElUtilsSafe.trim(mask);
            int maskInt = -1;
            maskInt = Integer.parseInt(mask);
            if (!GcElUtilsSafe.ipOnNetwork(ipString, network, maskInt)) continue;
            return true;
        }
        return false;
    }

    public static int ipReadyForAnd(int ip, int maskLength) {
        int mask = -1 + (int)Math.pow(2.0, 32 - maskLength);
        return ip | mask;
    }

    public static int ipInt(String ip) {
        int block4;
        int block3;
        int block2;
        int block1;
        try {
            int periodIndex = ip.indexOf(46);
            String blockString = ip.substring(0, periodIndex);
            block1 = Integer.parseInt(blockString);
            int mathPow = (int)Math.pow(2.0, 24.0);
            block1 *= mathPow;
            int oldPeriodIndex = periodIndex;
            periodIndex = ip.indexOf(46, periodIndex + 1);
            blockString = ip.substring(oldPeriodIndex + 1, periodIndex);
            block2 = Integer.parseInt(blockString);
            block2 = (int)((double)block2 * Math.pow(2.0, 16.0));
            oldPeriodIndex = periodIndex;
            periodIndex = ip.indexOf(46, periodIndex + 1);
            blockString = ip.substring(oldPeriodIndex + 1, periodIndex);
            block3 = Integer.parseInt(blockString);
            block3 = (int)((double)block3 * Math.pow(2.0, 8.0));
            blockString = ip.substring(periodIndex + 1, ip.length());
            block4 = Integer.parseInt(blockString);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Could not parse the ipaddress: " + ip);
        }
        return block1 + block2 + block3 + block4;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = GcElUtilsSafe.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (GcElUtilsSafe.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static Object get(Object arrayOrCollection, int index) {
        if (arrayOrCollection == null) {
            if (index == 0) {
                return null;
            }
            throw new RuntimeException("Trying to access index " + index + " of null");
        }
        if (arrayOrCollection instanceof List) {
            return ((List)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            Iterator iterator = GcElUtilsSafe.iterator(arrayOrCollection);
            for (int i = 0; i < index; ++i) {
                GcElUtilsSafe.next(arrayOrCollection, iterator, i);
            }
            return GcElUtilsSafe.next(arrayOrCollection, iterator, index);
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (index == 0) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Trying to access index " + index + " of and object: " + arrayOrCollection);
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = GcElUtilsSafe.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (GcElUtilsSafe.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        int isize = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < isize; ++i) {
            try {
                Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable) {
        return GcElUtilsSafe.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = GcElUtilsSafe.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            String methodName;
            if (methodNames == null) {
                methodNames = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = GcElUtilsSafe.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = GcElUtilsSafe.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    static {
        Method getCauseMethod;
        emailPattern = Pattern.compile("^[^@]+@[^.]+\\..+$");
        timestampFileFormat = new SimpleDateFormat(TIMESTAMP_FILE_FORMAT);
        dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat2 = new SimpleDateFormat(DATE_FORMAT2);
        dateMinutesSecondsFormat = new SimpleDateFormat(DATE_MINUTES_SECONDS_FORMAT);
        dateMinutesSecondsNoSlashFormat = new SimpleDateFormat(DATE_MINUTES_SECONDS_NO_SLASH_FORMAT);
        timestampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        timestampNoSlashFormat = new SimpleDateFormat(TIMESTAMP_NO_SLASH_FORMAT);
        lastId = GcElUtilsSafe.convertLongToStringSmall(new java.util.Date().getTime()).toCharArray();
        datePattern_yyyy_mm_dd = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_dd_mon_yyyy = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})$");
        datePattern_yyyy_mm_dd_hhmmss = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_dd_mon_yyyy_hhmmss = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_yyyy_mm_dd_hhmmss_SSS = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,3})$");
        datePattern_dd_mon_yyyy_hhmmss_SSS = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,3})$");
        LOG = GrouperClientUtils.retrieveLog(GcElUtilsSafe.class);
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        PADDING = new String[65535];
        GcElUtilsSafe.PADDING[32] = "                                                                ";
        XML_REPLACE_NO_SINGLE = new String[]{"&amp;", "&lt;", "&gt;", "&quot;"};
        XML_SEARCH_NO_SINGLE = new String[]{"&", "<", ">", "\""};
        try {
            getCauseMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
    }
}

