/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import java.io.Serializable;

public class ExpirableValue<T>
implements Serializable {
    private long timePlacedInCache = System.currentTimeMillis();
    private long timeToLiveInCacheMillis = ExpirableCache.MAX_TIME_TO_LIVE_MILLIS;
    private T content = null;

    public ExpirableValue(T theContent, long theTimeToLiveInCacheMillis) {
        if (theTimeToLiveInCacheMillis >= 0L && theTimeToLiveInCacheMillis <= ExpirableCache.MAX_TIME_TO_LIVE_MILLIS) {
            this.timeToLiveInCacheMillis = theTimeToLiveInCacheMillis;
        }
        this.content = theContent;
    }

    T getContent() {
        if (this.expiredLongTime()) {
            throw new RuntimeException("This content is expired!");
        }
        return this.content;
    }

    boolean expired() {
        if (this.timeToLiveInCacheMillis <= 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }

    boolean expiredLongTime() {
        if (this.timeToLiveInCacheMillis <= 0L) {
            return true;
        }
        return System.currentTimeMillis() - 3000L - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }
}

