/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJobState;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncColumnMetadata;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncRowData;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableBean;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableData;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableMetadata;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum GcTableSyncSubtype {
    fullSyncFull{

        @Override
        public boolean isFullSync() {
            return true;
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            GcTableSyncSubtype.captureCurrentMaxIncrementalIndexIfNeeded(debugMap, gcTableSync);
            String sqlFrom = "select " + gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            String sqlTo = "select " + gcTableSync.getDataBeanTo().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName();
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().columnListAll(), "retrieveData", null);
            gcTableSync.getDataBeanFrom().setDataInitialQuery(gcTableSyncTableDatas[0]);
            gcTableSync.getDataBeanTo().setDataInitialQuery(gcTableSyncTableDatas[1]);
            gcTableSync.getGcGrouperSync().setRecordsCount(GrouperClientUtils.length(gcTableSyncTableDatas[0].getRows()));
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            int[] results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSync.getDataBeanTo().getDataInitialQuery());
            if (!GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalAllColumnsColumnString())) {
                GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn());
            } else if (!GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalProgressColumnString())) {
                GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), null);
            }
            int recordsChanged = results[0] + results[1] + results[2];
            return recordsChanged;
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return false;
        }
    }
    ,
    fullSyncGroups{

        @Override
        public boolean isFullSync() {
            return true;
        }

        @Override
        public boolean isNeedsGroupColumn() {
            return true;
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            GcTableSyncSubtype.captureCurrentMaxIncrementalIndexIfNeeded(debugMap, gcTableSync);
            String sqlFrom = "select distinct " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            String sqlTo = "select distinct " + gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName();
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName(), "retrieveGroups", null);
            gcTableSync.getDataBeanFrom().setDataInitialQuery(gcTableSyncTableDatas[0]);
            gcTableSync.getDataBeanTo().setDataInitialQuery(gcTableSyncTableDatas[1]);
            String sqlCountFrom = "select count(1) from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            int count = new GcDbAccess().connectionName(gcTableSync.getDataBeanFrom().getTableMetadata().getConnectionName()).sql(sqlCountFrom).select(Integer.TYPE);
            gcTableSync.getGcGrouperSync().setRecordsCount(count);
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            Integer recordsChanged = GcTableSyncSubtype.runInsertsUpdatesDeletesGroupings(debugMap, gcTableSync, gcTableSync.getDataBeanFrom().getDataInitialQuery().allGroupings(), gcTableSync.getDataBeanTo().getDataInitialQuery().allGroupings());
            GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), null);
            return recordsChanged;
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return false;
        }
    }
    ,
    fullSyncChangeFlag{

        @Override
        public boolean isFullSync() {
            return true;
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            GcTableSyncSubtype.captureCurrentMaxIncrementalIndexIfNeeded(debugMap, gcTableSync);
            String sqlFrom = "select " + gcTableSync.getDataBeanFrom().getTableMetadata().columnListPrimaryKeyAndChangeFlagAndOptionalIncrementalProgress() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            String sqlTo = "select " + gcTableSync.getDataBeanTo().getTableMetadata().columnListPrimaryKeyAndChangeFlagAndOptionalIncrementalProgress() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName();
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().columnListPrimaryKeyAndChangeFlagAndOptionalIncrementalProgress(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().columnListPrimaryKeyAndChangeFlagAndOptionalIncrementalProgress(), "retrieveChangeFlag", null);
            gcTableSync.getDataBeanFrom().setDataInitialQuery(gcTableSyncTableDatas[0]);
            gcTableSync.getDataBeanTo().setDataInitialQuery(gcTableSyncTableDatas[1]);
            gcTableSync.getGcGrouperSync().setRecordsCount(GrouperClientUtils.length(gcTableSyncTableDatas[0].getRows()));
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            Integer changes = GcTableSyncSubtype.runInsertsUpdatesDeletesChangeFlag(debugMap, gcTableSync, gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSync.getDataBeanTo().getDataInitialQuery());
            if (!GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalAllColumnsColumnString())) {
                GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn());
            } else if (!GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalProgressColumnString())) {
                GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), null);
            }
            return changes;
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return false;
        }
    }
    ,
    incrementalAllColumns{

        @Override
        public boolean isFullSync() {
            return false;
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            if (gcTableSync.getDataBeanFrom().getDataInitialQuery() == null) {
                return 0;
            }
            Set<MultiKey> primaryKeysToRetrieve = gcTableSync.getDataBeanFrom().getDataInitialQuery().allPrimaryKeys();
            int recordsChanged = GcTableSyncSubtype.handleLotsOfChangesAnotherWay((Map<String, Object>)debugMap, gcTableSync, (Set<MultiKey>)primaryKeysToRetrieve, gcTableSync.getDataBeanFrom().getDataInitialQuery());
            GcTableSyncTableData gcTableSyncTableDataTo = GcTableSyncSubtype.runQueryForAllDataFromPrimaryKeys(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToRetrieve, false);
            int[] results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSyncTableDataTo);
            recordsChanged += results[0] + results[1] + results[2];
            if (gcTableSync.getGcGrouperSync().getRecordsCount() != null) {
                gcTableSync.getGcGrouperSync().setRecordsCount(gcTableSync.getGcGrouperSync().getRecordsCount() + results[0] - results[2]);
            }
            GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanFrom().getDataInitialQuery(), gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn());
            return recordsChanged;
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            GcTableSyncSubtype.retrieveIncrementalDataHelper(debugMap, gcTableSync, gcTableSync.getDataBeanFrom(), gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll(), gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn(), true);
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return true;
        }
    }
    ,
    incrementalPrimaryKey{

        @Override
        public boolean isFullSync() {
            return false;
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            if (gcTableSync.getDataBeanRealTime().getDataInitialQuery() == null) {
                return 0;
            }
            Set<MultiKey> primaryKeysToRetrieve = gcTableSync.getDataBeanRealTime().getDataInitialQuery().allDataInColumns(gcTableSync.getDataBeanFrom().getTableMetadata().getPrimaryKey());
            int recordsChanged = GcTableSyncSubtype.handleLotsOfChangesAnotherWay((Map<String, Object>)debugMap, gcTableSync, (Set<MultiKey>)primaryKeysToRetrieve, gcTableSync.getDataBeanRealTime().getDataInitialQuery());
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndToForAllDataFromPrimaryKeys(debugMap, gcTableSync, primaryKeysToRetrieve);
            GcTableSyncTableData gcTableSyncTableDataFrom = gcTableSyncTableDatas[0];
            GcTableSyncTableData gcTableSyncTableDataTo = gcTableSyncTableDatas[1];
            int[] results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSyncTableDataFrom, gcTableSyncTableDataTo);
            gcTableSync.getGcGrouperSync().setRecordsCount(gcTableSync.getGcGrouperSync().getRecordsCount() + results[0] - results[2]);
            GcTableSyncSubtype.assignIncrementalIndex(gcTableSync.getDataBeanRealTime().getDataInitialQuery(), gcTableSync.getDataBeanRealTime().getTableMetadata().getIncrementalProgressColumn());
            return recordsChanged += results[0] + results[1] + results[2];
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            GcTableSyncSubtype.retrieveIncrementalDataHelper(debugMap, gcTableSync, gcTableSync.getDataBeanRealTime(), gcTableSync.getDataBeanRealTime().getTableMetadata().columnListInputtedColumnsAndIncrementalProgressColumn(gcTableSync.getDataBeanFrom().getTableMetadata().getPrimaryKey()), gcTableSync.getDataBeanRealTime().getTableMetadata().getIncrementalProgressColumn(), null);
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return true;
        }
    }
    ,
    fullSyncMetadata{

        @Override
        public boolean isFullSync() {
            return false;
        }

        @Override
        public boolean isNeedsGroupColumn() {
            return true;
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            String sqlFrom = "select distinct " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            String sqlTo = "select distinct " + gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName();
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName(), "retrieveGroups", null);
            gcTableSync.getDataBeanFrom().setDataInitialQuery(gcTableSyncTableDatas[0]);
            gcTableSync.getDataBeanTo().setDataInitialQuery(gcTableSyncTableDatas[1]);
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            Integer recordsChanged = GcTableSyncSubtype.runInsertsUpdatesDeletesGroupingsMetadata(debugMap, gcTableSync, gcTableSync.getDataBeanFrom().getDataInitialQuery().allGroupings(), gcTableSync.getDataBeanTo().getDataInitialQuery().allGroupings());
            return recordsChanged;
        }

        @Override
        public boolean isFullMetadataSync() {
            return true;
        }

        @Override
        public boolean isIncrementalSync() {
            return false;
        }
    }
    ,
    incrementalFromIdentifiedPrimaryKeys{

        @Override
        public boolean isFullSync() {
            return false;
        }

        @Override
        public Integer syncData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
            Set<MultiKey> primaryKeysToRetrieve = gcTableSync.getPrimaryKeysToSync();
            if (GrouperClientUtils.length(primaryKeysToRetrieve) == 0) {
                return 0;
            }
            HashMap<Object, HashSet<MultiKey>> groupPrimaryKeys = new HashMap<Object, HashSet<MultiKey>>();
            for (MultiKey multiKey : primaryKeysToRetrieve) {
                Object groupLabel = multiKey.getKey(0);
                HashSet<MultiKey> currentPrimaryKeys = (HashSet<MultiKey>)groupPrimaryKeys.get(groupLabel);
                if (currentPrimaryKeys == null) {
                    currentPrimaryKeys = new HashSet<MultiKey>();
                    groupPrimaryKeys.put(groupLabel, currentPrimaryKeys);
                }
                currentPrimaryKeys.add(multiKey);
            }
            int recordsChanged = GcTableSyncSubtype.handleLotsOfChangesAnotherWay((Map<String, Object>)debugMap, gcTableSync, (Set<MultiKey>)primaryKeysToRetrieve, groupPrimaryKeys);
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndToForAllDataFromPrimaryKeys(debugMap, gcTableSync, primaryKeysToRetrieve);
            GcTableSyncTableData gcTableSyncTableDataFrom = gcTableSyncTableDatas[0];
            GcTableSyncTableData gcTableSyncTableDataTo = gcTableSyncTableDatas[1];
            int[] results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSyncTableDataFrom, gcTableSyncTableDataTo);
            gcTableSync.getGcGrouperSync().setRecordsCount(gcTableSync.getGcGrouperSync().getRecordsCount() + results[0] - results[2]);
            return recordsChanged += results[0] + results[1] + results[2];
        }

        @Override
        public void retrieveData(Map<String, Object> debugMap, GcTableSync gcTableSync) {
        }

        @Override
        public boolean isFullMetadataSync() {
            return false;
        }

        @Override
        public boolean isIncrementalSync() {
            return true;
        }
    };

    private static final Log LOG;

    public static int syncGroupings(Map<String, Object> debugMap, GcTableSync gcTableSync, Collection<Object> groupings) {
        if (GrouperClientUtils.length(groupings) == 0) {
            return 0;
        }
        int groupingsBatchSize = Math.min(gcTableSync.getGcTableSyncConfiguration().getMaxBindVarsInSelect(), gcTableSync.getGcTableSyncConfiguration().getGroupingSize());
        int groupingsNumberOfBatches = GrouperClientUtils.batchNumberOfBatches(groupings, groupingsBatchSize);
        int recordsChanged = 0;
        for (int currentBatchIndex = 0; currentBatchIndex < groupingsNumberOfBatches; ++currentBatchIndex) {
            List<Object> groupingsBatch = GrouperClientUtils.batchList(groupings, groupingsBatchSize, currentBatchIndex);
            String sqlFrom = "select " + gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName() + " where " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " in (" + GrouperClientUtils.appendQuestions(groupingsBatch.size()) + ")";
            String sqlTo = "select " + gcTableSync.getDataBeanTo().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName() + " where " + gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName() + " in (" + GrouperClientUtils.appendQuestions(groupingsBatch.size()) + ")";
            GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().columnListAll(), "retrieveGroups", GrouperClientUtils.toArray(groupingsBatch, Object.class));
            int[] results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSyncTableDatas[0], gcTableSyncTableDatas[1]);
            gcTableSync.getGcGrouperSync().setRecordsCount(gcTableSync.getGcGrouperSync().getRecordsCount() + results[0] - results[2]);
            recordsChanged += results[0] + results[1] + results[2];
        }
        return recordsChanged;
    }

    private static int handleLotsOfChangesAnotherWay(Map<String, Object> debugMap, GcTableSync gcTableSync, Set<MultiKey> primaryKeysToRetrieve, GcTableSyncTableData fullDataOfQuery) {
        Integer groupingColumnZeroIndex;
        if (GrouperClientUtils.length(primaryKeysToRetrieve) == 0) {
            return 0;
        }
        HashMap<Object, HashSet<MultiKey>> groupPrimaryKeys = null;
        String groupingColumnName = gcTableSync.getGcTableSyncConfiguration().getGroupColumnString();
        if (!GrouperClientUtils.isBlank(groupingColumnName) && (groupingColumnZeroIndex = fullDataOfQuery.getRows().iterator().next().lookupColumnToIndexZeroIndexed(groupingColumnName, false)) != null) {
            groupPrimaryKeys = new HashMap<Object, HashSet<MultiKey>>();
            for (GcTableSyncRowData gcTableSyncRowData : fullDataOfQuery.getRows()) {
                Object groupLabel = gcTableSyncRowData.getData()[groupingColumnZeroIndex];
                HashSet<MultiKey> currentPrimaryKeys = (HashSet<MultiKey>)groupPrimaryKeys.get(groupLabel);
                if (currentPrimaryKeys == null) {
                    currentPrimaryKeys = new HashSet<MultiKey>();
                    groupPrimaryKeys.put(groupLabel, currentPrimaryKeys);
                }
                currentPrimaryKeys.add(gcTableSyncRowData.getPrimaryKey());
            }
        }
        return GcTableSyncSubtype.handleLotsOfChangesAnotherWay(debugMap, gcTableSync, primaryKeysToRetrieve, groupPrimaryKeys);
    }

    private static int handleLotsOfChangesAnotherWay(Map<String, Object> debugMap, GcTableSync gcTableSync, Set<MultiKey> primaryKeysToRetrieve, Map<Object, Set<MultiKey>> groupPrimaryKeys) {
        if (GrouperClientUtils.length(primaryKeysToRetrieve) == 0) {
            return 0;
        }
        int switchFromIncrementalToFullIfOverRecords = gcTableSync.getGcTableSyncConfiguration().getSwitchFromIncrementalToFullIfOverRecords();
        GcTableSyncSubtype switchFromIncrementalToFullSubtype = gcTableSync.getGcTableSyncConfiguration().getSwitchFromIncrementalToFullSubtype();
        int switchFromIncrementalToGroupIfOverRecordsInGroup = gcTableSync.getGcTableSyncConfiguration().getSwitchFromIncrementalToGroupIfOverRecordsInGroup();
        int switchFromIncrementalToFullIfOverGroupCount = gcTableSync.getGcTableSyncConfiguration().getSwitchFromIncrementalToFullIfOverGroupCount();
        boolean needsFullSyncBasedOnRecords = switchFromIncrementalToFullIfOverRecords > 0 && switchFromIncrementalToFullSubtype != null && GrouperClientUtils.length(primaryKeysToRetrieve) > switchFromIncrementalToFullIfOverRecords;
        boolean needsFullSyncBasedOnGroups = false;
        if (needsFullSyncBasedOnRecords && switchFromIncrementalToFullIfOverGroupCount > 0 && GrouperClientUtils.length(groupPrimaryKeys) > switchFromIncrementalToFullIfOverGroupCount) {
            needsFullSyncBasedOnGroups = true;
        }
        if (needsFullSyncBasedOnGroups) {
            needsFullSyncBasedOnRecords = false;
            for (Object grouping : new HashSet<Object>(GrouperClientUtils.nonNull(groupPrimaryKeys).keySet())) {
                Set<MultiKey> primaryKeys = groupPrimaryKeys.get(grouping);
                if (primaryKeys.size() > switchFromIncrementalToGroupIfOverRecordsInGroup) continue;
                groupPrimaryKeys.remove(grouping);
            }
            if (GrouperClientUtils.length(groupPrimaryKeys) > 0) {
                HashSet<Object> switchedToGroups = new HashSet<Object>(groupPrimaryKeys.keySet());
                gcTableSync.getGcTableSyncOutput().setSwitchedToGroups(switchedToGroups);
                GcTableSyncSubtype.logIncrement(debugMap, "switchedToGroupsCount", switchedToGroups.size());
                if (switchedToGroups.size() < 10) {
                    int i = 0;
                    for (Object e : switchedToGroups) {
                        debugMap.put("switchedToGroup_" + i++, e);
                    }
                }
                int recordsChanged = GcTableSyncSubtype.syncGroupings(debugMap, gcTableSync, switchedToGroups);
                for (Set set : groupPrimaryKeys.values()) {
                    primaryKeysToRetrieve.removeAll(set);
                }
                return recordsChanged;
            }
        }
        if (needsFullSyncBasedOnGroups || needsFullSyncBasedOnRecords) {
            GcTableSyncSubtype.runEmbeddedFullSync(debugMap, gcTableSync.getGcGrouperSyncJob(), gcTableSync.getGcGrouperSyncLog(), switchFromIncrementalToFullSubtype);
            gcTableSync.getGcTableSyncOutput().setSwitchedToFull(true);
            primaryKeysToRetrieve.clear();
        }
        return 0;
    }

    public static void runEmbeddedFullSync(Map<String, Object> debugMap, GcGrouperSyncJob gcGrouperSyncJob, GcGrouperSyncLog gcGrouperSyncLog, GcTableSyncSubtype switchFromIncrementalToFullSubtype) {
        debugMap.put("switchedToFullSync", true);
        debugMap.put("switchedToFullSyncSubtype", switchFromIncrementalToFullSubtype.name());
        debugMap.put("paused", true);
        gcGrouperSyncJob.setJobState(GcGrouperSyncJobState.pending);
        gcGrouperSyncJob.getGrouperSync().getGcGrouperSyncJobDao().internal_jobStore(gcGrouperSyncJob);
        GrouperClientUtils.sleep(1000L);
        GcTableSync newFull = new GcTableSync();
        newFull.setGcGrouperSync(gcGrouperSyncJob.getGrouperSync());
        newFull.setGcGrouperSyncLog(gcGrouperSyncLog);
        newFull.sync(gcGrouperSyncJob.getGrouperSync().getProvisionerName(), switchFromIncrementalToFullSubtype);
        GrouperClientUtils.sleep(1000L);
        gcGrouperSyncJob.waitForRelatedJobsToFinishThenRun(false);
        debugMap.put("paused", false);
    }

    private static void retrieveIncrementalDataHelper(Map<String, Object> debugMap, GcTableSync gcTableSync, GcTableSyncTableBean gcTableSyncTableBeanSelectFrom, String columnsToSelect, GcTableSyncColumnMetadata incrementalColumn, Boolean isFrom) {
        Long lastRetrievedLong = gcTableSync.getGcGrouperSync().getIncrementalIndex();
        Timestamp lastRetrievedTimestamp = gcTableSync.getGcGrouperSync().getIncrementalTimestamp();
        Comparable<Long> lastRetrieved = null;
        GcTableSyncColumnMetadata.ColumnType columnTypeProgressColumn = incrementalColumn.getColumnType();
        switch (columnTypeProgressColumn) {
            case NUMERIC: {
                lastRetrieved = lastRetrievedLong;
                break;
            }
            case TIMESTAMP: {
                lastRetrieved = lastRetrievedTimestamp;
                break;
            }
            case STRING: {
                lastRetrieved = lastRetrievedLong == null ? null : "" + lastRetrievedLong;
                break;
            }
            default: {
                throw new RuntimeException("Not expecting type: " + (Object)((Object)columnTypeProgressColumn));
            }
        }
        debugMap.put("lastRetrieved", lastRetrieved);
        if (lastRetrieved != null) {
            String sqlGetIncrementals = "select " + columnsToSelect + " from " + gcTableSyncTableBeanSelectFrom.getTableMetadata().getTableName() + " where " + incrementalColumn.getColumnName() + " > ?";
            GcTableSyncTableData gcTableSyncTableData = GcTableSyncSubtype.runQuery(debugMap, gcTableSyncTableBeanSelectFrom, sqlGetIncrementals, columnsToSelect, "incrementalChanges", new Object[]{lastRetrieved}, isFrom);
            gcTableSyncTableBeanSelectFrom.setDataInitialQuery(gcTableSyncTableData);
        }
    }

    private static void captureCurrentMaxIncrementalIndexIfNeeded(Map<String, Object> debugMap, GcTableSync gcTableSync) {
        boolean hasAllColumnsColumn;
        boolean hasProgressColumn = !GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalProgressColumnString());
        boolean bl = hasAllColumnsColumn = !GrouperClientUtils.isBlank(gcTableSync.getGcTableSyncConfiguration().getIncrementalAllColumnsColumnString());
        if (!hasProgressColumn && !hasAllColumnsColumn) {
            return;
        }
        Long maxProgress = null;
        if (hasProgressColumn) {
            String maxSql = "select max( " + gcTableSync.getDataBeanRealTime().getTableMetadata().getIncrementalProgressColumn().getColumnName() + " )  from " + gcTableSync.getDataBeanRealTime().getTableMetadata().getTableName();
            GcDbAccess gcDbAccessMaxSql = new GcDbAccess().sql(maxSql).connectionName(gcTableSync.getDataBeanFrom().getTableMetadata().getConnectionNameOrReadonly());
            switch (gcTableSync.getDataBeanRealTime().getTableMetadata().getIncrementalProgressColumn().getColumnType()) {
                case NUMERIC: {
                    maxProgress = gcDbAccessMaxSql.select(Long.class);
                    break;
                }
                case STRING: {
                    String maxProgressString = gcDbAccessMaxSql.select(String.class);
                    maxProgress = GrouperClientUtils.longObjectValue(maxProgressString, true);
                    break;
                }
                case TIMESTAMP: {
                    Timestamp maxProgressTimestamp = gcDbAccessMaxSql.select(Timestamp.class);
                    maxProgress = maxProgressTimestamp == null ? null : Long.valueOf(maxProgressTimestamp.getTime());
                    break;
                }
                default: {
                    throw new RuntimeException("Not expecting type: " + (Object)((Object)gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn().getColumnType()));
                }
            }
        }
        Long maxProgressAllColumns = null;
        if (hasAllColumnsColumn) {
            String maxSql = "select max( " + gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn().getColumnName() + " )  from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName();
            GcDbAccess gcDbAccessMaxSql = new GcDbAccess().sql(maxSql).connectionName(gcTableSync.getDataBeanFrom().getTableMetadata().getConnectionNameOrReadonly());
            switch (gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn().getColumnType()) {
                case NUMERIC: {
                    maxProgressAllColumns = gcDbAccessMaxSql.select(Long.class);
                    break;
                }
                case STRING: {
                    String maxProgressAllColumnsString = gcDbAccessMaxSql.select(String.class);
                    maxProgressAllColumns = GrouperClientUtils.longObjectValue(maxProgressAllColumnsString, true);
                    break;
                }
                case TIMESTAMP: {
                    Timestamp maxProgressAllColumnsTimestamp = gcDbAccessMaxSql.select(Timestamp.class);
                    maxProgressAllColumns = maxProgressAllColumnsTimestamp == null ? null : Long.valueOf(maxProgressAllColumnsTimestamp.getTime());
                    break;
                }
                default: {
                    throw new RuntimeException("Not expecting type: " + (Object)((Object)gcTableSync.getDataBeanFrom().getTableMetadata().getIncrementalAllCoumnsColumn().getColumnType()));
                }
            }
        }
        if (maxProgress != null) {
            GcTableSyncSubtype.logIncrement(debugMap, "initialMaxProgress", maxProgress);
        }
        if (maxProgressAllColumns != null) {
            GcTableSyncSubtype.logIncrement(debugMap, "initialMaxProgressAllColumns", maxProgressAllColumns);
        }
        if (maxProgress == null && maxProgressAllColumns == null) {
            return;
        }
        if (maxProgress == null) {
            gcTableSync.setLatestIncrementalValueBeforeStarted(maxProgressAllColumns);
        } else if (maxProgressAllColumns == null) {
            gcTableSync.setLatestIncrementalValueBeforeStarted(maxProgress);
        } else {
            gcTableSync.setLatestIncrementalValueBeforeStarted(Math.max(maxProgress, maxProgressAllColumns));
        }
    }

    private static GcTableSyncTableData runQuery(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBean, String sql, String columns, String queryLogLabel, Object[] bindVars, Boolean isFrom) {
        long start = System.nanoTime();
        GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBean.getTableMetadata();
        String connectionName = gcTableSyncTableMetadata.getConnectionNameOrReadonly();
        try {
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(connectionName);
            if (bindVars != null) {
                gcDbAccess.bindVars(bindVars);
            }
            List<Object[]> results = gcDbAccess.sql(sql).selectList(Object[].class);
            GcTableSyncTableData gcTableSyncTableData = new GcTableSyncTableData();
            gcTableSyncTableData.init(gcTableSyncTableBean, gcTableSyncTableMetadata.lookupColumns(columns), results);
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", GrouperClientUtils.length(results));
            if (isFrom != null) {
                if (isFrom.booleanValue()) {
                    gcTableSyncTableBean.getGcTableSync().getGcTableSyncOutput().addRowsSelectedFrom(GrouperClientUtils.length(results));
                } else {
                    gcTableSyncTableBean.getGcTableSync().getGcTableSyncOutput().addRowsSelectedTo(GrouperClientUtils.length(results));
                }
            }
            GcTableSyncTableData gcTableSyncTableData2 = gcTableSyncTableData;
            return gcTableSyncTableData2;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "Error in '" + queryLogLabel + "' connectionName: " + connectionName + ", query '" + sql + "', " + GrouperClientUtils.toStringForLog(bindVars));
            throw re;
        }
        finally {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Millis", (System.nanoTime() - start) / 1000L);
        }
    }

    private static void logIncrement(Map<String, Object> debugMap, String label, long amountToAdd) {
        Number currentValue = (Number)debugMap.get(label);
        if (currentValue != null) {
            amountToAdd += currentValue.longValue();
        }
        debugMap.put(label, amountToAdd);
    }

    private static void assignIncrementalIndex(GcTableSyncTableData gcTableSyncTableData, GcTableSyncColumnMetadata progressColumnMetadata) {
        GcTableSync gcTableSync = gcTableSyncTableData.getGcTableSyncTableBean().getGcTableSync();
        Object maxProgress = progressColumnMetadata == null ? null : gcTableSyncTableData.maxProgressValue(progressColumnMetadata);
        Long lastIncrementalValueBeforeStarted = gcTableSync.getLatestIncrementalValueBeforeStarted();
        if (maxProgress != null || lastIncrementalValueBeforeStarted != null) {
            if (maxProgress == null) {
                maxProgress = lastIncrementalValueBeforeStarted;
            } else if (lastIncrementalValueBeforeStarted != null) {
                Long maxProgressLong = null;
                if (maxProgress instanceof Number) {
                    maxProgressLong = ((Number)maxProgress).longValue();
                } else if (maxProgress instanceof Timestamp) {
                    maxProgressLong = ((Timestamp)maxProgress).getTime();
                } else if (maxProgress instanceof String) {
                    maxProgressLong = GrouperClientUtils.longValue((String)maxProgress);
                } else {
                    throw new RuntimeException("Not expecting type: " + maxProgress.getClass());
                }
                maxProgress = Math.max(maxProgressLong, lastIncrementalValueBeforeStarted);
            }
        }
        long millisWhenJobStarted = gcTableSync.getMillisWhenSyncStarted();
        if (maxProgress != null) {
            boolean madeProgress = false;
            if (maxProgress instanceof Date) {
                long maxProgressMillis = ((Date)maxProgress).getTime();
                if (gcTableSync.getGcGrouperSync().getIncrementalTimestamp() == null || gcTableSync.getGcGrouperSync().getIncrementalTimestamp().getTime() < maxProgressMillis) {
                    madeProgress = true;
                    gcTableSync.getGcGrouperSyncJob().setLastSyncIndex(maxProgressMillis);
                    gcTableSync.getGcGrouperSyncJob().setLastSyncTimestamp(new Timestamp(maxProgressMillis));
                    gcTableSync.getGcGrouperSync().setIncrementalIndex(maxProgressMillis);
                    gcTableSync.getGcGrouperSync().setIncrementalTimestamp(new Timestamp(maxProgressMillis));
                }
            } else if (maxProgress instanceof Number) {
                long maxProgressLong = ((Number)maxProgress).longValue();
                gcTableSync.getGcGrouperSyncJob().setLastSyncTimestamp(new Timestamp(millisWhenJobStarted));
                gcTableSync.getGcGrouperSync().setIncrementalTimestamp(new Timestamp(millisWhenJobStarted));
                madeProgress = true;
                if (gcTableSync.getGcGrouperSyncJob().getLastSyncIndex() == null || gcTableSync.getGcGrouperSyncJob().getLastSyncIndex() < maxProgressLong) {
                    gcTableSync.getGcGrouperSyncJob().setLastSyncIndex(maxProgressLong);
                    gcTableSync.getGcGrouperSync().setIncrementalIndex(maxProgressLong);
                }
            } else if (maxProgress instanceof String) {
                long maxProgressLong = GrouperClientUtils.longObjectValue((String)maxProgress, false);
                gcTableSync.getGcGrouperSyncJob().setLastSyncTimestamp(new Timestamp(millisWhenJobStarted));
                gcTableSync.getGcGrouperSync().setIncrementalTimestamp(new Timestamp(millisWhenJobStarted));
                madeProgress = true;
                if (gcTableSync.getGcGrouperSyncJob().getLastSyncIndex() == null || gcTableSync.getGcGrouperSyncJob().getLastSyncIndex() < maxProgressLong) {
                    gcTableSync.getGcGrouperSync().setIncrementalIndex(maxProgressLong);
                }
            }
        }
    }

    private static int runInserts(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBeanTo, Set<MultiKey> primaryKeysToInsertInput, Map<MultiKey, GcTableSyncRowData> allIndexByPrimaryKey, String queryLogLabel) {
        long start = System.nanoTime();
        String sql = null;
        try {
            int totalInserts = 0;
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", 0L);
            if (GrouperClientUtils.length(primaryKeysToInsertInput) > 0) {
                int batchSize = 10000;
                ArrayList<MultiKey> primaryKeysToInsertList = new ArrayList<MultiKey>(primaryKeysToInsertInput);
                int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(primaryKeysToInsertList, batchSize);
                for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
                    List<MultiKey> primaryKeysToInsertBatch = GrouperClientUtils.batchList(primaryKeysToInsertList, batchSize, batchIndex);
                    GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBeanTo.getTableMetadata();
                    sql = "insert into " + gcTableSyncTableMetadata.getTableName() + " ( " + gcTableSyncTableMetadata.columnListAll() + " ) values ( " + GrouperClientUtils.appendQuestions(GrouperClientUtils.length(gcTableSyncTableMetadata.getColumns())) + " )";
                    GcDbAccess gcDbAccess = new GcDbAccess().connectionName(gcTableSyncTableMetadata.getConnectionName());
                    List<List<Object>> bindVars = GcTableSyncSubtype.convertToListOfBindVarsValues(primaryKeysToInsertBatch, allIndexByPrimaryKey);
                    gcDbAccess.batchBindVars(bindVars);
                    gcDbAccess.batchSize(gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncConfiguration().getBatchSize());
                    int[] batchResults = gcDbAccess.sql(sql).executeBatchSql();
                    int inserts = GrouperClientUtils.length(primaryKeysToInsertInput);
                    int actualInserts = 0;
                    int missedInserts = 0;
                    int multiInsertInstances = 0;
                    if (GrouperClientUtils.length(batchResults) > 0) {
                        for (int result : batchResults) {
                            actualInserts += Math.max(result, 0);
                            if (result == 0) {
                                ++missedInserts;
                            }
                            if (result <= 1) continue;
                            ++multiInsertInstances;
                        }
                    }
                    totalInserts += actualInserts;
                    GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", actualInserts);
                    if (inserts != actualInserts) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "IntendedCount", inserts);
                    }
                    if (missedInserts > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "MissedInserts", missedInserts);
                    }
                    if (multiInsertInstances > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "PrimaryKeyProblems", multiInsertInstances);
                    }
                    gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncOutput().addInsert(actualInserts);
                }
            }
            int n = totalInserts;
            return n;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "Error in '" + queryLogLabel + "' query: '" + sql + "'");
            throw re;
        }
        finally {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Millis", (int)((System.nanoTime() - start) / 1000L));
        }
    }

    private static int runDeletes(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBeanTo, Set<MultiKey> primaryKeysToDeleteInput, String queryLogLabel) {
        long start = System.nanoTime();
        String sql = null;
        try {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", 0L);
            int totalDeletes = 0;
            if (GrouperClientUtils.length(primaryKeysToDeleteInput) > 0) {
                int batchSize = 10000;
                ArrayList<MultiKey> primaryKeysToDeleteList = new ArrayList<MultiKey>(primaryKeysToDeleteInput);
                int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(primaryKeysToDeleteList, batchSize);
                for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
                    List<MultiKey> primaryKeysToDeleteBatch = GrouperClientUtils.batchList(primaryKeysToDeleteList, batchSize, batchIndex);
                    GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBeanTo.getTableMetadata();
                    sql = "delete from " + gcTableSyncTableMetadata.getTableName() + " where " + gcTableSyncTableMetadata.queryWherePrimaryKey();
                    GcDbAccess gcDbAccess = new GcDbAccess().connectionName(gcTableSyncTableMetadata.getConnectionName());
                    List<List<Object>> bindVars = GcTableSyncSubtype.convertToListOfBindVars(primaryKeysToDeleteBatch);
                    gcDbAccess.batchBindVars(bindVars);
                    gcDbAccess.batchSize(gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncConfiguration().getBatchSize());
                    int[] batchResults = gcDbAccess.sql(sql).executeBatchSql();
                    int deletes = GrouperClientUtils.length(batchResults);
                    int actualDeletes = 0;
                    int missedDeletes = 0;
                    int multiDeleteInstances = 0;
                    if (GrouperClientUtils.length(batchResults) > 0) {
                        for (int result : batchResults) {
                            actualDeletes += Math.max(result, 0);
                            if (result == 0) {
                                ++missedDeletes;
                            }
                            if (result <= 1) continue;
                            ++multiDeleteInstances;
                        }
                    }
                    totalDeletes += actualDeletes;
                    GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", actualDeletes);
                    if (deletes != actualDeletes) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "IntendedCount", deletes);
                    }
                    if (missedDeletes > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "MissedDeletes", missedDeletes);
                    }
                    if (multiDeleteInstances > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "PrimaryKeyProblems", multiDeleteInstances);
                    }
                    gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncOutput().addDelete(actualDeletes);
                }
            }
            int n = totalDeletes;
            return n;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "Error in '" + queryLogLabel + "' query: '" + sql + "'");
            throw re;
        }
        finally {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Millis", (int)((System.nanoTime() - start) / 1000L));
        }
    }

    private static List<List<Object>> convertToListOfBindVarsValues(Collection<MultiKey> setOfMultiKeys, Map<MultiKey, GcTableSyncRowData> allIndexByPrimaryKey) {
        ArrayList<List<Object>> bindVars = new ArrayList<List<Object>>();
        for (MultiKey multiKey : setOfMultiKeys) {
            ArrayList<Object> bindVarRow = new ArrayList<Object>();
            GcTableSyncRowData gcTableSyncRowData = allIndexByPrimaryKey.get(multiKey);
            for (Object bindVar : gcTableSyncRowData.getData()) {
                bindVarRow.add(bindVar);
            }
            bindVars.add(bindVarRow);
        }
        return bindVars;
    }

    private static List<List<Object>> convertToListOfBindVars(Collection<MultiKey> setOfMultiKeys) {
        ArrayList<List<Object>> bindVars = new ArrayList<List<Object>>();
        for (MultiKey multiKey : setOfMultiKeys) {
            ArrayList<Object> bindVarRow = new ArrayList<Object>();
            for (Object bindVar : multiKey.getKeys()) {
                bindVarRow.add(bindVar);
            }
            bindVars.add(bindVarRow);
        }
        return bindVars;
    }

    private static List<List<Object>> convertToListOfBindVarsObjects(Set<Object> setOfObjects) {
        ArrayList<List<Object>> bindVars = new ArrayList<List<Object>>();
        for (Object object : setOfObjects) {
            ArrayList<Object> bindVarRow = new ArrayList<Object>();
            bindVarRow.add(object);
            bindVars.add(bindVarRow);
        }
        return bindVars;
    }

    private static GcTableSyncTableData[] runQueryFromAndToForAllDataFromPrimaryKeys(final Map<String, Object> debugMap, final GcTableSync gcTableSync, final Set<MultiKey> primaryKeys) {
        if (GrouperClientUtils.length(primaryKeys) == 0) {
            return new GcTableSyncTableData[]{new GcTableSyncTableData(), new GcTableSyncTableData()};
        }
        final RuntimeException[] RUNTIME_EXCEPTION = new RuntimeException[1];
        final GcTableSyncTableData[] result = new GcTableSyncTableData[2];
        Thread selectFromThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = GcTableSyncSubtype.runQueryForAllDataFromPrimaryKeys(debugMap, gcTableSync.getDataBeanFrom(), primaryKeys, true);
                }
                catch (RuntimeException re) {
                    if (RUNTIME_EXCEPTION[0] != null) {
                        LOG.error("Error retrieve by primary key", re);
                    }
                    RUNTIME_EXCEPTION[0] = re;
                }
            }
        });
        selectFromThread.start();
        result[1] = GcTableSyncSubtype.runQueryForAllDataFromPrimaryKeys(debugMap, gcTableSync.getDataBeanTo(), primaryKeys, false);
        GrouperClientUtils.join(selectFromThread);
        if (RUNTIME_EXCEPTION[0] != null) {
            throw RUNTIME_EXCEPTION[0];
        }
        return result;
    }

    private static GcTableSyncTableData[] runQueryFromAndTo(final Map<String, Object> debugMap, final GcTableSync gcTableSync, final String sqlFrom, final String columnsFrom, String sqlTo, String columnsTo, final String queryLogLabel, final Object[] bindVars) {
        final RuntimeException[] RUNTIME_EXCEPTION = new RuntimeException[1];
        final GcTableSyncTableData[] result = new GcTableSyncTableData[2];
        Thread selectFromThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = GcTableSyncSubtype.runQuery(debugMap, gcTableSync.getDataBeanFrom(), sqlFrom, columnsFrom, queryLogLabel + "From", bindVars, true);
                }
                catch (RuntimeException re) {
                    if (RUNTIME_EXCEPTION[0] != null) {
                        LOG.error("error", RUNTIME_EXCEPTION[0]);
                    }
                    RUNTIME_EXCEPTION[0] = re;
                }
            }
        });
        selectFromThread.start();
        try {
            result[1] = GcTableSyncSubtype.runQuery(debugMap, gcTableSync.getDataBeanTo(), sqlTo, columnsTo, queryLogLabel + "To", bindVars, false);
        }
        catch (RuntimeException re) {
            if (RUNTIME_EXCEPTION[0] != null) {
                LOG.error("error", RUNTIME_EXCEPTION[0]);
            }
            RUNTIME_EXCEPTION[0] = re;
        }
        GrouperClientUtils.join(selectFromThread);
        if (RUNTIME_EXCEPTION[0] != null) {
            throw new RuntimeException("error", RUNTIME_EXCEPTION[0]);
        }
        return result;
    }

    public abstract boolean isFullSync();

    public abstract boolean isFullMetadataSync();

    public abstract boolean isIncrementalSync();

    public boolean isNeedsGroupColumn() {
        return false;
    }

    public static GcTableSyncSubtype valueOfIgnoreCase(String string, boolean exceptionOnNull) {
        return GrouperClientUtils.enumValueOfIgnoreCase(GcTableSyncSubtype.class, string, exceptionOnNull);
    }

    public abstract void retrieveData(Map<String, Object> var1, GcTableSync var2);

    public abstract Integer syncData(Map<String, Object> var1, GcTableSync var2);

    private static int runInsertsUpdatesDeletesGroupings(Map<String, Object> debugMap, GcTableSync gcTableSync, Set<Object> groupingsFrom, Set<Object> groupingsTo) {
        int deletes = -1;
        HashSet<Object> groupingsToDelete = new HashSet<Object>(groupingsTo);
        groupingsToDelete.removeAll(groupingsFrom);
        deletes = GcTableSyncSubtype.runDeletesOfGroupings(debugMap, gcTableSync.getDataBeanTo(), groupingsToDelete, "deleteGroupings");
        if (GrouperClientUtils.length(groupingsFrom) == 0) {
            return deletes;
        }
        ArrayList<Object> groupings = new ArrayList<Object>(groupingsFrom);
        Collections.sort(groupings, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
        });
        int batchSize = gcTableSync.getGcTableSyncConfiguration().getGroupingSize();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(groupings, batchSize);
        int recordsUpdated = 0;
        for (int currentBatchIndex = 0; currentBatchIndex < numberOfBatches; ++currentBatchIndex) {
            List<Object> groupingsBatch = GrouperClientUtils.batchList(groupings, batchSize, currentBatchIndex);
            int[] results = null;
            if (GrouperClientUtils.length(groupingsBatch) > 0) {
                String sqlFrom = "select " + gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName() + " where " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " >= ?  and " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " <= ? ";
                String sqlTo = "select " + gcTableSync.getDataBeanTo().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanTo().getTableMetadata().getTableName() + " where " + gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName() + " >= ?  and " + gcTableSync.getDataBeanTo().getTableMetadata().getGroupColumnMetadata().getColumnName() + " <= ? ";
                GcTableSyncTableData[] gcTableSyncTableDatas = GcTableSyncSubtype.runQueryFromAndTo(debugMap, gcTableSync, sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll(), sqlTo, gcTableSync.getDataBeanTo().getTableMetadata().columnListAll(), "retrieveData", new Object[]{groupingsBatch.get(0), groupingsBatch.get(groupingsBatch.size() - 1)});
                results = GcTableSyncSubtype.runInsertsUpdatesDeletes(debugMap, gcTableSync, gcTableSyncTableDatas[0], gcTableSyncTableDatas[1]);
            } else {
                results = new int[]{0, 0, 0};
            }
            recordsUpdated += results[0] + results[1] + results[2];
        }
        return recordsUpdated;
    }

    private static int runDeletesOfGroupings(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBeanTo, Set<Object> groupingsToDelete, String queryLogLabel) {
        long start = System.nanoTime();
        String sql = null;
        try {
            int[] results = null;
            if (GrouperClientUtils.length(groupingsToDelete) > 0) {
                GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBeanTo.getTableMetadata();
                sql = "delete from " + gcTableSyncTableMetadata.getTableName() + " where " + gcTableSyncTableMetadata.getGroupColumnMetadata().getColumnName() + " = ?";
                GcDbAccess gcDbAccess = new GcDbAccess().connectionName(gcTableSyncTableMetadata.getConnectionName());
                List<List<Object>> bindVars = GcTableSyncSubtype.convertToListOfBindVarsObjects(groupingsToDelete);
                gcDbAccess.batchBindVars(bindVars);
                gcDbAccess.batchSize(gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncConfiguration().getBatchSize());
                results = gcDbAccess.sql(sql).executeBatchSql();
            }
            int deletes = GrouperClientUtils.length(groupingsToDelete);
            int actualDeletes = 0;
            int missedDeletes = 0;
            int multiDeleteInstances = 0;
            if (GrouperClientUtils.length(groupingsToDelete) > 0) {
                for (void var15_19 : results) {
                    actualDeletes += Math.max((int)var15_19, 0);
                    if (var15_19 == false) {
                        ++missedDeletes;
                    }
                    if (var15_19 <= true) continue;
                    ++multiDeleteInstances;
                }
            }
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", actualDeletes);
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "GroupsCount", deletes);
            if (missedDeletes > 0) {
                GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "MissedDeletes", missedDeletes);
            }
            if (multiDeleteInstances > 0) {
                GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "PrimaryKeyProblems", multiDeleteInstances);
            }
            gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncOutput().addDelete(actualDeletes);
            int n = actualDeletes;
            return n;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "Error in '" + queryLogLabel + "' query: '" + sql + "'");
            throw re;
        }
        finally {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Millis", (int)((System.nanoTime() - start) / 1000L));
        }
    }

    private static int runInsertsUpdatesDeletesChangeFlag(Map<String, Object> debugMap, GcTableSync gcTableSync, GcTableSyncTableData gcTableSyncTableDataFrom, GcTableSyncTableData gcTableSyncTableDataTo) {
        int deletes = -1;
        LinkedHashSet<MultiKey> primaryKeysToDelete = new LinkedHashSet<MultiKey>(gcTableSyncTableDataTo.allPrimaryKeys());
        primaryKeysToDelete.removeAll(gcTableSyncTableDataFrom.allPrimaryKeys());
        deletes = GcTableSyncSubtype.runDeletes(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToDelete, "deletes");
        int inserts = -1;
        LinkedHashSet<MultiKey> primaryKeysToInsert = new LinkedHashSet<MultiKey>(gcTableSyncTableDataFrom.allPrimaryKeys());
        primaryKeysToInsert.removeAll(gcTableSyncTableDataTo.allPrimaryKeys());
        GcTableSyncTableData gcTableSyncTableDataInserts = GcTableSyncSubtype.runQueryForAllDataFromPrimaryKeys(debugMap, gcTableSyncTableDataFrom.getGcTableSyncTableBean(), primaryKeysToInsert, true);
        Map<MultiKey, GcTableSyncRowData> indexByPrimaryKeyInserts = gcTableSyncTableDataInserts.allIndexByPrimaryKey();
        inserts = GcTableSyncSubtype.runInserts(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToInsert, indexByPrimaryKeyInserts, "inserts");
        int updates = -1;
        LinkedHashSet<MultiKey> primaryKeysToUpdate = new LinkedHashSet<MultiKey>();
        for (MultiKey multiKey : gcTableSyncTableDataFrom.allPrimaryKeys()) {
            GcTableSyncRowData gcTableSyncRowData = gcTableSyncTableDataTo.allIndexByPrimaryKey().get(multiKey);
            if (gcTableSyncRowData == null) continue;
            MultiKey multiKeyDataTo = new MultiKey(gcTableSyncRowData.getData());
            MultiKey multiKeyDataFrom = new MultiKey(gcTableSyncTableDataFrom.allIndexByPrimaryKey().get(multiKey).getData());
            if (multiKeyDataFrom.equals(multiKeyDataTo)) continue;
            primaryKeysToUpdate.add(multiKey);
        }
        GcTableSyncTableData gcTableSyncTableDataUpdates = GcTableSyncSubtype.runQueryForAllDataFromPrimaryKeys(debugMap, gcTableSyncTableDataFrom.getGcTableSyncTableBean(), primaryKeysToUpdate, true);
        Map<MultiKey, GcTableSyncRowData> indexByPrimaryKeyUpdates = gcTableSyncTableDataUpdates.allIndexByPrimaryKey();
        updates = GcTableSyncSubtype.runUpdates(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToUpdate, indexByPrimaryKeyUpdates, "updates");
        return inserts + updates + deletes;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] runInsertsUpdatesDeletes(Map<String, Object> debugMap, GcTableSync gcTableSync, GcTableSyncTableData gcTableSyncTableDataFrom, GcTableSyncTableData gcTableSyncTableDataTo) {
        int[] results = new int[3];
        int deletes = -1;
        LinkedHashSet<MultiKey> primaryKeysToDelete = new LinkedHashSet<MultiKey>(gcTableSyncTableDataTo.allPrimaryKeys());
        primaryKeysToDelete.removeAll(gcTableSyncTableDataFrom.allPrimaryKeys());
        if (GrouperClientUtils.length(primaryKeysToDelete) > 0) {
            int count = 0;
            for (MultiKey multiKey : primaryKeysToDelete) {
                debugMap.put("delete_" + count, GrouperClientUtils.toStringForLog(multiKey));
                if (count++ < 2) continue;
                break;
            }
        }
        results[2] = deletes = GcTableSyncSubtype.runDeletes(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToDelete, "deletes");
        int inserts = -1;
        LinkedHashSet<MultiKey> primaryKeysToInsert = new LinkedHashSet<MultiKey>(gcTableSyncTableDataFrom.allPrimaryKeys());
        primaryKeysToInsert.removeAll(gcTableSyncTableDataTo.allPrimaryKeys());
        if (GrouperClientUtils.length(primaryKeysToInsert) > 0) {
            int count = 0;
            for (MultiKey key : primaryKeysToInsert) {
                debugMap.put("insert_" + count, GrouperClientUtils.toStringForLog(key));
                if (count++ < 2) continue;
                break;
            }
        }
        results[0] = inserts = GcTableSyncSubtype.runInserts(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToInsert, gcTableSyncTableDataFrom.allIndexByPrimaryKey(), "inserts");
        int updates = -1;
        LinkedHashSet<MultiKey> primaryKeysToUpdate = new LinkedHashSet<MultiKey>();
        for (MultiKey multiKey : gcTableSyncTableDataFrom.allPrimaryKeys()) {
            GcTableSyncRowData gcTableSyncRowData = gcTableSyncTableDataTo.allIndexByPrimaryKey().get(multiKey);
            if (gcTableSyncRowData == null) continue;
            MultiKey multiKeyDataTo = new MultiKey(gcTableSyncRowData.getData());
            MultiKey multiKeyDataFrom = new MultiKey(gcTableSyncTableDataFrom.allIndexByPrimaryKey().get(multiKey).getData());
            if (multiKeyDataFrom.equals(multiKeyDataTo)) continue;
            primaryKeysToUpdate.add(multiKey);
        }
        if (GrouperClientUtils.length(primaryKeysToUpdate) > 0) {
            boolean bl = false;
            for (MultiKey key : primaryKeysToUpdate) {
                void var9_18;
                debugMap.put("update_" + (int)var9_18, GrouperClientUtils.toStringForLog(key));
                if (++var9_18 < 2) continue;
                break;
            }
        }
        results[1] = updates = GcTableSyncSubtype.runUpdates(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToUpdate, gcTableSyncTableDataFrom.allIndexByPrimaryKey(), "updates");
        return results;
    }

    private static List<List<Object>> convertToListOfBindVarsUpdate(Collection<MultiKey> setOfMultiKeys, Map<MultiKey, GcTableSyncRowData> allIndexByPrimaryKey) {
        ArrayList<List<Object>> bindVars = new ArrayList<List<Object>>();
        for (MultiKey multiKey : setOfMultiKeys) {
            ArrayList<Object> bindVarRow = new ArrayList<Object>();
            GcTableSyncRowData gcTableSyncRowData = allIndexByPrimaryKey.get(multiKey);
            for (Object bindVar : gcTableSyncRowData.getNonPrimaryKey().getKeys()) {
                bindVarRow.add(bindVar);
            }
            for (Object bindVar : gcTableSyncRowData.getPrimaryKey().getKeys()) {
                bindVarRow.add(bindVar);
            }
            bindVars.add(bindVarRow);
        }
        return bindVars;
    }

    private static int runUpdates(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBeanTo, Set<MultiKey> primaryKeysToUpdateInput, Map<MultiKey, GcTableSyncRowData> allIndexByPrimaryKey, String queryLogLabel) {
        long start = System.nanoTime();
        String sql = null;
        try {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", 0L);
            int totalUpdates = 0;
            if (GrouperClientUtils.length(primaryKeysToUpdateInput) > 0) {
                int batchSize = 10000;
                ArrayList<MultiKey> primaryKeysToUpdateList = new ArrayList<MultiKey>(primaryKeysToUpdateInput);
                int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(primaryKeysToUpdateList, batchSize);
                for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
                    List<MultiKey> primaryKeysToUpdateBatch = GrouperClientUtils.batchList(primaryKeysToUpdateList, batchSize, batchIndex);
                    GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBeanTo.getTableMetadata();
                    sql = "update " + gcTableSyncTableMetadata.getTableName() + " set  " + gcTableSyncTableMetadata.queryUpdateNonPrimaryKey() + " where " + gcTableSyncTableMetadata.queryWherePrimaryKey();
                    GcDbAccess gcDbAccess = new GcDbAccess().connectionName(gcTableSyncTableMetadata.getConnectionName());
                    List<List<Object>> bindVars = GcTableSyncSubtype.convertToListOfBindVarsUpdate(primaryKeysToUpdateBatch, allIndexByPrimaryKey);
                    gcDbAccess.batchBindVars(bindVars);
                    gcDbAccess.batchSize(gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncConfiguration().getBatchSize());
                    int[] batchResults = gcDbAccess.sql(sql).executeBatchSql();
                    int updates = GrouperClientUtils.length(primaryKeysToUpdateBatch);
                    int actualUpdates = 0;
                    int missedUpdates = 0;
                    int multiUpdateInstances = 0;
                    if (GrouperClientUtils.length(batchResults) > 0) {
                        for (int result : batchResults) {
                            actualUpdates += Math.max(result, 0);
                            if (result == 0) {
                                ++missedUpdates;
                            }
                            if (result <= 1) continue;
                            ++multiUpdateInstances;
                        }
                    }
                    totalUpdates += actualUpdates;
                    GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Count", actualUpdates);
                    if (updates != actualUpdates) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "IntendedCount", updates);
                    }
                    if (missedUpdates > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "MissedUpdates", missedUpdates);
                    }
                    if (multiUpdateInstances > 0) {
                        GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "PrimaryKeyProblems", multiUpdateInstances);
                    }
                    gcTableSyncTableBeanTo.getGcTableSync().getGcTableSyncOutput().addUpdate(actualUpdates);
                }
            }
            int n = totalUpdates;
            return n;
        }
        catch (RuntimeException re) {
            GrouperClientUtils.injectInException(re, "Error in '" + queryLogLabel + "' query: '" + sql + "'");
            throw re;
        }
        finally {
            GcTableSyncSubtype.logIncrement(debugMap, queryLogLabel + "Millis", (System.nanoTime() - start) / 1000L);
        }
    }

    private static int runInsertsUpdatesDeletesGroupingsMetadata(Map<String, Object> debugMap, GcTableSync gcTableSync, Set<Object> groupingsFrom, Set<Object> groupingsTo) {
        int deletes = 0;
        HashSet<Object> groupingsToDelete = new HashSet<Object>(groupingsTo);
        groupingsToDelete.removeAll(groupingsFrom);
        deletes = GcTableSyncSubtype.runDeletesOfGroupings(debugMap, gcTableSync.getDataBeanTo(), groupingsToDelete, "deleteGroupings");
        if (GrouperClientUtils.length(groupingsFrom) == 0) {
            return deletes;
        }
        HashSet<Object> groupingsToInsert = new HashSet<Object>(groupingsFrom);
        groupingsToInsert.removeAll(groupingsTo);
        if (GrouperClientUtils.length(groupingsToInsert) == 0) {
            return deletes;
        }
        ArrayList<Object> groupings = new ArrayList<Object>(groupingsToInsert);
        Collections.sort(groupings, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
        });
        int batchSize = gcTableSync.getGcTableSyncConfiguration().getGroupingSize();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(groupings, batchSize);
        int recordsUpdated = deletes;
        int inserts = 0;
        for (int currentBatchIndex = 0; currentBatchIndex < numberOfBatches; ++currentBatchIndex) {
            List<Object> groupingsBatch = GrouperClientUtils.batchList(groupings, batchSize, currentBatchIndex);
            if (GrouperClientUtils.length(groupingsBatch) <= 0) continue;
            String sqlFrom = "select " + gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll() + " from " + gcTableSync.getDataBeanFrom().getTableMetadata().getTableName() + " where " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " >= ?  and " + gcTableSync.getDataBeanFrom().getTableMetadata().getGroupColumnMetadata().getColumnName() + " <= ? ";
            GcTableSyncTableData gcTableSyncTableDataFrom = GcTableSyncSubtype.runQuery(debugMap, gcTableSync.getDataBeanFrom(), sqlFrom, gcTableSync.getDataBeanFrom().getTableMetadata().columnListAll(), "retrieveData", new Object[]{groupingsBatch.get(0), groupingsBatch.get(groupingsBatch.size() - 1)}, true);
            LinkedHashSet<MultiKey> primaryKeysToInsert = new LinkedHashSet<MultiKey>(gcTableSyncTableDataFrom.allPrimaryKeys());
            inserts += GcTableSyncSubtype.runInserts(debugMap, gcTableSync.getDataBeanTo(), primaryKeysToInsert, gcTableSyncTableDataFrom.allIndexByPrimaryKey(), "inserts");
        }
        return recordsUpdated += inserts;
    }

    private static GcTableSyncTableData runQueryForAllDataFromPrimaryKeys(Map<String, Object> debugMap, GcTableSyncTableBean gcTableSyncTableBean, Set<MultiKey> primaryKeys, boolean isFrom) {
        LinkedHashMap<MultiKey, GcTableSyncRowData> results = new LinkedHashMap<MultiKey, GcTableSyncRowData>();
        int numberOfRecordsToSelect = GrouperClientUtils.length(primaryKeys);
        if (numberOfRecordsToSelect > 0) {
            int numberOfPrimaryKeyColumns = GrouperClientUtils.length(primaryKeys.iterator().next().getKeys());
            int maxBindVarsInSelect = gcTableSyncTableBean.getGcTableSync().getGcTableSyncConfiguration().getMaxBindVarsInSelect();
            int batchSize = maxBindVarsInSelect / numberOfPrimaryKeyColumns;
            batchSize = batchSize < 1 ? 1 : batchSize;
            int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(primaryKeys, batchSize);
            ArrayList<MultiKey> primaryKeysList = new ArrayList<MultiKey>(primaryKeys);
            String queryWherePrimaryKey = gcTableSyncTableBean.getTableMetadata().queryWherePrimaryKey();
            for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
                List<MultiKey> primaryKeyBatch = GrouperClientUtils.batchList(primaryKeysList, batchSize, batchIndex);
                Object[] bindVars = new Object[GrouperClientUtils.length(primaryKeyBatch) * numberOfPrimaryKeyColumns];
                int bindVarIndex = 0;
                StringBuilder sql = new StringBuilder("select " + gcTableSyncTableBean.getTableMetadata().columnListAll() + " from " + gcTableSyncTableBean.getTableMetadata().getTableName() + " where ");
                for (int primaryKeyIndex = 0; primaryKeyIndex < GrouperClientUtils.length(primaryKeyBatch); ++primaryKeyIndex) {
                    if (primaryKeyIndex > 0) {
                        sql.append(" or ");
                    }
                    sql.append(" ( ");
                    sql.append(queryWherePrimaryKey);
                    sql.append(" ) ");
                    MultiKey primaryKey = primaryKeyBatch.get(primaryKeyIndex);
                    for (Object primaryKeyValue : primaryKey.getKeys()) {
                        bindVars[bindVarIndex++] = primaryKeyValue;
                    }
                }
                GcTableSyncTableData gcTableSyncTableData = GcTableSyncSubtype.runQuery(debugMap, gcTableSyncTableBean, sql.toString(), gcTableSyncTableBean.getTableMetadata().columnListAll(), "selectAllColumns", bindVars, isFrom);
                for (GcTableSyncRowData gcTableSyncRowData : gcTableSyncTableData.getRows()) {
                    results.put(gcTableSyncRowData.getPrimaryKey(), gcTableSyncRowData);
                }
            }
        }
        GcTableSyncTableData gcTableSyncTableData = new GcTableSyncTableData();
        gcTableSyncTableData.init(gcTableSyncTableBean, gcTableSyncTableBean.getTableMetadata().getColumnMetadata(), results);
        return gcTableSyncTableData;
    }

    static {
        LOG = GrouperClientUtils.retrieveLog(GcTableSyncSubtype.class);
    }
}

