/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncConfiguration;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncOutput;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncSubtype;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableBean;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableData;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableMetadata;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GcTableSyncFromData {
    private Map<String, Object> debugMap;
    private String debugMapPrefix;
    private String connectionName;
    private String tableName;
    private List<String> columnNames;
    private List<String> columnNamesPrimaryKey;
    private List<Object[]> data;
    private GcTableSync gcTableSync = new GcTableSync();

    public GcTableSyncFromData assignDebugMap(Map<String, Object> theDebugMap1) {
        this.debugMap = theDebugMap1;
        return this;
    }

    public GcTableSyncFromData assignDebugMapPrefix(String theDebugMapPrefix) {
        this.debugMapPrefix = theDebugMapPrefix;
        return this;
    }

    public GcTableSyncFromData assignConnectionName(String theConnectionName) {
        this.connectionName = theConnectionName;
        return this;
    }

    public GcTableSyncFromData assignTableName(String theTableName) {
        this.tableName = theTableName;
        return this;
    }

    public GcTableSyncFromData assignColumnNames(List<String> theColumnNames) {
        this.columnNames = theColumnNames;
        return this;
    }

    public GcTableSyncFromData assignColumnNamesPrimaryKey(List<String> theColumnNamesPrimaryKey) {
        this.columnNamesPrimaryKey = theColumnNamesPrimaryKey;
        return this;
    }

    public GcTableSyncFromData assignData(List<Object[]> theData) {
        this.data = theData;
        return this;
    }

    public GcTableSync getGcTableSync() {
        return this.gcTableSync;
    }

    public void setGcTableSync(GcTableSync gcTableSync) {
        this.gcTableSync = gcTableSync;
    }

    public void sync() {
        Long updatesMillis;
        Long insertsMillis;
        Long deletesMillis;
        this.connectionName = GrouperClientUtils.defaultString(this.connectionName, "grouper");
        GrouperClientUtils.assertion(GrouperClientUtils.length(this.columnNames) > 0, "Must pass in column names");
        GrouperClientUtils.assertion(GrouperClientUtils.length(this.columnNamesPrimaryKey) > 0, "Must pass in primary key column names");
        this.data = GrouperClientUtils.nonNull(this.data);
        GrouperClientUtils.assertion(!GrouperClientUtils.isBlank(this.tableName), "Must pass in table name");
        if (this.debugMap == null) {
            this.debugMap = new LinkedHashMap<String, Object>();
        }
        this.debugMapPrefix = GrouperClientUtils.defaultString(this.debugMapPrefix);
        String columnsCommaSeparated = GrouperClientUtils.join(this.columnNames.iterator(), ",");
        this.gcTableSync.setGcTableSyncConfiguration(new GcTableSyncConfiguration());
        this.gcTableSync.setGcTableSyncOutput(new GcTableSyncOutput());
        GcTableSyncTableBean gcTableSyncTableBeanSql = new GcTableSyncTableBean(this.gcTableSync);
        gcTableSyncTableBeanSql.configureMetadata(this.connectionName, this.tableName);
        this.gcTableSync.setDataBeanTo(gcTableSyncTableBeanSql);
        GcTableSyncTableMetadata gcTableSyncTableMetadata = gcTableSyncTableBeanSql.getTableMetadata();
        gcTableSyncTableMetadata.assignColumns(columnsCommaSeparated);
        gcTableSyncTableMetadata.assignPrimaryKeyColumns(GrouperClientUtils.join(this.columnNamesPrimaryKey.iterator(), ","));
        String sql = "select " + gcTableSyncTableMetadata.columnListAll() + " from " + gcTableSyncTableMetadata.getTableName();
        long nowNanos = System.nanoTime();
        List<Object[]> sqlResults = new GcDbAccess().connectionName(this.connectionName).sql(sql).selectList(Object[].class);
        GrouperClientUtils.debugMapIncrementLogEntry(this.debugMap, this.debugMapPrefix + "calls", 1);
        GrouperClientUtils.debugMapIncrementLogEntry(this.debugMap, this.debugMapPrefix + "dbRows", GrouperClientUtils.length(sqlResults));
        GrouperClientUtils.debugMapIncrementLogEntry(this.debugMap, this.debugMapPrefix + "sqlSelectMillis", (System.nanoTime() - nowNanos) / 1000000L);
        GcTableSyncTableData gcTableSyncTableDataSql = new GcTableSyncTableData();
        gcTableSyncTableDataSql.init(gcTableSyncTableBeanSql, gcTableSyncTableMetadata.lookupColumns(columnsCommaSeparated), sqlResults);
        gcTableSyncTableDataSql.indexData();
        gcTableSyncTableBeanSql.setDataInitialQuery(gcTableSyncTableDataSql);
        gcTableSyncTableBeanSql.setGcTableSync(this.gcTableSync);
        GcTableSyncTableBean gcTableSyncTableBeanWs = new GcTableSyncTableBean();
        this.gcTableSync.setDataBeanFrom(gcTableSyncTableBeanWs);
        gcTableSyncTableBeanWs.setTableMetadata(gcTableSyncTableBeanSql.getTableMetadata());
        gcTableSyncTableBeanWs.setGcTableSync(this.gcTableSync);
        GcTableSyncTableData gcTableSyncTableDataWs = new GcTableSyncTableData();
        this.gcTableSync.getDataBeanFrom().setDataInitialQuery(gcTableSyncTableDataWs);
        gcTableSyncTableDataWs.setColumnMetadata(gcTableSyncTableDataSql.getColumnMetadata());
        gcTableSyncTableDataWs.setGcTableSyncTableBean(gcTableSyncTableDataSql.getGcTableSyncTableBean());
        gcTableSyncTableDataWs.init(gcTableSyncTableBeanSql, gcTableSyncTableMetadata.lookupColumns(columnsCommaSeparated), this.data);
        gcTableSyncTableDataWs.indexData();
        GcTableSyncSubtype.fullSyncFull.syncData(this.debugMap, this.gcTableSync);
        long retrieveMillis = 0L;
        long syncMillis = 0L;
        Long retrieveDataFromMillis = (Long)this.debugMap.get("retrieveDataFromMillis");
        Long retrieveDataToMillis = (Long)this.debugMap.get("retrieveDataToMillis");
        if (retrieveDataFromMillis != null && retrieveDataToMillis != null) {
            retrieveMillis += Math.max(retrieveDataFromMillis, retrieveDataToMillis);
        } else if (retrieveDataFromMillis != null) {
            retrieveMillis += retrieveDataFromMillis.longValue();
        } else if (retrieveDataToMillis != null) {
            retrieveMillis += retrieveDataToMillis.longValue();
        }
        Long selectAllColumnsMillis = (Long)this.debugMap.get("selectAllColumnsMillis");
        if (selectAllColumnsMillis != null) {
            retrieveMillis += selectAllColumnsMillis.longValue();
        }
        if ((deletesMillis = (Long)this.debugMap.get("deletesMillis")) != null) {
            syncMillis += deletesMillis.longValue();
        }
        if ((insertsMillis = (Long)this.debugMap.get("insertsMillis")) != null) {
            syncMillis += insertsMillis.longValue();
        }
        if ((updatesMillis = (Long)this.debugMap.get("updatesMillis")) != null) {
            syncMillis += updatesMillis.longValue();
        }
        this.gcTableSync.getGcTableSyncOutput().setMillisGetData(retrieveMillis);
        this.gcTableSync.getGcTableSyncOutput().setMillisLoadData(syncMillis);
        if (this.gcTableSync.getGcGrouperSync() != null && this.gcTableSync.getGcGrouperSync().getRecordsCount() != null) {
            this.gcTableSync.getGcTableSyncOutput().setTotalCount(this.gcTableSync.getGcGrouperSync().getRecordsCount());
        }
    }
}

