/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLogState;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncSubtype;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;

public class GcTableSyncConfiguration {
    private boolean enabled = true;
    private String databaseFrom;
    private String databaseToReadonly;
    private String databaseTo;
    private GcTableSyncSubtype gcTableSyncSubtype = null;
    private String groupColumnString;
    private int maxBindVarsInSelect = 900;
    private int batchSize = 800;
    private int groupingSize = 10000;
    private String configKey;
    private String changeFlagColumnString;
    private String incrementalProgressColumnString;
    private String incrementalPrimaryKeyTable;
    private String statusDatabase;
    private String tableFrom;
    private String tableTo;
    private String primaryKeyColumnsString;
    private String columnsString;
    private String incrementalAllColumnsColumnString;
    private GcTableSync gcTableSync;
    private int switchFromIncrementalToFullIfOverGroupCount;
    private int switchFromIncrementalToGroupIfOverRecordsInGroup;
    private GcTableSyncSubtype switchFromIncrementalToFullSubtype;
    private int switchFromIncrementalToFullIfOverRecords;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDatabaseFrom() {
        return this.databaseFrom;
    }

    public String getDatabaseTo() {
        return this.databaseTo;
    }

    public String getDatabaseToReadonly() {
        return this.databaseToReadonly;
    }

    public String getDatabaseToOrReadonly() {
        return GrouperClientUtils.defaultIfBlank(this.databaseToReadonly, this.databaseTo);
    }

    public void setDatabaseToReadonly(String databaseToReadonly1) {
        this.databaseToReadonly = databaseToReadonly1;
    }

    public GcTableSyncSubtype getGcTableSyncSubtype() {
        return this.gcTableSyncSubtype;
    }

    public void setGcTableSyncSubtype(GcTableSyncSubtype gcTableSyncSubtype1) {
        this.gcTableSyncSubtype = gcTableSyncSubtype1;
    }

    public int getMaxBindVarsInSelect() {
        return this.maxBindVarsInSelect;
    }

    public void setMaxBindVarsInSelect(int maxBindVarsInSelect1) {
        this.maxBindVarsInSelect = maxBindVarsInSelect1;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize1) {
        this.batchSize = batchSize1;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public String getChangeFlagColumnString() {
        return this.changeFlagColumnString;
    }

    public void setChangeFlagColumnString(String fullSyncChangeFlagColumnString1) {
        this.changeFlagColumnString = fullSyncChangeFlagColumnString1;
    }

    public String getIncrementalProgressColumnString() {
        return this.incrementalProgressColumnString;
    }

    public void setIncrementalProgressColumnString(String incrementalAllColumnsColumnString1) {
        this.incrementalProgressColumnString = incrementalAllColumnsColumnString1;
    }

    public Integer retrieveConfigInt(String configName, boolean required) {
        String configValueString = this.retrieveConfigString(configName, required);
        return GrouperClientUtils.intObjectValue(configValueString, true);
    }

    public Boolean retrieveConfigBoolean(String configName, boolean required) {
        String configValueString = this.retrieveConfigString(configName, required);
        return GrouperClientUtils.booleanObjectValue(configValueString);
    }

    public String retrieveConfigString(String configName, boolean required) {
        String value = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.syncTable." + this.configKey + "." + configName);
        if (!StringUtils.isBlank(value)) {
            return value;
        }
        value = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.syncTableDefault." + configName);
        if (!StringUtils.isBlank(value)) {
            return value;
        }
        if (required) {
            throw new RuntimeException("Cant find config for syncTable: " + this.configKey + ": " + configName);
        }
        return null;
    }

    public String getIncrementalAllColumnsColumnString() {
        return this.incrementalAllColumnsColumnString;
    }

    public void setIncrementalAllColumnsColumnString(String incrementalAllColumnsColumnString1) {
        this.incrementalAllColumnsColumnString = incrementalAllColumnsColumnString1;
    }

    public String getPrimaryKeyColumnsString() {
        return this.primaryKeyColumnsString;
    }

    public void setPrimaryKeyColumnsString(String primaryKeyColumnsString1) {
        this.primaryKeyColumnsString = primaryKeyColumnsString1;
    }

    public String getColumnsString() {
        return this.columnsString;
    }

    public void setColumnsString(String columnsString1) {
        this.columnsString = columnsString1;
    }

    public GcTableSync getGcTableSync() {
        return this.gcTableSync;
    }

    public void setGcTableSync(GcTableSync gcTableSync1) {
        this.gcTableSync = gcTableSync1;
    }

    public void configureTableSync(Map<String, Object> debugMap, GcTableSync theGcTableSync, String theConfigKey, GcTableSyncSubtype theGcTableSyncSubtype) {
        try {
            GcGrouperSyncJob gcGrouperSyncJob;
            this.gcTableSync = theGcTableSync;
            this.setConfigKey(theConfigKey);
            this.setGcTableSyncSubtype(theGcTableSyncSubtype);
            String defaultStatusDatabase = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.syncTableDefault.statusDatabase", "grouper");
            this.statusDatabase = GrouperClientUtils.defaultIfNull(this.retrieveConfigString("statusDatabase", false), defaultStatusDatabase);
            if (!StringUtils.equals(defaultStatusDatabase, this.statusDatabase)) {
                debugMap.put("configStatusDatabase", this.statusDatabase);
            }
            if (this.gcTableSync.getGcGrouperSync() == null) {
                this.gcTableSync.setGcGrouperSync(GcGrouperSyncDao.retrieveOrCreateByProvisionerName(defaultStatusDatabase, this.configKey));
            }
            if (!GrouperClientUtils.equals("sqlTableSync", this.gcTableSync.getGcGrouperSync().getSyncEngine())) {
                this.gcTableSync.getGcGrouperSync().setSyncEngine("sqlTableSync");
                this.gcTableSync.getGcGrouperSync().getGcGrouperSyncDao().store();
            }
            if ((gcGrouperSyncJob = this.gcTableSync.getGcGrouperSyncJob()) == null) {
                gcGrouperSyncJob = this.gcTableSync.getGcGrouperSync().getGcGrouperSyncJobDao().jobRetrieveOrCreateBySyncType(this.gcTableSyncSubtype.name());
                this.gcTableSync.setGcGrouperSyncJob(gcGrouperSyncJob);
            }
            this.gcTableSync.getGcGrouperSyncJob().waitForRelatedJobsToFinishThenRun(theGcTableSyncSubtype.isFullSync());
            if (this.gcTableSync.getGcGrouperSyncLog() == null) {
                this.gcTableSync.setGcGrouperSyncLog(this.gcTableSync.getGcGrouperSync().getGcGrouperSyncJobDao().jobCreateLog(this.gcTableSync.getGcGrouperSyncJob()));
            }
            this.gcTableSync.getGcGrouperSyncLog().setSyncTimestamp(new Timestamp(System.currentTimeMillis()));
            if (StringUtils.isBlank(this.configKey)) {
                throw new RuntimeException("Why is config key blank?");
            }
            if (this.gcTableSyncSubtype == null) {
                throw new RuntimeException("Why is table sync subtype blank?");
            }
            if (debugMap == null) {
                debugMap = new LinkedHashMap<String, Object>();
            }
            this.databaseFrom = GrouperClientUtils.defaultIfBlank(this.retrieveConfigString("databaseFrom", false), "grouper");
            debugMap.put("configDatabaseFrom", this.databaseFrom);
            this.enabled = GrouperClientUtils.booleanValue(this.retrieveConfigBoolean("enabled", false), true);
            debugMap.put("configEnabled", this.enabled);
            this.databaseTo = GrouperClientUtils.defaultIfBlank(this.retrieveConfigString("databaseTo", false), "grouper");
            debugMap.put("configDatabaseTo", this.databaseTo);
            this.databaseToReadonly = this.retrieveConfigString("databaseToReadonly", false);
            if (!StringUtils.isBlank(this.databaseToReadonly)) {
                debugMap.put("configDatabaseToReadonly", this.databaseToReadonly);
            }
            this.tableFrom = this.retrieveConfigString("tableFrom", true);
            debugMap.put("configTableFrom", this.tableFrom);
            this.tableTo = GrouperClientUtils.defaultIfBlank(this.retrieveConfigString("tableTo", false), this.tableFrom);
            debugMap.put("configTableTo", this.tableTo);
            this.columnsString = GrouperClientUtils.defaultIfBlank(this.retrieveConfigString("columns", false), "*");
            debugMap.put("configColumns", this.columnsString);
            this.primaryKeyColumnsString = this.retrieveConfigString("primaryKeyColumns", true);
            debugMap.put("configPrimaryKeyColumns", this.primaryKeyColumnsString);
            this.changeFlagColumnString = this.retrieveConfigString("changeFlagColumn", this.gcTableSyncSubtype == GcTableSyncSubtype.fullSyncChangeFlag);
            if (!GrouperClientUtils.isBlank(this.changeFlagColumnString)) {
                debugMap.put("changeFlagColumn", this.changeFlagColumnString);
            }
            this.incrementalAllColumnsColumnString = this.retrieveConfigString("incrementalAllColumnsColumn", this.gcTableSyncSubtype == GcTableSyncSubtype.incrementalAllColumns);
            if (!GrouperClientUtils.isBlank(this.incrementalProgressColumnString)) {
                debugMap.put("incrementalAllColumnsColumn", this.incrementalProgressColumnString);
            }
            this.incrementalProgressColumnString = this.retrieveConfigString("incrementalProgressColumn", this.gcTableSyncSubtype == GcTableSyncSubtype.incrementalPrimaryKey);
            if (!GrouperClientUtils.isBlank(this.incrementalProgressColumnString)) {
                debugMap.put("incrementalProgressColumn", this.incrementalProgressColumnString);
            }
            this.groupColumnString = this.retrieveConfigString("groupingColumn", false);
            if (this.gcTableSyncSubtype.isNeedsGroupColumn() && GrouperClientUtils.isBlank(this.groupColumnString)) {
                throw new RuntimeException("groupingColumn is required for " + this.configKey);
            }
            if (!GrouperClientUtils.isBlank(this.groupColumnString)) {
                debugMap.put("configGroupingColumn", this.groupColumnString);
            }
            int defaultBatchSize = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.batchSize", 800);
            this.batchSize = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("batchSize", false), defaultBatchSize);
            if (this.batchSize != defaultBatchSize) {
                debugMap.put("configBatchSize", this.batchSize);
            }
            int defaultMaxBindVarsInSelect = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.maxBindVarsInSelect", 900);
            this.maxBindVarsInSelect = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("maxBindVarsInSelect", false), defaultMaxBindVarsInSelect);
            if (this.maxBindVarsInSelect < 1) {
                throw new RuntimeException("Cant have less than one maxBindVarsInSelect! " + this.maxBindVarsInSelect);
            }
            if (this.maxBindVarsInSelect != defaultMaxBindVarsInSelect) {
                debugMap.put("maxBindVarsInSelect", this.maxBindVarsInSelect);
            }
            int defaultGroupingSize = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.groupingSize", 10000);
            this.groupingSize = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("groupingSize", false), defaultGroupingSize);
            if (this.groupingSize != defaultGroupingSize) {
                debugMap.put("configGroupingSize", this.groupingSize);
            }
            this.incrementalPrimaryKeyTable = this.retrieveConfigString("incrementalPrimaryKeyTable", false);
            if (!GrouperClientUtils.isBlank(this.incrementalPrimaryKeyTable)) {
                debugMap.put("incrementalPrimaryKeyTable", this.incrementalPrimaryKeyTable);
            }
            int defaultSwitchFromIncrementalToFullIfOverRecords = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.switchFromIncrementalToFullIfOverRecords", 300000);
            this.switchFromIncrementalToFullIfOverRecords = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("switchFromIncrementalToFullIfOverRecords", false), defaultSwitchFromIncrementalToFullIfOverRecords);
            if (this.switchFromIncrementalToFullIfOverRecords != defaultSwitchFromIncrementalToFullIfOverRecords) {
                debugMap.put("configSwitchFromIncrementalToFullIfOverRecords", this.switchFromIncrementalToFullIfOverRecords);
            }
            GcTableSyncSubtype defaultSwitchFromIncrementalToFullSubtype = GcTableSyncSubtype.valueOfIgnoreCase(GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.syncTableDefault.switchFromIncrementalToFullSubtype", "fullSyncFull"), false);
            this.switchFromIncrementalToFullSubtype = GcTableSyncSubtype.valueOfIgnoreCase(GrouperClientUtils.defaultIfNull(this.retrieveConfigString("switchFromIncrementalToFullSubtype", false), defaultSwitchFromIncrementalToFullSubtype == null ? null : defaultSwitchFromIncrementalToFullSubtype.name()), false);
            if (defaultSwitchFromIncrementalToFullSubtype != this.switchFromIncrementalToFullSubtype) {
                debugMap.put("configSwitchFromIncrementalToFullSubtype", (Object)this.switchFromIncrementalToFullSubtype);
            }
            if (this.switchFromIncrementalToFullSubtype != null && !this.switchFromIncrementalToFullSubtype.isFullSync()) {
                throw new RuntimeException("defaultSwitchFromIncrementalToFullSubtype is not a full sync! " + (Object)((Object)this.switchFromIncrementalToFullSubtype));
            }
            int defaultSwitchFromIncrementalToGroupIfOverRecordsInGroup = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.switchFromIncrementalToGroupIfOverRecordsInGroup", 50000);
            this.switchFromIncrementalToGroupIfOverRecordsInGroup = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("switchFromIncrementalToGroupIfOverRecordsInGroup", false), defaultSwitchFromIncrementalToGroupIfOverRecordsInGroup);
            if (this.switchFromIncrementalToGroupIfOverRecordsInGroup != defaultSwitchFromIncrementalToGroupIfOverRecordsInGroup) {
                debugMap.put("configSwitchFromIncrementalToGroupIfOverRecordsInGroup", this.switchFromIncrementalToGroupIfOverRecordsInGroup);
            }
            int defaultSwitchFromIncrementalToFullIfOverGroupCount = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.switchFromIncrementalToFullIfOverGroupCount", 100);
            this.switchFromIncrementalToFullIfOverGroupCount = GrouperClientUtils.defaultIfNull(this.retrieveConfigInt("switchFromIncrementalToFullIfOverGroupCount", false), defaultSwitchFromIncrementalToFullIfOverGroupCount);
            if (this.switchFromIncrementalToFullIfOverGroupCount != defaultSwitchFromIncrementalToFullIfOverGroupCount) {
                debugMap.put("configSwitchFromIncrementalToFullIfOverGroupCount", this.switchFromIncrementalToFullIfOverGroupCount);
            }
        }
        catch (RuntimeException re) {
            if (this.gcTableSync != null && this.gcTableSync.getGcGrouperSyncLog() != null) {
                try {
                    this.gcTableSync.getGcGrouperSyncLog().setStatus(GcGrouperSyncLogState.CONFIG_ERROR);
                    this.gcTableSync.getGcGrouperSync().getGcGrouperSyncLogDao().internal_logStore(this.gcTableSync.getGcGrouperSyncLog());
                }
                catch (RuntimeException re2) {
                    GrouperClientUtils.injectInException(re, "***** START ANOTHER EXCEPTON *******" + GrouperClientUtils.getFullStackTrace(re2) + "***** END ANOTHER EXCEPTON *******");
                }
            }
            throw re;
        }
    }

    public int getSwitchFromIncrementalToFullIfOverGroupCount() {
        return this.switchFromIncrementalToFullIfOverGroupCount;
    }

    public void setSwitchFromIncrementalToFullIfOverGroupCount(int switchFromIncrementalToFullIfOverGroupCount1) {
        this.switchFromIncrementalToFullIfOverGroupCount = switchFromIncrementalToFullIfOverGroupCount1;
    }

    public int getSwitchFromIncrementalToGroupIfOverRecordsInGroup() {
        return this.switchFromIncrementalToGroupIfOverRecordsInGroup;
    }

    public void setSwitchFromIncrementalToGroupIfOverRecordsInGroup(int switchFromIncrementalToGroupIfOverRecordsInGroup1) {
        this.switchFromIncrementalToGroupIfOverRecordsInGroup = switchFromIncrementalToGroupIfOverRecordsInGroup1;
    }

    public GcTableSyncSubtype getSwitchFromIncrementalToFullSubtype() {
        return this.switchFromIncrementalToFullSubtype;
    }

    public void setSwitchFromIncrementalToFullSubtype(GcTableSyncSubtype switchFromIncrementalToFullSubtype1) {
        this.switchFromIncrementalToFullSubtype = switchFromIncrementalToFullSubtype1;
    }

    public int getSwitchFromIncrementalToFullIfOverRecords() {
        return this.switchFromIncrementalToFullIfOverRecords;
    }

    public void setSwitchFromIncrementalToFullIfOverRecords(int switchFromIncrementalToFullIfOverRecords1) {
        this.switchFromIncrementalToFullIfOverRecords = switchFromIncrementalToFullIfOverRecords1;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getIncrementalPrimaryKeyTable() {
        return this.incrementalPrimaryKeyTable;
    }

    public String getStatusDatabase() {
        return this.statusDatabase;
    }

    public String getTableFrom() {
        return this.tableFrom;
    }

    public String getTableTo() {
        return this.tableTo;
    }

    public String getGroupColumnString() {
        return this.groupColumnString;
    }

    public void setDatabaseFrom(String databaseFrom1) {
        this.databaseFrom = databaseFrom1;
    }

    public void setDatabaseTo(String databaseTo1) {
        this.databaseTo = databaseTo1;
    }

    public void setGroupColumnString(String groupColumn1) {
        this.groupColumnString = groupColumn1;
    }

    public void setGroupingSize(int groupSize1) {
        this.groupingSize = groupSize1;
    }

    public void setConfigKey(String key1) {
        this.configKey = key1;
    }

    public void setIncrementalPrimaryKeyTable(String realTimeTable1) {
        this.incrementalPrimaryKeyTable = realTimeTable1;
    }

    public void setStatusDatabase(String statusDatabase1) {
        this.statusDatabase = statusDatabase1;
    }

    public void setTableFrom(String tableName1) {
        this.tableFrom = tableName1;
    }

    public void setTableTo(String tableNameTo1) {
        this.tableTo = tableNameTo1;
    }
}

