/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.EqualsBuilder;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class GcTableSyncColumnMetadata {
    private int columnIndexZeroIndexed = -1;
    private ColumnType columnType;
    private int precision;
    private int scale;
    private int columnDisplaySize;
    private String columnName;

    public int hashCode() {
        return new HashCodeBuilder().append(this.columnName).append((Object)this.columnType).append(this.precision).append(this.scale).append(this.columnDisplaySize).toHashCode();
    }

    public String toString() {
        return this.columnName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GcTableSyncColumnMetadata)) {
            return false;
        }
        GcTableSyncColumnMetadata other = (GcTableSyncColumnMetadata)obj;
        return new EqualsBuilder().append(this.columnName, other.columnName).append((Object)this.columnType, (Object)other.columnType).append(this.precision, other.precision).append(this.scale, other.scale).append(this.columnDisplaySize, other.columnDisplaySize).isEquals();
    }

    public int getColumnIndexZeroIndexed() {
        return this.columnIndexZeroIndexed;
    }

    public void setColumnIndexZeroIndexed(int columnIndexZeroIndexed1) {
        this.columnIndexZeroIndexed = columnIndexZeroIndexed1;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision1) {
        this.precision = precision1;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale1) {
        this.scale = scale1;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public void setColumnDisplaySize(int stringLength1) {
        this.columnDisplaySize = stringLength1;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnType columnType1) {
        this.columnType = columnType1;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName1) {
        this.columnName = columnName1;
    }

    public static enum ColumnType {
        NUMERIC{

            @Override
            public Object readDataFromResultSet(GcTableSyncColumnMetadata gcTableSyncColumnMetadata, ResultSet resultSet) throws SQLException {
                return resultSet.getBigDecimal(gcTableSyncColumnMetadata.getColumnName());
            }

            @Override
            public Object convertToType(Object input) {
                if (input == null) {
                    return null;
                }
                if (input instanceof String) {
                    return new BigDecimal(GrouperClientUtils.longValue(input));
                }
                if (input instanceof Timestamp) {
                    return new BigDecimal(((Timestamp)input).getTime());
                }
                return new BigDecimal(GrouperClientUtils.longValue(input));
            }
        }
        ,
        BOOLEAN{

            @Override
            public Object readDataFromResultSet(GcTableSyncColumnMetadata gcTableSyncColumnMetadata, ResultSet resultSet) throws SQLException {
                return resultSet.getBoolean(gcTableSyncColumnMetadata.getColumnName());
            }

            @Override
            public Object convertToType(Object input) {
                if (GrouperClientUtils.isBlank(input)) {
                    return null;
                }
                return GrouperClientUtils.booleanValue(input);
            }
        }
        ,
        STRING{

            @Override
            public Object readDataFromResultSet(GcTableSyncColumnMetadata gcTableSyncColumnMetadata, ResultSet resultSet) throws SQLException {
                return resultSet.getString(gcTableSyncColumnMetadata.getColumnName());
            }

            @Override
            public Object convertToType(Object input) {
                if (input == null) {
                    return null;
                }
                if (input instanceof String) {
                    return (String)input;
                }
                if (input instanceof Number) {
                    return input.toString();
                }
                if (input instanceof Timestamp) {
                    return Long.toString(((Timestamp)input).getTime());
                }
                return input.toString();
            }
        }
        ,
        TIMESTAMP{

            @Override
            public Object readDataFromResultSet(GcTableSyncColumnMetadata gcTableSyncColumnMetadata, ResultSet resultSet) throws SQLException {
                return resultSet.getTimestamp(gcTableSyncColumnMetadata.getColumnName());
            }

            @Override
            public Object convertToType(Object input) {
                if (input == null) {
                    return null;
                }
                if (input instanceof String) {
                    return GrouperClientUtils.toTimestamp(input);
                }
                if (input instanceof Timestamp) {
                    return (Timestamp)input;
                }
                if (input instanceof Number) {
                    return new Timestamp(GrouperClientUtils.longValue(input));
                }
                return new Timestamp(GrouperClientUtils.longValue(input));
            }
        };


        public abstract Object readDataFromResultSet(GcTableSyncColumnMetadata var1, ResultSet var2) throws SQLException;

        public abstract Object convertToType(Object var1);
    }
}

