/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcDbVersionable;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableClass;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncGroup;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJobState;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLogState;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMember;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembership;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.RandomStringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.EqualsBuilder;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.net.InetAddress;
import java.sql.Timestamp;

@GcPersistableClass(tableName="grouper_sync_log", defaultFieldPersist=GcPersist.doPersist)
public class GcGrouperSyncLog
implements GcSqlAssignPrimaryKey,
GcDbVersionable {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncLog dbVersion = null;
    private Timestamp lastUpdated;
    @GcPersistableField(primaryKey=true, primaryKeyManuallyAssigned=false)
    private String id;
    private String grouperSyncId;
    private String grouperSyncOwnerId;
    @GcPersistableField(columnName="status")
    private String statusDb;
    private Timestamp syncTimestamp;
    private Timestamp syncTimestampStart;
    private String description;
    private String descriptionClob;
    private Long descriptionBytes;
    private Integer recordsProcessed;
    private Integer recordsChanged;
    private Integer jobTookMillis;
    private String server;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private String connectionName;
    private static Log LOG = GrouperClientUtils.retrieveLog(GcGrouperSyncLog.class);
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSync grouperSync;

    @Override
    public void dbVersionReset() {
        this.dbVersion = this.clone();
    }

    @Override
    public boolean dbVersionDifferent() {
        return !this.equalsDeep(this.dbVersion);
    }

    @Override
    public void dbVersionDelete() {
        this.dbVersion = null;
    }

    public GcGrouperSyncLog clone() {
        GcGrouperSyncLog gcGrouperSyncLog = new GcGrouperSyncLog();
        gcGrouperSyncLog.description = this.description;
        gcGrouperSyncLog.grouperSyncId = this.grouperSyncId;
        gcGrouperSyncLog.grouperSyncOwnerId = this.grouperSyncOwnerId;
        gcGrouperSyncLog.id = this.id;
        gcGrouperSyncLog.jobTookMillis = this.jobTookMillis;
        gcGrouperSyncLog.recordsChanged = this.recordsChanged;
        gcGrouperSyncLog.recordsProcessed = this.recordsProcessed;
        gcGrouperSyncLog.server = this.server;
        gcGrouperSyncLog.statusDb = this.statusDb;
        gcGrouperSyncLog.syncTimestampStart = this.syncTimestampStart;
        gcGrouperSyncLog.syncTimestamp = this.syncTimestamp;
        return gcGrouperSyncLog;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GcGrouperSyncLog)) {
            return false;
        }
        GcGrouperSyncLog other = (GcGrouperSyncLog)obj;
        return new EqualsBuilder().append(this.description, other.description).append(this.grouperSyncId, other.grouperSyncId).append(this.grouperSyncOwnerId, other.grouperSyncOwnerId).append(this.id, other.id).append(this.jobTookMillis, other.jobTookMillis).append(this.recordsChanged, other.recordsChanged).append(this.recordsProcessed, other.recordsProcessed).append(this.server, other.server).append(this.statusDb, other.statusDb).append(this.syncTimestampStart, other.syncTimestampStart).append(this.syncTimestamp, other.syncTimestamp).isEquals();
    }

    public static void reset() {
        new GcDbAccess().connectionName("grouper").sql("delete from " + GcPersistableHelper.tableName(GcGrouperSyncLog.class)).executeSql();
    }

    public static void main(String[] args) {
        System.out.println("none");
        for (GcGrouperSyncLog theGcGrouperSyncLog : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncLog.class)) {
            System.out.println(theGcGrouperSyncLog.toString());
        }
        GcGrouperSync gcGrouperSync = new GcGrouperSync();
        gcGrouperSync.setSyncEngine("temp");
        gcGrouperSync.setProvisionerName("myJob");
        gcGrouperSync.getGcGrouperSyncDao().store();
        GcGrouperSyncJob gcGrouperSyncJob = new GcGrouperSyncJob();
        gcGrouperSyncJob.setGrouperSync(gcGrouperSync);
        gcGrouperSyncJob.setJobState(GcGrouperSyncJobState.notRunning);
        gcGrouperSyncJob.setLastSyncIndex(135L);
        gcGrouperSyncJob.setLastTimeWorkWasDone(new Timestamp(System.currentTimeMillis() + 2000L));
        gcGrouperSyncJob.setSyncType("testSyncType");
        gcGrouperSync.getGcGrouperSyncJobDao().internal_jobStore(gcGrouperSyncJob);
        GcGrouperSyncGroup gcGrouperSyncGroup = gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveOrCreateByGroupId("groupId");
        gcGrouperSyncGroup.setLastTimeWorkWasDone(new Timestamp(System.currentTimeMillis() + 2000L));
        gcGrouperSync.getGcGrouperSyncGroupDao().internal_groupStore(gcGrouperSyncGroup);
        GcGrouperSyncMember gcGrouperSyncMember = gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveOrCreateByMemberId("memberId");
        gcGrouperSyncMember.setLastTimeWorkWasDone(new Timestamp(System.currentTimeMillis() + 4000L));
        gcGrouperSync.getGcGrouperSyncMemberDao().internal_memberStore(gcGrouperSyncMember);
        GcGrouperSyncMembership gcGrouperSyncMembership = gcGrouperSync.getGcGrouperSyncMembershipDao().membershipRetrieveById("membershipId");
        gcGrouperSync.getGcGrouperSyncMembershipDao().internal_membershipStore(gcGrouperSyncMembership);
        GcGrouperSyncLog gcGrouperSyncLog = new GcGrouperSyncLog();
        gcGrouperSyncLog.setDescriptionToSave("desc");
        gcGrouperSyncLog.jobTookMillis = 1223;
        gcGrouperSyncLog.recordsChanged = 12;
        gcGrouperSyncLog.recordsProcessed = 23;
        gcGrouperSync.getGcGrouperSyncLogDao().internal_logStore(gcGrouperSyncLog);
        System.out.println("stored");
        System.out.println(gcGrouperSyncLog);
        String longDescription = RandomStringUtils.random(4500, true, true);
        gcGrouperSyncLog.setDescriptionToSave(longDescription);
        gcGrouperSync.getGcGrouperSyncLogDao().internal_logStore(gcGrouperSyncLog);
        System.out.println("updated");
        for (GcGrouperSyncLog theGcGrouperSyncLog : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncLog.class)) {
            System.out.println(theGcGrouperSyncLog.toString());
        }
        System.out.println("deleted");
        for (GcGrouperSyncGroup theGcGrouperSyncStatus : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncGroup.class)) {
            System.out.println(theGcGrouperSyncStatus.toString());
        }
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated1) {
        this.lastUpdated = lastUpdated1;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id1) {
        this.id = id1;
    }

    public String getGrouperSyncId() {
        return this.grouperSyncId;
    }

    public void setGrouperSyncId(String grouperSyncId1) {
        this.grouperSyncId = grouperSyncId1;
        if (this.grouperSync == null || !GrouperClientUtils.equals(grouperSyncId1, this.grouperSync.getId())) {
            this.grouperSync = null;
        }
    }

    public String getGrouperSyncOwnerId() {
        return this.grouperSyncOwnerId;
    }

    public void setGrouperSyncOwnerId(String grouperSyncOwnerId1) {
        this.grouperSyncOwnerId = grouperSyncOwnerId1;
    }

    public String getStatusDb() {
        return this.statusDb;
    }

    public void setStatusDb(String status1) {
        this.statusDb = status1;
    }

    public GcGrouperSyncLogState getStatus() {
        return GcGrouperSyncLogState.valueOfIgnoreCase(this.statusDb);
    }

    public void setStatus(GcGrouperSyncLogState gcGrouperSyncLogState) {
        this.statusDb = gcGrouperSyncLogState == null ? null : gcGrouperSyncLogState.name();
    }

    public Timestamp getSyncTimestampStart() {
        return this.syncTimestampStart;
    }

    public void setSyncTimestampStart(Timestamp syncTimestampStart1) {
        this.syncTimestampStart = syncTimestampStart1;
    }

    public Timestamp getSyncTimestamp() {
        return this.syncTimestamp;
    }

    public void setSyncTimestamp(Timestamp syncTimestamp1) {
        this.syncTimestamp = syncTimestamp1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description1) {
        this.description = description1;
    }

    public String getDescriptionClob() {
        return this.descriptionClob;
    }

    public void setDescriptionClob(String descriptionClob) {
        this.descriptionClob = descriptionClob;
    }

    public Long getDescriptionBytes() {
        return this.descriptionBytes;
    }

    public void setDescriptionBytes(Long descriptionBytes) {
        this.descriptionBytes = descriptionBytes;
    }

    public String getDescriptionOrDescriptionClob() {
        if (GrouperClientUtils.isNotBlank(this.description)) {
            return this.description;
        }
        return this.descriptionClob;
    }

    public void setDescriptionToSave(String description) {
        int lengthAscii = GrouperClientUtils.lengthAscii(description);
        if (GrouperClientUtils.lengthAscii(description) <= 3000) {
            this.description = description;
            this.descriptionClob = null;
        } else {
            this.descriptionClob = description;
            this.description = null;
        }
        this.descriptionBytes = new Long(lengthAscii);
    }

    public Integer getRecordsProcessed() {
        return this.recordsProcessed;
    }

    public void setRecordsProcessed(Integer recordsProcessed1) {
        this.recordsProcessed = recordsProcessed1;
    }

    public Integer getRecordsChanged() {
        return this.recordsChanged;
    }

    public void setRecordsChanged(Integer recordsChanged1) {
        this.recordsChanged = recordsChanged1;
    }

    public Integer getJobTookMillis() {
        return this.jobTookMillis;
    }

    public void setJobTookMillis(Integer jobTookMillis) {
        this.jobTookMillis = jobTookMillis;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server1) {
        this.server = server1;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName1) {
        this.connectionName = connectionName1;
    }

    @Override
    public boolean gcSqlAssignNewPrimaryKeyForInsert() {
        if (this.id != null) {
            return false;
        }
        this.id = GrouperClientUtils.uuid();
        return true;
    }

    public void storePrepare() {
        try {
            this.server = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.info(e);
        }
        this.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.connectionName = GcGrouperSync.defaultConnectionName(this.connectionName);
    }

    public String toString() {
        return GrouperClientUtils.toStringReflection(this);
    }

    public GcGrouperSync getGrouperSync() {
        return this.grouperSync;
    }

    public void setGrouperSync(GcGrouperSync gcGrouperSync) {
        this.grouperSync = gcGrouperSync;
        this.grouperSyncId = gcGrouperSync == null ? null : gcGrouperSync.getId();
        this.connectionName = gcGrouperSync == null ? this.connectionName : gcGrouperSync.getConnectionName();
    }
}

