/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GcGrouperSyncJobDao {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncJob> internalCacheSyncJobs = new HashMap<String, GcGrouperSyncJob>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncJob> internalCacheSyncJobsById = new HashMap<String, GcGrouperSyncJob>();
    private GcGrouperSync gcGrouperSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private boolean jobRetrievedAllObjectsFromDb = false;

    public GcGrouperSyncJob jobCreateBySyncType(String syncType) {
        GcGrouperSyncJob gcGrouperSyncJob = new GcGrouperSyncJob();
        gcGrouperSyncJob.setGrouperSync(this.getGcGrouperSync());
        gcGrouperSyncJob.setSyncType(syncType);
        this.internal_jobStore(gcGrouperSyncJob);
        this.gcGrouperSync.addObjectCreatedCount(1);
        return gcGrouperSyncJob;
    }

    public int jobDelete(Collection<GcGrouperSyncJob> gcGrouperSyncJobs, boolean deleteLogs) {
        int[] rowDeleteCounts;
        int count = 0;
        if (GrouperClientUtils.length(gcGrouperSyncJobs) == 0) {
            return 0;
        }
        ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
        HashSet<String> logJobIds = new HashSet<String>();
        for (GcGrouperSyncJob gcGrouperSyncJob : gcGrouperSyncJobs) {
            ArrayList<String> currentBindVarRow = new ArrayList<String>();
            currentBindVarRow.add(gcGrouperSyncJob.getId());
            batchBindVars.add(currentBindVarRow);
            logJobIds.add(gcGrouperSyncJob.getId());
            this.internal_jobCacheDelete(gcGrouperSyncJob);
        }
        String connectionName = gcGrouperSyncJobs.iterator().next().getConnectionName();
        count += this.getGcGrouperSync().getGcGrouperSyncLogDao().internal_logDeleteBatchByOwnerIds(logJobIds);
        for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(connectionName).sql("delete from grouper_sync_job where id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
            count += rowDeleteCount;
        }
        return count;
    }

    public int jobDelete(GcGrouperSyncJob gcGrouperSyncJob, boolean deleteLogs) {
        if (gcGrouperSyncJob == null) {
            return 0;
        }
        this.internal_jobCacheDelete(gcGrouperSyncJob);
        int count = 0;
        if (deleteLogs) {
            count += this.getGcGrouperSync().getGcGrouperSyncLogDao().logDeleteByOwnerId(gcGrouperSyncJob.getId());
        }
        int rowDeleteCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_job where id = ?").bindVars(gcGrouperSyncJob.getId()).executeSql();
        return count += rowDeleteCount;
    }

    public int jobDeleteAll(boolean deleteLogs) {
        this.internalCacheSyncJobs.clear();
        this.internalCacheSyncJobsById.clear();
        int rowDeleteCount = 0;
        if (deleteLogs) {
            rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id in ( select id from grouper_sync_job gsj where gsj.grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        }
        return rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_job where grouper_sync_id = ?").bindVars(this.getGcGrouperSync().getId()).executeSql();
    }

    public List<GcGrouperSyncJob> jobRetrieveAll() {
        if (!this.jobRetrievedAllObjectsFromDb) {
            for (GcGrouperSyncJob gcGrouperSyncJob : this.internal_jobRetrieveFromDbAll()) {
                this.internal_jobCacheAdd(gcGrouperSyncJob);
            }
            this.jobRetrievedAllObjectsFromDb = true;
        }
        return new ArrayList<GcGrouperSyncJob>(this.internalCacheSyncJobs.values());
    }

    public GcGrouperSyncJob jobRetrieveBySyncType(String syncType) {
        GcGrouperSyncJob gcGrouperSyncJob = this.internalCacheSyncJobs.get(syncType);
        if (gcGrouperSyncJob == null) {
            gcGrouperSyncJob = this.internal_jobRetrieveFromDbBySyncType(syncType);
        }
        return gcGrouperSyncJob;
    }

    public GcGrouperSyncJob jobRetrieveById(String gcGrouperSyncJobId) {
        GcGrouperSyncJob gcGrouperSyncJob = this.internalCacheSyncJobsById.get(gcGrouperSyncJobId);
        if (gcGrouperSyncJob == null) {
            gcGrouperSyncJob = this.internal_jobRetrieveFromDbById(gcGrouperSyncJobId);
        }
        return gcGrouperSyncJob;
    }

    public Map<String, GcGrouperSyncJob> jobRetrieveByIds(Collection<String> gcGrouperSyncJobIds) {
        HashMap<String, GcGrouperSyncJob> result = new HashMap<String, GcGrouperSyncJob>();
        HashSet<String> jobIdsToGetFromDb = new HashSet<String>();
        for (String gcGrouperSyncJobId : GrouperClientUtils.nonNull(gcGrouperSyncJobIds)) {
            GcGrouperSyncJob gcGrouperSyncJob = this.internalCacheSyncJobsById.get(gcGrouperSyncJobId);
            if (gcGrouperSyncJob != null) {
                result.put(gcGrouperSyncJobId, gcGrouperSyncJob);
                continue;
            }
            jobIdsToGetFromDb.add(gcGrouperSyncJobId);
        }
        if (jobIdsToGetFromDb.size() > 0) {
            Map<String, GcGrouperSyncJob> fromDb = this.internal_jobRetrieveFromDbByIds(jobIdsToGetFromDb);
            result.putAll(fromDb);
        }
        return result;
    }

    public Map<String, GcGrouperSyncJob> internal_jobRetrieveFromDbByIds(Collection<String> gcGrouperSyncJobIds) {
        HashMap<String, GcGrouperSyncJob> result = new HashMap<String, GcGrouperSyncJob>();
        if (GrouperClientUtils.length(gcGrouperSyncJobIds) == 0) {
            return result;
        }
        ArrayList<String> jobIdsList = new ArrayList<String>(gcGrouperSyncJobIds);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(jobIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfJobIds = GrouperClientUtils.batchList(jobIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_job where grouper_sync_id = ? and id in ( " + GrouperClientUtils.appendQuestions(batchOfJobIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql).addBindVar(this.getGcGrouperSync().getId());
            for (String jobId : batchOfJobIds) {
                gcDbAccess.addBindVar(jobId);
            }
            List<GcGrouperSyncJob> gcGrouperSyncJobs = gcDbAccess.selectList(GcGrouperSyncJob.class);
            for (GcGrouperSyncJob gcGrouperSyncJob : GrouperClientUtils.nonNull(gcGrouperSyncJobs)) {
                result.put(gcGrouperSyncJob.getId(), gcGrouperSyncJob);
                gcGrouperSyncJob.setGrouperSync(this.getGcGrouperSync());
                this.internal_jobCacheAdd(gcGrouperSyncJob);
            }
        }
        return result;
    }

    public GcGrouperSyncJob jobRetrieveOrCreateBySyncType(String syncType) {
        GcGrouperSyncJob gcGrouperSyncJob = this.jobRetrieveBySyncType(syncType);
        if (gcGrouperSyncJob == null) {
            gcGrouperSyncJob = this.jobCreateBySyncType(syncType);
        }
        return gcGrouperSyncJob;
    }

    public GcGrouperSyncLog jobCreateLog(GcGrouperSyncJob gcGrouperSyncJob) {
        return this.gcGrouperSync.getGcGrouperSyncLogDao().logCreateByOwnerId(gcGrouperSyncJob.getId());
    }

    private void internal_jobCacheAdd(GcGrouperSyncJob gcGrouperSyncJob) {
        if (gcGrouperSyncJob.getSyncType() != null) {
            this.internalCacheSyncJobs.put(gcGrouperSyncJob.getSyncType(), gcGrouperSyncJob);
        }
        if (gcGrouperSyncJob.getId() != null) {
            this.internalCacheSyncJobsById.put(gcGrouperSyncJob.getId(), gcGrouperSyncJob);
        }
    }

    public void internal_jobCacheDelete(GcGrouperSyncJob gcGrouperSyncJob) {
        if (gcGrouperSyncJob.getSyncType() != null) {
            this.internalCacheSyncJobs.remove(gcGrouperSyncJob.getSyncType());
        }
        if (gcGrouperSyncJob.getId() != null) {
            this.internalCacheSyncJobsById.remove(gcGrouperSyncJob.getId());
        }
    }

    public List<GcGrouperSyncJob> internal_jobRetrieveFromDbAll() {
        this.internalCacheSyncJobs.clear();
        this.internalCacheSyncJobsById.clear();
        List<GcGrouperSyncJob> gcGrouperSyncJobList = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_job where grouper_sync_id = ?").addBindVar(this.getGcGrouperSync().getId()).selectList(GcGrouperSyncJob.class);
        for (GcGrouperSyncJob gcGrouperSyncJob : gcGrouperSyncJobList) {
            gcGrouperSyncJob.setGrouperSync(this.getGcGrouperSync());
            this.internal_jobCacheAdd(gcGrouperSyncJob);
        }
        return gcGrouperSyncJobList;
    }

    public GcGrouperSyncJob internal_jobRetrieveFromDbBySyncType(String syncType) {
        GcGrouperSyncJob gcGrouperSyncJob = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_job where grouper_sync_id = ? and sync_type = ?").addBindVar(this.getGcGrouperSync().getId()).addBindVar(syncType).select(GcGrouperSyncJob.class);
        if (gcGrouperSyncJob != null) {
            gcGrouperSyncJob.setGrouperSync(this.getGcGrouperSync());
            this.internal_jobCacheAdd(gcGrouperSyncJob);
        }
        return gcGrouperSyncJob;
    }

    public GcGrouperSyncJob internal_jobRetrieveFromDbById(String gcGrouperSyncJobId) {
        GcGrouperSyncJob gcGrouperSyncJob = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_job where id = ?").addBindVar(gcGrouperSyncJobId).select(GcGrouperSyncJob.class);
        if (gcGrouperSyncJob != null) {
            gcGrouperSyncJob.setGrouperSync(this.getGcGrouperSync());
            this.internal_jobCacheAdd(gcGrouperSyncJob);
        }
        return gcGrouperSyncJob;
    }

    public GcGrouperSync getGcGrouperSync() {
        return this.gcGrouperSync;
    }

    public void setGcGrouperSync(GcGrouperSync gcGrouperSync) {
        this.gcGrouperSync = gcGrouperSync;
    }

    public int internal_jobStoreAll() {
        return this.internal_jobStore(this.internalCacheSyncJobs.values());
    }

    public int internal_jobStore(Collection<GcGrouperSyncJob> gcGrouperSyncJobs) {
        if (GrouperClientUtils.length(gcGrouperSyncJobs) == 0) {
            return 0;
        }
        int batchSize = this.getGcGrouperSync().batchSize();
        ArrayList<GcGrouperSyncJob> gcGrouperSyncJobsList = new ArrayList<GcGrouperSyncJob>(gcGrouperSyncJobs);
        for (GcGrouperSyncJob gcGrouperSyncJob : GrouperClientUtils.nonNull(gcGrouperSyncJobs)) {
            gcGrouperSyncJob.storePrepare();
        }
        int changes = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeBatchToDatabase(gcGrouperSyncJobsList, batchSize);
        for (GcGrouperSyncJob gcGrouperSyncJob : GrouperClientUtils.nonNull(gcGrouperSyncJobs)) {
            this.internal_jobCacheAdd(gcGrouperSyncJob);
        }
        return changes;
    }

    public void internal_jobStore(GcGrouperSyncJob gcGrouperSyncJob) {
        gcGrouperSyncJob.storePrepare();
        new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeToDatabase(gcGrouperSyncJob);
        this.internal_jobCacheAdd(gcGrouperSyncJob);
    }
}

