/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcDbVersionable;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableClass;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncErrorCode;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.EqualsBuilder;
import java.sql.Timestamp;
import java.util.Set;

@GcPersistableClass(tableName="grouper_sync_group", defaultFieldPersist=GcPersist.doPersist)
public class GcGrouperSyncGroup
implements GcSqlAssignPrimaryKey,
GcDbVersionable {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncGroup dbVersion = null;
    private Timestamp lastGroupSync;
    private Timestamp lastGroupSyncStart;
    private Timestamp lastGroupMetadataSyncStart;
    private Timestamp lastGroupMetadataSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSync grouperSync;
    @GcPersistableField(columnName="error_code")
    private String errorCodeDb;
    private String errorMessage;
    private Timestamp errorTimestamp;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private String connectionName;
    private static Set<String> toStringFieldNamesToIgnore = GrouperClientUtils.toSet("connectionName", "dbVersion", "debugMap", "errorMessage", "grouperSync", "grouperSyncId", "lastGroupMetadataSync", "lastGroupMetadataSyncStart", "lastGroupSync", "lastUpdated", "metadataUpdated");
    private Timestamp lastTimeWorkWasDone;
    private String metadataJson;
    @GcPersistableField(primaryKey=true, primaryKeyManuallyAssigned=false)
    private String id;
    @GcPersistableField(columnName="in_target")
    private String inTargetDb;
    @GcPersistableField(columnName="in_target_insert_or_exists")
    private String inTargetInsertOrExistsDb;
    private Timestamp metadataUpdated;
    private String grouperSyncId;
    private Timestamp lastUpdated;
    private String groupId;
    private String groupName;
    @GcPersistableField(columnName="provisionable")
    private String provisionableDb;
    private Timestamp provisionableStart;
    private Timestamp inTargetStart;
    private Timestamp inTargetEnd;
    private Timestamp provisionableEnd;
    private Long groupIdIndex;
    @GcPersistableField(columnName="group_from_id2")
    private String groupAttributeValueCache0;
    @GcPersistableField(columnName="group_from_id3")
    private String groupAttributeValueCache1;
    @GcPersistableField(columnName="group_to_id2")
    private String groupAttributeValueCache2;
    @GcPersistableField(columnName="group_to_id3")
    private String groupAttributeValueCache3;

    @Override
    public void dbVersionReset() {
        this.dbVersion = this.clone();
    }

    @Override
    public boolean dbVersionDifferent() {
        return !this.equalsDeep(this.dbVersion);
    }

    @Override
    public void dbVersionDelete() {
        this.dbVersion = null;
    }

    public GcGrouperSyncGroup clone() {
        GcGrouperSyncGroup gcGrouperSyncGroup = new GcGrouperSyncGroup();
        gcGrouperSyncGroup.errorCodeDb = this.errorCodeDb;
        gcGrouperSyncGroup.errorMessage = this.errorMessage;
        gcGrouperSyncGroup.errorTimestamp = this.errorTimestamp;
        gcGrouperSyncGroup.groupAttributeValueCache0 = this.groupAttributeValueCache0;
        gcGrouperSyncGroup.groupAttributeValueCache1 = this.groupAttributeValueCache1;
        gcGrouperSyncGroup.groupId = this.groupId;
        gcGrouperSyncGroup.groupIdIndex = this.groupIdIndex;
        gcGrouperSyncGroup.groupName = this.groupName;
        gcGrouperSyncGroup.groupAttributeValueCache2 = this.groupAttributeValueCache2;
        gcGrouperSyncGroup.groupAttributeValueCache3 = this.groupAttributeValueCache3;
        gcGrouperSyncGroup.grouperSyncId = this.grouperSyncId;
        gcGrouperSyncGroup.id = this.id;
        gcGrouperSyncGroup.inTargetDb = this.inTargetDb;
        gcGrouperSyncGroup.inTargetEnd = this.inTargetEnd;
        gcGrouperSyncGroup.inTargetInsertOrExistsDb = this.inTargetInsertOrExistsDb;
        gcGrouperSyncGroup.inTargetStart = this.inTargetStart;
        gcGrouperSyncGroup.lastGroupMetadataSync = this.lastGroupMetadataSync;
        gcGrouperSyncGroup.lastGroupMetadataSyncStart = this.lastGroupMetadataSyncStart;
        gcGrouperSyncGroup.lastGroupSync = this.lastGroupSync;
        gcGrouperSyncGroup.lastGroupSyncStart = this.lastGroupSyncStart;
        gcGrouperSyncGroup.lastTimeWorkWasDone = this.lastTimeWorkWasDone;
        gcGrouperSyncGroup.metadataJson = this.metadataJson;
        gcGrouperSyncGroup.metadataUpdated = this.metadataUpdated;
        gcGrouperSyncGroup.provisionableDb = this.provisionableDb;
        gcGrouperSyncGroup.provisionableEnd = this.provisionableEnd;
        gcGrouperSyncGroup.provisionableStart = this.provisionableStart;
        return gcGrouperSyncGroup;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GcGrouperSyncGroup)) {
            return false;
        }
        GcGrouperSyncGroup other = (GcGrouperSyncGroup)obj;
        return new EqualsBuilder().append(this.errorCodeDb, other.errorCodeDb).append(this.errorMessage, other.errorMessage).append(this.errorTimestamp, other.errorTimestamp).append(this.groupAttributeValueCache0, other.groupAttributeValueCache0).append(this.groupAttributeValueCache1, other.groupAttributeValueCache1).append(this.groupId, other.groupId).append(this.groupIdIndex, other.groupIdIndex).append(this.groupName, other.groupName).append(this.groupAttributeValueCache2, other.groupAttributeValueCache2).append(this.groupAttributeValueCache3, other.groupAttributeValueCache3).append(this.grouperSyncId, other.grouperSyncId).append(this.id, other.id).append(this.inTargetDb, other.inTargetDb).append(this.inTargetEnd, other.inTargetEnd).append(this.inTargetInsertOrExistsDb, other.inTargetInsertOrExistsDb).append(this.inTargetStart, other.inTargetStart).append(this.lastGroupMetadataSync, other.lastGroupMetadataSync).append(this.lastGroupMetadataSyncStart, other.lastGroupMetadataSyncStart).append(this.lastGroupSync, other.lastGroupSync).append(this.lastGroupSyncStart, other.lastGroupSyncStart).append(this.lastTimeWorkWasDone, other.lastTimeWorkWasDone).append(this.metadataJson, other.metadataJson).append(this.metadataUpdated, other.metadataUpdated).append(this.provisionableDb, other.provisionableDb).append(this.provisionableEnd, other.provisionableEnd).append(this.provisionableStart, other.provisionableStart).isEquals();
    }

    public Timestamp getLastGroupSyncStart() {
        return this.lastGroupSyncStart;
    }

    public void setLastGroupSyncStart(Timestamp lastGroupSyncStart) {
        this.lastGroupSyncStart = lastGroupSyncStart;
    }

    public Timestamp getLastGroupSync() {
        return this.lastGroupSync;
    }

    public void setLastGroupSync(Timestamp lastGroupSync1) {
        this.lastGroupSync = lastGroupSync1;
    }

    public Timestamp getLastGroupMetadataSyncStart() {
        return this.lastGroupMetadataSyncStart;
    }

    public void setLastGroupMetadataSyncStart(Timestamp lastGroupMetadataSyncStart) {
        this.lastGroupMetadataSyncStart = lastGroupMetadataSyncStart;
    }

    public Timestamp getLastGroupMetadataSync() {
        return this.lastGroupMetadataSync;
    }

    public void setLastGroupMetadataSync(Timestamp lastGroupMetadataSync) {
        this.lastGroupMetadataSync = lastGroupMetadataSync;
    }

    public static void reset() {
        new GcDbAccess().connectionName("grouper").sql("delete from " + GcPersistableHelper.tableName(GcGrouperSyncGroup.class)).executeSql();
    }

    public void storePrepare() {
        this.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.connectionName = GcGrouperSync.defaultConnectionName(this.connectionName);
        this.errorMessage = GrouperClientUtils.abbreviate(this.errorMessage, 3700);
    }

    public GcGrouperSync getGrouperSync() {
        return this.grouperSync;
    }

    public void setGrouperSync(GcGrouperSync gcGrouperSync) {
        this.grouperSync = gcGrouperSync;
        this.grouperSyncId = gcGrouperSync == null ? null : gcGrouperSync.getId();
        this.connectionName = gcGrouperSync == null ? this.connectionName : gcGrouperSync.getConnectionName();
    }

    public String getErrorCodeDb() {
        return this.errorCodeDb;
    }

    public void setErrorCodeDb(String errorCodeDb) {
        this.errorCodeDb = errorCodeDb;
    }

    public GcGrouperSyncErrorCode getErrorCode() {
        if (this.errorCodeDb == null) {
            return null;
        }
        return GrouperClientUtils.enumValueOfIgnoreCase(GcGrouperSyncErrorCode.class, this.errorCodeDb, false);
    }

    public void setErrorCode(GcGrouperSyncErrorCode gcGrouperSyncErrorCode) {
        this.errorCodeDb = gcGrouperSyncErrorCode == null ? null : gcGrouperSyncErrorCode.name();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage1) {
        this.errorMessage = errorMessage1;
    }

    public Timestamp getErrorTimestamp() {
        return this.errorTimestamp;
    }

    public void setErrorTimestamp(Timestamp errorTimestamp1) {
        this.errorTimestamp = errorTimestamp1;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName1) {
        this.connectionName = connectionName1;
    }

    public static void main(String[] args) {
    }

    public String toString() {
        return GrouperClientUtils.toStringReflection(this, toStringFieldNamesToIgnore);
    }

    public Timestamp getLastTimeWorkWasDone() {
        return this.lastTimeWorkWasDone;
    }

    public void setLastTimeWorkWasDone(Timestamp lastTimeWorkWasDone1) {
        this.lastTimeWorkWasDone = lastTimeWorkWasDone1;
    }

    public String getMetadataJson() {
        return this.metadataJson;
    }

    public void setMetadataJson(String metadataJson) {
        this.metadataJson = metadataJson;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id1) {
        this.id = id1;
    }

    public String getInTargetDb() {
        return this.inTargetDb;
    }

    public void setInTargetDb(String inTargetDb1) {
        this.inTargetDb = inTargetDb1;
    }

    public boolean isInTarget() {
        return GrouperClientUtils.booleanValue(this.inTargetDb, false);
    }

    public void setInTarget(boolean inTarget) {
        this.inTargetDb = inTarget ? "T" : "F";
    }

    public Boolean getInTarget() {
        return GrouperClientUtils.booleanObjectValue(this.inTargetDb);
    }

    public String getInTargetInsertOrExistsDb() {
        return this.inTargetInsertOrExistsDb;
    }

    public void setInTargetInsertOrExistsDb(String inTargetInsertOrExistsDb1) {
        this.inTargetInsertOrExistsDb = inTargetInsertOrExistsDb1;
    }

    public Timestamp getMetadataUpdated() {
        return this.metadataUpdated;
    }

    public void setMetadataUpdated(Timestamp metadataUpdated1) {
        this.metadataUpdated = metadataUpdated1;
    }

    public boolean isInTargetInsertOrExists() {
        return GrouperClientUtils.booleanValue(this.inTargetInsertOrExistsDb, false);
    }

    public void setInTargetInsertOrExists(boolean inTargetInsertOrExists) {
        this.inTargetInsertOrExistsDb = inTargetInsertOrExists ? "T" : "F";
    }

    public String getGrouperSyncId() {
        return this.grouperSyncId;
    }

    public void setGrouperSyncId(String grouperSyncId1) {
        this.grouperSyncId = grouperSyncId1;
        if (this.grouperSync == null || !GrouperClientUtils.equals(this.grouperSync.getId(), grouperSyncId1)) {
            this.grouperSync = null;
        }
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated1) {
        this.lastUpdated = lastUpdated1;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId1) {
        this.groupId = groupId1;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName1) {
        this.groupName = groupName1;
    }

    public String getProvisionableDb() {
        return this.provisionableDb;
    }

    public void setProvisionableDb(String provisionableDb1) {
        this.provisionableDb = provisionableDb1;
    }

    public boolean isProvisionable() {
        return GrouperClientUtils.booleanValue(this.provisionableDb, false);
    }

    public void setProvisionable(boolean provisionable) {
        this.provisionableDb = provisionable ? "T" : "F";
    }

    public Timestamp getProvisionableStart() {
        return this.provisionableStart;
    }

    public void setProvisionableStart(Timestamp provisionableStartMillis1) {
        this.provisionableStart = provisionableStartMillis1;
    }

    public Timestamp getInTargetStart() {
        return this.inTargetStart;
    }

    public void setInTargetStart(Timestamp inTargetStart1) {
        this.inTargetStart = inTargetStart1;
    }

    public Timestamp getInTargetEnd() {
        return this.inTargetEnd;
    }

    public void setInTargetEnd(Timestamp inTargetEnd1) {
        this.inTargetEnd = inTargetEnd1;
    }

    public Timestamp getProvisionableEnd() {
        return this.provisionableEnd;
    }

    public void setProvisionableEnd(Timestamp provisionableEndMillis1) {
        this.provisionableEnd = provisionableEndMillis1;
    }

    public Long getGroupIdIndex() {
        return this.groupIdIndex;
    }

    public void setGroupIdIndex(Long groupIdIndex1) {
        this.groupIdIndex = groupIdIndex1;
    }

    public String getGroupAttributeValueCache0() {
        return this.groupAttributeValueCache0;
    }

    public void setGroupAttributeValueCache0(String groupAttributeValueCache0_1) {
        this.groupAttributeValueCache0 = groupAttributeValueCache0_1;
    }

    public String getGroupAttributeValueCache1() {
        return this.groupAttributeValueCache1;
    }

    public void setGroupAttributeValueCache1(String groupAttributeValueCache1_1) {
        this.groupAttributeValueCache1 = groupAttributeValueCache1_1;
    }

    public String getGroupAttributeValueCache2() {
        return this.groupAttributeValueCache2;
    }

    public void setGroupAttributeValueCache2(String groupAttributeValueCache2_1) {
        this.groupAttributeValueCache2 = groupAttributeValueCache2_1;
    }

    public String getGroupAttributeValueCache3() {
        return this.groupAttributeValueCache3;
    }

    public void setGroupAttributeValueCache3(String groupAttributeValueCache3_1) {
        this.groupAttributeValueCache3 = groupAttributeValueCache3_1;
    }

    @Override
    public boolean gcSqlAssignNewPrimaryKeyForInsert() {
        if (this.id != null) {
            return false;
        }
        this.id = GrouperClientUtils.uuid();
        return true;
    }

    public void assignField(String syncField, Object result) {
        if (GrouperClientUtils.equals("groupAttributeValueCache0", syncField)) {
            this.setGroupAttributeValueCache0(GrouperClientUtils.stringValue(result));
        } else if (GrouperClientUtils.equals("groupAttributeValueCache1", syncField)) {
            this.setGroupAttributeValueCache1(GrouperClientUtils.stringValue(result));
        } else if (GrouperClientUtils.equals("groupAttributeValueCache2", syncField)) {
            this.setGroupAttributeValueCache2(GrouperClientUtils.stringValue(result));
        } else if (GrouperClientUtils.equals("groupAttributeValueCache3", syncField)) {
            this.setGroupAttributeValueCache3(GrouperClientUtils.stringValue(result));
        } else {
            throw new RuntimeException("Not expecting groupSyncField: '" + syncField + "'");
        }
    }

    public String retrieveField(String syncField) {
        if (GrouperClientUtils.equals("groupAttributeValueCache0", syncField)) {
            return this.getGroupAttributeValueCache0();
        }
        if (GrouperClientUtils.equals("groupAttributeValueCache1", syncField)) {
            return this.getGroupAttributeValueCache1();
        }
        if (GrouperClientUtils.equals("groupAttributeValueCache2", syncField)) {
            return this.getGroupAttributeValueCache2();
        }
        if (GrouperClientUtils.equals("groupAttributeValueCache3", syncField)) {
            return this.getGroupAttributeValueCache3();
        }
        throw new RuntimeException("Not expecting groupSyncField: '" + syncField + "'");
    }
}

