/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GcQueryReport {
    private String query;
    private long cumulativeTimeMillis;
    private int numberOfExecutions;
    private Long shortestExecutionTimeMillis;
    private Long longestExecutionTimeMillis;

    public static void reportToFile(String fileLocation, Map<String, GcQueryReport> queryReports) {
        StringBuilder contents = new StringBuilder("QUERY,CUMULATIVE_TIME_MILLIS,MM:SS:MI,NUM_EXECUTIONS,AVG_EXECUTION_MILLIS,SHORT_MILLIS,LONG_MILLIS,CONNECTION\n");
        for (GcQueryReport queryReport : queryReports.values()) {
            contents.append("\"" + queryReport.getQuery() + "\"," + queryReport.getCumulativeTimeMillis() + "," + queryReport.cumulativeTimeMillisHumanReadable() + "," + queryReport.getNumberOfExecutions() + "," + queryReport.getCumulativeTimeMillis() / (long)queryReport.getNumberOfExecutions() + "," + queryReport.getShortestExecutionTimeMillis() + "\n");
        }
        File file = new File(fileLocation);
        GrouperClientUtils.saveStringIntoFile(file, contents.toString());
    }

    public void addExecutionTime(long millis) {
        ++this.numberOfExecutions;
        this.cumulativeTimeMillis += millis;
        if (this.getShortestExecutionTimeMillis() == null || millis < this.getShortestExecutionTimeMillis()) {
            this.setShortestExecutionTimeMillis(millis);
        }
        if (this.getLongestExecutionTimeMillis() == null || millis > this.getLongestExecutionTimeMillis()) {
            this.setLongestExecutionTimeMillis(millis);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String _query) {
        this.query = _query;
    }

    public Long getCumulativeTimeMillis() {
        return this.cumulativeTimeMillis;
    }

    public void setCumulativeTime(Long _cumulativeTimeMillis) {
        this.cumulativeTimeMillis = _cumulativeTimeMillis;
    }

    public int getNumberOfExecutions() {
        return this.numberOfExecutions;
    }

    public void setNumberOfExecutions(int _numberOfExecutions) {
        this.numberOfExecutions = _numberOfExecutions;
    }

    private Long getShortestExecutionTimeMillis() {
        return this.shortestExecutionTimeMillis;
    }

    private void setShortestExecutionTimeMillis(Long _shortestExecutionTimeMillis) {
        this.shortestExecutionTimeMillis = _shortestExecutionTimeMillis;
    }

    private Long getLongestExecutionTimeMillis() {
        return this.longestExecutionTimeMillis;
    }

    private void setLongestExecutionTimeMillis(Long _longestExecutionTimeMillis) {
        this.longestExecutionTimeMillis = _longestExecutionTimeMillis;
    }

    private String cumulativeTimeMillisHumanReadable() {
        Long millis = this.getCumulativeTimeMillis();
        if (this.getCumulativeTimeMillis() < 1000L) {
            return "00:00." + this.getCumulativeTimeMillis();
        }
        if (this.getCumulativeTimeMillis() < 60000L) {
            return "00:" + this.getCumulativeTimeMillis() / 60L + ".00";
        }
        return String.format("%d:%d.00", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

