/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcBoundDataConversion;
import edu.internet2.middleware.grouperClient.jdbc.GcBoundDataConversionImpl;
import edu.internet2.middleware.grouperClient.jdbc.GcCallableStatementCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcCaseIgnoreHashMap;
import edu.internet2.middleware.grouperClient.jdbc.GcConnectionCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcDbQueryCache;
import edu.internet2.middleware.grouperClient.jdbc.GcDbQueryCacheMap;
import edu.internet2.middleware.grouperClient.jdbc.GcDbVersionable;
import edu.internet2.middleware.grouperClient.jdbc.GcEntityCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcPreparedStatementCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcQueryReport;
import edu.internet2.middleware.grouperClient.jdbc.GcResultSetCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.GcTransactionCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcTransactionEnd;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import edu.internet2.middleware.morphString.Morph;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GcDbAccess {
    private static boolean grouperIsStarted = false;
    private static Map<MultiKey, GcDbQueryCache> dbQueryCacheMap = new GcDbQueryCacheMap();
    private Integer cacheMinutes;
    private static boolean accumulateQueryMillis;
    private static Map<String, GcQueryReport> queriesAndMillis;
    private Integer queryTimeoutSeconds;
    private List<Object> bindVars;
    private List<List<Object>> batchBindVars;
    private int batchSize = -1;
    private static InheritableThreadLocal<Integer> queryCount;
    private String sql;
    private String tableName;
    private List<Object> primaryKeys;
    private String connectionName;
    private Connection connection;
    private Object example;
    private boolean omitNullValuesForExample;
    private int numberOfRowsAffected;
    private int[] numberOfBatchRowsAffected;
    private static GcBoundDataConversion boundDataConversion;
    private static boolean dbConnectionClassesRegistered;
    private static final Log LOG;
    private static ThreadLocal<Map<String, Connection>> connectionThreadLocal;
    private static ThreadLocal<Boolean> transactionThreadLocal;
    private Map<String, Integer> resultSetMetadataColumnNameLowerToIndex = null;
    private ResultSetMetaData resultSetMetaData;

    public static boolean isGrouperIsStarted() {
        return grouperIsStarted;
    }

    public static void setGrouperIsStarted(boolean theGrouperIsStarted) {
        grouperIsStarted = theGrouperIsStarted;
    }

    public GcDbAccess batchSize(int theBatchSize) {
        this.batchSize = theBatchSize;
        return this;
    }

    public static void threadLocalQueryCountReset() {
        queryCount.set(0);
    }

    public static int threadLocalQueryCountRetrieve() {
        Integer queryCountInteger = (Integer)queryCount.get();
        return queryCountInteger == null ? 0 : queryCountInteger;
    }

    public static synchronized void threadLocalQueryCountIncrement(int queriesToAdd) {
        Integer queryCountInteger = (Integer)queryCount.get();
        queryCount.set((queryCountInteger == null ? 0 : queryCountInteger) + queriesToAdd);
    }

    public GcDbAccess tableName(String theTableName) {
        this.tableName = theTableName;
        return this;
    }

    private String tableName(Class<?> theClass) {
        if (!GrouperClientUtils.isBlank(this.tableName)) {
            return this.tableName;
        }
        return GcPersistableHelper.tableName(theClass);
    }

    public GcDbAccess connectionName(String theConnectionName) {
        this.connectionName = theConnectionName;
        return this;
    }

    public static void transactionEnd(GcTransactionEnd transactionEnd, boolean endOnlyIfStarted) {
        GcDbAccess.transactionEnd(transactionEnd, endOnlyIfStarted, null);
    }

    public static void transactionEnd(GcTransactionEnd transactionEnd, boolean endOnlyIfStarted, String connectionName) {
        ConnectionBean connectionBean = GcDbAccess.connection(false, false, connectionName);
        Connection connection = connectionBean.getConnection();
        if (connection == null) {
            throw new RuntimeException("There is no connection!");
        }
        ConnectionBean.transactionEnd(connectionBean, transactionEnd, endOnlyIfStarted, true, false);
    }

    public static void loadBoundDataConversion(GcBoundDataConversion _boundDataConversion) {
        boundDataConversion = _boundDataConversion;
    }

    public static String createInString(int numberOfBindVariables) {
        StringBuilder results = new StringBuilder(" (");
        for (int i = 0; i < numberOfBindVariables; ++i) {
            results.append("?,");
        }
        GrouperClientUtils.removeEnd(results, ",");
        results.append(") ");
        return results.toString();
    }

    public GcDbAccess bindVars(Object ... _bindVars) {
        this.bindVars = new ArrayList<Object>();
        for (Object bindVar : _bindVars) {
            if (bindVar instanceof List) {
                List arrayData = (List)bindVar;
                for (Object value : arrayData) {
                    this.bindVars.add(value);
                }
                continue;
            }
            this.bindVars.add(bindVar);
        }
        return this;
    }

    public GcDbAccess addBindVar(Object _bindVar) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList<Object>();
        }
        this.bindVars.add(_bindVar);
        return this;
    }

    public GcDbAccess addBindVars(Collection<?> _bindVar) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList<Object>();
        }
        this.bindVars.addAll(_bindVar);
        return this;
    }

    public GcDbAccess batchBindVars(List<List<Object>> _batchBindVars) {
        this.batchBindVars = _batchBindVars;
        return this;
    }

    public GcDbAccess cacheMinutes(Integer _cacheMinutes) {
        this.cacheMinutes = _cacheMinutes;
        return this;
    }

    public GcDbAccess sql(String _sql) {
        this.sql = _sql;
        return this;
    }

    public GcDbAccess omitNullValuesForExample() {
        this.omitNullValuesForExample = true;
        return this;
    }

    public GcDbAccess example(Object _example) {
        this.example = _example;
        return this;
    }

    public GcDbAccess queryTimeoutSeconds(Integer _queryTimeoutSeconds) {
        this.queryTimeoutSeconds = _queryTimeoutSeconds;
        return this;
    }

    public static void accumulateQueryMillis(boolean _accumulateQueryMillis) {
        if (_accumulateQueryMillis) {
            queriesAndMillis = new LinkedHashMap<String, GcQueryReport>();
        } else {
            queriesAndMillis.clear();
        }
        accumulateQueryMillis = _accumulateQueryMillis;
    }

    public static void reportQueriesAndMillisAndTurnOffAccumulation(String fileLocation) {
        if (!accumulateQueryMillis) {
            throw new RuntimeException("accumulateQueryMillis must be set to true first!");
        }
        GcQueryReport.reportToFile(fileLocation, queriesAndMillis);
    }

    public GcDbAccess primaryKey(Object ... _primaryKey) {
        block3: {
            block2: {
                this.primaryKeys = new ArrayList<Object>();
                if (_primaryKey == null || _primaryKey.length != 1 || !(_primaryKey[0] instanceof List)) break block2;
                List arrayData = (List)_primaryKey[0];
                for (Object value : arrayData) {
                    this.primaryKeys.add(value);
                }
                break block3;
            }
            if (_primaryKey == null) break block3;
            for (Object primaryKey : _primaryKey) {
                this.primaryKeys.add(primaryKey);
            }
        }
        return this;
    }

    private void addQueryToQueriesAndMillis(String query, Long nanoTimeStarted) {
        if (!accumulateQueryMillis) {
            return;
        }
        GcQueryReport queryReport = queriesAndMillis.get(query);
        if (queryReport == null) {
            queryReport = new GcQueryReport();
            queryReport.setQuery(query);
            queriesAndMillis.put(query, queryReport);
        }
        queryReport.addExecutionTime((System.nanoTime() - nanoTimeStarted) / 1000000L);
    }

    public boolean isPreviouslyPersisted(Object o) {
        Field field = GcPersistableHelper.primaryKeyField(o.getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(o.getClass());
        if (field == null && compoundPrimaryKeys.size() == 0) {
            return false;
        }
        if (field != null) {
            Object fieldValue = null;
            try {
                fieldValue = field.get(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (fieldValue == null) {
                return false;
            }
            if (GcPersistableHelper.primaryKeyManuallyAssigned(field)) {
                Long startTime = System.nanoTime();
                String query = "select count(*) from " + this.tableName(o.getClass()) + " where " + GcPersistableHelper.columnName(field) + " =  ?";
                int count = new GcDbAccess().connectionName(this.connectionName).sql(query).bindVars(fieldValue).select(Integer.TYPE);
                this.addQueryToQueriesAndMillis(query, startTime);
                return count > 0;
            }
            if (fieldValue != null && fieldValue instanceof String) {
                return true;
            }
            try {
                Long theId = new Long(String.valueOf(fieldValue));
                return theId > 0L;
            }
            catch (Exception e) {
                throw new RuntimeException("Expected primary key field of numeric type but got " + field.getName() + " of type " + field.getClass() + ". You need to override isPreviouslyPersisted() or provide a Persistable annotation for your primary key!", e);
            }
        }
        if (compoundPrimaryKeys.size() > 0) {
            ArrayList<Object> theBindVariables = new ArrayList<Object>();
            String theSql = "select count(*) from " + this.tableName(o.getClass()) + " where ";
            for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                Object fieldValue = null;
                try {
                    fieldValue = compoundPrimaryKey.get(o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                theSql = theSql + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                theBindVariables.add(fieldValue);
            }
            theSql = theSql.substring(0, theSql.length() - 4);
            Long startTime = System.nanoTime();
            int count = new GcDbAccess().sql(theSql).bindVars(theBindVariables).select(Integer.TYPE);
            this.addQueryToQueriesAndMillis(theSql, startTime);
            return count > 0;
        }
        throw new RuntimeException("No primary key or compound primary keys specified!");
    }

    public void deleteFromDatabase(Object o) {
        if (!this.isPreviouslyPersisted(o) && !GcPersistableHelper.defaultUpdate(o.getClass())) {
            return;
        }
        Field primaryKeyField = GcPersistableHelper.primaryKeyField(o.getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(o.getClass());
        if (primaryKeyField == null && compoundPrimaryKeys.size() == 0) {
            throw new RuntimeException("Cannot delete a row with no primary key or compound primary keys - use sql to delete the row instead of the method deleteFromDatabase().");
        }
        if (primaryKeyField != null) {
            String primaryKeyColumnName = GcPersistableHelper.columnName(primaryKeyField);
            Object primaryKey = null;
            try {
                primaryKey = primaryKeyField.get(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String tableName = this.tableName(o.getClass());
            String sqlToUse = "delete from " + tableName + " where " + primaryKeyColumnName + " = ? ";
            this.sql(sqlToUse);
            this.bindVars(primaryKey);
            this.executeSql();
            if (o instanceof GcDbVersionable) {
                ((GcDbVersionable)o).dbVersionDelete();
            }
            return;
        }
        if (compoundPrimaryKeys.size() > 0) {
            ArrayList<Object> theBindVariables = new ArrayList<Object>();
            String theSql = "delete from " + this.tableName(o.getClass()) + " where ";
            for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                Object fieldValue = null;
                try {
                    fieldValue = compoundPrimaryKey.get(o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                theSql = theSql + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                theBindVariables.add(fieldValue);
            }
            theSql = theSql.substring(0, theSql.length() - 4);
            this.sql(theSql);
            this.bindVars(theBindVariables);
            this.executeSql();
        }
        if (o instanceof GcDbVersionable) {
            ((GcDbVersionable)o).dbVersionDelete();
        }
    }

    public <T> void storeListToDatabase(List<T> objects) {
        this.storeBatchToDatabase(objects, 200);
    }

    public <T> boolean storeToDatabase(T t) {
        if (t instanceof GcDbVersionable && !((GcDbVersionable)t).dbVersionDifferent()) {
            return false;
        }
        if (!GrouperClientUtils.isBlank(this.sql)) {
            throw new RuntimeException("Cannot use both sql and set an object to store.");
        }
        HashMap<String, Object> columnNamesAndValues = new HashMap<String, Object>();
        Field primaryKey = GcPersistableHelper.primaryKeyField(t.getClass());
        boolean defaultUpdate = GcPersistableHelper.defaultUpdate(t.getClass());
        boolean previouslyPersisted = false;
        try {
            boolean keepPrimaryKeyColumns;
            previouslyPersisted = defaultUpdate ? true : this.isPreviouslyPersisted(t);
            boolean bl = keepPrimaryKeyColumns = t instanceof GcSqlAssignPrimaryKey && !previouslyPersisted;
            if (keepPrimaryKeyColumns) {
                ((GcSqlAssignPrimaryKey)t).gcSqlAssignNewPrimaryKeyForInsert();
            }
            for (Field field : GcPersistableHelper.heirarchicalFields(t.getClass())) {
                field.setAccessible(true);
                if ((primaryKey != null || !GcPersistableHelper.isPersist(field, t.getClass())) && (!GcPersistableHelper.isPersist(field, t.getClass()) || !keepPrimaryKeyColumns && !GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) && GcPersistableHelper.isPrimaryKey(field))) continue;
                columnNamesAndValues.put(GcPersistableHelper.columnName(field), field.get(t));
            }
            if (defaultUpdate) {
                try {
                    int records = this.storeToDatabaseUpdateHelper(t, columnNamesAndValues, primaryKey);
                    if (records == 0) {
                        throw new RuntimeException("");
                    }
                }
                catch (RuntimeException re) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Error trying to update a defaultUpdate record: " + t, re);
                    }
                    this.storeToDatabaseInsertHelper(t, columnNamesAndValues, primaryKey, keepPrimaryKeyColumns);
                }
            } else if (previouslyPersisted) {
                this.storeToDatabaseUpdateHelper(t, columnNamesAndValues, primaryKey);
            } else {
                this.storeToDatabaseInsertHelper(t, columnNamesAndValues, primaryKey, keepPrimaryKeyColumns);
            }
            if (t instanceof GcDbVersionable) {
                ((GcDbVersionable)t).dbVersionReset();
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void storeToDatabaseInsertHelper(T t, Map<String, Object> columnNamesAndValues, Field primaryKey, boolean keepPrimaryKeyColumns) {
        Object primaryKeyValue = null;
        ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
        StringBuilder sqlToUse = new StringBuilder();
        try {
            sqlToUse.append(" insert into ").append(this.tableName(t.getClass())).append(" ( ");
            StringBuilder bindVarString = new StringBuilder("values (");
            for (String columnName : columnNamesAndValues.keySet()) {
                sqlToUse.append(columnName + ",");
                bindVarString.append("?,");
                bindVarstoUse.add(columnNamesAndValues.get(columnName));
            }
            if (!(keepPrimaryKeyColumns || primaryKey == null || GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) || GcPersistableHelper.findPersistableClassAnnotation(t.getClass()).hasNoPrimaryKey())) {
                sqlToUse.append(GcPersistableHelper.columnName(primaryKey));
                sqlToUse.append(") ");
                primaryKeyValue = new GcDbAccess().sql(" select " + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval from dual").select(primaryKey.getType());
                bindVarstoUse.add(primaryKeyValue);
                bindVarString.append("?) ");
            } else {
                sqlToUse = new StringBuilder(GrouperClientUtils.removeEnd(sqlToUse.toString(), ",") + ") ");
                bindVarString = new StringBuilder(GrouperClientUtils.removeEnd(bindVarString.toString(), ",") + ") ");
            }
            sqlToUse.append((CharSequence)bindVarString);
            this.sql(sqlToUse.toString());
            this.bindVars(bindVarstoUse);
            this.executeSql();
            if (primaryKeyValue != null) {
                boundDataConversion.setFieldValue(t, primaryKey, primaryKeyValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> int storeToDatabaseUpdateHelper(T t, Map<String, Object> columnNamesAndValues, Field primaryKey) {
        ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(t.getClass());
        try {
            boolean keepPrimaryKeyColumns;
            boolean previouslyPersisted = this.isPreviouslyPersisted(t);
            boolean bl = keepPrimaryKeyColumns = t instanceof GcSqlAssignPrimaryKey && !previouslyPersisted;
            if (keepPrimaryKeyColumns) {
                ((GcSqlAssignPrimaryKey)t).gcSqlAssignNewPrimaryKeyForInsert();
            }
            for (Field field : GcPersistableHelper.heirarchicalFields(t.getClass())) {
                field.setAccessible(true);
                if ((primaryKey != null || !GcPersistableHelper.isPersist(field, t.getClass())) && (!GcPersistableHelper.isPersist(field, t.getClass()) || !keepPrimaryKeyColumns && !GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) && GcPersistableHelper.isPrimaryKey(field))) continue;
                columnNamesAndValues.put(GcPersistableHelper.columnName(field), field.get(t));
            }
            StringBuilder sqlToUse = new StringBuilder();
            sqlToUse.append(" update ").append(this.tableName(t.getClass())).append(" set ");
            for (String columnName : columnNamesAndValues.keySet()) {
                sqlToUse.append(" ").append(columnName).append(" = ?, ");
                bindVarstoUse.add(columnNamesAndValues.get(columnName));
            }
            sqlToUse = new StringBuilder(GrouperClientUtils.removeEnd(sqlToUse.toString(), ", "));
            if (primaryKey != null) {
                sqlToUse.append(" where ").append(GcPersistableHelper.columnName(primaryKey)).append(" = ? ");
                bindVarstoUse.add(primaryKey.get(t));
            } else if (compoundPrimaryKeys.size() > 0) {
                sqlToUse.append(" where ");
                for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                    Object fieldValue = null;
                    try {
                        fieldValue = compoundPrimaryKey.get(t);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    sqlToUse.append(GcPersistableHelper.columnName(compoundPrimaryKey)).append(" = ? and ");
                    bindVarstoUse.add(fieldValue);
                }
                sqlToUse = new StringBuilder(sqlToUse.substring(0, sqlToUse.length() - 4));
            }
            this.sql(sqlToUse.toString());
            this.bindVars(bindVarstoUse);
            return this.executeSql();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> int storeBatchToDatabase(List<T> objects, int batchSize) {
        return this.storeBatchToDatabase(objects, batchSize, false);
    }

    public <T> int storeBatchToDatabase(List<T> objects, int batchSize, boolean omitPrimaryKeyPopulation) {
        if (objects == null || objects.size() == 0) {
            return 0;
        }
        if (GrouperClientUtils.length(objects) > 0) {
            ArrayList<T> newList = new ArrayList<T>();
            for (T t : objects) {
                if (t instanceof GcDbVersionable) {
                    if (!((GcDbVersionable)t).dbVersionDifferent()) continue;
                    newList.add(t);
                    continue;
                }
                newList.add(t);
            }
            objects = newList;
        }
        if (objects == null || objects.size() == 0) {
            return 0;
        }
        if (objects.iterator().next() instanceof GcSqlAssignPrimaryKey) {
            ArrayList<T> objectsToInsert = new ArrayList<T>();
            ArrayList<T> objectsToUpdate = new ArrayList<T>();
            int changes = 0;
            Field primaryKey = GcPersistableHelper.primaryKeyField(objects.get(0).getClass());
            for (T t : objects) {
                boolean isInsert;
                Object primaryKeyValue = GrouperClientUtils.fieldValue(primaryKey, t);
                boolean bl = isInsert = primaryKeyValue == null;
                if (isInsert) {
                    objectsToInsert.add(t);
                    continue;
                }
                objectsToUpdate.add(t);
            }
            if (objectsToInsert.size() > 0) {
                changes += this.storeBatchToDatabaseHelper(objectsToInsert, batchSize, omitPrimaryKeyPopulation);
            }
            if (objectsToUpdate.size() > 0) {
                changes += this.storeBatchToDatabaseHelper(objectsToUpdate, batchSize, omitPrimaryKeyPopulation);
            }
            return changes;
        }
        return this.storeBatchToDatabaseHelper(objects, batchSize, omitPrimaryKeyPopulation);
    }

    private <T> int storeBatchToDatabaseHelper(List<T> objects, final int batchSize, final boolean omitPrimaryKeyPopulation) {
        final List<T> OBJECTS = objects;
        final ArrayList objectsToStore = new ArrayList();
        final ArrayList objectsToReturn = new ArrayList();
        this.callbackTransaction(new GcTransactionCallback<Boolean>(){

            @Override
            public Boolean callback(GcDbAccess dbAccessForStorage) {
                for (int i = 0; i < OBJECTS.size(); ++i) {
                    objectsToStore.add(OBJECTS.get(i));
                    if (objectsToStore.size() < batchSize && i != OBJECTS.size() - 1) continue;
                    dbAccessForStorage.storeBatchToDatabase(objectsToStore, omitPrimaryKeyPopulation);
                    objectsToReturn.addAll(objectsToStore);
                    objectsToStore.clear();
                }
                return null;
            }
        });
        int existingLength = objects.size();
        objects.clear();
        objects.addAll(objectsToReturn);
        if (objects.size() != existingLength) {
            throw new RuntimeException("There should have been " + existingLength + " objects returned but there are only " + objects.size() + "!");
        }
        return objects.size();
    }

    private <T> void storeBatchToDatabase(List<T> objects) {
        this.storeBatchToDatabase(objects, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void storeBatchToDatabase(List<T> objects, boolean omitPrimaryKeyPopulation) {
        if (GrouperClientUtils.length(objects) > 0 && GcPersistableHelper.defaultUpdate(objects.get(0).getClass())) {
            RuntimeException runtimeException = null;
            try {
                this.storeBatchToDatabaseHelper(objects, omitPrimaryKeyPopulation);
                return;
            }
            catch (RuntimeException re) {
                for (T object : objects) {
                    try {
                        this.storeToDatabase(object);
                    }
                    catch (RuntimeException re2) {
                        LOG.error("error storing objects", re2);
                        runtimeException = re2;
                    }
                }
                if (runtimeException == null) return;
                throw runtimeException;
            }
        } else {
            this.storeBatchToDatabaseHelper(objects, omitPrimaryKeyPopulation);
        }
    }

    private <T> void storeBatchToDatabaseHelper(List<T> objects, boolean omitPrimaryKeyPopulation) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        String insertSql = null;
        String updateSql = null;
        boolean updateSqlInitialized = false;
        boolean insertSqlInitialized = false;
        if (!GrouperClientUtils.isBlank(this.sql)) {
            throw new RuntimeException("Cannot use both sql and set objects to store.");
        }
        Field primaryKey = GcPersistableHelper.primaryKeyField(objects.get(0).getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(objects.get(0).getClass());
        List<Field> allFields = GcPersistableHelper.heirarchicalFields(objects.get(0).getClass());
        HashMap<Field, Boolean> fieldAndIncludeStatuses = new HashMap<Field, Boolean>();
        for (Field field : allFields) {
            boolean primaryKeyManuallyAssignedOrNotPrimaryKey;
            field.setAccessible(true);
            boolean persistField = GcPersistableHelper.isPersist(field, objects.get(0).getClass());
            boolean primaryKeyNullAndPersistField = primaryKey == null && persistField;
            boolean bl = primaryKeyManuallyAssignedOrNotPrimaryKey = objects.get(0) instanceof GcSqlAssignPrimaryKey || GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) || !GcPersistableHelper.isPrimaryKey(field);
            if (primaryKeyNullAndPersistField || persistField && primaryKeyManuallyAssignedOrNotPrimaryKey) {
                fieldAndIncludeStatuses.put(field, true);
                continue;
            }
            fieldAndIncludeStatuses.put(field, false);
        }
        try {
            ArrayList<List<Object>> listsOfBindVars = new ArrayList<List<Object>>();
            HashMap indexOfObjectAndPrimaryKeyToSet = new HashMap();
            int objectIndex = 0;
            for (T object : objects) {
                Object primaryKeyValue;
                HashMap<String, Object> columnNamesAndValues = new HashMap<String, Object>();
                boolean gcSqlAssignPrimaryKey = false;
                Boolean isInsert = null;
                if (object instanceof GcSqlAssignPrimaryKey && (isInsert = Boolean.valueOf((primaryKeyValue = primaryKey.get(object)) == null)).booleanValue()) {
                    ((GcSqlAssignPrimaryKey)object).gcSqlAssignNewPrimaryKeyForInsert();
                    gcSqlAssignPrimaryKey = true;
                }
                primaryKeyValue = allFields.iterator();
                while (primaryKeyValue.hasNext()) {
                    Field field = (Field)primaryKeyValue.next();
                    if (!((Boolean)fieldAndIncludeStatuses.get(field)).booleanValue()) continue;
                    columnNamesAndValues.put(GcPersistableHelper.columnName(field), field.get(object));
                }
                ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
                Boolean isUpdate = null;
                isUpdate = isInsert != null ? Boolean.valueOf(isInsert == false) : Boolean.valueOf(this.isPreviouslyPersisted(object));
                if (isUpdate.booleanValue()) {
                    if (!updateSqlInitialized) {
                        updateSql = " update " + this.tableName(object.getClass()) + " set ";
                        for (String string : columnNamesAndValues.keySet()) {
                            updateSql = updateSql + " " + string + " = ?, ";
                        }
                        updateSql = GrouperClientUtils.removeEnd(updateSql, ", ");
                    }
                    for (String string : columnNamesAndValues.keySet()) {
                        bindVarstoUse.add(columnNamesAndValues.get(string));
                    }
                    if (primaryKey != null) {
                        if (!updateSqlInitialized) {
                            updateSql = updateSql + " where " + GcPersistableHelper.columnName(primaryKey) + " = ? ";
                        }
                        bindVarstoUse.add(primaryKey.get(object));
                    } else if (compoundPrimaryKeys.size() > 0) {
                        if (!updateSqlInitialized) {
                            updateSql = updateSql + " where ";
                        }
                        for (Field field : compoundPrimaryKeys) {
                            Object fieldValue = null;
                            try {
                                fieldValue = field.get(object);
                                bindVarstoUse.add(fieldValue);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (updateSqlInitialized) continue;
                            updateSql = updateSql + GcPersistableHelper.columnName(field) + " = ? and ";
                        }
                        if (!updateSqlInitialized) {
                            updateSql = updateSql.substring(0, updateSql.length() - 4);
                        }
                    }
                    updateSqlInitialized = true;
                    listsOfBindVars.add(bindVarstoUse);
                } else {
                    String bindVarString = "";
                    if (!insertSqlInitialized) {
                        insertSql = " insert into " + this.tableName(object.getClass()) + " ( ";
                        bindVarString = "values (";
                        for (String columnName : columnNamesAndValues.keySet()) {
                            insertSql = insertSql + columnName + ",";
                            bindVarString = bindVarString + "?,";
                        }
                    }
                    for (String columnName : columnNamesAndValues.keySet()) {
                        bindVarstoUse.add(columnNamesAndValues.get(columnName));
                    }
                    if (!(gcSqlAssignPrimaryKey || primaryKey == null || GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) || GcPersistableHelper.findPersistableClassAnnotation(object.getClass()).hasNoPrimaryKey())) {
                        if (!insertSqlInitialized) {
                            insertSql = insertSql + GcPersistableHelper.columnName(primaryKey);
                            insertSql = insertSql + ") ";
                            bindVarString = !omitPrimaryKeyPopulation ? bindVarString + "?) " : bindVarString + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval) ";
                        }
                        if (!omitPrimaryKeyPopulation) {
                            Object obj = new GcDbAccess().sql(" select " + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval from dual").select(primaryKey.getType().getClass());
                            bindVarstoUse.add(obj);
                            indexOfObjectAndPrimaryKeyToSet.put(objectIndex, obj);
                        }
                    } else if (!insertSqlInitialized) {
                        insertSql = GrouperClientUtils.removeEnd(insertSql, ",") + ") ";
                        bindVarString = GrouperClientUtils.removeEnd(bindVarString, ",") + ") ";
                    }
                    if (!insertSqlInitialized) {
                        insertSql = insertSql + bindVarString;
                    }
                    insertSqlInitialized = true;
                    listsOfBindVars.add(bindVarstoUse);
                }
                ++objectIndex;
            }
            if (updateSql != null && insertSql != null) {
                throw new RuntimeException("It is not possible to mix updates and inserts in one batch; Statement supports it but not with bind variables so we do not support it.");
            }
            if (updateSql == null && insertSql == null) {
                throw new RuntimeException("No sql was created!");
            }
            this.batchBindVars(listsOfBindVars);
            this.sql(updateSql != null ? updateSql : insertSql);
            this.executeBatchSql();
            this.sql(null);
            this.batchBindVars(null);
            for (Integer objectIndexInList : indexOfObjectAndPrimaryKeyToSet.keySet()) {
                boundDataConversion.setFieldValue(objects.get(objectIndexInList), primaryKey, indexOfObjectAndPrimaryKeyToSet.get(objectIndexInList));
            }
            for (Object t : objects) {
                if (!(t instanceof GcDbVersionable)) continue;
                ((GcDbVersionable)t).dbVersionReset();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void callbackEntity(Class<T> clazz, GcEntityCallback<T> entityCallback) {
        this.selectList(clazz, entityCallback);
    }

    public <T> T callbackTransaction(GcTransactionCallback<T> transactionCallback) {
        T t;
        long startNanos = System.nanoTime();
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(true, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            T t2 = transactionCallback.callback(this);
            ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.commit, true, true, true);
            t = t2;
        }
        catch (Exception e) {
            try {
                ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.rollback, true, true, true);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConnectionBean.closeIfStarted(connectionBean);
                GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
                throw throwable;
            }
        }
        ConnectionBean.closeIfStarted(connectionBean);
        GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
        return t;
    }

    public <K, V> Map<K, V> selectMap(Class<K> keyClass, Class<V> valueClass) {
        List<Map> list = this.selectList(Map.class);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("Only one object expected but " + list.size() + " were returned for sql " + this.sql);
        }
        if (keyClass.equals(String.class)) {
            GcCaseIgnoreHashMap mapToReturn = new GcCaseIgnoreHashMap();
            for (Object key : list.get(0).keySet()) {
                mapToReturn.put(String.valueOf(key), boundDataConversion.getFieldValue(valueClass, list.get(0).get(key)));
            }
            return mapToReturn;
        }
        HashMap mapToReturn = new HashMap();
        for (Object key : list.get(0).keySet()) {
            mapToReturn.put(key, boundDataConversion.getFieldValue(valueClass, list.get(0).get(key)));
        }
        return mapToReturn;
    }

    public <K, V> Map<K, V> selectMapMultipleRows(Class<K> keyClass, Class<V> valueClass) {
        List<Map> list = this.selectList(Map.class);
        if (list.size() == 0) {
            return null;
        }
        Iterator columnNames = list.get(0).keySet().iterator();
        Object keyName = columnNames.next();
        Object valueName = columnNames.next();
        HashMap mapToReturn = new HashMap();
        for (Map theMap : list) {
            mapToReturn.put(theMap.get(keyName), boundDataConversion.getFieldValue(valueClass, theMap.get(valueName)));
        }
        return mapToReturn;
    }

    public List<GcCaseIgnoreHashMap> selectListMap() {
        List<Map> list = this.selectList(Map.class);
        ArrayList<GcCaseIgnoreHashMap> newList = new ArrayList<GcCaseIgnoreHashMap>();
        for (Map map : list) {
            GcCaseIgnoreHashMap mapToReturn = new GcCaseIgnoreHashMap();
            mapToReturn.putAll(map);
            newList.add(mapToReturn);
        }
        return newList;
    }

    public GcCaseIgnoreHashMap selectMapMultipleColumnsOneRow() {
        List<GcCaseIgnoreHashMap> caseIgnoreHashMaps = this.selectListMap();
        if (caseIgnoreHashMaps.size() > 1) {
            throw new RuntimeException("More than one row was returned for query " + this.sql);
        }
        if (caseIgnoreHashMaps.size() == 1) {
            return caseIgnoreHashMaps.get(0);
        }
        return null;
    }

    public <T> T select(Class<T> clazz) {
        Object cachedObject;
        if (this.cacheMinutes != null && (cachedObject = this.selectFromQueryCache(false, clazz)) != null) {
            return (T)cachedObject;
        }
        List<T> list = this.selectList(clazz, true);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("Only one object expected but " + list.size() + " were returned for sql " + this.sql);
        }
        if (this.cacheMinutes != null) {
            this.populateQueryCache(clazz, list.get(0), false);
        }
        return list.get(0);
    }

    public <T> List<T> selectList(Class<T> clazz) {
        return this.selectList(clazz, false);
    }

    private <T> List<T> selectList(Class<T> clazz, boolean calledFromSelect) {
        Object cachedObject;
        if (!calledFromSelect && this.cacheMinutes != null && (cachedObject = this.selectFromQueryCache(true, clazz)) != null) {
            return (List)cachedObject;
        }
        List<T> resultList = this.selectList(clazz, null);
        if (!calledFromSelect && this.cacheMinutes != null) {
            this.populateQueryCache(clazz, resultList, true);
        }
        return resultList;
    }

    private <T> List<T> selectList(final Class<T> clazz, final GcEntityCallback<T> entityCallback) {
        if (this.primaryKeys != null && (this.sql != null || this.example != null) || this.sql != null && (this.primaryKeys != null || this.example != null) || this.example != null && (this.primaryKeys != null || this.sql != null)) {
            throw new RuntimeException("Set sql(), primaryKey(), or example() but not more than one! primaryKey() will formulate sql.");
        }
        ArrayList<String> columnNamesList = new ArrayList<String>();
        for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
            if (!GcPersistableHelper.isSelect(field, clazz)) continue;
            String columnName = GcPersistableHelper.columnName(field);
            columnNamesList.add(columnName);
        }
        String columnNames = GrouperClientUtils.join(columnNamesList.iterator(), ",");
        if (this.primaryKeys != null) {
            if (this.bindVars != null) {
                throw new RuntimeException("Set bindVars() or primaryKey() but not both! primaryKey() will formulate sql.");
            }
            Field primaryKeyField = GcPersistableHelper.primaryKeyField(clazz);
            String theSql = " select " + columnNames + " from " + this.tableName(clazz) + " where " + GcPersistableHelper.columnName(primaryKeyField);
            if (this.primaryKeys.size() == 1) {
                theSql = theSql + " = ? ";
                this.bindVars(this.primaryKeys.get(0));
            } else if (this.primaryKeys.size() > 1) {
                theSql = theSql + " in (";
                for (int i = 0; i < this.primaryKeys.size(); ++i) {
                    theSql = theSql + "?,";
                }
                theSql = GrouperClientUtils.removeEnd(theSql, ",") + ")";
                this.bindVars(this.primaryKeys);
            }
            this.sql(theSql);
        } else if (this.sql == null && this.example == null) {
            this.sql(" select " + columnNames + " from " + this.tableName(clazz));
        } else if (this.example != null) {
            String theSql = " select * from " + this.tableName(clazz) + " where ";
            String whereClauseToUse = "";
            ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                field.setAccessible(true);
                try {
                    if (!GcPersistableHelper.isSelect(field, clazz) || GcPersistableHelper.isPrimaryKey(field)) continue;
                    Object fieldValue = field.get(this.example);
                    if (this.omitNullValuesForExample && fieldValue == null) continue;
                    String columnName = "";
                    if (field.getType().equals(String.class)) {
                        columnName = "to_char(" + GcPersistableHelper.columnName(field) + ")";
                        if (fieldValue != null) {
                            bindVarstoUse.add(fieldValue);
                        }
                    } else if (field.getType().equals(Date.class)) {
                        columnName = "to_char(" + GcPersistableHelper.columnName(field) + ", 'MM/DD/YYYY HH24:MI:SS')";
                        if (fieldValue != null) {
                            bindVarstoUse.add(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format((Date)fieldValue));
                        }
                    } else {
                        columnName = GcPersistableHelper.columnName(field);
                        if (fieldValue != null) {
                            bindVarstoUse.add(fieldValue);
                        }
                    }
                    String bindOrEquals = fieldValue == null ? " is null and " : " = ? and ";
                    whereClauseToUse = whereClauseToUse + columnName + bindOrEquals;
                }
                catch (Exception e) {
                    throw new RuntimeException("Issues encountered trying to read field " + field.getName() + " in class " + this.example.getClass(), e);
                }
            }
            whereClauseToUse = GrouperClientUtils.removeEnd(whereClauseToUse, "and ");
            theSql = theSql + whereClauseToUse;
            this.sql(theSql);
            this.bindVars(bindVarstoUse);
        }
        Long startTime = System.nanoTime();
        String sqlToRecord = this.sql;
        List list = (List)this.callbackResultSet(new GcResultSetCallback<List<T>>(){

            @Override
            public List<T> callback(ResultSet resultSet) throws Exception {
                ArrayList theList = new ArrayList();
                HashMap fieldIsIncludedInResults = new HashMap();
                while (resultSet.next()) {
                    if (entityCallback != null) {
                        Object t = GcDbAccess.this.addObjectToList(clazz, fieldIsIncludedInResults, resultSet, null);
                        boolean keepScrolling = entityCallback.callback(t);
                        if (keepScrolling) continue;
                        break;
                    }
                    GcDbAccess.this.addObjectToList(clazz, fieldIsIncludedInResults, resultSet, theList);
                }
                return theList;
            }
        });
        this.addQueryToQueriesAndMillis(sqlToRecord, startTime);
        for (Field t : GrouperClientUtils.nonNull(list)) {
            if (!(t instanceof GcDbVersionable)) continue;
            ((GcDbVersionable)((Object)t)).dbVersionReset();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ConnectionBean connection(boolean needsTransaction, boolean startIfNotStarted, String connectionName) {
        Connection connection;
        if (GrouperClientUtils.isBlank(connectionName)) {
            connectionName = GrouperClientUtils.defaultIfBlank(connectionName, GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc.defaultName"));
        }
        ConnectionBean connectionBean = new ConnectionBean();
        Map<String, Connection> connectionMapByName = connectionThreadLocal.get();
        if (connectionMapByName == null) {
            Class<GcDbAccess> clazz = GcDbAccess.class;
            // MONITORENTER : edu.internet2.middleware.grouperClient.jdbc.GcDbAccess.class
            connectionMapByName = connectionThreadLocal.get();
            if (connectionMapByName == null) {
                connectionMapByName = new HashMap<String, Connection>();
                connectionThreadLocal.set(connectionMapByName);
            }
            // MONITOREXIT : clazz
        }
        if ((connection = connectionMapByName.get(connectionName)) == null && !startIfNotStarted) {
            return connectionBean;
        }
        Boolean transaction = transactionThreadLocal.get();
        connectionBean.setInTransaction(needsTransaction || transaction != null);
        if (needsTransaction) {
            if (transaction != null) {
                connectionBean.setTransactionStarted(false);
            } else {
                transactionThreadLocal.set(true);
                connectionBean.setTransactionStarted(true);
            }
        }
        if (connection != null) {
            connectionBean.setConnectionStarted(false);
            connectionBean.setConnection(connection);
            try {
                if (!connectionBean.isTransactionStarted()) return connectionBean;
                connection.setAutoCommit(false);
                return connectionBean;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
        }
        if (transaction != null) {
            throw new RuntimeException("How can you have a transaction without a connection???");
        }
        connectionBean.setConnectionStarted(true);
        String[] url = new String[1];
        try {
            connection = GcDbAccess.connectionHelper(connectionName, url);
            connectionMapByName.put(connectionName, connection);
            connectionBean.setConnection(connection);
            if (connectionBean.isTransactionStarted()) {
                connection.setAutoCommit(false);
                return connectionBean;
            }
            connection.setAutoCommit(true);
            return connectionBean;
        }
        catch (Exception e) {
            connectionThreadLocal.remove();
            transactionThreadLocal.remove();
            throw new RuntimeException("Error connecting to: " + url[0], e);
        }
    }

    public static Connection connectionCreateNew(String connectionName, String[] url) throws ClassNotFoundException, SQLException {
        String driver = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.jdbc." + connectionName + ".driver");
        url[0] = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + connectionName + ".url");
        if (StringUtils.isBlank(driver)) {
            driver = GrouperClientUtils.convertUrlToDriverClassIfNeeded(url[0], driver);
        }
        Class.forName(driver);
        String user = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + connectionName + ".user");
        String pass = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.jdbc." + connectionName + ".pass");
        pass = Morph.decryptIfFile(pass);
        Connection connection = DriverManager.getConnection(url[0], user, pass);
        return connection;
    }

    public static Connection connectionGetFromPool(String connectionName, String[] url) throws ClassNotFoundException, SQLException {
        String GROUPER_LOADER_DB_CLASSNAME = "edu.internet2.middleware.grouper.app.loader.db.GrouperLoaderDb";
        try {
            Class grouperLoaderDbClass = GrouperClientUtils.forName("edu.internet2.middleware.grouper.app.loader.db.GrouperLoaderDb");
            Constructor constructor = grouperLoaderDbClass.getConstructor(String.class);
            Object grouperLoaderDbInstance = constructor.newInstance(connectionName);
            Connection connection = (Connection)GrouperClientUtils.callMethod(grouperLoaderDbInstance, "connection");
            url[0] = (String)GrouperClientUtils.callMethod(grouperLoaderDbInstance, "getUrl");
            return connection;
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling constructor and 'connection' on edu.internet2.middleware.grouper.app.loader.db.GrouperLoaderDb", e);
        }
    }

    public <T> T callbackCallableStatement(GcCallableStatementCallback<T> callableStatementCallback) {
        long startNanos = System.nanoTime();
        Statement callableStatement = null;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            callableStatement = this.connection.prepareCall(callableStatementCallback.getQuery());
            callableStatement.setFetchSize(1000);
            Long startTime = System.nanoTime();
            T t = callableStatementCallback.callback((CallableStatement)callableStatement);
            this.addQueryToQueriesAndMillis(callableStatementCallback.getQuery(), startTime);
            T t2 = t;
            return t2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
            ConnectionBean.closeIfStarted(connectionBean);
            GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
        }
    }

    public <T> T callbackPreparedStatement(GcPreparedStatementCallback<T> preparedStatementCallback) {
        long startNanos = System.nanoTime();
        Statement preparedStatement = null;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            preparedStatement = this.connection.prepareStatement(preparedStatementCallback.getQuery());
            preparedStatement.setFetchSize(1000);
            Long startTime = System.nanoTime();
            if (this.bindVars != null) {
                int i = 1;
                for (Object bindVar : this.bindVars) {
                    boundDataConversion.addBindVariableToStatement((PreparedStatement)preparedStatement, bindVar, i);
                    ++i;
                }
            }
            T t = preparedStatementCallback.callback((PreparedStatement)preparedStatement);
            this.addQueryToQueriesAndMillis(preparedStatementCallback.getQuery(), startTime);
            Iterator<Object> iterator = t;
            return (T)iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            ConnectionBean.closeIfStarted(connectionBean);
            GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
        }
    }

    public <T> T callbackConnection(GcConnectionCallback<T> connectionCallback) {
        T t;
        ConnectionBean connectionBean = null;
        long startNanos = System.nanoTime();
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            Long startTime = System.nanoTime();
            T t2 = connectionCallback.callback(this.connection);
            this.addQueryToQueriesAndMillis("Connection callback, SQL unknown", startTime);
            t = t2;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConnectionBean.closeIfStarted(connectionBean);
                GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
                throw throwable;
            }
        }
        ConnectionBean.closeIfStarted(connectionBean);
        GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
        return t;
    }

    public <T> T callbackResultSet(GcResultSetCallback<T> resultSetCallback) {
        GcDbAccess.threadLocalQueryCountIncrement(1);
        long startNanos = System.nanoTime();
        if (this.sql == null) {
            throw new RuntimeException("You must set sql!");
        }
        Statement preparedStatement = null;
        ConnectionBean connectionBean = null;
        try {
            Iterator<Object> iterator;
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            preparedStatement = this.connection.prepareStatement(this.sql);
            preparedStatement.setFetchSize(1000);
            String sqltoRecord = this.sql;
            if (this.queryTimeoutSeconds != null) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            if (this.bindVars != null) {
                int i = 1;
                for (Object bindVar : this.bindVars) {
                    boundDataConversion.addBindVariableToStatement((PreparedStatement)preparedStatement, bindVar, i);
                    ++i;
                }
            }
            if (this.batchBindVars != null) {
                for (List<Object> theBindVars : this.batchBindVars) {
                    int i = 1;
                    for (Object bindVar : theBindVars) {
                        boundDataConversion.addBindVariableToStatement((PreparedStatement)preparedStatement, bindVar, i);
                        ++i;
                    }
                    preparedStatement.addBatch();
                }
            }
            if (resultSetCallback == null) {
                if (this.batchBindVars != null) {
                    Long startTime = System.nanoTime();
                    this.numberOfBatchRowsAffected = preparedStatement.executeBatch();
                    this.addQueryToQueriesAndMillis(sqltoRecord, startTime);
                    iterator = null;
                    return (T)iterator;
                }
                Long startTime = System.nanoTime();
                this.numberOfRowsAffected = preparedStatement.executeUpdate();
                this.addQueryToQueriesAndMillis(sqltoRecord, startTime);
                iterator = null;
                return (T)iterator;
            }
            ResultSet rs = preparedStatement.executeQuery();
            this.resultSetMetaData = rs.getMetaData();
            iterator = resultSetCallback.callback(rs);
            return (T)iterator;
        }
        catch (Exception e) {
            GrouperClientUtils.injectInException(e, "sql: " + this.sql + ", " + (GrouperClientUtils.length(this.bindVars) > 1 ? "args: " + GrouperClientUtils.toStringForLog(this.bindVars) : ""));
            throw new RuntimeException(e);
        }
        finally {
            this.resultSetMetaData = null;
            this.resultSetMetadataColumnNameLowerToIndex = null;
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ConnectionBean.closeIfStarted(connectionBean);
            GrouperClientUtils.performanceTimingAllDuration("sqlQueries", System.nanoTime() - startNanos);
        }
    }

    public int executeSql() {
        if (this.batchBindVars != null) {
            throw new RuntimeException("Use executeBatchSql() with batchBindVars!");
        }
        this.callbackResultSet(null);
        return this.numberOfRowsAffected;
    }

    public int[] executeBatchSql() {
        if (this.batchSize <= 0 || GrouperClientUtils.length(this.batchBindVars) <= this.batchSize) {
            if (this.bindVars != null) {
                throw new RuntimeException("Use batchBindVars with executeBatchSql(), not bindVars!");
            }
            this.callbackResultSet(null);
            return this.numberOfBatchRowsAffected;
        }
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(this.batchBindVars, this.batchSize);
        int[] result = new int[GrouperClientUtils.length(this.batchBindVars)];
        for (int i = 0; i < numberOfBatches; ++i) {
            List<List<Object>> batchOfBindVars = GrouperClientUtils.batchList(this.batchBindVars, this.batchSize, i);
            GcDbAccess gcDbAccess = this.cloneDbAccess();
            gcDbAccess.batchBindVars(batchOfBindVars);
            gcDbAccess.batchSize(-1);
            int[] batchResult = gcDbAccess.executeBatchSql();
            System.arraycopy(batchResult, 0, result, i * this.batchSize, batchResult.length);
        }
        return result;
    }

    private <T> T addObjectToList(Class<T> clazz, Map<String, Boolean> fieldIsIncludedInResults, ResultSet resultSet, List<T> theList) throws Exception {
        if (GcPersistableHelper.hasPersistableAnnotation(clazz)) {
            T t = clazz.newInstance();
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                if (!GcPersistableHelper.isSelect(field, clazz)) continue;
                String columnName = GcPersistableHelper.columnName(field);
                Boolean columnInQueryResults = fieldIsIncludedInResults.get(columnName);
                if (columnInQueryResults == null) {
                    try {
                        resultSet.findColumn(columnName);
                        fieldIsIncludedInResults.put(columnName, new Boolean(true));
                        columnInQueryResults = new Boolean(true);
                    }
                    catch (SQLException e) {
                        fieldIsIncludedInResults.put(columnName, new Boolean(false));
                        columnInQueryResults = new Boolean(false);
                    }
                }
                if (!columnInQueryResults.booleanValue()) continue;
                int columnNumberOneIndexed = this.retrieveColumnNumberOneIndexed(columnName);
                Object value = this.retrieveObjectFromResultSetByIndex(resultSet, columnNumberOneIndexed);
                boundDataConversion.setFieldValue(t, field, value);
            }
            if (theList != null) {
                theList.add(t);
            }
            return t;
        }
        if (clazz.isAssignableFrom(Map.class)) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                Object value = this.retrieveObjectFromResultSetByIndex(resultSet, columnNumber);
                results.put(resultSet.getMetaData().getColumnName(columnNumber).toLowerCase(), value);
            }
            LinkedHashMap<String, Object> t = results;
            if (theList != null) {
                theList.add(t);
            }
            return (T)t;
        }
        if (clazz.isAssignableFrom(Object[].class)) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            Object[] results = new Object[columnCount];
            for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                Object value;
                results[columnNumber - 1] = value = this.retrieveObjectFromResultSetByIndex(resultSet, columnNumber);
            }
            Object[] t = results;
            if (theList != null) {
                theList.add(t);
            }
            return (T)t;
        }
        if (clazz.isAssignableFrom(String[].class)) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            String[] results = new String[columnCount];
            for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                Object value = this.retrieveObjectFromResultSetByIndex(resultSet, columnNumber);
                results[columnNumber - 1] = boundDataConversion.getFieldValue(String.class, value);
            }
            String[] t = results;
            if (theList != null) {
                theList.add(t);
            }
            return (T)t;
        }
        Object value = this.retrieveObjectFromResultSetByIndex(resultSet, 1);
        T t = boundDataConversion.getFieldValue(clazz, value);
        if (theList != null) {
            theList.add(t);
        }
        return t;
    }

    private int retrieveColumnNumberOneIndexed(String columnName) throws SQLException {
        if (this.resultSetMetadataColumnNameLowerToIndex == null) {
            this.resultSetMetadataColumnNameLowerToIndex = new HashMap<String, Integer>();
            for (int columnOneIndex = 1; columnOneIndex <= this.resultSetMetaData.getColumnCount(); ++columnOneIndex) {
                String columnLabel = this.resultSetMetaData.getColumnLabel(columnOneIndex);
                columnLabel = columnLabel.toLowerCase();
                this.resultSetMetadataColumnNameLowerToIndex.put(columnLabel, columnOneIndex);
            }
        }
        if (!this.resultSetMetadataColumnNameLowerToIndex.containsKey(columnName = columnName.toLowerCase())) {
            throw new RuntimeException("Cant find column name '" + columnName + "' ! " + GrouperClientUtils.toStringForLog(this.resultSetMetadataColumnNameLowerToIndex));
        }
        return this.resultSetMetadataColumnNameLowerToIndex.get(columnName);
    }

    private Object retrieveObjectFromResultSetByIndex(ResultSet resultSet, int columnNumberOneIndexed) throws SQLException {
        int type = this.resultSetMetaData.getColumnType(columnNumberOneIndexed);
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(columnNumberOneIndexed);
                return bigDecimal;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(columnNumberOneIndexed);
                return bigDecimal;
            }
            case -7: 
            case 16: {
                return resultSet.getBoolean(columnNumberOneIndexed);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(columnNumberOneIndexed);
            }
            case 91: 
            case 93: {
                return resultSet.getTimestamp(columnNumberOneIndexed);
            }
            case 2005: {
                Clob clob = resultSet.getClob(columnNumberOneIndexed);
                return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
            }
        }
        throw new RuntimeException("Not expecting column type: " + type);
    }

    public static Map<MultiKey, GcDbQueryCache> getGcDbQueryCacheMap() {
        return dbQueryCacheMap;
    }

    public static Map<String, GcQueryReport> getQueriesAndMillis() {
        return queriesAndMillis;
    }

    private Object selectFromQueryCache(boolean isList, Class<?> clazz) {
        if (this.cacheMinutes == null) {
            return null;
        }
        MultiKey queryKey = this.queryCacheKey(isList, clazz);
        GcDbQueryCache dbQueryCache = dbQueryCacheMap.get(queryKey);
        if (dbQueryCache == null) {
            return null;
        }
        return dbQueryCache.getThingBeingCached();
    }

    private void populateQueryCache(Class<?> clazz, Object thingBeingCached, boolean isList) {
        if (this.cacheMinutes == null) {
            return;
        }
        MultiKey queryKey = this.queryCacheKey(isList, clazz);
        dbQueryCacheMap.put(queryKey, new GcDbQueryCache(this.cacheMinutes, thingBeingCached));
    }

    private MultiKey queryCacheKey(boolean isList, Class<?> clazz) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.sql);
        key.add(clazz.getName());
        key.add(isList);
        if (this.bindVars != null && this.bindVars.size() > 0) {
            for (Object object : this.bindVars) {
                key.add(object);
            }
        }
        if (this.batchBindVars != null && this.batchBindVars.size() > 0) {
            for (List list : this.batchBindVars) {
                for (Object bindVar : list) {
                    key.add(bindVar);
                }
            }
        }
        if (this.primaryKeys != null) {
            for (Object object : this.primaryKeys) {
                key.add(object);
            }
        }
        return new MultiKey(key.toArray());
    }

    private GcDbAccess cloneDbAccess() {
        GcDbAccess dbAccess = new GcDbAccess();
        for (Field field : GcDbAccess.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(dbAccess, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot clone value of field " + field.getName());
            }
        }
        return dbAccess;
    }

    public static Connection connectionHelper(String connectionName, String[] url) throws ClassNotFoundException, SQLException {
        if (grouperIsStarted) {
            return GcDbAccess.connectionGetFromPool(connectionName, url);
        }
        try {
            return GcDbAccess.connectionGetFromPool(connectionName, url);
        }
        catch (Exception exception) {
            return GcDbAccess.connectionCreateNew(connectionName, url);
        }
    }

    static {
        queryCount = new InheritableThreadLocal();
        boundDataConversion = new GcBoundDataConversionImpl();
        dbConnectionClassesRegistered = false;
        LOG = LogFactory.getLog(GcDbAccess.class);
        connectionThreadLocal = new ThreadLocal();
        transactionThreadLocal = new ThreadLocal();
    }

    public static class ConnectionBean {
        private boolean inTransaction;
        private Connection connection;
        private boolean transactionStarted;
        private boolean connectionStarted;

        public boolean isInTransaction() {
            return this.inTransaction;
        }

        public void setInTransaction(boolean inTransaction1) {
            this.inTransaction = inTransaction1;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection1) {
            this.connection = connection1;
        }

        public boolean isTransactionStarted() {
            return this.transactionStarted;
        }

        public void setTransactionStarted(boolean transactionStarted1) {
            this.transactionStarted = transactionStarted1;
        }

        public boolean isConnectionStarted() {
            return this.connectionStarted;
        }

        public void setConnectionStarted(boolean connectionStarted1) {
            this.connectionStarted = connectionStarted1;
        }

        public static void transactionEnd(ConnectionBean connectionBean, GcTransactionEnd transactionEnd, boolean endOnlyIfStarted, boolean errorIfNoTransaction, boolean endTransaction) {
            if (connectionBean == null) {
                return;
            }
            if (!connectionBean.isInTransaction()) {
                if (errorIfNoTransaction) {
                    throw new RuntimeException("Cannot end a transaction when not in a transaction!");
                }
                return;
            }
            if (endOnlyIfStarted && !connectionBean.isTransactionStarted()) {
                return;
            }
            if (endTransaction) {
                transactionThreadLocal.remove();
            }
            try {
                switch (transactionEnd) {
                    case commit: {
                        connectionBean.connection.commit();
                        connectionBean.setInTransaction(false);
                        break;
                    }
                    case rollback: {
                        connectionBean.connection.rollback();
                        connectionBean.setInTransaction(false);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Not expecting: " + (Object)((Object)transactionEnd));
                    }
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Error: " + (Object)((Object)transactionEnd) + ", " + endOnlyIfStarted, sqle);
            }
            if (endTransaction) {
                try {
                    connectionBean.connection.setAutoCommit(true);
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
        }

        public static void closeIfStarted(ConnectionBean connectionBean) {
            ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.rollback, true, false, true);
            if (connectionBean != null && connectionBean.isConnectionStarted()) {
                connectionThreadLocal.remove();
                GrouperClientUtils.closeQuietly(connectionBean.getConnection());
            }
        }
    }
}

