/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.discovery;

import edu.internet2.middleware.grouperClient.GrouperClient;
import edu.internet2.middleware.grouperClient.failover.FailoverClient;
import edu.internet2.middleware.grouperClient.failover.FailoverConfig;
import edu.internet2.middleware.grouperClient.failover.FailoverLogic;
import edu.internet2.middleware.grouperClient.failover.FailoverLogicBean;
import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpClient;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.UsernamePasswordCredentials;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.AuthScope;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods.GetMethod;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.params.DefaultHttpParams;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.protocol.Protocol;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiscoveryClient {
    static final String TEMP_FILE_DATE_FORMAT = "yyyyMMdd_HHmmss_SSS";
    private static final String DISCOVERYTMP = ".discoverytmp";
    private static final String DISCOVERY_CLIENT_CONNECTION_TYPE = "discoveryClient";
    static Log log = GrouperClientUtils.retrieveLog(DiscoveryClient.class);
    private static ExpirableCache<String, File> discoveryFileCache = null;
    static boolean failoverClientConfigured = false;
    private static Map<String, String> synchronizedObjectBasedOnName = new HashMap<String, String>();
    private static Pattern localCacheDatePattern = Pattern.compile("(.*)_(\\d{8}_\\d{6}_\\d{3})_.*(\\..*)");

    private static void usage() {
        System.out.println("Grouper Discovery Client USAGE:\n");
        System.out.println("This program downloads a file from a discovery server and failsafe caches the result.");
        System.out.println("The system exit code will be 0 for success, and not 0 for failure.");
        System.out.println("Output data is printed to stdout, error messages are printed to stderr or logs (configured in grouper.client.properties).\n");
        System.out.println("Grouper discovery client webpage: https://spaces.internet2.edu/display/Grouper/Grouper+discovery+client\n");
        System.out.println("Grouper discovery client USAGE:\n");
        System.out.println("Arguments are in the format: --argName=argValue");
        System.out.println("Example argument: --operation=getFile");
        System.out.println("Optional arguments below are in [brackets]\n");
        System.out.println("###############################################");
        System.out.println("## Operations\n");
        System.out.println("getFile usage:");
        System.out.println("Get a file from a discovery server or cache, will output the location of the file on the local machine to stdout.");
        System.out.println("Note, that file is cached, do not move, edit, delete it.");
        System.out.println("  java -cp grouperClient.jar edu.internet2.middleware.grouperClient.discovery.DiscoveryClient --operation=getFile --fileName=someFile.txt");
        System.out.println("  output: /home/whoever/grouperClient/someFile_20120102_132414_123_sd43sdf.txt");
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        String operation = null;
        try {
            File file;
            boolean shouldSaveResultsToFile;
            if (GrouperClientUtils.length(args) == 0) {
                DiscoveryClient.usage();
                return;
            }
            Map<String, String> argMap = GrouperClientUtils.argMap(args);
            LinkedHashMap<String, String> argMapNotUsed = new LinkedHashMap<String, String>(argMap);
            boolean debugMode = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "debug", false, false);
            GrouperClientLog.assignDebugToConsole(debugMode);
            GrouperClientConfig.retrieveConfig().properties();
            StringBuilder callingLog = new StringBuilder();
            GrouperClientUtils.propertiesFromResourceName("grouper.client.properties", false, true, GrouperClientCommonUtils.class, callingLog);
            operation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "operation", true);
            String saveResultsToFile = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "saveResultsToFile", false);
            boolean bl = shouldSaveResultsToFile = !GrouperClientUtils.isBlank(saveResultsToFile);
            if (shouldSaveResultsToFile) {
                log.debug("Will save results to file: " + GrouperClientUtils.fileCanonicalPath(new File(saveResultsToFile)));
            }
            String result = null;
            if (GrouperClientUtils.equals(operation, "getFile")) {
                String fileName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "fileName", true);
                file = DiscoveryClient.retrieveFile(fileName, true);
                if (file == null) {
                    throw new RuntimeException("Discovery service did not retrieve a success for file: " + fileName);
                }
            } else {
                System.err.println("Error: invalid operation: '" + operation + "', for usage help, run: java -cp grouperClient.jar edu.internet2.middleware.grouperClient.discovery.DiscoveryClient");
                if (GrouperClient.exitOnError) {
                    System.exit(1);
                }
                throw new RuntimeException("Invalid usage");
            }
            result = file.getAbsolutePath();
            if (shouldSaveResultsToFile) {
                GrouperClientUtils.saveStringIntoFile(new File(saveResultsToFile), result);
            } else {
                System.out.print(result);
            }
            GrouperClient.failOnArgsNotUsed(argMapNotUsed);
        }
        catch (Exception e) {
            System.err.println("Error with grouper client, check the logs: " + e.getMessage());
            log.fatal(e.getMessage(), e);
            if (GrouperClient.exitOnError) {
                System.exit(1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                log.debug("Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (Exception exception) {}
            GrouperClientLog.assignDebugToConsole(false);
        }
    }

    public static boolean hasDiscovery() {
        String firstUrl = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.urlOfDiscovery.0");
        return !GrouperClientUtils.isBlank(firstUrl);
    }

    private static ExpirableCache<String, File> discoveryFileCache() {
        if (discoveryFileCache == null) {
            int cacheDiscoveryFileCacheForSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.cacheDiscoveryPropertiesForSeconds", 120);
            discoveryFileCache = new ExpirableCache(cacheDiscoveryFileCacheForSeconds);
        }
        return discoveryFileCache;
    }

    private static String convertFileNameToLocalFileName(String fileName) {
        String localFileName = GrouperClientUtils.replace(fileName, "/", "_");
        localFileName = GrouperClientUtils.replace(localFileName, "\\", "_");
        return localFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File retrieveFile(String fileName, boolean throwExceptionIfNotFound) {
        LinkedHashMap<String, Object> logMap;
        LinkedHashMap<String, Object> linkedHashMap = logMap = log.isDebugEnabled() ? new LinkedHashMap<String, Object>() : null;
        if (logMap != null) {
            logMap.put("method", "DiscoveryClient.retrieveFile");
        }
        File file = null;
        try {
            boolean retrievedFromCache;
            if (!DiscoveryClient.hasDiscovery()) {
                if (logMap != null) {
                    logMap.put("configuredToUseDiscovery", false);
                }
                File file2 = null;
                return file2;
            }
            String localFileName = DiscoveryClient.convertFileNameToLocalFileName(fileName);
            file = DiscoveryClient.discoveryFileCache().get(localFileName);
            boolean bl = retrievedFromCache = file != null;
            if (logMap != null) {
                logMap.put("existsInDiscoveryFilecache", file != null);
            }
            if (file == null) {
                File discoveryLocalFile = DiscoveryClient.mostRecentFileFromFileSystem(localFileName);
                if (discoveryLocalFile != null && discoveryLocalFile.exists()) {
                    Matcher matcher = localCacheDatePattern.matcher(discoveryLocalFile.getName());
                    if (!matcher.matches()) {
                        throw new RuntimeException("Why does matcher not match???? " + discoveryLocalFile.getAbsolutePath());
                    }
                    String datePart = matcher.group(2);
                    SimpleDateFormat dateFormat = new SimpleDateFormat(TEMP_FILE_DATE_FORMAT);
                    Date date = null;
                    try {
                        date = dateFormat.parse(datePart);
                    }
                    catch (ParseException pe) {
                        throw new RuntimeException("Why date format exception???? " + file.getAbsolutePath());
                    }
                    if ((System.currentTimeMillis() - date.getTime()) / 1000L < (long)GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.cacheDiscoveryPropertiesForSeconds", 120)) {
                        file = discoveryLocalFile;
                    }
                }
                if (logMap != null) {
                    logMap.put("existsInFilecache", discoveryLocalFile != null);
                }
                if (logMap != null) {
                    logMap.put("fileIsYoungEnough", file != null);
                }
            }
            if (file == null) {
                try {
                    file = DiscoveryClient.retrieveFileFromDiscoveryServer(fileName, localFileName);
                }
                catch (Exception e) {
                    log.error("Problem retrieving file from discovery server: " + fileName, e);
                }
                if (logMap != null) {
                    logMap.put("fileFromServer", file != null);
                }
            }
            if (file == null) {
                file = DiscoveryClient.mostRecentFileFromFileSystem(localFileName);
                if (logMap != null) {
                    logMap.put("fileFromFailsafeLocalSystem", file != null);
                }
            }
            if (!retrievedFromCache && file != null) {
                Class<DiscoveryClient> clazz = DiscoveryClient.class;
                // MONITORENTER : edu.internet2.middleware.grouperClient.discovery.DiscoveryClient.class
                DiscoveryClient.discoveryFileCache().put(localFileName, file);
                // MONITOREXIT : clazz
            }
            if (logMap != null) {
                logMap.put("fileFound", file != null);
                if (file != null) {
                    logMap.put("fileSizeBytes", file.length());
                    logMap.put("lastModified", new Date(file.lastModified()));
                }
            }
            if (file != null) return file;
            if (!throwExceptionIfNotFound) return file;
            throw new RuntimeException("Cant find file from discovery: '" + fileName + "'");
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(GrouperClientUtils.mapToString(logMap));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureFailoverClientOnce() {
        if (failoverClientConfigured) {
            return;
        }
        Class<DiscoveryClient> clazz = DiscoveryClient.class;
        synchronized (DiscoveryClient.class) {
            if (!failoverClientConfigured) {
                String discoveryUrl;
                ArrayList<String> discoveryUrls = new ArrayList<String>();
                for (int i = 0; i < 100 && !GrouperClientUtils.isBlank(discoveryUrl = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.urlOfDiscovery." + i)); ++i) {
                    discoveryUrls.add(discoveryUrl);
                }
                if (discoveryUrls.size() > 0) {
                    FailoverConfig failoverConfig = new FailoverConfig();
                    failoverConfig.setConnectionNames(discoveryUrls);
                    failoverConfig.setConnectionType(DISCOVERY_CLIENT_CONNECTION_TYPE);
                    failoverConfig.setFailoverStrategy(FailoverConfig.FailoverStrategy.activeActive);
                    FailoverClient.initFailoverClient(failoverConfig);
                    failoverClientConfigured = true;
                } else {
                    log.error("There are no discovery URLs in grouper.client.properties");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String synchronizedObjectBasedOnName(String name) {
        String synchronizedObject = synchronizedObjectBasedOnName.get(name);
        if (synchronizedObject != null) return synchronizedObject;
        Class<DiscoveryClient> clazz = DiscoveryClient.class;
        synchronized (DiscoveryClient.class) {
            synchronizedObject = synchronizedObjectBasedOnName.get(name);
            if (synchronizedObject != null) return synchronizedObject;
            synchronizedObject = new String(name);
            synchronizedObjectBasedOnName.put(name, synchronizedObject);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return synchronizedObject;
        }
    }

    static File mostRecentFileFromFileSystem(String localFileName) {
        File cacheDirectory = new File(GrouperClientUtils.cacheDirectoryName());
        File[] files = cacheDirectory.listFiles();
        TreeMap<Date, File> mapOfDateToFile = new TreeMap<Date, File>();
        for (File file : files) {
            String fileName;
            Matcher matcher;
            if (file.getAbsolutePath().endsWith(DISCOVERYTMP) || !(matcher = localCacheDatePattern.matcher(fileName = file.getName())).matches()) continue;
            String prefixFileName = matcher.group(1);
            String suffixFileName = matcher.group(3);
            if (!GrouperClientCommonUtils.equals(prefixFileName + suffixFileName, localFileName)) continue;
            String datePart = matcher.group(2);
            SimpleDateFormat dateFormat = new SimpleDateFormat(TEMP_FILE_DATE_FORMAT);
            Date date = null;
            try {
                date = dateFormat.parse(datePart);
            }
            catch (ParseException pe) {
                log.error("Why date format exception???? " + file.getAbsolutePath());
                continue;
            }
            mapOfDateToFile.put(date, file);
        }
        if (mapOfDateToFile.size() == 0) {
            return null;
        }
        return (File)new ArrayList(mapOfDateToFile.values()).get(mapOfDateToFile.size() - 1);
    }

    private static File discoveryLocalFileUnique(String localFileName, boolean isTmpFile) {
        File file = null;
        for (int i = 0; i < 100 && (file = DiscoveryClient.discoveryLocalFileUniqueHelper(localFileName, isTmpFile)).exists(); ++i) {
        }
        if (file.exists()) {
            throw new RuntimeException("Why does the file exist?");
        }
        return file;
    }

    private static File discoveryLocalFileUniqueHelper(String localFileName, boolean isTmpFile) {
        String directoryName = GrouperClientUtils.cacheDirectoryName();
        if (localFileName.contains("/")) {
            throw new RuntimeException("Local file cannot contain / : " + localFileName);
        }
        if (localFileName.contains("\\")) {
            throw new RuntimeException("Local file cannot contain \\ : " + localFileName);
        }
        int dotIndex = localFileName.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new RuntimeException("Local filename must have a dot in it! " + localFileName);
        }
        String fileNamePrefix = localFileName.substring(0, dotIndex);
        String fileNameSuffix = localFileName.substring(dotIndex, localFileName.length());
        SimpleDateFormat dateFormat = new SimpleDateFormat(TEMP_FILE_DATE_FORMAT);
        String pathname = directoryName + File.separator + fileNamePrefix + "_" + dateFormat.format(new Date()) + "_" + GrouperClientUtils.uniqueId() + fileNameSuffix;
        if (isTmpFile) {
            pathname = pathname + DISCOVERYTMP;
        }
        return new File(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File retrieveFileFromDiscoveryServer(final String fileNameOnServer, final String localFileName) {
        if (!DiscoveryClient.hasDiscovery()) {
            return null;
        }
        DiscoveryClient.configureFailoverClientOnce();
        File file = FailoverClient.failoverLogic(DISCOVERY_CLIENT_CONNECTION_TYPE, new FailoverLogic<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File logic(FailoverLogicBean failoverLogicBean) {
                String httpsSocketFactoryName;
                LinkedHashMap<String, String> logMap;
                LinkedHashMap<String, String> linkedHashMap = logMap = log.isDebugEnabled() ? new LinkedHashMap<String, String>() : null;
                if (logMap != null) {
                    logMap.put("method", "DiscoveryClient.retrieveFileFromDiscoveryServer.logic");
                }
                String url = failoverLogicBean.getConnectionName();
                url = GrouperClientUtils.stripEnd(url, "/");
                String fileNameNoSlash = GrouperClientUtils.stripStart(fileNameOnServer, "/");
                String fullUrl = url + "/" + fileNameNoSlash;
                if (logMap != null) {
                    logMap.put("fullUrl", fullUrl);
                }
                if (!GrouperClientUtils.isBlank(httpsSocketFactoryName = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.https.customSocketFactory"))) {
                    Class httpsSocketFactoryClass = GrouperClientUtils.forName(httpsSocketFactoryName);
                    SecureProtocolSocketFactory httpsSocketFactoryInstance = (SecureProtocolSocketFactory)GrouperClientUtils.newInstance(httpsSocketFactoryClass);
                    Protocol easyhttps = new Protocol("https", httpsSocketFactoryInstance, 443);
                    Protocol.registerProtocol("https", easyhttps);
                }
                HttpClient httpClient = new HttpClient();
                DefaultHttpParams.getDefaultParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
                int soTimeoutMillis = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discovery.httpSocketTimeoutMillis", 90000);
                httpClient.getParams().setSoTimeout(soTimeoutMillis);
                httpClient.getParams().setParameter("http.protocol.head-body-timeout", soTimeoutMillis);
                int connectionManagerMillis = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discovery.httpConnectionManagerTimeoutMillis", 90000);
                httpClient.getParams().setConnectionManagerTimeout(connectionManagerMillis);
                String user = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discover.user");
                if (logMap != null) {
                    logMap.put("user", user);
                }
                if (!GrouperClientUtils.isBlank(user)) {
                    httpClient.getParams().setAuthenticationPreemptive(true);
                    boolean disableExternalFileLookup = GrouperClientConfig.retrieveConfig().propertyValueBooleanRequired("encrypt.disableExternalFileLookup");
                    String pass = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discovery.password");
                    String passFromFile = GrouperClientUtils.readFromFileIfFile(pass, disableExternalFileLookup);
                    String passPrefix = null;
                    if (!GrouperClientUtils.equals(pass, passFromFile)) {
                        passPrefix = "Discovery pass: reading encrypted value from file: " + pass;
                        String encryptKey = GrouperClientUtils.encryptKey();
                        pass = new Crypto(encryptKey).decrypt(passFromFile);
                    } else {
                        passPrefix = "Discovery pass: reading scalar value from grouper.client.properties";
                    }
                    if (GrouperClientConfig.retrieveConfig().propertyValueBoolean("grouperClient.logging.logMaskedPassword", false) && logMap != null) {
                        logMap.put(passPrefix, GrouperClientUtils.repeat("*", pass.length()));
                    }
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(user, pass);
                    httpClient.getState().setCredentials(new AuthScope(null, -1), defaultcreds);
                }
                GetMethod getMethod = new GetMethod(fullUrl);
                getMethod.setRequestHeader("Connection", "close");
                File file = DiscoveryClient.discoveryLocalFileUnique(localFileName, true);
                try {
                    int responseCodeInt = httpClient.executeMethod(getMethod);
                    if (responseCodeInt != 200) {
                        throw new RuntimeException("Expected 200, but received response code: " + responseCodeInt);
                    }
                    String string = DiscoveryClient.synchronizedObjectBasedOnName(localFileName);
                    synchronized (string) {
                        InputStream inputStream = null;
                        FileOutputStream outputStream = null;
                        try {
                            inputStream = getMethod.getResponseBodyAsStream();
                            GrouperClientUtils.deleteFile(file);
                            outputStream = new FileOutputStream(file);
                            GrouperClientUtils.copy(inputStream, outputStream);
                        }
                        catch (RuntimeException re) {
                            try {
                                try {
                                    GrouperClientUtils.deleteFile(file);
                                }
                                catch (Exception e) {
                                    log.error("Cant delete file: " + file.getAbsolutePath(), e);
                                }
                                throw re;
                            }
                            catch (Throwable throwable) {
                                GrouperClientUtils.closeQuietly(inputStream);
                                GrouperClientUtils.closeQuietly(outputStream);
                                throw throwable;
                            }
                        }
                        GrouperClientUtils.closeQuietly(inputStream);
                        GrouperClientUtils.closeQuietly(outputStream);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Problem with url: " + fullUrl + ", and local file: " + file.getAbsolutePath(), exception);
                }
                return file;
            }
        });
        File realFile = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - DISCOVERYTMP.length()));
        String string = DiscoveryClient.synchronizedObjectBasedOnName(localFileName);
        synchronized (string) {
            GrouperClientUtils.renameTo(file, realFile);
        }
        DiscoveryClient.cleanoutOldFiles();
        return realFile;
    }

    static void cleanoutOldFiles() {
        try {
            File cacheDirectory = new File(GrouperClientUtils.cacheDirectoryName());
            File[] files = cacheDirectory.listFiles();
            HashMap nonTmpFileCatalog = new HashMap();
            for (File file : files) {
                String fileName = file.getName();
                Matcher matcher = localCacheDatePattern.matcher(fileName);
                if (!matcher.matches()) continue;
                String datePart = matcher.group(2);
                SimpleDateFormat dateFormat = new SimpleDateFormat(TEMP_FILE_DATE_FORMAT);
                Date date = dateFormat.parse(datePart);
                if (System.currentTimeMillis() - date.getTime() < 1200000L) continue;
                if (file.getAbsolutePath().endsWith(DISCOVERYTMP)) {
                    try {
                        GrouperClientUtils.deleteFile(file);
                    }
                    catch (Exception e) {
                        log.error("Cant delete file: " + file.getAbsolutePath(), e);
                    }
                    continue;
                }
                String prefixFileName = matcher.group(1);
                String suffixFileName = matcher.group(3);
                String nonTmpFileName = prefixFileName + suffixFileName;
                TreeMap<Date, File> mapOfDateToFile = (TreeMap<Date, File>)nonTmpFileCatalog.get(nonTmpFileName);
                if (mapOfDateToFile == null) {
                    mapOfDateToFile = new TreeMap<Date, File>();
                    nonTmpFileCatalog.put(nonTmpFileName, mapOfDateToFile);
                }
                if (mapOfDateToFile.containsKey(date)) {
                    try {
                        GrouperClientUtils.deleteFile(file);
                    }
                    catch (Exception e) {
                        log.error("Cant delete file: " + file.getAbsolutePath(), e);
                    }
                }
                mapOfDateToFile.put(date, file);
            }
            for (Map mapOfDateToFile : nonTmpFileCatalog.values()) {
                if (mapOfDateToFile.size() <= 1) continue;
                int index = 0;
                Collection filesToDelete = mapOfDateToFile.values();
                for (File file : filesToDelete) {
                    if (index < filesToDelete.size() - 1) {
                        try {
                            GrouperClientCommonUtils.deleteFile(file);
                        }
                        catch (Exception e) {
                            log.error("Cant delete file: " + file.getAbsolutePath(), e);
                        }
                    }
                    ++index;
                }
            }
        }
        catch (Exception e) {
            log.error("Cant clean log directory!", e);
        }
    }
}

