/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.config.db;

import edu.internet2.middleware.grouperClient.config.GrouperHibernateConfigClient;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import edu.internet2.middleware.morphString.Morph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class ConfigDatabaseLogic {
    public static String DATABASE_CACHE_KEY = "edu.internet2.middleware.grouperClient.config.db.ConfigDatabaseLogic.databaseConfigs";
    private static Map<String, Map<String, String>> databaseConfigCache = new HashMap<String, Map<String, String>>();
    private static long databaseConfigCacheLastRetrieved = -1L;
    public static int databaseConfigRefreshCount = 0;
    private static final Log LOG = LogFactory.getLog(ConfigDatabaseLogic.class);
    private static boolean tableExists = false;
    private static int secondsBetweenUpdateChecksToDb = 600;
    private static boolean readonly = true;
    private static int secondsBetweenFullRefresh = 3600;

    public static void clearCache() {
        ConfigDatabaseLogic.clearCache(true);
    }

    public static void clearCache(boolean checkConfigTableExists) {
        LOG.debug("ConfigDatabaseLogic.clearCache()");
        databaseConfigCacheLastRetrieved = -1L;
        databaseConfigCache = null;
        if (checkConfigTableExists) {
            tableExists = false;
        }
    }

    public static void main(String[] args) {
    }

    public static void assignSecondsBetweenUpdateChecksToDb(int theSeconds) {
        secondsBetweenUpdateChecksToDb = theSeconds;
    }

    public static void assignReadonly(boolean theReadonly) {
        readonly = theReadonly;
    }

    public static void assignSecondsBetweenFullRefresh(int theSeconds) {
        secondsBetweenFullRefresh = theSeconds;
    }

    public static InputStream retrieveConfigInputStream(String mainConfigFileName) {
        Map<String, String> configMap = ConfigDatabaseLogic.retrieveConfigMap(mainConfigFileName);
        if (configMap == null) {
            configMap = new HashMap<String, String>();
        }
        Properties properties = new Properties();
        for (String key : configMap.keySet()) {
            if (key == null) {
                throw new RuntimeException("Why is key null???? " + mainConfigFileName);
            }
            String value = GrouperClientUtils.defaultString(configMap.get(key));
            properties.put(key, value);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "");
        }
        catch (IOException e) {
            throw new RuntimeException("Error in " + mainConfigFileName, e);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map<String, String> retrieveConfigMap(String mainConfigFileName) {
        LinkedHashMap<String, Object> debugMap = new LinkedHashMap<String, Object>();
        debugMap.put("operation", "retrieveConfigMap");
        debugMap.put("readonly", readonly);
        debugMap.put("mainConfigFileName", mainConfigFileName);
        long now = System.nanoTime();
        long currentDatabaseConfigCache = databaseConfigCacheLastRetrieved;
        Map<String, Map<String, String>> theDatabaseConfigCache = databaseConfigCache;
        try {
            boolean tableExistsTemp = tableExists;
            if (tableExistsTemp || ConfigDatabaseLogic.configTableExists()) {
                Map<String, String> configCache;
                if (!tableExistsTemp) {
                    tableExists = true;
                }
                boolean needsRefresh = false;
                boolean databaseConfigCacheIsNull = theDatabaseConfigCache == null;
                debugMap.put("databaseConfigCacheIsNull", databaseConfigCacheIsNull);
                if (databaseConfigCacheIsNull) {
                    needsRefresh = true;
                }
                if (!needsRefresh) {
                    debugMap.put("secondsBetweenFullRefresh", secondsBetweenFullRefresh);
                    long secondsSinceLastRefresh = (System.currentTimeMillis() - currentDatabaseConfigCache) / 1000L;
                    debugMap.put("secondsSinceLastRefresh", secondsSinceLastRefresh);
                    boolean needsFullRefresh = secondsSinceLastRefresh > (long)secondsBetweenFullRefresh;
                    debugMap.put("needsFullRefresh", needsFullRefresh);
                    if (needsFullRefresh) {
                        needsRefresh = true;
                    }
                }
                if (!needsRefresh) {
                    debugMap.put("databaseConfigCacheLastRetrieved", databaseConfigCacheLastRetrieved);
                    debugMap.put("secondsBetweenUpdateChecksToDb", secondsBetweenUpdateChecksToDb);
                }
                debugMap.put("needsRefresh", needsRefresh);
                if (needsRefresh) {
                    Class<ConfigDatabaseLogic> secondsSinceLastRefresh = ConfigDatabaseLogic.class;
                    // MONITORENTER : edu.internet2.middleware.grouperClient.config.db.ConfigDatabaseLogic.class
                    theDatabaseConfigCache = databaseConfigCache;
                    if (theDatabaseConfigCache == null || databaseConfigCacheLastRetrieved == currentDatabaseConfigCache) {
                        debugMap.put("updatingConfig", true);
                        databaseConfigCache = theDatabaseConfigCache = ConfigDatabaseLogic.retrieveDatabaseConfigFromDatabase();
                        ++databaseConfigRefreshCount;
                        databaseConfigCacheLastRetrieved = System.currentTimeMillis();
                    } else {
                        debugMap.put("configUpdatedInAnotherThread", true);
                    }
                    // MONITOREXIT : secondsSinceLastRefresh
                }
                if (theDatabaseConfigCache != null && (configCache = theDatabaseConfigCache.get(mainConfigFileName)) != null) {
                    debugMap.put("configCount", configCache.size());
                    Map<String, String> map = configCache;
                    return map;
                }
            }
            debugMap.put("cantFindConfigMap", true);
            return new HashMap<String, String>();
        }
        catch (Exception e) {
            debugMap.put("exception", e.getMessage());
            throw new RuntimeException("error", e);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
                LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
            }
        }
    }

    public static String sha256(String input) {
        String algorithm = "SHA-256";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return ConfigDatabaseLogic.toHexString(md.digest(input.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Error in algorith: 'SHA-256'", nsae);
        }
    }

    public static String toHexString(byte[] hash) {
        BigInteger number = new BigInteger(1, hash);
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 32) {
            hexString.insert(0, '0');
        }
        return hexString.toString();
    }

    public static boolean equals(String first, String second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    private static synchronized Connection connection(Map<String, Object> debugMap) throws SQLException, ClassNotFoundException {
        GrouperHibernateConfigClient grouperHibernateConfig = GrouperHibernateConfigClient.retrieveConfig();
        String dbUrl = grouperHibernateConfig.propertyValueStringRequired("hibernate.connection.url");
        String dbUser = grouperHibernateConfig.propertyValueString("hibernate.connection.username");
        String dbPass = grouperHibernateConfig.propertyValueString("hibernate.connection.password");
        dbPass = Morph.decryptIfFile(dbPass);
        String driver = grouperHibernateConfig.propertyValueString("hibernate.connection.driver_class");
        driver = ConfigDatabaseLogic.convertUrlToDriverClassIfNeeded(dbUrl, driver);
        debugMap.put("makingUnpooledConnection", true);
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(dbUrl, dbUser, dbPass);
        return connection;
    }

    private static synchronized Map<String, Map<String, String>> retrieveDatabaseConfigFromDatabase() {
        return ConfigDatabaseLogic.retrieveDatabaseConfigFromDatabaseHelper();
    }

    private static synchronized Map<String, Map<String, String>> retrieveDatabaseConfigFromDatabaseHelper() {
        LinkedHashMap<String, Object> debugMap = new LinkedHashMap<String, Object>();
        debugMap.put("operation", "retrieveDatabaseConfigFromDatabase");
        long now = System.nanoTime();
        Connection theConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, Map<String, String>> databaseConfigCacheTemp = new HashMap<String, Map<String, String>>();
        try {
            boolean isClob;
            theConnection = ConfigDatabaseLogic.connection(debugMap);
            debugMap.put("gotConnection", true);
            String query = "select * from grouper_config where config_file_hierarchy = ?";
            preparedStatement = theConnection.prepareStatement(query);
            preparedStatement.setFetchSize(1000);
            preparedStatement.setString(1, "INSTITUTION");
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            int clobColType = 12;
            boolean foundClobCol = false;
            for (int i = 1; i <= columnCount; ++i) {
                if (!"config_value_clob".equals(metaData.getColumnName(i).toLowerCase())) continue;
                clobColType = metaData.getColumnType(i);
                foundClobCol = true;
                break;
            }
            boolean bl = isClob = clobColType == 2005;
            while (resultSet.next()) {
                String configFileName = resultSet.getString("config_file_name");
                String configKey = resultSet.getString("config_key");
                String configValue = resultSet.getString("config_value");
                String configValueClob = null;
                if (foundClobCol) {
                    Clob clob;
                    configValueClob = isClob ? ((clob = resultSet.getClob("config_value_clob")) != null ? clob.getSubString(1L, (int)clob.length()) : null) : resultSet.getString("config_value_clob");
                }
                String configEncrypted = resultSet.getString("config_encrypted");
                String value = StringUtils.isNotBlank(configValue) ? configValue : configValueClob;
                HashMap<String, String> configPropertiesForFile = (HashMap<String, String>)databaseConfigCacheTemp.get(configFileName);
                if (configPropertiesForFile == null) {
                    configPropertiesForFile = new HashMap<String, String>();
                    databaseConfigCacheTemp.put(configFileName, configPropertiesForFile);
                }
                if (ConfigDatabaseLogic.booleanValue(configEncrypted, false)) {
                    try {
                        value = Morph.decrypt(value);
                    }
                    catch (RuntimeException re) {
                        GrouperClientUtils.injectInException(re, " Problem with configFile: '" + configFileName + "', configKey: '" + configKey + "' ");
                        if (GrouperHibernateConfigClient.retrieveConfig().propertyValueBoolean("grouper.ignoreMorphErrorsOnStartup", false)) {
                            LOG.error("Error decrypting", re);
                        }
                        throw re;
                    }
                }
                configPropertiesForFile.put(configKey, value);
            }
            debugMap.put("configFilesFound", databaseConfigCacheTemp.size());
            for (String configFileName : databaseConfigCacheTemp.keySet()) {
                debugMap.put("configFile_" + configFileName + "_propertiesFound", ((Map)databaseConfigCacheTemp.get(configFileName)).size());
            }
        }
        catch (Exception e) {
            try {
                debugMap.put("exception", e.getMessage());
                throw new RuntimeException("error", e);
            }
            catch (Throwable throwable) {
                ConfigDatabaseLogic.closeQuietly(resultSet);
                ConfigDatabaseLogic.closeQuietly(preparedStatement);
                ConfigDatabaseLogic.closeQuietly(theConnection);
                if (LOG.isDebugEnabled()) {
                    debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
                    LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
                }
                throw throwable;
            }
        }
        ConfigDatabaseLogic.closeQuietly(resultSet);
        ConfigDatabaseLogic.closeQuietly(preparedStatement);
        ConfigDatabaseLogic.closeQuietly(theConnection);
        if (LOG.isDebugEnabled()) {
            debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
            LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
        }
        return databaseConfigCacheTemp;
    }

    public static boolean nullOrBlank(Object object) {
        if (object == null) {
            return true;
        }
        return object instanceof String && ConfigDatabaseLogic.isBlank((String)object);
    }

    public static boolean booleanValue(Object object) {
        if (ConfigDatabaseLogic.nullOrBlank(object)) {
            throw new RuntimeException("Expecting something which can be converted to boolean, but is null or blank: '" + object + "'");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ConfigDatabaseLogic.equalsIgnoreCase(string, "true") || ConfigDatabaseLogic.equalsIgnoreCase(string, "t") || ConfigDatabaseLogic.equalsIgnoreCase(string, "yes") || ConfigDatabaseLogic.equalsIgnoreCase(string, "y")) {
                return true;
            }
            if (ConfigDatabaseLogic.equalsIgnoreCase(string, "false") || ConfigDatabaseLogic.equalsIgnoreCase(string, "f") || ConfigDatabaseLogic.equalsIgnoreCase(string, "no") || ConfigDatabaseLogic.equalsIgnoreCase(string, "n")) {
                return false;
            }
            throw new RuntimeException("Invalid string to boolean conversion: '" + string + "' expecting true|false or t|f or yes|no or y|n case insensitive");
        }
        throw new RuntimeException("Cant convert object to boolean: " + object.getClass());
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : map.keySet()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object).append(": ").append(map.get(object));
        }
        return result.toString();
    }

    public static void closeQuietly(Connection theConnection) {
        if (theConnection != null) {
            try {
                theConnection.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Cant close connection!");
            }
        }
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isBlank(Object input) {
        if (null == input) {
            return true;
        }
        return input instanceof String && ConfigDatabaseLogic.isBlank((String)input);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static boolean booleanValue(Object object, boolean defaultBoolean) {
        if (ConfigDatabaseLogic.nullOrBlank(object)) {
            return defaultBoolean;
        }
        return ConfigDatabaseLogic.booleanValue(object);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static String uuid() {
        String uuid = UUID.randomUUID().toString();
        char[] result = new char[32];
        int resultIndex = 0;
        for (int i = 0; i < uuid.length(); ++i) {
            char theChar = uuid.charAt(i);
            if (theChar == '-') continue;
            if (resultIndex >= result.length) {
                throw new RuntimeException("Why is resultIndex greater than result.length ???? " + resultIndex + " , " + result.length + ", " + uuid);
            }
            result[resultIndex++] = theChar;
        }
        return new String(result);
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static long longValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Long.parseLong(string);
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        throw new RuntimeException("Cannot convert to long: " + ConfigDatabaseLogic.className(input));
    }

    private static synchronized boolean configTableExists() {
        return ConfigDatabaseLogic.configTableExistsHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean configTableExistsHelper() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection theConnection;
        long now;
        LinkedHashMap<String, Object> debugMap;
        block10: {
            boolean bl;
            block9: {
                debugMap = new LinkedHashMap<String, Object>();
                now = System.nanoTime();
                debugMap.put("operation", "configTableExists");
                theConnection = null;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (tableExists) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    theConnection = ConfigDatabaseLogic.connection(debugMap);
                    debugMap.put("gotConnection", true);
                    preparedStatement = theConnection.prepareStatement("select count(*) from grouper_config");
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        debugMap.put("gotResult", true);
                        resultSet.getBigDecimal(1);
                        debugMap.put("foundTable", true);
                        bl = true;
                        ConfigDatabaseLogic.closeQuietly(resultSet);
                        break block9;
                    }
                    ConfigDatabaseLogic.closeQuietly(resultSet);
                    break block10;
                }
                catch (Exception e) {
                    debugMap.put("exception", e.getMessage());
                    return false;
                }
            }
            ConfigDatabaseLogic.closeQuietly(preparedStatement);
            ConfigDatabaseLogic.closeQuietly(theConnection);
            if (!LOG.isDebugEnabled()) return bl;
            debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
            LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
            return bl;
        }
        ConfigDatabaseLogic.closeQuietly(preparedStatement);
        ConfigDatabaseLogic.closeQuietly(theConnection);
        if (!LOG.isDebugEnabled()) return false;
        debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
        LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
        return false;
        finally {
            ConfigDatabaseLogic.closeQuietly(resultSet);
            ConfigDatabaseLogic.closeQuietly(preparedStatement);
            ConfigDatabaseLogic.closeQuietly(theConnection);
            if (LOG.isDebugEnabled()) {
                debugMap.put("ms", (System.nanoTime() - now) / 1000000L);
                LOG.debug(ConfigDatabaseLogic.mapToString(debugMap));
            }
        }
    }

    public static String convertUrlToDriverClassIfNeeded(String connectionUrl, String driverClassName) {
        if (ConfigDatabaseLogic.isBlank(driverClassName)) {
            if (ConfigDatabaseLogic.isMysql(connectionUrl)) {
                try {
                    driverClassName = "com.mysql.cj.jdbc.Driver";
                    Class.forName(driverClassName);
                }
                catch (Exception e) {
                    driverClassName = "com.mysql.jdbc.Driver";
                }
            } else if (ConfigDatabaseLogic.isOracle(connectionUrl)) {
                driverClassName = "oracle.jdbc.driver.OracleDriver";
            } else if (ConfigDatabaseLogic.isPostgres(connectionUrl)) {
                driverClassName = "org.postgresql.Driver";
            } else if (ConfigDatabaseLogic.isSQLServer(connectionUrl)) {
                driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            } else if (!ConfigDatabaseLogic.isBlank(connectionUrl)) {
                String error = "Cannot determine the driver class from database URL: " + connectionUrl;
                System.err.println(error);
                LOG.error(error);
                return null;
            }
        }
        return driverClassName;
    }

    public static boolean isMysql(String connectionUrl) {
        return ConfigDatabaseLogic.defaultString(connectionUrl).toLowerCase().contains(":mysql:");
    }

    public static boolean isOracle(String connectionUrl) {
        return ConfigDatabaseLogic.defaultString(connectionUrl).toLowerCase().contains(":oracle:");
    }

    public static boolean isPostgres(String connectionUrl) {
        return ConfigDatabaseLogic.defaultString(connectionUrl).toLowerCase().contains(":postgresql:");
    }

    public static boolean isSQLServer(String connectionUrl) {
        return ConfigDatabaseLogic.defaultString(connectionUrl).toLowerCase().contains(":sqlserver:");
    }

    public static String defaultString(String str) {
        return str == null ? "" : str;
    }
}

