/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsMessageResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestReceiveMessageRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GcMessageReceive {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String queueOrTopicName;
    private String messageSystemName;
    private Integer blockMillis;
    private Integer maxMessagesToReceiveAtOnce;
    private String routingKey;
    private Boolean autocreateObjects;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private String clientVersion;

    public GcMessageReceive assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcMessageReceive assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcMessageReceive assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcMessageReceive assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcMessageReceive assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcMessageReceive assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcMessageReceive assignAutocreateObjets(Boolean theAutocreateObjects) {
        this.autocreateObjects = theAutocreateObjects;
        return this;
    }

    public GcMessageReceive assignBlockMillis(Integer theBlockMillis) {
        this.blockMillis = theBlockMillis;
        return this;
    }

    public GcMessageReceive assignMaxMessagesToReceiveAtOnce(Integer theMaxMessagesToReceiveAtOnce) {
        this.maxMessagesToReceiveAtOnce = theMaxMessagesToReceiveAtOnce;
        return this;
    }

    public GcMessageReceive assignQueueOrTopicName(String theQueueOrTopicName) {
        this.queueOrTopicName = theQueueOrTopicName;
        return this;
    }

    public GcMessageReceive assignRoutingKey(String theRoutingKey) {
        this.routingKey = theRoutingKey;
        return this;
    }

    public GcMessageReceive assignMessageSystemName(String theMessageSystemName) {
        this.messageSystemName = theMessageSystemName;
        return this;
    }

    public GcMessageReceive addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcMessageReceive addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcMessageReceive assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.queueOrTopicName)) {
            throw new RuntimeException("Need queue or topic name where the message(s) needs to be received from " + this);
        }
    }

    public GcMessageReceive assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsMessageResults execute() {
        this.validate();
        WsMessageResults wsMessageResults = null;
        try {
            WsRestReceiveMessageRequest messageReceiveRequest = new WsRestReceiveMessageRequest();
            messageReceiveRequest.setActAsSubjectLookup(this.actAsSubject);
            messageReceiveRequest.setQueueOrTopicName(this.queueOrTopicName);
            messageReceiveRequest.setMessageSystemName(this.messageSystemName);
            messageReceiveRequest.setRoutingKey(this.routingKey);
            messageReceiveRequest.setBlockMillis(this.blockMillis == null ? null : this.blockMillis.toString());
            messageReceiveRequest.setMaxMessagesToReceiveAtOnce(this.maxMessagesToReceiveAtOnce == null ? null : this.maxMessagesToReceiveAtOnce.toString());
            messageReceiveRequest.setAutocreateObjects(this.autocreateObjects == null ? null : (this.autocreateObjects != false ? "T" : "F"));
            if (this.params.size() > 0) {
                messageReceiveRequest.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsMessageResults = (WsMessageResults)grouperClientWs.executeService("messaging", messageReceiveRequest, "receive messages", this.clientVersion, false);
            String resultMessage = wsMessageResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsMessageResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsMessageResults;
    }
}

