/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetAttributeAssignActionsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetAttributeAssignActionsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetAttributeAssignActions {
    private String clientVersion;
    private Set<String> actions = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Set<String> namesOfAttributeDefs = new LinkedHashSet<String>();
    private Set<String> uuidsOfAttributeDefs = new LinkedHashSet<String>();
    private Set<Long> idIndexesOfAttributeDefs = new LinkedHashSet<Long>();
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;

    public GcGetAttributeAssignActions addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public GcGetAttributeAssignActions assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetAttributeAssignActions addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetAttributeAssignActions addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetAttributeAssignActions assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.namesOfAttributeDefs) == 0 && GrouperClientUtils.length(this.uuidsOfAttributeDefs) == 0 && GrouperClientUtils.length(this.idIndexesOfAttributeDefs) == 0) {
            throw new RuntimeException("atleast one of the attributeDefNames, attributeDefUuids and attributeDefIdIndexes is required : " + this);
        }
    }

    public WsGetAttributeAssignActionsResults execute() {
        this.validate();
        WsGetAttributeAssignActionsResults wsGetAttributeAssignActionsResults = null;
        try {
            WsRestGetAttributeAssignActionsRequest getAttributeAssignActions = new WsRestGetAttributeAssignActionsRequest();
            getAttributeAssignActions.setActAsSubjectLookup(this.actAsSubject);
            ArrayList<WsAttributeDefLookup> attributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String nameOfAttributeDef : this.namesOfAttributeDefs) {
                attributeDefLookups.add(new WsAttributeDefLookup(nameOfAttributeDef, null));
            }
            for (String uuidOfAttributeDef : this.uuidsOfAttributeDefs) {
                attributeDefLookups.add(new WsAttributeDefLookup(null, uuidOfAttributeDef));
            }
            for (Long idIndexOfAttributeDef : this.idIndexesOfAttributeDefs) {
                attributeDefLookups.add(new WsAttributeDefLookup(null, null, idIndexOfAttributeDef.toString()));
            }
            if (GrouperClientUtils.length(attributeDefLookups) > 0) {
                getAttributeAssignActions.setWsAttributeDefLookups(GrouperClientUtils.toArray(attributeDefLookups, WsAttributeDefLookup.class));
            }
            if (this.params.size() > 0) {
                getAttributeAssignActions.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (GrouperClientUtils.length(this.actions) > 0) {
                getAttributeAssignActions.setActions(GrouperClientUtils.toArray(this.actions, String.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsGetAttributeAssignActionsResults = (WsGetAttributeAssignActionsResults)grouperClientWs.executeService("attributeAssignActions", getAttributeAssignActions, "getAttributeAssignActions", this.clientVersion, true);
            String resultMessage = wsGetAttributeAssignActionsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetAttributeAssignActionsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetAttributeAssignActionsResults;
    }

    public GcGetAttributeAssignActions addAttributeDefName(String nameOfAttributeDef) {
        this.namesOfAttributeDefs.add(nameOfAttributeDef);
        return this;
    }

    public GcGetAttributeAssignActions addAttributeDefUuid(String uuidOfAttributeDef) {
        this.uuidsOfAttributeDefs.add(uuidOfAttributeDef);
        return this;
    }

    public GcGetAttributeAssignActions addAttributeDefIdIndex(Long idIndexOfATtributeDef) {
        this.idIndexesOfAttributeDefs.add(idIndexOfATtributeDef);
        return this;
    }

    public GcGetAttributeAssignActions assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcGetAttributeAssignActions assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcGetAttributeAssignActions assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcGetAttributeAssignActions assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcGetAttributeAssignActions assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcGetAttributeAssignActions assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }
}

